/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui.annotate;

import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.revisions.RevisionInformation;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.team.ui.history.IHistoryView;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.ide.ResourceUtil;
import org.eclipse.ui.texteditor.AbstractDecoratedTextEditor;
import org.polarion.team.svn.core.client.ISVNClientWrapper;
import org.polarion.team.svn.core.client.LogMessage;
import org.polarion.team.svn.core.client.Revision;
import org.polarion.team.svn.core.operation.AbstractNonLockingOperation;
import org.polarion.team.svn.core.operation.CompositeOperation;
import org.polarion.team.svn.core.operation.IActionOperation;
import org.polarion.team.svn.core.operation.remote.GetLogMessagesOperation;
import org.polarion.team.svn.core.operation.remote.GetResourceAnnotationOperation;
import org.polarion.team.svn.core.resource.IRepositoryResource;
import org.polarion.team.svn.ui.SVNTeamUIPlugin;
import org.polarion.team.svn.ui.annotate.BuiltInAnnotateRevision;
import org.polarion.team.svn.ui.annotate.CommitterColors;
import org.polarion.team.svn.ui.history.SVNHistoryPage;
import org.polarion.team.svn.ui.preferences.SVNTeamPreferences;
import org.polarion.team.svn.ui.utility.UIMonitorUtility;

public class BuiltInAnnotate {
    protected AbstractDecoratedTextEditor textEditor;
    protected SVNHistoryPage historyPage;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public void open(IWorkbenchPage page, IRepositoryResource remote, IFile resource) {
        GetResourceAnnotationOperation annotateOp = new GetResourceAnnotationOperation(remote);
        IActionOperation showOp = this.prepareBuiltInAnnotate(annotateOp, page, resource);
        CompositeOperation op = new CompositeOperation(showOp.getId());
        op.add((IActionOperation)annotateOp);
        op.add(showOp, new IActionOperation[]{annotateOp});
        UIMonitorUtility.doTaskScheduledDefault(page.getActivePart(), (IActionOperation)op);
    }

    protected IActionOperation prepareBuiltInAnnotate(final GetResourceAnnotationOperation annotateOp, final IWorkbenchPage page, final IFile resource) {
        CompositeOperation op = new CompositeOperation("Operation.BuiltInShowAnnotation");
        final RevisionInformation info = new RevisionInformation();
        AbstractNonLockingOperation prepareRevisions = new AbstractNonLockingOperation("Operation.PrepareRevisions"){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            protected void runImpl(IProgressMonitor monitor) throws Exception {
                HashMap<String, BuiltInAnnotateRevision> revisions = new HashMap<String, BuiltInAnnotateRevision>();
                String[][] lines = annotateOp.getAnnotatedLines();
                if (lines == null) return;
                if (lines.length == 0) {
                    return;
                }
                RGB palette = SVNTeamPreferences.getAnnotateRGB(SVNTeamUIPlugin.instance().getPreferenceStore(), "rgbBase");
                boolean useOneRGB = SVNTeamPreferences.getAnnotateBoolean(SVNTeamUIPlugin.instance().getPreferenceStore(), "useOneRGB");
                int i = 0;
                while (i < lines.length) {
                    BuiltInAnnotateRevision revision = (BuiltInAnnotateRevision)((Object)revisions.get(lines[i][0]));
                    if (revision == null) {
                        revision = new BuiltInAnnotateRevision(lines[i][0], lines[i][1], useOneRGB ? palette : CommitterColors.getDefault().getCommitterRGB(lines[i][1]));
                        revisions.put(lines[i][0], revision);
                        info.addRevision((org.eclipse.jface.text.revisions.Revision)revision);
                    }
                    revision.addLine(Integer.parseInt(lines[i][2]));
                    ++i;
                }
                long from = -1L;
                long to = -1L;
                Iterator it = revisions.values().iterator();
                while (it.hasNext()) {
                    BuiltInAnnotateRevision revision = (BuiltInAnnotateRevision)((Object)it.next());
                    revision.addLine(-1);
                    long revisionNum = Long.parseLong(revision.getId());
                    if (from > revisionNum || from == -1L) {
                        from = revisionNum;
                    }
                    if (to >= revisionNum) continue;
                    to = revisionNum;
                }
                IRepositoryResource resource = annotateOp.getRepositoryResource();
                ISVNClientWrapper proxy = resource.getRepositoryLocation().acquireSVNProxy();
                try {
                    LogMessage[] msgs = GetLogMessagesOperation.getMessagesImpl((ISVNClientWrapper)proxy, (IRepositoryResource)resource, (Revision)Revision.getInstance((long)to), (Revision)Revision.getInstance((long)from), (long)0L, (boolean)false, (IActionOperation)this, (IProgressMonitor)monitor);
                    int i2 = 0;
                    while (i2 < msgs.length) {
                        BuiltInAnnotateRevision revision = (BuiltInAnnotateRevision)((Object)revisions.get(String.valueOf(msgs[i2].revision)));
                        if (revision != null) {
                            revision.setLogMessage(msgs[i2]);
                        }
                        ++i2;
                    }
                }
                catch (Throwable throwable) {
                    Object var15_17 = null;
                    resource.getRepositoryLocation().releaseSVNProxy(proxy);
                    throw throwable;
                }
                {
                    Object var15_18 = null;
                }
                resource.getRepositoryLocation().releaseSVNProxy(proxy);
            }
        };
        op.add((IActionOperation)prepareRevisions, new IActionOperation[]{annotateOp});
        AbstractNonLockingOperation attachMessages = new AbstractNonLockingOperation("Operation.BuiltInShowView"){

            protected void runImpl(IProgressMonitor monitor) throws Exception {
                page.getActivePart().getSite().getShell().getDisplay().syncExec(new Runnable(this, page, resource, info){
                    final /* synthetic */ 2 this$1;
                    private final /* synthetic */ IWorkbenchPage val$page;
                    private final /* synthetic */ IFile val$resource;
                    private final /* synthetic */ RevisionInformation val$info;
                    {
                        this.this$1 = var1_1;
                        this.val$page = iWorkbenchPage;
                        this.val$resource = iFile;
                        this.val$info = revisionInformation;
                    }

                    public void run() {
                        try {
                            2.access$0(this.this$1).initializeEditor(this.val$page, this.val$resource, this.val$info);
                        }
                        catch (PartInitException ex) {
                            throw new RuntimeException(ex);
                        }
                    }
                });
            }

            static /* synthetic */ BuiltInAnnotate access$0(2 var0) {
                return var0.BuiltInAnnotate.this;
            }
        };
        op.add((IActionOperation)attachMessages, new IActionOperation[]{annotateOp, prepareRevisions});
        return op;
    }

    protected void initializeEditor(final IWorkbenchPage page, IFile resource, RevisionInformation info) throws PartInitException {
        IHistoryView view;
        IEditorPart editor = this.openEditor(page, resource);
        if (editor instanceof AbstractDecoratedTextEditor) {
            Class<?> clazz;
            ISelectionProvider provider;
            this.textEditor = (AbstractDecoratedTextEditor)editor;
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("org.eclipse.jface.internal.text.revisions.RevisionSelectionProvider");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((provider = (ISelectionProvider)this.textEditor.getAdapter((Class)clazz2)) != null) {
                final ISelectionChangedListener selectionListener = new ISelectionChangedListener(){

                    public void selectionChanged(SelectionChangedEvent event) {
                        BuiltInAnnotateRevision selected;
                        if (event.getSelection() instanceof IStructuredSelection && (selected = (BuiltInAnnotateRevision)((Object)((IStructuredSelection)event.getSelection()).getFirstElement())) != null && BuiltInAnnotate.this.historyPage != null) {
                            BuiltInAnnotate.this.historyPage.selectRevision(Long.parseLong(selected.getId()));
                        }
                    }
                };
                provider.addSelectionChangedListener(selectionListener);
                page.addPartListener(new IPartListener(){

                    public void partClosed(IWorkbenchPart part) {
                        if (part instanceof IHistoryView || part == BuiltInAnnotate.this.textEditor) {
                            page.removePartListener((IPartListener)this);
                            provider.removeSelectionChangedListener(selectionListener);
                        }
                    }

                    public void partActivated(IWorkbenchPart part) {
                    }

                    public void partBroughtToTop(IWorkbenchPart part) {
                    }

                    public void partDeactivated(IWorkbenchPart part) {
                    }

                    public void partOpened(IWorkbenchPart part) {
                    }
                });
            }
            if ((clazz = class$1) == null) {
                try {
                    clazz = class$1 = Class.forName("org.polarion.team.svn.ui.annotate.SVNTeamQuickDiffProvider");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.textEditor.showRevisionInformation(info, clazz.getName());
        }
        if ((view = (IHistoryView)page.showView("org.eclipse.team.ui.GenericHistoryView")) != null) {
            this.historyPage = (SVNHistoryPage)view.showHistoryFor((Object)resource);
        }
    }

    protected IEditorPart openEditor(IWorkbenchPage page, IFile resource) throws PartInitException {
        IEditorPart part = ResourceUtil.findEditor((IWorkbenchPage)page, (IFile)resource);
        if (part != null && part instanceof AbstractDecoratedTextEditor) {
            page.activate((IWorkbenchPart)part);
            return part;
        }
        return IDE.openEditor((IWorkbenchPage)page, (IFile)resource, (String)"org.eclipse.ui.DefaultTextEditor");
    }
}

