/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui.annotate;

import java.io.BufferedReader;
import java.io.CharArrayWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.editors.text.IStorageDocumentProvider;
import org.eclipse.ui.ide.ResourceUtil;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IElementStateListener;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.quickdiff.IQuickDiffReferenceProvider;
import org.polarion.team.svn.core.IStateFilter;
import org.polarion.team.svn.core.operation.AbstractNonLockingOperation;
import org.polarion.team.svn.core.operation.CompositeOperation;
import org.polarion.team.svn.core.operation.IActionOperation;
import org.polarion.team.svn.core.operation.local.GetLocalFileContentOperation;
import org.polarion.team.svn.core.resource.ILocalResource;
import org.polarion.team.svn.core.resource.events.IResourceStatesListener;
import org.polarion.team.svn.core.resource.events.ResourceStatesChangedEvent;
import org.polarion.team.svn.core.svnstorage.SVNRemoteStorage;
import org.polarion.team.svn.core.utility.ProgressMonitorUtility;

public class SVNTeamQuickDiffProvider
implements IQuickDiffReferenceProvider,
IResourceStatesListener,
IElementStateListener {
    protected String id;
    protected ITextEditor editor;
    protected IDocumentProvider documentProvider;
    protected boolean referenceInitialized;
    protected IDocument reference;
    protected ILocalResource savedState;
    protected Job updateJob;
    static /* synthetic */ Class class$0;

    public void setActiveEditor(ITextEditor editor) {
        IEditorInput editorInput = editor.getEditorInput();
        if (editorInput == null || ResourceUtil.getFile((IEditorInput)editorInput) == null) {
            return;
        }
        this.editor = editor;
        this.documentProvider = editor.getDocumentProvider();
        SVNRemoteStorage sVNRemoteStorage = SVNRemoteStorage.instance();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.polarion.team.svn.core.resource.events.ResourceStatesChangedEvent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        sVNRemoteStorage.addResourceStatesListener((Class)clazz, (IResourceStatesListener)this);
        if (this.documentProvider != null) {
            this.documentProvider.addElementStateListener((IElementStateListener)this);
        }
        this.referenceInitialized = true;
    }

    public void dispose() {
        if (this.updateJob != null && this.updateJob.getState() != 0) {
            this.updateJob.cancel();
        }
        this.referenceInitialized = false;
        if (this.documentProvider != null) {
            this.documentProvider.removeElementStateListener((IElementStateListener)this);
        }
        SVNRemoteStorage sVNRemoteStorage = SVNRemoteStorage.instance();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.polarion.team.svn.core.resource.events.ResourceStatesChangedEvent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        sVNRemoteStorage.removeResourceStatesListener((Class)clazz, (IResourceStatesListener)this);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public IDocument getReference(IProgressMonitor monitor) throws CoreException {
        if (this.referenceInitialized) {
            if (this.reference == null) {
                this.readDocument(monitor);
            }
            return this.reference;
        }
        return null;
    }

    public boolean isEnabled() {
        return this.referenceInitialized && this.isShared();
    }

    public void resourcesStateChanged(ResourceStatesChangedEvent event) {
        if (this.isEnabled() && event.contains((IResource)this.getFile())) {
            this.backgroundFetch();
        }
    }

    public void elementContentReplaced(Object element) {
        if (this.isEnabled() && this.editor.getEditorInput() == element) {
            this.backgroundFetch();
        }
    }

    public void elementContentAboutToBeReplaced(Object element) {
    }

    public void elementDeleted(Object element) {
    }

    public void elementDirtyStateChanged(Object element, boolean isDirty) {
    }

    public void elementMoved(Object originalElement, Object movedElement) {
    }

    protected boolean isShared() {
        ILocalResource local = this.getLocalResource();
        return local != null && IStateFilter.SF_VERSIONED.accept(local.getResource(), local.getStatus(), local.getChangeMask());
    }

    protected ILocalResource getLocalResource() {
        return SVNRemoteStorage.instance().asLocalResource((IResource)this.getFile());
    }

    protected IFile getFile() {
        return this.editor == null ? null : ResourceUtil.getFile((IEditorInput)this.editor.getEditorInput());
    }

    protected void backgroundFetch() {
        if (this.updateJob != null && this.updateJob.getState() != 0) {
            this.updateJob.cancel();
        }
        this.updateJob = ProgressMonitorUtility.doTaskScheduledDefault((IActionOperation)new AbstractNonLockingOperation("Operation.QuickDiff"){

            protected void runImpl(IProgressMonitor monitor) throws Exception {
                SVNTeamQuickDiffProvider.this.readDocument(monitor);
            }
        });
    }

    protected void readDocument(IProgressMonitor monitor) {
        if (this.reference == null) {
            this.reference = new Document();
        }
        ILocalResource tmp = this.getLocalResource();
        if (this.savedState == null || tmp != null && this.savedState.getRevision() != tmp.getRevision()) {
            this.savedState = tmp;
            if (this.documentProvider instanceof IStorageDocumentProvider) {
                IStorageDocumentProvider provider = (IStorageDocumentProvider)this.documentProvider;
                String encodingTmp = provider.getEncoding((Object)this.editor.getEditorInput());
                final String encoding = encodingTmp == null ? provider.getDefaultEncoding() : encodingTmp;
                final GetLocalFileContentOperation contentOp = new GetLocalFileContentOperation(tmp.getResource(), 5);
                CompositeOperation op = new CompositeOperation("Operation.PrepareQuickDiff");
                op.add((IActionOperation)contentOp);
                op.add((IActionOperation)new AbstractNonLockingOperation("Operation.InitializeDocument"){

                    /*
                     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    protected void runImpl(IProgressMonitor monitor) throws Exception {
                        BufferedReader in;
                        InputStream content;
                        block19: {
                            content = contentOp.getContent();
                            in = null;
                            CharArrayWriter store = null;
                            try {
                                in = new BufferedReader(new InputStreamReader(content, encoding));
                                store = new CharArrayWriter();
                                char[] buf = new char[2048];
                                while (true) {
                                    int len;
                                    block21: {
                                        if ((len = in.read(buf)) > 0 && !monitor.isCanceled()) break block21;
                                        if (!monitor.isCanceled()) {
                                            SVNTeamQuickDiffProvider.this.reference.set(store.toString());
                                        }
                                        break;
                                    }
                                    store.write(buf, 0, len);
                                }
                            }
                            catch (Throwable throwable) {
                                Object var7_8 = null;
                                if (store != null) {
                                    try {
                                        store.close();
                                    }
                                    catch (Exception exception) {}
                                }
                                if (in != null) {
                                    try {
                                        ((Reader)in).close();
                                    }
                                    catch (Exception exception) {}
                                }
                                try {
                                    content.close();
                                    throw throwable;
                                }
                                catch (Exception exception) {}
                                throw throwable;
                            }
                            {
                                Object var7_9 = null;
                                if (store == null) break block19;
                            }
                            try {}
                            catch (Exception exception) {}
                            store.close();
                        }
                        if (in != null) {
                            try {}
                            catch (Exception exception) {}
                            ((Reader)in).close();
                        }
                        try {}
                        catch (Exception exception) {
                            return;
                        }
                        content.close();
                    }
                }, new IActionOperation[]{contentOp});
                ProgressMonitorUtility.doTaskExternalDefault((IActionOperation)op, (IProgressMonitor)monitor);
            } else if (!monitor.isCanceled()) {
                this.reference.set("");
            }
        }
    }
}

