/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui.compare;

import org.eclipse.compare.CompareEditorInput;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.polarion.team.svn.core.operation.CompositeOperation;
import org.polarion.team.svn.core.operation.IActionOperation;
import org.polarion.team.svn.core.operation.local.AbstractWorkingCopyOperation;
import org.polarion.team.svn.core.operation.local.RefreshResourcesOperation;
import org.polarion.team.svn.ui.SVNTeamUIPlugin;
import org.polarion.team.svn.ui.panel.AbstractDialogPanel;
import org.polarion.team.svn.ui.preferences.SVNTeamPreferences;
import org.polarion.team.svn.ui.utility.UIMonitorUtility;

public class ComparePanel
extends AbstractDialogPanel {
    protected CompareEditorInput compareInput;
    protected IResource resource;
    protected Composite parent;

    public ComparePanel(CompareEditorInput compareInput, IResource resource) {
        super(new String[]{SVNTeamUIPlugin.instance().getResource("CompareLocalPanel.Save"), IDialogConstants.CANCEL_LABEL});
        this.compareInput = compareInput;
        this.resource = resource;
        this.dialogTitle = SVNTeamUIPlugin.instance().getResource("CompareLocalPanel.Title");
        this.dialogDescription = SVNTeamUIPlugin.instance().getResource("CompareLocalPanel.Description");
        this.defaultMessage = SVNTeamUIPlugin.instance().getResource("CompareLocalPanel.Message");
    }

    public void createControls(Composite parent) {
        this.parent = parent;
        Control control = this.compareInput.createContents(parent);
        control.setLayoutData((Object)new GridData(1808));
        Shell shell = control.getShell();
        shell.setText(this.compareInput.getTitle());
        shell.setImage(this.compareInput.getTitleImage());
    }

    protected void cancelChanges() {
        this.retainSizeAndWeights();
    }

    protected void saveChanges() {
        this.retainSizeAndWeights();
        RefreshResourcesOperation refreshOp = new RefreshResourcesOperation(new IResource[]{this.resource.getProject()});
        AbstractWorkingCopyOperation mainOp = new AbstractWorkingCopyOperation("Operation.SaveChanges", new IResource[]{this.resource.getProject()}){

            protected void runImpl(IProgressMonitor monitor) throws Exception {
                ComparePanel.this.compareInput.saveChanges(monitor);
            }
        };
        CompositeOperation composite = new CompositeOperation(mainOp.getId());
        composite.add((IActionOperation)mainOp);
        composite.add((IActionOperation)refreshOp);
        UIMonitorUtility.doTaskBusyWorkspaceModify((IActionOperation)composite);
    }

    public Point getPrefferedSize() {
        IPreferenceStore store = SVNTeamUIPlugin.instance().getPreferenceStore();
        return new Point(SVNTeamPreferences.getCommitDialogInt(store, "compare.width"), SVNTeamPreferences.getCommitDialogInt(store, "compare.height"));
    }

    protected void retainSizeAndWeights() {
        IPreferenceStore store = SVNTeamUIPlugin.instance().getPreferenceStore();
        Point size = this.parent.getSize();
        SVNTeamPreferences.setCommitDialogInt(store, "compare.width", size.x);
        SVNTeamPreferences.setCommitDialogInt(store, "compare.height", size.y);
    }
}

