/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui.compare;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.IContentChangeListener;
import org.eclipse.compare.IContentChangeNotifier;
import org.eclipse.compare.IEditableContent;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.compare.structuremergeviewer.DiffTreeViewer;
import org.eclipse.compare.structuremergeviewer.IDiffContainer;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TreeItem;
import org.polarion.team.svn.core.client.Revision;
import org.polarion.team.svn.core.client.Status;
import org.polarion.team.svn.core.operation.AbstractGetFileContentOperation;
import org.polarion.team.svn.core.operation.AbstractNonLockingOperation;
import org.polarion.team.svn.core.operation.IActionOperation;
import org.polarion.team.svn.core.operation.local.GetLocalFileContentOperation;
import org.polarion.team.svn.core.operation.remote.GetFileContentOperation;
import org.polarion.team.svn.core.resource.ILocalResource;
import org.polarion.team.svn.core.resource.IRepositoryContainer;
import org.polarion.team.svn.core.resource.IRepositoryFile;
import org.polarion.team.svn.core.resource.IRepositoryLocation;
import org.polarion.team.svn.core.resource.IRepositoryResource;
import org.polarion.team.svn.core.resource.ISVNStorage;
import org.polarion.team.svn.core.utility.ProgressMonitorUtility;
import org.polarion.team.svn.core.utility.SVNUtility;
import org.polarion.team.svn.ui.SVNTeamUIPlugin;
import org.polarion.team.svn.ui.compare.ResourceCompareInput;
import org.polarion.team.svn.ui.repository.model.RepositoryFolder;
import org.polarion.team.svn.ui.utility.UIMonitorUtility;

public abstract class ResourceCompareInput
extends CompareEditorInput {
    protected ResourceCompareViewer viewer;
    protected DiffNode root;
    protected IRepositoryResource rootLeft;
    protected IRepositoryResource rootAncestor;
    protected IRepositoryResource rootRight;

    public ResourceCompareInput(CompareConfiguration configuration) {
        super(configuration);
    }

    public void initialize(IProgressMonitor monitor) throws Exception {
        this.refreshTitles();
    }

    public final Viewer createDiffViewer(Composite parent) {
        this.viewer = this.createDiffViewerImpl(parent, this.getCompareConfiguration());
        return this.viewer;
    }

    protected abstract boolean isThreeWay();

    protected ResourceCompareViewer createDiffViewerImpl(Composite parent, CompareConfiguration config) {
        return new ResourceCompareViewer(parent, config);
    }

    protected Object prepareInput(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        if (this.root != null) {
            ResourceElement left = (ResourceElement)this.root.getLeft();
            ResourceElement ancestor = (ResourceElement)this.root.getAncestor();
            ResourceElement right = (ResourceElement)this.root.getRight();
            if ((left.getType() == "FOLDER" || ancestor != null && ancestor.getType() == "FOLDER" || right.getType() == "FOLDER") && (this.root.getKind() & 3) != 0) {
                this.root = (DiffNode)this.root.getParent();
            }
        }
        monitor.done();
        return this.root;
    }

    protected void refreshTitles() throws Exception {
        CompareConfiguration cc = this.getCompareConfiguration();
        cc.setLeftLabel(this.getLeftLabel());
        cc.setLeftImage(this.getLeftImage());
        cc.setRightLabel(this.getRightLabel());
        cc.setRightImage(this.getRightImage());
        String leftLabel = this.getShortLeftLabel();
        String rightLabel = this.getShortRightLabel();
        if (this.isThreeWay()) {
            cc.setAncestorLabel(this.getAncestorLabel());
            cc.setAncestorImage(this.getAncestorImage());
            String format = CompareUI.getResourceBundle().getString("ResourceCompare.threeWay.title");
            String ancestorLabel = this.getShortAncestorLabel();
            this.setTitle(MessageFormat.format(format, ancestorLabel, leftLabel, rightLabel));
        } else {
            String format = CompareUI.getResourceBundle().getString("ResourceCompare.twoWay.title");
            this.setTitle(MessageFormat.format(format, leftLabel, rightLabel));
        }
    }

    protected String getShortAncestorLabel() throws Exception {
        return this.getShortLabel(this.getAncestorResourceElement());
    }

    protected String getAncestorLabel() throws Exception {
        return this.getLabel(this.getAncestorResourceElement());
    }

    protected Image getAncestorImage() throws Exception {
        return CompareUI.getImage((IAdaptable)RepositoryFolder.wrapChild(null, this.getAncestorResourceElement().getRepositoryResource()));
    }

    protected String getShortLeftLabel() throws Exception {
        return this.getShortLabel(this.getLeftResourceElement());
    }

    protected String getLeftLabel() throws Exception {
        return this.getLabel(this.getLeftResourceElement());
    }

    protected Image getLeftImage() throws Exception {
        return CompareUI.getImage((IAdaptable)RepositoryFolder.wrapChild(null, this.getLeftResourceElement().getRepositoryResource()));
    }

    protected String getShortRightLabel() throws Exception {
        return this.getShortLabel(this.getRightResourceElement());
    }

    protected String getRightLabel() throws Exception {
        return this.getLabel(this.getRightResourceElement());
    }

    protected Image getRightImage() throws Exception {
        return CompareUI.getImage((IAdaptable)RepositoryFolder.wrapChild(null, this.getRightResourceElement().getRepositoryResource()));
    }

    protected String getShortLabel(ResourceElement element) throws Exception {
        return String.valueOf(element.getName()) + this.getRevisionPart(element);
    }

    protected String getLabel(ResourceElement element) throws Exception {
        return String.valueOf(element.getRepositoryResource().getUrl()) + this.getRevisionPart(element);
    }

    protected String getRevisionPart(ResourceElement element) throws Exception {
        IRepositoryResource resource = element.getRepositoryResource();
        Revision selected = resource.getSelectedRevision();
        if (selected instanceof ISVNStorage.InvalidRevision) {
            return "";
        }
        int kind = selected.getKind();
        ILocalResource local = element.getLocalResource();
        String msg = SVNTeamUIPlugin.instance().getResource("ResourceCompareInput.RevisionPart");
        if (kind == 6 || kind == 5 || local != null && local.isCopied()) {
            if (local == null || local.getRevision() == -1L) {
                return "";
            }
            return " " + MessageFormat.format(msg, String.valueOf(local.getRevision()));
        }
        return " " + MessageFormat.format(msg, String.valueOf(resource.getRevision()));
    }

    protected ResourceElement getLeftResourceElement() {
        DiffNode node = this.getSelectedNode();
        if (node != null) {
            return (ResourceElement)node.getLeft();
        }
        return new ResourceElement(this.rootLeft, 1);
    }

    protected ResourceElement getRightResourceElement() {
        DiffNode node = this.getSelectedNode();
        if (node != null) {
            return (ResourceElement)node.getRight();
        }
        return new ResourceElement(this.rootRight, 1);
    }

    protected ResourceElement getAncestorResourceElement() {
        DiffNode node = this.getSelectedNode();
        if (node != null) {
            return (ResourceElement)node.getAncestor();
        }
        return new ResourceElement(this.rootAncestor, 1);
    }

    protected ILocalResource getLocalResourceFor(IRepositoryResource base) {
        return null;
    }

    protected DiffNode getSelectedNode() {
        IStructuredSelection selection;
        if (this.viewer != null && (selection = (IStructuredSelection)this.viewer.getSelection()) != null && !selection.isEmpty() && selection.getFirstElement() instanceof DiffNode) {
            return (DiffNode)selection.getFirstElement();
        }
        return null;
    }

    protected IDiffContainer getParentCompareNode(IRepositoryResource current, Map path2node) throws Exception {
        IRepositoryResource parent = current.getParent();
        if (parent == null) {
            return null;
        }
        Path parentUrl = new Path(parent.getUrl());
        IDiffContainer node = (IDiffContainer)path2node.get(parentUrl);
        if (node == null) {
            node = this.makeStubNode(this.getParentCompareNode(parent, path2node), parent);
            path2node.put(parentUrl, node);
        }
        return node;
    }

    protected abstract IDiffContainer makeStubNode(IDiffContainer var1, IRepositoryResource var2);

    protected static int getDiffKind(int textStatus, int propStatus, int kindOverride) {
        if (kindOverride == 7) {
            return 3;
        }
        if (textStatus == 2 || propStatus == 2) {
            return 3;
        }
        if (textStatus == 3 || textStatus == 5) {
            return 1;
        }
        if (textStatus == 4) {
            return 2;
        }
        if (textStatus == 7) {
            return 3;
        }
        return 0;
    }

    protected int getNodeKind(Status st) {
        int kind = SVNUtility.getNodeKind((String)st.path, (int)st.nodeKind, (boolean)true);
        return kind == 0 ? SVNUtility.getNodeKind((String)st.path, (int)st.reposKind, (boolean)false) : kind;
    }

    protected IRepositoryResource createResourceFor(IRepositoryLocation location, int kind, String url) {
        IRepositoryFile retVal = null;
        if (kind == 1) {
            retVal = location.asRepositoryFile(url, false);
        } else if (kind == 2) {
            retVal = location.asRepositoryContainer(url, false);
        }
        if (retVal == null) {
            throw new RuntimeException(SVNTeamUIPlugin.instance().getResource("Error.CompareUnknownNodeKind"));
        }
        return retVal;
    }

    public class ResourceElement
    implements ITypedElement,
    IStreamContentAccessor,
    IContentChangeNotifier,
    IEditableContent {
        protected Vector listenerList;
        protected boolean dirty;
        protected IRepositoryResource resource;
        protected AbstractGetFileContentOperation op;
        protected ILocalResource localAlias;
        protected int kind;
        protected boolean editable;

        public ResourceElement(IRepositoryResource resource, int kind) {
            this(resource, resourceCompareInput.getLocalResourceFor(resource), kind);
        }

        public ResourceElement(IRepositoryResource resource, ILocalResource alias, int kind) {
            this.resource = resource;
            this.localAlias = alias;
            this.kind = kind;
            this.editable = false;
            this.listenerList = new Vector();
            if (kind == 0) {
                resource.setSelectedRevision((Revision)new ISVNStorage.InvalidRevision());
            }
        }

        public void addContentChangeListener(IContentChangeListener listener) {
            this.listenerList.add(listener);
        }

        public void removeContentChangeListener(IContentChangeListener listener) {
            this.listenerList.remove(listener);
        }

        public boolean isDirty() {
            return this.dirty;
        }

        public boolean isEditable() {
            return this.editable && this.localAlias != null && this.localAlias.getResource() instanceof IFile;
        }

        public void setEditable(boolean editable) {
            this.editable = editable;
        }

        public ITypedElement replace(ITypedElement dest, ITypedElement src) {
            return dest;
        }

        public void commit(IProgressMonitor pm) throws CoreException {
            if (this.isDirty()) {
                IFile file = (IFile)this.localAlias.getResource();
                file.refreshLocal(0, pm);
                this.dirty = false;
            }
        }

        public void setContent(byte[] newContent) {
            if (this.isEditable()) {
                this.fetchContent((IProgressMonitor)new NullProgressMonitor());
                if (this.op != null) {
                    this.op.setContent(newContent);
                    this.fireContentChanged();
                }
            }
        }

        public IRepositoryResource getRepositoryResource() {
            return this.resource;
        }

        public ILocalResource getLocalResource() {
            return this.localAlias;
        }

        public String getName() {
            return this.resource.getName();
        }

        public Image getImage() {
            return CompareUI.getImage((IAdaptable)RepositoryFolder.wrapChild(null, this.resource));
        }

        public String getType() {
            if (this.resource instanceof IRepositoryContainer) {
                return "FOLDER";
            }
            String fileName = this.resource.getName();
            int dotIdx = fileName.lastIndexOf(46);
            return dotIdx == -1 ? "???" : fileName.substring(dotIdx + 1);
        }

        public void fetchContent(IProgressMonitor monitor) {
            if (this.kind != 0 && this.resource instanceof IRepositoryFile && this.op == null) {
                int revisionKind = this.resource.getSelectedRevision().getKind();
                GetLocalFileContentOperation op = revisionKind == 6 || revisionKind == 5 ? new GetLocalFileContentOperation(this.localAlias.getResource(), revisionKind) : new GetFileContentOperation(this.resource);
                UIMonitorUtility.doTaskExternalDefault((IActionOperation)op, monitor);
                if (op.getExecutionState() == 0) {
                    this.op = op;
                }
            }
        }

        public InputStream getContents() throws CoreException {
            if (this.kind != 0) {
                this.fetchContent((IProgressMonitor)new NullProgressMonitor());
                return this.op == null ? null : this.op.getContent();
            }
            return new ByteArrayInputStream(new byte[0]);
        }

        protected void fireContentChanged() {
            this.dirty = true;
            Object[] listeners = this.listenerList.toArray();
            int i = 0;
            while (i < listeners.length) {
                ((IContentChangeListener)listeners[i]).contentChanged((IContentChangeNotifier)this);
                ++i;
            }
        }
    }

    protected class ResourceCompareViewer
    extends DiffTreeViewer {
        public ResourceCompareViewer(Composite parent, CompareConfiguration configuration) {
            super(parent, configuration);
        }

        protected void handleOpen(SelectionEvent event) {
            BaseCompareNode node = (BaseCompareNode)((Object)((TreeItem)event.item).getData());
            AbstractNonLockingOperation fetchContent = new AbstractNonLockingOperation(this, "Operation.FetchContent", node, event){
                final /* synthetic */ ResourceCompareViewer this$1;
                private final /* synthetic */ BaseCompareNode val$node;
                private final /* synthetic */ SelectionEvent val$event;
                {
                    this.this$1 = resourceCompareViewer;
                    this.val$node = baseCompareNode;
                    this.val$event = selectionEvent;
                    super($anonymous0);
                }

                protected void runImpl(IProgressMonitor monitor) throws Exception {
                    this.val$node.fetchContent(monitor);
                    Throwable[] t = new Throwable[1];
                    UIMonitorUtility.getDisplay().syncExec(new Runnable(this, this.val$event, t){
                        final /* synthetic */ 1 this$2;
                        private final /* synthetic */ SelectionEvent val$event;
                        private final /* synthetic */ Throwable[] val$t;
                        {
                            this.this$2 = var1_1;
                            this.val$event = selectionEvent;
                            this.val$t = throwableArray;
                        }

                        public void run() {
                            try {
                                ResourceCompareViewer.access$1(1.access$0(this.this$2)).refreshTitles();
                                ResourceCompareViewer.access$0(1.access$0(this.this$2), this.val$event);
                            }
                            catch (Exception e) {
                                this.val$t[0] = e;
                            }
                        }
                    });
                    if (t[0] != null) {
                        this.reportError(t[0]);
                    }
                }

                static /* synthetic */ ResourceCompareViewer access$0(1 var0) {
                    return var0.this$1;
                }
            };
            UIMonitorUtility.doTaskNowDefault((IActionOperation)fetchContent, true);
        }

        static /* synthetic */ void access$0(ResourceCompareViewer resourceCompareViewer, SelectionEvent selectionEvent) {
            super.handleOpen(selectionEvent);
        }

        static /* synthetic */ ResourceCompareInput access$1(ResourceCompareViewer resourceCompareViewer) {
            return resourceCompareViewer.ResourceCompareInput.this;
        }

        protected class LabelProviderWrapper
        implements ILabelProvider {
            protected Map images = new HashMap();
            protected ILabelProvider baseProvider;

            public LabelProviderWrapper(ILabelProvider baseProvider) {
                this.baseProvider = baseProvider;
            }

            public void addListener(ILabelProviderListener listener) {
                this.baseProvider.addListener(listener);
            }

            public void removeListener(ILabelProviderListener listener) {
                this.baseProvider.removeListener(listener);
            }

            public boolean isLabelProperty(Object element, String property) {
                return this.baseProvider.isLabelProperty(element, property);
            }

            public String getText(Object element) {
                return this.baseProvider.getText(element);
            }

            public Image getImage(Object element) {
                return this.baseProvider.getImage(element);
            }

            public void dispose() {
                Iterator it = this.images.values().iterator();
                while (it.hasNext()) {
                    ((Image)it.next()).dispose();
                }
                this.baseProvider.dispose();
            }
        }
    }

    protected class BaseCompareNode
    extends DiffNode {
        protected IDiffElement[] ordered;

        public BaseCompareNode(IDiffContainer parent, int kind) {
            super(parent, kind);
        }

        public void fetchContent(IProgressMonitor monitor) {
            ResourceElement left = (ResourceElement)this.getLeft();
            ResourceElement ancestor = (ResourceElement)this.getAncestor();
            ResourceElement right = (ResourceElement)this.getRight();
            if (left != null && !monitor.isCanceled()) {
                monitor.subTask(MessageFormat.format(SVNTeamUIPlugin.instance().getResource("ResourceCompareInput.FetchLeft"), left.getRepositoryResource().getUrl()));
                left.fetchContent(monitor);
                ProgressMonitorUtility.progress((IProgressMonitor)monitor, (int)0, (int)3);
            }
            if (ancestor != null && !monitor.isCanceled()) {
                monitor.subTask(MessageFormat.format(SVNTeamUIPlugin.instance().getResource("ResourceCompareInput.FetchAncestor"), ancestor.getRepositoryResource().getUrl()));
                ancestor.fetchContent(monitor);
                ProgressMonitorUtility.progress((IProgressMonitor)monitor, (int)1, (int)3);
            }
            if (right != null && !monitor.isCanceled()) {
                monitor.subTask(MessageFormat.format(SVNTeamUIPlugin.instance().getResource("ResourceCompareInput.FetchRight"), right.getRepositoryResource().getUrl()));
                right.fetchContent(monitor);
                ProgressMonitorUtility.progress((IProgressMonitor)monitor, (int)2, (int)3);
            }
        }
    }
}

