/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui.compare;

import java.io.File;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.structuremergeviewer.IDiffContainer;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.polarion.team.svn.core.IStateFilter;
import org.polarion.team.svn.core.client.Revision;
import org.polarion.team.svn.core.client.Status;
import org.polarion.team.svn.core.operation.IActionOperation;
import org.polarion.team.svn.core.operation.remote.LocateResourceURLInHistoryOperation;
import org.polarion.team.svn.core.resource.ILocalResource;
import org.polarion.team.svn.core.resource.IRepositoryContainer;
import org.polarion.team.svn.core.resource.IRepositoryFile;
import org.polarion.team.svn.core.resource.IRepositoryLocation;
import org.polarion.team.svn.core.resource.IRepositoryResource;
import org.polarion.team.svn.core.svnstorage.SVNRemoteStorage;
import org.polarion.team.svn.core.utility.FileUtility;
import org.polarion.team.svn.core.utility.ProgressMonitorUtility;
import org.polarion.team.svn.core.utility.SVNUtility;
import org.polarion.team.svn.ui.SVNTeamUIPlugin;
import org.polarion.team.svn.ui.compare.ResourceCompareInput;
import org.polarion.team.svn.ui.utility.OverlayedImageDescriptor;
import org.polarion.team.svn.ui.utility.UIMonitorUtility;

public class ThreeWayResourceCompareInput
extends ResourceCompareInput {
    protected IResource localLeft;
    protected Status[] localChanges;
    protected Status[] remoteChanges;
    protected Map newUrl2OldUrl = new HashMap();
    static /* synthetic */ Class class$0;

    public ThreeWayResourceCompareInput(CompareConfiguration configuration, IResource left, Revision revision, Revision pegRevision, Status[] localChanges, Status[] remoteChanges) {
        super(configuration);
        this.localLeft = left;
        SVNRemoteStorage storage = SVNRemoteStorage.instance();
        this.rootLeft = storage.asRepositoryResource(this.localLeft);
        this.rootLeft.setSelectedRevision(Revision.WORKING);
        this.rootAncestor = storage.asRepositoryResource(this.localLeft);
        this.rootAncestor.setSelectedRevision(Revision.BASE);
        this.rootRight = storage.asRepositoryResource(this.localLeft);
        this.rootRight.setSelectedRevision(revision);
        this.rootRight.setPegRevision(pegRevision);
        this.localChanges = localChanges;
        this.remoteChanges = remoteChanges;
    }

    public void initialize(IProgressMonitor monitor) throws Exception {
        String url;
        super.initialize(monitor);
        HashMap<String, Status> localChanges = new HashMap<String, Status>();
        HashMap<String, Status> remoteChanges = new HashMap<String, Status>();
        HashSet<String> allChangesSet = new HashSet<String>();
        int i = 0;
        while (i < this.localChanges.length) {
            url = this.getUrl(this.localChanges[i].path);
            allChangesSet.add(url);
            localChanges.put(url, this.localChanges[i]);
            ++i;
        }
        i = 0;
        while (i < this.remoteChanges.length) {
            url = SVNUtility.decodeURL((String)this.remoteChanges[i].url);
            allChangesSet.add(url);
            remoteChanges.put(url, this.remoteChanges[i]);
            ++i;
        }
        Object[] allChanges = allChangesSet.toArray(new String[allChangesSet.size()]);
        FileUtility.sort((Object[])allChanges);
        HashMap path2node = new HashMap();
        String message = SVNTeamUIPlugin.instance().getResource("ResourceCompareInput.CheckingDelta");
        int i2 = 0;
        while (i2 < allChanges.length) {
            monitor.subTask(MessageFormat.format(message, allChanges[i2]));
            this.makeBranch((String)allChanges[i2], (Status)localChanges.get(allChanges[i2]), (Status)remoteChanges.get(allChanges[i2]), path2node, monitor);
            ProgressMonitorUtility.progress((IProgressMonitor)monitor, (int)i2, (int)allChanges.length);
            ++i2;
        }
        this.root = (CompareNode)((Object)path2node.get(new Path(this.rootRight.getUrl())));
        if (this.root == null) {
            LocateResourceURLInHistoryOperation op = new LocateResourceURLInHistoryOperation(new IRepositoryResource[]{this.rootRight}, false);
            UIMonitorUtility.doTaskExternalDefault((IActionOperation)op, monitor);
            IRepositoryResource converted = op.getRepositoryResources()[0];
            this.root = (CompareNode)((Object)path2node.get(new Path(converted.getUrl())));
        }
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IFile");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(adapter)) {
            return null;
        }
        return super.getAdapter(adapter);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveChanges(IProgressMonitor pm) throws CoreException {
        super.saveChanges(pm);
        if (this.root == null) return;
        try {
            pm.beginTask(SVNTeamUIPlugin.instance().getResource("ThreeWayResourceCompareInput.SaveChanges"), -1);
            this.saveChanges((CompareNode)this.root);
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            pm.done();
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        pm.done();
    }

    protected void saveChanges(CompareNode node) throws CoreException {
        IDiffElement[] children;
        ResourceCompareInput.ResourceElement left = (ResourceCompareInput.ResourceElement)node.getLeft();
        if (left.isEditable() && left.isDirty()) {
            left.commit((IProgressMonitor)new NullProgressMonitor());
        }
        if ((children = node.getChildren()) != null) {
            int i = 0;
            while (i < children.length) {
                this.saveChanges((CompareNode)children[i]);
                ++i;
            }
        }
    }

    protected void makeBranch(String url, Status stLocal, Status stRemote, Map path2node, IProgressMonitor monitor) throws Exception {
        CompareNode node;
        if (stRemote == null) {
            ILocalResource local;
            IProject resource;
            IProject project = this.localLeft.getProject();
            String relative = stLocal.path.substring(FileUtility.getWorkingCopyPath((IResource)project).length());
            Object object = resource = relative.length() == 0 ? project : project.findMember(relative);
            if (resource == null || (local = SVNRemoteStorage.instance().asLocalResource((IResource)resource)) == null || IStateFilter.SF_IGNORED.accept((IResource)resource, local.getStatus(), local.getChangeMask())) {
                return;
            }
        }
        if ((node = this.makeNode(url, stLocal, stRemote, path2node, monitor)) != null) {
            path2node.put(new Path(url), node);
        }
    }

    protected CompareNode makeNode(String oldUrl, Status stLeft, Status stRight, Map path2node, IProgressMonitor monitor) throws Exception {
        int diffKindRight;
        int diffKindLeft;
        int statusLeft;
        int rightNodeKind = stRight == null ? this.getNodeKind(stLeft) : this.getNodeKind(stRight);
        int leftNodeKind = stLeft == null ? this.getNodeKind(stRight) : this.getNodeKind(stLeft);
        int ancestorNodeKind = this.getAncestorKind(stLeft, leftNodeKind, rightNodeKind);
        IRepositoryLocation location = this.rootLeft.getRepositoryLocation();
        IRepositoryResource left = this.createResourceFor(location, leftNodeKind, oldUrl);
        left.setSelectedRevision(Revision.WORKING);
        left.setPegRevision(null);
        IRepositoryResource ancestor = this.createResourceFor(location, ancestorNodeKind, oldUrl);
        ancestor.setSelectedRevision(Revision.BASE);
        ancestor.setPegRevision(null);
        IRepositoryResource right = this.createResourceFor(location, rightNodeKind, stLeft != null && stLeft.isCopied ? stLeft.urlCopiedFrom : oldUrl);
        right.setPegRevision(this.rootRight.getPegRevision());
        right.setSelectedRevision(this.rootRight.getSelectedRevision());
        LocateResourceURLInHistoryOperation op = new LocateResourceURLInHistoryOperation(new IRepositoryResource[]{right}, true);
        ProgressMonitorUtility.doTaskExternal((IActionOperation)op, (IProgressMonitor)monitor);
        right = op.getRepositoryResources()[0];
        this.newUrl2OldUrl.put(right.getUrl(), oldUrl);
        int n = stLeft == null ? 1 : (statusLeft = stLeft.textStatus == 1 ? stLeft.propStatus : stLeft.textStatus);
        if (statusLeft == 4 && new File(stLeft.path).exists()) {
            statusLeft = 7;
        }
        int statusRight = stRight == null ? (statusLeft == 11 || statusLeft == 0 || statusLeft == 5 ? 0 : 1) : (stRight.textStatus == 1 ? stRight.propStatus : stRight.textStatus);
        ILocalResource local = this.getLocalResourceFor(right);
        if (stRight != null && local != null) {
            ILocalResource tmp = SVNRemoteStorage.instance().asLocalResource(this.localLeft);
            if (this.rootRight.getSelectedRevision().getKind() == 1 && tmp != null && tmp.getRevision() >= ((Revision.Number)this.rootRight.getSelectedRevision()).getNumber()) {
                if (!local.getResource().exists() && statusRight == 4 || statusRight != 4 && local.getRevision() == right.getRevision()) {
                    return null;
                }
            } else if (local.getRevision() == right.getRevision()) {
                if (stLeft == null) {
                    return null;
                }
                stRight = null;
                statusRight = statusLeft == 3 || statusLeft == 11 || statusLeft == 0 || statusLeft == 5 ? 0 : 1;
            }
        }
        if ((diffKindLeft = ResourceCompareInput.getDiffKind(statusLeft, stLeft == null ? 0 : stLeft.propStatus, 1)) != 0) {
            diffKindLeft |= 4;
        }
        if ((diffKindRight = ResourceCompareInput.getDiffKind(statusRight, stRight == null ? 0 : stRight.propStatus, 1)) != 0) {
            diffKindRight |= 8;
        }
        IDiffContainer parent = this.getParentCompareNode(right, path2node);
        return new CompareNode(parent, diffKindLeft | diffKindRight, left, ancestor, right, statusLeft, statusRight);
    }

    protected int getAncestorKind(Status stLeft, int leftNodeKind, int rightNodeKind) {
        if (stLeft != null) {
            switch (stLeft.textStatus) {
                case 0: 
                case 3: 
                case 5: 
                case 11: 
                case 13: {
                    return rightNodeKind;
                }
            }
            return leftNodeKind;
        }
        return rightNodeKind;
    }

    protected String getUrl(String localPath) {
        IResource resource = this.getResourceForPath(localPath);
        if (resource != null) {
            SVNRemoteStorage storage = SVNRemoteStorage.instance();
            return storage.asRepositoryResource(resource).getUrl();
        }
        IProject project = this.localLeft.getProject();
        String relativePath = localPath.substring(FileUtility.getWorkingCopyPath((IResource)project).length());
        SVNRemoteStorage storage = SVNRemoteStorage.instance();
        return String.valueOf(storage.asRepositoryResource((IResource)project).getUrl()) + relativePath;
    }

    protected IResource getResourceForPath(String pathString) {
        Path path = new Path(pathString);
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IFile[] files = workspaceRoot.findFilesForLocation((IPath)path);
        if (files != null && files.length != 0 && files[0] != null) {
            return files[0];
        }
        IContainer[] containers = workspaceRoot.findContainersForLocation((IPath)path);
        if (containers != null && containers.length != 0 && containers[0] != null) {
            return containers[0];
        }
        return null;
    }

    protected IDiffContainer makeStubNode(IDiffContainer parent, IRepositoryResource node) {
        return new CompareNode(parent, 0, node, node, node, 1, 1);
    }

    protected boolean isThreeWay() {
        return true;
    }

    protected String getLeftLabel() throws Exception {
        ResourceCompareInput.ResourceElement element = this.getLeftResourceElement();
        return String.valueOf(element.getLocalResource().getResource().getFullPath().toString().substring(1)) + this.getRevisionPart(element);
    }

    protected ILocalResource getLocalResourceFor(IRepositoryResource base) {
        String url = base.getUrl();
        if (this.newUrl2OldUrl.containsKey(url)) {
            url = (String)this.newUrl2OldUrl.get(url);
        }
        return SVNRemoteStorage.instance().asLocalResource(this.localLeft.getProject(), url, base instanceof IRepositoryContainer ? 2 : 1);
    }

    protected ResourceCompareInput.ResourceCompareViewer createDiffViewerImpl(Composite parent, CompareConfiguration config) {
        return new ResourceCompareInput.ResourceCompareViewer(this, parent, config){

            public void setLabelProvider(IBaseLabelProvider labelProvider) {
                super.setLabelProvider((IBaseLabelProvider)new ResourceCompareInput.ResourceCompareViewer.LabelProviderWrapper(this, this, (ILabelProvider)labelProvider){
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                        super($anonymous0);
                    }

                    public Image getImage(Object element) {
                        if (element instanceof CompareNode && (((CompareNode)((Object)element)).getStatusKindLeft() == 7 || ((CompareNode)((Object)element)).getStatusKindRight() == 7)) {
                            Image image = (Image)this.images.get(element);
                            if (image == null) {
                                OverlayedImageDescriptor imageDescriptor = null;
                                int direction = ((CompareNode)((Object)element)).getKind() & 0xC;
                                imageDescriptor = direction == 4 ? new OverlayedImageDescriptor(this.baseProvider.getImage(element), SVNTeamUIPlugin.instance().getImageDescriptor("icons/overlays/replaced_out.gif"), new Point(22, 16), OverlayedImageDescriptor.RIGHT | OverlayedImageDescriptor.CENTER_V) : (direction == 8 ? new OverlayedImageDescriptor(this.baseProvider.getImage(element), SVNTeamUIPlugin.instance().getImageDescriptor("icons/overlays/replaced_in.gif"), new Point(22, 16), OverlayedImageDescriptor.RIGHT | OverlayedImageDescriptor.CENTER_V) : new OverlayedImageDescriptor(this.baseProvider.getImage(element), SVNTeamUIPlugin.instance().getImageDescriptor("icons/overlays/replaced_conf.gif"), new Point(22, 16), OverlayedImageDescriptor.RIGHT | OverlayedImageDescriptor.CENTER_V));
                                image = imageDescriptor.createImage();
                                this.images.put(element, image);
                            }
                            return image;
                        }
                        return super.getImage(element);
                    }
                });
            }
        };
    }

    protected class CompareNode
    extends ResourceCompareInput.BaseCompareNode {
        protected int statusKindLeft;
        protected int statusKindRight;

        public CompareNode(IDiffContainer parent, int kind, IRepositoryResource left, IRepositoryResource ancestor, IRepositoryResource right, int statusKindLeft, int statusKindRight) {
            super(parent, kind);
            this.statusKindLeft = statusKindLeft;
            this.statusKindRight = statusKindRight;
            ResourceCompareInput.ResourceElement leftElt = new ResourceCompareInput.ResourceElement(left, statusKindLeft == 0 || statusKindLeft == 4 ? 0 : 1);
            leftElt.setEditable(left instanceof IRepositoryFile);
            this.setLeft(leftElt);
            this.setAncestor(new ResourceCompareInput.ResourceElement(ancestor, statusKindLeft == 5 || statusKindRight == 3 ? 0 : 1));
            this.setRight(new ResourceCompareInput.ResourceElement(right, statusKindRight == 4 || statusKindRight == 0 ? 0 : 1));
        }

        public int getStatusKindLeft() {
            return this.statusKindLeft;
        }

        public int getStatusKindRight() {
            return this.statusKindRight;
        }
    }
}

