/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui.composite;

import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.compare.CompareUI;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.polarion.team.svn.core.SVNTeamPlugin;
import org.polarion.team.svn.core.client.ChangePath;
import org.polarion.team.svn.core.client.LogMessage;
import org.polarion.team.svn.core.client.Revision;
import org.polarion.team.svn.core.resource.IRepositoryResource;
import org.polarion.team.svn.core.resource.ISVNStorage;
import org.polarion.team.svn.core.utility.FileUtility;
import org.polarion.team.svn.core.utility.PatternProvider;
import org.polarion.team.svn.ui.SVNTeamUIPlugin;
import org.polarion.team.svn.ui.composite.AffectedPathsComposite;
import org.polarion.team.svn.ui.extension.ExtensionsManager;
import org.polarion.team.svn.ui.extension.factory.ICommentView;
import org.polarion.team.svn.ui.utility.OverlayedImageDescriptor;
import org.polarion.team.svn.ui.utility.TableViewerSorter;

public class LogMessagesComposite
extends SashForm {
    protected static Image FILE_IMAGE;
    protected static Image FOLDER_IMAGE;
    protected static Image ADDED_FILE_IMAGE;
    protected static Image MODIFIED_FILE_IMAGE;
    protected static Image DELETED_FILE_IMAGE;
    protected static Image REPLACED_FILE_IMAGE;
    protected SashForm innerSashForm;
    protected boolean commentVisible = true;
    protected boolean affectedVisible = true;
    protected boolean hierarchicalAffected;
    protected TableViewer historyTable;
    protected ISelectionChangedListener historyTableListener;
    protected long currentRevision;
    protected Font currentRevisionFont;
    protected Map pathData;
    protected boolean showRelatedPathsOnly;
    protected Set relatedPathsPrefixes;
    protected Set relatedParents;
    protected AffectedPathsComposite affectedPathsComposite;
    protected ICommentView viewManager;
    protected IRepositoryResource repositoryResource;
    protected LogMessage[] msgs = new LogMessage[0];

    public LogMessagesComposite(Composite parent, int logPercent, int style) {
        super(parent, 512);
        this.pathData = new HashMap();
        this.initializeTableView(style, logPercent);
        this.initializeFont();
        this.setDefaults();
    }

    public void setCommentViewerVisible(boolean visible) {
        if (visible) {
            this.innerSashForm.setMaximizedControl(null);
        } else {
            this.innerSashForm.setMaximizedControl(this.historyTable.getControl());
        }
    }

    public void setAffectedPathsViewerVisible(boolean visible) {
        if (visible) {
            this.setMaximizedControl(null);
        } else {
            this.setMaximizedControl((Control)this.innerSashForm);
        }
    }

    public void setResourceTreeVisible(boolean visible) {
        this.affectedPathsComposite.setResourceTreeVisible(visible);
    }

    public void dispose() {
        this.historyTable.removeSelectionChangedListener(this.historyTableListener);
        this.currentRevisionFont.dispose();
    }

    public TableViewer getTableViewer() {
        return this.historyTable;
    }

    public AffectedPathsComposite getAffectedPathsComposite() {
        return this.affectedPathsComposite;
    }

    public void setSelectedRevision(long revision) {
        LogMessage newSelection = null;
        int i = 0;
        while (i < this.msgs.length) {
            if (this.msgs[i].revision == revision) {
                newSelection = this.msgs[i];
                break;
            }
            ++i;
        }
        if (newSelection != null) {
            this.historyTable.setSelection((ISelection)new StructuredSelection(newSelection), true);
        } else {
            this.historyTable.setSelection((ISelection)new StructuredSelection());
        }
    }

    public long[] getSelectedRevisions() {
        IStructuredSelection tSelection = (IStructuredSelection)this.historyTable.getSelection();
        if (tSelection.size() > 0) {
            long[] revisions = new long[tSelection.size()];
            int i = 0;
            Iterator it = tSelection.iterator();
            while (it.hasNext()) {
                revisions[i++] = ((LogMessage)it.next()).revision;
            }
            return revisions;
        }
        return new long[0];
    }

    public LogMessage[] getSelectedLogMessages() {
        IStructuredSelection tSelection = (IStructuredSelection)this.historyTable.getSelection();
        if (tSelection.size() > 0) {
            return tSelection.toList().toArray(new LogMessage[0]);
        }
        return new LogMessage[0];
    }

    public long getSelectedRevision() {
        IStructuredSelection tSelection = (IStructuredSelection)this.historyTable.getSelection();
        if (tSelection.size() > 0) {
            return ((LogMessage)tSelection.getFirstElement()).revision;
        }
        return -1L;
    }

    public String getSelectedMessage() {
        IStructuredSelection tSelection = (IStructuredSelection)this.historyTable.getSelection();
        if (tSelection.size() > 0) {
            String message = ((LogMessage)tSelection.getFirstElement()).message;
            return message == null ? "" : message;
        }
        return "";
    }

    public String getSelectedMessageNoComment() {
        String message = this.getSelectedMessage();
        return message.length() == 0 ? SVNTeamPlugin.instance().getResource("SVNInfo.NoComment") : message;
    }

    public String[][] getSelectedPathData() {
        IStructuredSelection tSelection;
        Object selected = null;
        if (this.historyTable != null && (tSelection = (IStructuredSelection)this.historyTable.getSelection()).size() > 0) {
            selected = tSelection.getFirstElement();
        }
        return selected != null ? (String[][])this.pathData.get(selected) : null;
    }

    public ICommentView getCommentView() {
        return this.viewManager;
    }

    public IRepositoryResource getRepositoryResource() {
        return this.repositoryResource;
    }

    public ISelectionChangedListener getHistoryTableListener() {
        return this.historyTableListener;
    }

    public boolean isShowRelatedPathsOnly() {
        return this.showRelatedPathsOnly;
    }

    public void setShowRelatedPathsOnly(boolean showRelatedPathsOnly) {
        this.showRelatedPathsOnly = showRelatedPathsOnly;
        if (this.historyTableListener != null) {
            this.historyTableListener.selectionChanged(null);
        }
    }

    public void setLogMessages(Revision currentRevision, LogMessage[] msgs, IRepositoryResource repositoryResource) {
        this.msgs = msgs;
        this.repositoryResource = repositoryResource;
        this.currentRevision = -1L;
        this.pathData.clear();
        if (msgs == null || msgs.length == 0) {
            this.msgs = new LogMessage[0];
            this.setTableInput();
            this.historyTableListener.selectionChanged(null);
            return;
        }
        if (repositoryResource != null) {
            ChangePath[] changes = null;
            int i = 0;
            while (i < msgs.length) {
                if (msgs[i].changedPaths != null && msgs[i].changedPaths.length > 0) {
                    changes = msgs[i].changedPaths;
                    break;
                }
                ++i;
            }
            this.relatedPathsPrefixes = null;
            if (changes != null) {
                String baseUrl = repositoryResource.getUrl();
                String changePath = changes[0].path;
                int idx = -1;
                while (changePath.length() > 0 && (idx = baseUrl.indexOf(changePath)) == -1) {
                    changePath = new Path(changePath).removeLastSegments(1).toString();
                }
                if (idx != -1 && idx < baseUrl.length()) {
                    String relatedPathsPrefix = baseUrl.substring(idx + 1, baseUrl.length());
                    this.relatedPathsPrefixes = new HashSet();
                    this.relatedParents = new HashSet();
                    int i2 = 0;
                    while (i2 < msgs.length) {
                        this.relatedPathsPrefixes.add(relatedPathsPrefix);
                        if (msgs[i2].changedPaths != null && msgs[i2].changedPaths.length > 0) {
                            relatedPathsPrefix = this.getNextPrefix(msgs[i2], relatedPathsPrefix, this.relatedParents);
                        }
                        ++i2;
                    }
                }
            }
        }
        if (currentRevision != null && !(currentRevision instanceof ISVNStorage.InvalidRevision)) {
            if (currentRevision.getKind() == 7) {
                this.currentRevision = Math.max(msgs[0].revision, msgs[msgs.length - 1].revision);
            } else if (currentRevision.getKind() == 1) {
                this.currentRevision = ((Revision.Number)currentRevision).getNumber();
            }
        }
        int i = 0;
        while (i < msgs.length) {
            this.mapPathData(msgs[i], msgs[i].changedPaths);
            ++i;
        }
        this.setTableInput();
    }

    public String getSelectedMessagesAsString() {
        String historyText = "";
        LogMessagesLabelProvider provider = new LogMessagesLabelProvider(true);
        Object[] selectedItems = ((IStructuredSelection)this.historyTable.getSelection()).toArray();
        int i = 0;
        while (i < selectedItems.length) {
            Object rowItems = selectedItems[i];
            int j = 1;
            while (j < 6) {
                historyText = String.valueOf(historyText) + provider.getColumnText(rowItems, j);
                historyText = String.valueOf(historyText) + (j < 6 ? "\t" : "");
                ++j;
            }
            historyText = String.valueOf(historyText) + System.getProperty("line.separator");
            ++i;
        }
        return historyText;
    }

    protected static String flattenMultiLineText(String input, String lineSeparatorReplacement) {
        String retVal = PatternProvider.replaceAll((String)input, (String)"\r\n", (String)lineSeparatorReplacement);
        retVal = PatternProvider.replaceAll((String)retVal, (String)"\n", (String)lineSeparatorReplacement);
        retVal = PatternProvider.replaceAll((String)retVal, (String)"\r", (String)lineSeparatorReplacement);
        return retVal;
    }

    protected String revisionToString(long revision) {
        String retVal = String.valueOf(revision);
        if (this.currentRevision == revision) {
            retVal = "*" + retVal;
        }
        return retVal;
    }

    protected String getNextPrefix(LogMessage message, String current, Set relatedParents) {
        String checked = "/" + current;
        ChangePath[] changes = message.changedPaths;
        int i = 0;
        while (i < changes.length) {
            if (changes[i].copySrcPath != null && checked.startsWith(changes[i].path)) {
                String rest = checked.substring(changes[i].path.length());
                String relatedParent = changes[i].copySrcPath.substring(1);
                relatedParents.add(relatedParent);
                relatedParents.add(changes[i].path.substring(1));
                return String.valueOf(relatedParent) + rest;
            }
            ++i;
        }
        return current;
    }

    protected void setTableInput() {
        if (!this.historyTable.getTable().isDisposed()) {
            this.historyTable.setInput((Object)this.msgs);
        }
    }

    protected void mapPathData(Object key, ChangePath[] paths) {
        String[][] pathData = new String[paths == null ? 0 : paths.length][];
        int i = 0;
        while (i < pathData.length) {
            String path = paths[i].path;
            path = path.startsWith("/") ? path.substring(1) : path;
            int idx = path.lastIndexOf("/");
            pathData[i] = new String[]{this.getAction(paths[i].action), idx != -1 ? path.substring(idx + 1) : path, idx != -1 ? path.substring(0, idx) : "", paths[i].copySrcRevision != -1L ? paths[i].copySrcPath : "", paths[i].copySrcRevision != -1L ? "" + paths[i].copySrcRevision : ""};
            ++i;
        }
        this.pathData.put(key, pathData);
    }

    protected String getAction(char action) {
        switch (action) {
            case 'A': {
                return SVNTeamUIPlugin.instance().getResource("LogMessagesComposite.Add");
            }
            case 'M': {
                return SVNTeamUIPlugin.instance().getResource("LogMessagesComposite.Modify");
            }
            case 'D': {
                return SVNTeamUIPlugin.instance().getResource("LogMessagesComposite.Delete");
            }
            case 'R': {
                return SVNTeamUIPlugin.instance().getResource("LogMessagesComposite.Replace");
            }
        }
        throw new RuntimeException(MessageFormat.format(SVNTeamUIPlugin.instance().getResource("Error.InvalidLogAction"), String.valueOf(action)));
    }

    private void setDefaults() {
        SVNTeamUIPlugin instance = SVNTeamUIPlugin.instance();
        FILE_IMAGE = instance.getImageDescriptor("icons/views/history/file.gif").createImage();
        FOLDER_IMAGE = instance.getImageDescriptor("icons/views/history/affected_folder.gif").createImage();
        ADDED_FILE_IMAGE = new OverlayedImageDescriptor(FILE_IMAGE, instance.getImageDescriptor("icons/overlays/addition.gif"), new Point(22, 16), OverlayedImageDescriptor.RIGHT | OverlayedImageDescriptor.CENTER_V).createImage();
        MODIFIED_FILE_IMAGE = new OverlayedImageDescriptor(FILE_IMAGE, instance.getImageDescriptor("icons/overlays/change.gif"), new Point(22, 16), OverlayedImageDescriptor.RIGHT | OverlayedImageDescriptor.CENTER_V).createImage();
        DELETED_FILE_IMAGE = new OverlayedImageDescriptor(FILE_IMAGE, instance.getImageDescriptor("icons/overlays/deletion.gif"), new Point(22, 16), OverlayedImageDescriptor.RIGHT | OverlayedImageDescriptor.CENTER_V).createImage();
        REPLACED_FILE_IMAGE = new OverlayedImageDescriptor(FILE_IMAGE, instance.getImageDescriptor("icons/overlays/replacement.gif"), new Point(22, 16), OverlayedImageDescriptor.RIGHT | OverlayedImageDescriptor.CENTER_V).createImage();
        CompareUI.disposeOnShutdown((Image)FILE_IMAGE);
        CompareUI.disposeOnShutdown((Image)FOLDER_IMAGE);
        CompareUI.disposeOnShutdown((Image)ADDED_FILE_IMAGE);
        CompareUI.disposeOnShutdown((Image)MODIFIED_FILE_IMAGE);
        CompareUI.disposeOnShutdown((Image)DELETED_FILE_IMAGE);
        CompareUI.disposeOnShutdown((Image)REPLACED_FILE_IMAGE);
    }

    private void initializeTableView(int style, int logPercent) {
        GridData data = null;
        data = new GridData(1808);
        data.horizontalSpan = 2;
        this.setLayoutData(data);
        this.innerSashForm = new SashForm((Composite)this, 512);
        Table table = new Table((Composite)this.innerSashForm, style | 0x100 | 0x200 | 0x10000);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        data = new GridData(1808);
        table.setLayoutData((Object)data);
        this.viewManager = ExtensionsManager.getInstance().getCurrentMessageFactory().getCommentView();
        this.viewManager.createCommentView((Composite)this.innerSashForm, 578);
        this.affectedPathsComposite = new AffectedPathsComposite((Composite)this, 4);
        this.affectedPathsComposite.setLayoutData(new GridData(1808));
        this.innerSashForm.setWeights(new int[]{75, 25});
        this.setWeights(new int[]{logPercent, 100 - logPercent});
        TableLayout layout = new TableLayout();
        table.setLayout((Layout)layout);
        this.historyTable = new TableViewer(table);
        TableViewerSorter sorter = new TableViewerSorter(this.historyTable, new TableViewerSorter.IColumnComparator(){

            public int compare(Object row1, Object row2, int column) {
                LogMessage rowData1 = (LogMessage)row1;
                LogMessage rowData2 = (LogMessage)row2;
                if (column == 1) {
                    return new Long(rowData1.revision).compareTo(new Long(rowData2.revision));
                }
                if (column == 2) {
                    return new Long(rowData1.date).compareTo(new Long(rowData2.date));
                }
                if (column == 3) {
                    int files1 = rowData1.changedPaths == null ? 0 : rowData1.changedPaths.length;
                    int files2 = rowData2.changedPaths == null ? 0 : rowData2.changedPaths.length;
                    return new Integer(files1).compareTo(new Integer(files2));
                }
                if (column == 4) {
                    return TableViewerSorter.compare(rowData1.author == null ? "" : rowData1.author, rowData2.author == null ? "" : rowData2.author);
                }
                return TableViewerSorter.compare(rowData1.message == null ? "" : rowData1.message, rowData2.message == null ? "" : rowData2.message);
            }
        });
        this.historyTable.setSorter((ViewerSorter)sorter);
        TableColumn col = new TableColumn(table, 0);
        col.setResizable(false);
        col.setText("");
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(0, 0, false));
        col = new TableColumn(table, 0);
        col.setResizable(true);
        col.setAlignment(131072);
        col.setText(SVNTeamUIPlugin.instance().getResource("LogMessagesComposite.Revision"));
        col.addSelectionListener((SelectionListener)sorter);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(10, true));
        col = new TableColumn(table, 0);
        col.setResizable(true);
        col.setText(SVNTeamUIPlugin.instance().getResource("LogMessagesComposite.Date"));
        col.addSelectionListener((SelectionListener)sorter);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(20, true));
        col = new TableColumn(table, 0);
        col.setResizable(true);
        col.setAlignment(131072);
        col.setText(SVNTeamUIPlugin.instance().getResource("LogMessagesComposite.Changes"));
        col.addSelectionListener((SelectionListener)sorter);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(10, true));
        col = new TableColumn(table, 0);
        col.setResizable(true);
        col.setText(SVNTeamUIPlugin.instance().getResource("LogMessagesComposite.Author"));
        col.addSelectionListener((SelectionListener)sorter);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(13, true));
        col = new TableColumn(table, 0);
        col.setResizable(true);
        col.setText(SVNTeamUIPlugin.instance().getResource("LogMessagesComposite.Comment"));
        col.addSelectionListener((SelectionListener)sorter);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(46, true));
        this.historyTable.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return LogMessagesComposite.this.msgs;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.historyTable.setLabelProvider((IBaseLabelProvider)new LogMessagesLabelProvider(false));
        this.historyTableListener = new ISelectionChangedListener(){
            protected Object oldSelection;
            protected boolean hideUnrelated;
            {
                this.hideUnrelated = LogMessagesComposite.this.showRelatedPathsOnly;
            }

            public void selectionChanged(SelectionChangedEvent event) {
                if (LogMessagesComposite.this.isDisposed()) {
                    return;
                }
                IStructuredSelection tSelection = (IStructuredSelection)LogMessagesComposite.this.historyTable.getSelection();
                if (tSelection.size() > 0) {
                    Object selection = tSelection.getFirstElement();
                    if (this.oldSelection != selection || this.hideUnrelated != LogMessagesComposite.this.showRelatedPathsOnly) {
                        String message = LogMessagesComposite.this.getSelectedMessageNoComment();
                        LogMessagesComposite.this.viewManager.setComment(message);
                        LogMessagesComposite.this.affectedPathsComposite.setRepositoryResource(LogMessagesComposite.this.repositoryResource);
                        LogMessagesComposite.this.affectedPathsComposite.setInput(LogMessagesComposite.this.getSelectedPathData(), LogMessagesComposite.this.getRelatedPathPrefixes(), LogMessagesComposite.this.getRelatedParents(), LogMessagesComposite.this.getSelectedRevision());
                        this.oldSelection = selection;
                        this.hideUnrelated = LogMessagesComposite.this.showRelatedPathsOnly;
                    }
                } else {
                    LogMessagesComposite.this.viewManager.setComment("");
                    LogMessagesComposite.this.affectedPathsComposite.setInput(null, null, null, -1L);
                    this.oldSelection = null;
                }
            }
        };
        this.historyTable.addSelectionChangedListener(this.historyTableListener);
        this.setTableInput();
        this.historyTable.refresh();
    }

    private Collection getRelatedPathPrefixes() {
        return this.showRelatedPathsOnly ? this.relatedPathsPrefixes : null;
    }

    private Collection getRelatedParents() {
        return this.showRelatedPathsOnly ? this.relatedParents : null;
    }

    private void initializeFont() {
        Font defaultFont = JFaceResources.getDefaultFont();
        FontData[] data = defaultFont.getFontData();
        int i = 0;
        while (i < data.length) {
            data[i].setStyle(1);
            ++i;
        }
        this.currentRevisionFont = new Font((Device)this.historyTable.getTable().getDisplay(), data);
    }

    private class LogMessagesLabelProvider
    implements ITableLabelProvider,
    IFontProvider {
        private DateFormat dateTimeFormat = DateFormat.getDateTimeInstance(2, 2, Locale.getDefault());
        private boolean fullMessage;

        public LogMessagesLabelProvider(boolean fullMessage) {
            this.fullMessage = fullMessage;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            LogMessage row = (LogMessage)element;
            switch (columnIndex) {
                case 1: {
                    return LogMessagesComposite.this.revisionToString(row.revision);
                }
                case 2: {
                    return row.date == 0L ? SVNTeamPlugin.instance().getResource("SVNInfo.NoDate") : this.dateTimeFormat.format(new Date(row.date));
                }
                case 3: {
                    return String.valueOf(row.changedPaths != null ? row.changedPaths.length : 0);
                }
                case 4: {
                    return row.author == null || row.author.length() == 0 ? SVNTeamPlugin.instance().getResource("SVNInfo.NoAuthor") : row.author;
                }
                case 5: {
                    return row.message == null || row.message.length() == 0 ? SVNTeamPlugin.instance().getResource("SVNInfo.NoComment") : (this.fullMessage ? LogMessagesComposite.flattenMultiLineText(row.message, " ") : FileUtility.formatMultilineText((String)row.message));
                }
            }
            return "";
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return true;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Font getFont(Object element) {
            LogMessage row = (LogMessage)element;
            if (LogMessagesComposite.this.currentRevision == row.revision && !LogMessagesComposite.this.currentRevisionFont.isDisposed()) {
                return LogMessagesComposite.this.currentRevisionFont;
            }
            return null;
        }
    }
}

