/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui.composite;

import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.polarion.team.svn.core.resource.ProxySettings;
import org.polarion.team.svn.ui.SVNTeamUIPlugin;
import org.polarion.team.svn.ui.composite.AbstractDynamicComposite;
import org.polarion.team.svn.ui.composite.IPropertiesPanel;
import org.polarion.team.svn.ui.composite.SecurityWarningComposite;
import org.polarion.team.svn.ui.utility.UserInputHistory;
import org.polarion.team.svn.ui.verifier.AbstractVerifierProxy;
import org.polarion.team.svn.ui.verifier.CompositeVerifier;
import org.polarion.team.svn.ui.verifier.IValidationManager;
import org.polarion.team.svn.ui.verifier.NonEmptyFieldVerifier;
import org.polarion.team.svn.ui.verifier.ProxyPortVerifier;

public class ProxyComposite
extends AbstractDynamicComposite
implements IPropertiesPanel {
    protected static final String USER_HISTORY_NAME = "proxyUser";
    protected static final String HOST_HISTORY_NAME = "proxyHost";
    protected boolean proxyEnabled;
    protected String host;
    protected int port;
    protected boolean authenticationEnabled;
    protected String username;
    protected String password;
    protected boolean savePassword;
    protected boolean callback;
    protected Button enableAuthenticationCheckBox;
    protected Button proxyEnableCheckBox;
    protected Combo hostText;
    protected Text portText;
    protected Combo usernameText;
    protected Text passwordText;
    protected Button savePasswordCheckBox;
    protected IValidationManager validationManager;
    protected UserInputHistory userHistory;
    protected UserInputHistory hostHistory;
    protected boolean tempProxyEnabled;
    protected boolean tempAuthEnabled;
    protected boolean tempSavePassEnabled;
    protected boolean tempOptionsSaved;

    public ProxyComposite(Composite parent, int style, IValidationManager validationManager) {
        this(parent, style, validationManager, false);
    }

    public ProxyComposite(Composite parent, int style, IValidationManager validationManager, boolean callback) {
        super(parent, style);
        this.validationManager = validationManager;
        this.callback = callback;
        this.port = 3128;
    }

    public ProxySettings getProxySettingsDirect() {
        ProxySettings settings = new ProxySettings();
        this.getProxySettingsDirectImpl(settings);
        return settings;
    }

    public void setProxySettingsDirect(ProxySettings settings) {
        this.proxyEnableCheckBox.setSelection(settings.isEnabled());
        this.portText.setText(String.valueOf(settings.getPort()));
        this.hostText.setText(settings.getHost());
        this.enableAuthenticationCheckBox.setSelection(settings.isAuthenticationEnabled());
        this.usernameText.setText(settings.getUsername());
        this.passwordText.setText(settings.getPassword());
        this.savePasswordCheckBox.setSelection(settings.isPasswordSaved());
        if (this.callback && settings.isAuthenticationEnabled()) {
            if (this.username != null && this.username.trim().length() > 0) {
                this.passwordText.setFocus();
                this.passwordText.selectAll();
            } else {
                this.usernameText.setFocus();
            }
        }
        this.refreshControlsEnablement();
    }

    public void saveChanges() {
        this.userHistory.addLine(this.usernameText.getText());
        this.hostHistory.addLine(this.hostText.getText());
        this.proxyEnabled = this.proxyEnableCheckBox.getSelection();
        if (this.proxyEnabled) {
            this.host = this.hostText.getText().trim();
            this.port = Integer.parseInt(this.portText.getText().trim());
            this.authenticationEnabled = this.enableAuthenticationCheckBox.getSelection();
            if (this.authenticationEnabled) {
                this.username = this.usernameText.getText().trim();
                this.savePassword = this.savePasswordCheckBox.getSelection();
                this.password = this.passwordText.getText().trim();
            }
        }
    }

    public void resetChanges() {
        this.proxyEnableCheckBox.setSelection(this.proxyEnabled);
        this.portText.setText(String.valueOf(this.port));
        this.hostText.setText(this.host != null ? this.host : "");
        this.enableAuthenticationCheckBox.setSelection(this.authenticationEnabled);
        this.usernameText.setText(this.username != null ? this.username : "");
        this.passwordText.setText(this.password != null ? this.password : "");
        this.savePasswordCheckBox.setSelection(this.savePassword);
        if (this.callback && this.authenticationEnabled) {
            if (this.username != null && this.username.trim().length() > 0) {
                this.passwordText.setFocus();
                this.passwordText.selectAll();
            } else {
                this.usernameText.setFocus();
            }
        }
        this.refreshControlsEnablement();
    }

    public void cancelChanges() {
    }

    public void initialize() {
        GridLayout layout = null;
        GridData data = null;
        layout = new GridLayout();
        layout.verticalSpacing = 12;
        layout.marginHeight = 7;
        this.setLayout((Layout)layout);
        data = new GridData(1808);
        this.setLayoutData(data);
        Composite wrap = new Composite((Composite)this, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 3;
        wrap.setLayout((Layout)layout);
        data = new GridData(768);
        wrap.setLayoutData((Object)data);
        this.proxyEnableCheckBox = new Button(wrap, 32);
        data = new GridData(32);
        this.proxyEnableCheckBox.setLayoutData((Object)data);
        this.proxyEnableCheckBox.setText(SVNTeamUIPlugin.instance().getResource("ProxyComposite.EnableProxy"));
        this.proxyEnableCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ProxyComposite.this.refreshControlsEnablement();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Group group = new Group(wrap, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        data = new GridData(768);
        data.horizontalSpan = 2;
        group.setLayoutData((Object)data);
        group.setText(SVNTeamUIPlugin.instance().getResource("ProxyComposite.Proxy"));
        Label description = new Label((Composite)group, 0);
        data = new GridData(32);
        description.setLayoutData((Object)data);
        description.setText(SVNTeamUIPlugin.instance().getResource("ProxyComposite.Host"));
        this.hostHistory = new UserInputHistory(HOST_HISTORY_NAME);
        this.hostText = new Combo((Composite)group, 4);
        data = new GridData(768);
        data.widthHint = 200;
        this.hostText.setLayoutData((Object)data);
        this.hostText.setVisibleItemCount(this.hostHistory.getDepth());
        this.hostText.setItems(this.hostHistory.getHistory());
        this.validationManager.attachTo((Control)this.hostText, new AbstractVerifierProxy(new NonEmptyFieldVerifier(SVNTeamUIPlugin.instance().getResource("ProxyComposite.Host.Verifier"))){

            protected boolean isVerificationEnabled(Control input) {
                return ProxyComposite.this.proxyEnableCheckBox.getSelection() && ProxyComposite.this.isVisible();
            }
        });
        description = new Label((Composite)group, 0);
        data = new GridData(32);
        description.setLayoutData((Object)data);
        description.setText(SVNTeamUIPlugin.instance().getResource("ProxyComposite.Port"));
        this.portText = new Text((Composite)group, 2048);
        data = new GridData(768);
        this.portText.setLayoutData((Object)data);
        CompositeVerifier verifier = new CompositeVerifier();
        String name = SVNTeamUIPlugin.instance().getResource("ProxyComposite.Port.Verifier");
        verifier.add(new NonEmptyFieldVerifier(name));
        verifier.add(new ProxyPortVerifier(name));
        this.validationManager.attachTo((Control)this.portText, new AbstractVerifierProxy(verifier){

            protected boolean isVerificationEnabled(Control input) {
                return ProxyComposite.this.proxyEnableCheckBox.getSelection() && ProxyComposite.this.isVisible();
            }
        });
        wrap = new Composite((Composite)this, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 3;
        data = new GridData(768);
        wrap.setLayout((Layout)layout);
        wrap.setLayoutData((Object)data);
        this.enableAuthenticationCheckBox = new Button(wrap, 32);
        this.enableAuthenticationCheckBox.setText(SVNTeamUIPlugin.instance().getResource("ProxyComposite.EnableAuthentication"));
        this.enableAuthenticationCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ProxyComposite.this.refreshControlsEnablement();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Group authGroup = new Group(wrap, 0);
        data = new GridData(768);
        data.horizontalSpan = 2;
        authGroup.setLayoutData((Object)data);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.verticalSpacing = 12;
        authGroup.setLayout((Layout)layout);
        authGroup.setText(SVNTeamUIPlugin.instance().getResource("ProxyComposite.Authentication"));
        Composite inner = new Composite((Composite)authGroup, 4);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        inner.setLayout((Layout)layout);
        data = new GridData(768);
        data.horizontalSpan = 2;
        inner.setLayoutData((Object)data);
        description = new Label(inner, 0);
        data = new GridData(32);
        description.setLayoutData((Object)data);
        description.setText(SVNTeamUIPlugin.instance().getResource("ProxyComposite.Username"));
        this.userHistory = new UserInputHistory(USER_HISTORY_NAME);
        this.usernameText = new Combo(inner, 4);
        data = new GridData(768);
        data.widthHint = 200;
        this.usernameText.setLayoutData((Object)data);
        this.usernameText.setVisibleItemCount(this.userHistory.getDepth());
        this.usernameText.setItems(this.userHistory.getHistory());
        description = new Label(inner, 0);
        description.setText(SVNTeamUIPlugin.instance().getResource("ProxyComposite.Password"));
        data = new GridData(32);
        description.setLayoutData((Object)data);
        this.passwordText = new Text(inner, 0x400800);
        data = new GridData(768);
        data.widthHint = 200;
        this.passwordText.setLayoutData((Object)data);
        inner = new Composite((Composite)authGroup, 4);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        inner.setLayout((Layout)layout);
        data = new GridData(768);
        data.horizontalSpan = 2;
        inner.setLayoutData((Object)data);
        this.savePasswordCheckBox = new Button(inner, 32);
        data = new GridData(768);
        this.savePasswordCheckBox.setLayoutData((Object)data);
        this.savePasswordCheckBox.setText(SVNTeamUIPlugin.instance().getResource("ProxyComposite.SavePassword"));
        new SecurityWarningComposite(inner);
    }

    public boolean isAuthenticationEnabled() {
        return this.authenticationEnabled;
    }

    public void setAuthenticationEnabled(boolean authenticationEnabled) {
        this.authenticationEnabled = authenticationEnabled;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public boolean isProxyEnabled() {
        return this.proxyEnabled;
    }

    public void setProxyEnabled(boolean proxyEnabled) {
        this.proxyEnabled = proxyEnabled;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public boolean isSavePassword() {
        return this.savePassword;
    }

    public void setSavePassword(boolean savePassword) {
        this.savePassword = savePassword;
    }

    protected void refreshControlsEnablement() {
        boolean enabled = this.proxyEnableCheckBox.getSelection();
        this.hostText.setEnabled(enabled);
        this.portText.setEnabled(enabled);
        this.enableAuthenticationCheckBox.setEnabled(enabled);
        boolean authEnabled = this.enableAuthenticationCheckBox.getSelection();
        this.usernameText.setEnabled(enabled && authEnabled);
        this.passwordText.setEnabled(enabled && authEnabled);
        this.savePasswordCheckBox.setEnabled(enabled && authEnabled);
        this.validationManager.validateContent();
    }

    public void saveAppearance() {
        this.tempProxyEnabled = this.proxyEnableCheckBox.getSelection();
        this.tempAuthEnabled = this.enableAuthenticationCheckBox.getSelection();
        this.tempSavePassEnabled = this.savePasswordCheckBox.getSelection();
        this.tempOptionsSaved = true;
    }

    public void restoreAppearance() {
        if (this.tempOptionsSaved) {
            this.proxyEnableCheckBox.setSelection(this.tempProxyEnabled);
            this.enableAuthenticationCheckBox.setSelection(this.tempAuthEnabled);
            this.savePasswordCheckBox.setSelection(this.tempSavePassEnabled);
            this.tempOptionsSaved = false;
            this.refreshControlsEnablement();
        } else {
            this.resetChanges();
        }
    }

    public void revalidateContent() {
        this.validationManager.validateContent();
    }

    protected void getProxySettingsDirectImpl(ProxySettings settings) {
        settings.setEnabled(this.proxyEnableCheckBox.getSelection());
        settings.setHost(this.hostText.getText());
        String text = this.portText.getText().trim();
        if (text.length() > 0) {
            settings.setPort(Integer.parseInt(text));
        }
        settings.setAuthenticationEnabled(this.enableAuthenticationCheckBox.getSelection());
        settings.setUsername(this.usernameText.getText());
        settings.setPassword(this.passwordText.getText());
        settings.setPasswordSaved(this.savePasswordCheckBox.getSelection());
    }
}

