/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui.composite;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.polarion.team.svn.core.client.Revision;
import org.polarion.team.svn.core.operation.IActionOperation;
import org.polarion.team.svn.core.operation.remote.GetLogMessagesOperation;
import org.polarion.team.svn.core.resource.IRepositoryResource;
import org.polarion.team.svn.ui.SVNTeamUIPlugin;
import org.polarion.team.svn.ui.dialog.DefaultDialog;
import org.polarion.team.svn.ui.panel.common.SelectRevisionPanel;
import org.polarion.team.svn.ui.preferences.SVNTeamPreferences;
import org.polarion.team.svn.ui.utility.UIMonitorUtility;
import org.polarion.team.svn.ui.verifier.AbstractVerifierProxy;
import org.polarion.team.svn.ui.verifier.CompositeVerifier;
import org.polarion.team.svn.ui.verifier.IValidationManager;
import org.polarion.team.svn.ui.verifier.IntegerFieldVerifier;
import org.polarion.team.svn.ui.verifier.NonEmptyFieldVerifier;

public class RevisionComposite
extends Composite {
    protected IRepositoryResource selectedResource;
    protected Revision defaultRevision;
    protected long currentRevision;
    protected long lastSelectedRevision;
    protected boolean stopOnCopy;
    protected String[] captions;
    protected Revision selectedRevision;
    protected Text revisionField;
    protected Button headRevisionRadioButton;
    protected Button changeRevisionRadioButton;
    protected Button changeRevisionButton;
    protected IValidationManager validationManager;

    public RevisionComposite(Composite parent, IValidationManager validationManager, boolean stopOnCopy, String[] captions, Revision defaultRevision) {
        super(parent, 0);
        this.stopOnCopy = stopOnCopy;
        this.validationManager = validationManager;
        this.lastSelectedRevision = -1L;
        this.captions = captions;
        this.defaultRevision = defaultRevision;
        this.createControls();
    }

    public Revision getSelectedRevision() {
        return this.selectedRevision;
    }

    public IRepositoryResource getSelectedResource() {
        return this.selectedResource;
    }

    public void addChangeRevisionListener(SelectionListener listener) {
        this.changeRevisionButton.addSelectionListener(listener);
    }

    public void setSelectedResource(IRepositoryResource resource) {
        this.selectedResource = resource;
        Revision rev = this.selectedResource.getSelectedRevision();
        if (rev.getKind() == 1) {
            this.selectedRevision = rev;
            this.lastSelectedRevision = ((Revision.Number)this.selectedRevision).getNumber();
            if (this.changeRevisionRadioButton != null) {
                this.revisionField.setText(this.selectedRevision.toString());
                this.headRevisionRadioButton.setSelection(false);
                this.changeRevisionRadioButton.setSelection(true);
                this.changeRevisionButton.setEnabled(true);
                this.revisionField.setEditable(true);
            }
        } else {
            this.selectedRevision = this.defaultRevision;
            this.lastSelectedRevision = -1L;
            if (this.changeRevisionRadioButton != null) {
                this.revisionField.setText("");
                this.headRevisionRadioButton.setSelection(true);
                this.changeRevisionRadioButton.setSelection(false);
                this.changeRevisionButton.setEnabled(false);
                this.revisionField.setEditable(false);
            }
        }
    }

    public long getCurrentRevision() {
        return this.currentRevision;
    }

    public void setCurrentRevision(long currentRevision) {
        this.currentRevision = currentRevision;
    }

    private void createControls() {
        GridLayout layout = null;
        GridData data = null;
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        Group group = new Group((Composite)this, 0);
        group.setText(this.captions == null ? SVNTeamUIPlugin.instance().getResource("RevisionComposite.Revision") : this.captions[0]);
        layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        data = new GridData(768);
        data.horizontalSpan = 2;
        group.setLayoutData((Object)data);
        this.headRevisionRadioButton = new Button((Composite)group, 16);
        this.headRevisionRadioButton.setText(this.captions == null ? SVNTeamUIPlugin.instance().getResource("RevisionComposite.HeadRevision") : this.captions[1]);
        this.headRevisionRadioButton.setLayoutData((Object)new GridData());
        this.headRevisionRadioButton.setSelection(true);
        this.headRevisionRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RevisionComposite.this.validationManager.validateContent();
                Button button = (Button)e.widget;
                if (button.getSelection()) {
                    RevisionComposite.this.selectedRevision = RevisionComposite.this.defaultRevision;
                    RevisionComposite.this.changeRevisionButton.setEnabled(false);
                    RevisionComposite.this.revisionField.setEditable(false);
                    RevisionComposite.this.revisionField.setText("");
                } else {
                    RevisionComposite.this.changeRevisionButton.setEnabled(true);
                    RevisionComposite.this.revisionField.setEditable(true);
                    if (RevisionComposite.this.lastSelectedRevision != -1L) {
                        RevisionComposite.this.revisionField.setText(String.valueOf(RevisionComposite.this.lastSelectedRevision));
                        RevisionComposite.this.selectedRevision = Revision.getInstance((long)RevisionComposite.this.lastSelectedRevision);
                    }
                }
                RevisionComposite.this.additionalValidation();
            }
        });
        Label emptyControl = new Label((Composite)group, 0);
        emptyControl.setLayoutData((Object)new GridData());
        emptyControl.setText("");
        this.changeRevisionRadioButton = new Button((Composite)group, 16);
        this.changeRevisionRadioButton.setText(SVNTeamUIPlugin.instance().getResource("RevisionComposite.Revision"));
        Composite revisionSelection = new Composite((Composite)group, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        revisionSelection.setLayout((Layout)layout);
        data = new GridData(768);
        revisionSelection.setLayoutData((Object)data);
        data = new GridData();
        data.widthHint = 60;
        this.revisionField = new Text(revisionSelection, 2052);
        this.revisionField.setLayoutData((Object)data);
        this.revisionField.setEditable(false);
        CompositeVerifier verifier = new CompositeVerifier();
        String name = SVNTeamUIPlugin.instance().getResource("RevisionComposite.Revision.Verifier");
        verifier.add(new NonEmptyFieldVerifier(name));
        verifier.add(new IntegerFieldVerifier(name, true));
        this.validationManager.attachTo((Control)this.revisionField, new AbstractVerifierProxy(verifier){

            protected boolean isVerificationEnabled(Control input) {
                return RevisionComposite.this.changeRevisionRadioButton.getSelection();
            }
        });
        this.revisionField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String input = ((Text)e.widget).getText();
                try {
                    long selectedRevisionNum = Long.parseLong(input);
                    if (selectedRevisionNum >= 0L) {
                        RevisionComposite.this.lastSelectedRevision = selectedRevisionNum;
                        RevisionComposite.this.selectedRevision = Revision.getInstance((long)selectedRevisionNum);
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            }
        });
        this.changeRevisionButton = new Button(revisionSelection, 8);
        this.changeRevisionButton.setText(SVNTeamUIPlugin.instance().getResource("RevisionComposite.Select"));
        data = new GridData();
        data.widthHint = DefaultDialog.computeButtonWidth(this.changeRevisionButton);
        this.changeRevisionButton.setLayoutData((Object)data);
        this.changeRevisionButton.setEnabled(false);
        this.changeRevisionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GetLogMessagesOperation msgsOp = new GetLogMessagesOperation(RevisionComposite.this.selectedResource, RevisionComposite.this.stopOnCopy);
                IPreferenceStore store = SVNTeamUIPlugin.instance().getPreferenceStore();
                if (SVNTeamPreferences.getHistoryBoolean(store, "pagingEnable")) {
                    msgsOp.setLimit((long)SVNTeamPreferences.getHistoryInt(store, "pageSize"));
                }
                if (!UIMonitorUtility.doTaskNowDefault(RevisionComposite.this.getShell(), (IActionOperation)msgsOp, true).isCancelled() && msgsOp.getExecutionState() == 0) {
                    SelectRevisionPanel panel = new SelectRevisionPanel(msgsOp, 4, RevisionComposite.this.currentRevision);
                    DefaultDialog dialog = new DefaultDialog(RevisionComposite.this.getShell(), panel);
                    if (dialog.open() == 0) {
                        long selectedRevisionNum;
                        RevisionComposite.this.lastSelectedRevision = selectedRevisionNum = panel.getSelectedRevision();
                        RevisionComposite.this.selectedRevision = Revision.getInstance((long)selectedRevisionNum);
                        RevisionComposite.this.revisionField.setText(String.valueOf(selectedRevisionNum));
                    }
                }
                RevisionComposite.this.additionalValidation();
            }
        });
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.changeRevisionButton.setEnabled(enabled && this.changeRevisionRadioButton.getSelection());
        this.changeRevisionRadioButton.setEnabled(enabled);
        this.headRevisionRadioButton.setEnabled(enabled);
    }

    public void additionalValidation() {
    }
}

