/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui.composite;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.internal.ide.misc.ContainerSelectionGroup;
import org.polarion.team.svn.core.IStateFilter;
import org.polarion.team.svn.core.resource.ILocalResource;
import org.polarion.team.svn.core.svnstorage.SVNRemoteStorage;
import org.polarion.team.svn.core.utility.FileUtility;
import org.polarion.team.svn.ui.SVNTeamUIPlugin;
import org.polarion.team.svn.ui.verifier.AbstractFormattedVerifier;

public class SVNContainerSelectionGroup
extends ContainerSelectionGroup {
    public SVNContainerSelectionGroup(Composite parent, Listener listener) {
        super(parent, listener, false, "", false);
    }

    public void createContents(String message, int heightHint, int widthHint) {
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.setLayoutData(new GridData(4, 4, true, true));
        this.createTreeViewer(heightHint);
        Dialog.applyDialogFont((Control)this);
    }

    public void createContents(String message, int heightHint) {
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.setLayoutData(new GridData(4, 4, true, true));
        this.createTreeViewer(heightHint);
        Dialog.applyDialogFont((Control)this);
    }

    public static class SVNContainerSelectionVerifier
    extends AbstractFormattedVerifier {
        protected static String ERROR_MESSAGE;
        protected static String DESTINATION_IS_DETACHED_FROM_SVN;
        protected static String DESTINATION_DIRECTORY_IS_DELETED;
        protected static String DESTINATION_DIRECTORY_IS_OBSTRUCTED;

        public SVNContainerSelectionVerifier() {
            super("");
            ERROR_MESSAGE = SVNTeamUIPlugin.instance().getResource("SVNContainerSelectionGroup.Verifier.NotSelected");
            DESTINATION_IS_DETACHED_FROM_SVN = SVNTeamUIPlugin.instance().getResource("SVNContainerSelectionGroup.Verifier.NonSVN");
            DESTINATION_DIRECTORY_IS_DELETED = SVNTeamUIPlugin.instance().getResource("SVNContainerSelectionGroup.Verifier.Deleted");
            DESTINATION_DIRECTORY_IS_OBSTRUCTED = SVNTeamUIPlugin.instance().getResource("SVNContainerSelectionGroup.Verifier.Obstructed");
        }

        protected String getErrorMessageImpl(Control input) {
            SVNContainerSelectionGroup control = (SVNContainerSelectionGroup)input;
            if (control.getContainerFullPath() == null) {
                return ERROR_MESSAGE;
            }
            IResource destinationRoot = ResourcesPlugin.getWorkspace().getRoot().findMember(control.getContainerFullPath());
            SVNRemoteStorage storage = SVNRemoteStorage.instance();
            ILocalResource localDest = storage.asLocalResource(destinationRoot);
            if (localDest == null) {
                return this.isNonSVNCheckDisabled() ? DESTINATION_IS_DETACHED_FROM_SVN : null;
            }
            if (IStateFilter.SF_DELETED.accept(destinationRoot, localDest.getStatus(), localDest.getChangeMask())) {
                return DESTINATION_DIRECTORY_IS_DELETED;
            }
            if (IStateFilter.SF_OBSTRUCTED.accept(destinationRoot, localDest.getStatus(), localDest.getChangeMask())) {
                return DESTINATION_DIRECTORY_IS_OBSTRUCTED;
            }
            return null;
        }

        protected String getWarningMessageImpl(Control input) {
            return null;
        }

        protected boolean isNonSVNCheckDisabled() {
            return true;
        }
    }

    public static class SVNContainerCheckOutSelectionVerifier
    extends SVNContainerSelectionVerifier {
        protected static String WARNING_MESSAGE;

        public SVNContainerCheckOutSelectionVerifier() {
            WARNING_MESSAGE = SVNTeamUIPlugin.instance().getResource("SVNContainerSelectionGroup.Verifier.NonSVNWarning");
        }

        protected String getWarningMessageImpl(Control input) {
            SVNContainerSelectionGroup control = (SVNContainerSelectionGroup)input;
            IResource destinationRoot = ResourcesPlugin.getWorkspace().getRoot().findMember(control.getContainerFullPath());
            if (!FileUtility.isConnected((IResource)destinationRoot)) {
                return WARNING_MESSAGE;
            }
            return null;
        }

        protected boolean isNonSVNCheckDisabled() {
            return false;
        }
    }
}

