/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui.crashrecovery.invalidmeta;

import java.text.MessageFormat;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.polarion.team.svn.core.extension.CoreExtensionsManager;
import org.polarion.team.svn.core.extension.factory.ISVNClientWrapperFactory;
import org.polarion.team.svn.core.svnstorage.SVNRemoteStorage;
import org.polarion.team.svn.core.utility.FileUtility;
import org.polarion.team.svn.ui.SVNTeamUIPlugin;
import org.polarion.team.svn.ui.panel.AbstractDialogPanel;
import org.polarion.team.svn.ui.preferences.SVNTeamPreferences;

public class ValidClientsSelectionPanel
extends AbstractDialogPanel {
    protected Combo svnClientField;
    protected ISVNClientWrapperFactory[] factories;
    protected String svnClient;

    public ValidClientsSelectionPanel(IProject project, List validClients) {
        this.dialogTitle = MessageFormat.format(SVNTeamUIPlugin.instance().getResource("ValidClientsSelectionPanel.Title"), project.getName());
        this.dialogDescription = SVNTeamUIPlugin.instance().getResource("ValidClientsSelectionPanel.Description");
        this.defaultMessage = SVNTeamUIPlugin.instance().getResource("ValidClientsSelectionPanel.Message");
        this.factories = validClients.toArray(new ISVNClientWrapperFactory[validClients.size()]);
    }

    public Point getPrefferedSize() {
        return new Point(500, 60);
    }

    public void postInit() {
        super.postInit();
        this.svnClient = this.factories[this.svnClientField.getSelectionIndex()].getId();
    }

    public void createControls(Composite parent) {
        super.createControls(parent);
        GridLayout layout = null;
        GridData data = null;
        Composite composite = new Composite(parent, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        data = new GridData(1808);
        composite.setLayoutData((Object)data);
        Label label = new Label(composite, 0);
        data = new GridData();
        label.setLayoutData((Object)data);
        label.setText(SVNTeamUIPlugin.instance().getResource("ValidClientsSelectionPanel.Clients"));
        this.svnClientField = new Combo(composite, 8);
        data = new GridData(768);
        this.svnClientField.setLayoutData((Object)data);
        FileUtility.sort((Object[])this.factories, (Comparator)new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((ISVNClientWrapperFactory)o1).getName().compareTo(((ISVNClientWrapperFactory)o2).getName());
            }
        });
        String[] items = new String[this.factories.length];
        int i = 0;
        while (i < items.length) {
            items[i] = String.valueOf(this.factories[i].getName()) + " (" + this.factories[i].getClientVersion().replace('\n', ' ') + ")";
            ++i;
        }
        this.svnClientField.setItems(items);
        this.svnClientField.select(0);
        this.svnClientField.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ValidClientsSelectionPanel.this.svnClient = ValidClientsSelectionPanel.this.factories[ValidClientsSelectionPanel.this.svnClientField.getSelectionIndex()].getId();
            }
        });
    }

    protected void cancelChanges() {
    }

    protected void saveChanges() {
        String oldId = CoreExtensionsManager.instance().getSVNClientWrapperFactory().getId();
        if (!oldId.equals(this.svnClient)) {
            SVNTeamPreferences.setCoreString(SVNTeamUIPlugin.instance().getPreferenceStore(), "svnclient", this.svnClient);
            SVNTeamUIPlugin.instance().savePluginPreferences();
            SVNRemoteStorage.instance().dispose();
        }
    }
}

