/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui.debugmail;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import org.eclipse.core.runtime.IStatus;
import org.polarion.team.svn.core.extension.CoreExtensionsManager;
import org.polarion.team.svn.core.extension.factory.ISVNClientWrapperFactory;
import org.polarion.team.svn.ui.debugmail.MailDelivery;
import org.polarion.team.svn.ui.extension.factory.IMailSettingsProvider;

public class Reporter {
    public static void sendReport(IMailSettingsProvider provider, IStatus status, String plugin, String operationName, String userComment, String email, String name, String sequenceNumber) throws Exception {
        String messageBody = Reporter.formReport(provider, status, plugin, userComment, email, name, sequenceNumber);
        MailDelivery.sendMail(messageBody, operationName, sequenceNumber, provider);
    }

    public static void sendReport(IMailSettingsProvider provider, String subject, String userComment, String email, String name, String sequenceNumber, boolean isProblem) throws Exception {
        String messageBody = Reporter.formReport(provider, userComment, email, name, sequenceNumber, isProblem);
        MailDelivery.sendMailReport(messageBody, subject, sequenceNumber, provider);
    }

    public static boolean checkStatus(IStatus status, IStatusVisitor visitor) {
        if (!status.isMultiStatus()) {
            return visitor.visit(status);
        }
        IStatus[] children = status.getChildren();
        int i = 0;
        while (i < children.length) {
            if (Reporter.checkStatus(children[i], visitor)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String getStackTrace(IStatus operationStatus) {
        final String[] stackTrace = new String[]{""};
        Reporter.checkStatus(operationStatus, new IStatusVisitor(){

            public boolean visit(IStatus status) {
                String trace = Reporter.getOutput(status);
                stackTrace[0] = String.valueOf(stackTrace[0]) + trace + "\n";
                return false;
            }
        });
        return stackTrace[0];
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getOutput(IStatus status) {
        Throwable t = status.getException();
        String message = "";
        if (t == null) return message;
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        PrintWriter writer = new PrintWriter(output);
        try {
            t.printStackTrace(writer);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            writer.close();
            throw throwable;
        }
        {
            Object var5_7 = null;
            writer.close();
            return output.toString();
        }
    }

    public static String formReport(IMailSettingsProvider provider, IStatus status, String plugin, String userComment, String email, String name, String sequenceNumber) {
        String messageBody = String.valueOf(Reporter.formReportHeader(provider, userComment, email, name, sequenceNumber)) + "<br><br><b>Plug-in ID:</b> " + plugin;
        String msgPlusTrace = "";
        if (status != null) {
            String[] stackTraces = Reporter.getStackTrace(status).split("\n\n");
            int i = 0;
            while (i < stackTraces.length) {
                int idx = stackTraces[i].indexOf(10);
                msgPlusTrace = idx == -1 ? String.valueOf(msgPlusTrace) + stackTraces[i] + "<br><br>" : String.valueOf(msgPlusTrace) + "<b>" + stackTraces[i].substring(0, idx) + "</b><br>" + stackTraces[i] + "<br><br>";
                ++i;
            }
        }
        msgPlusTrace = String.valueOf(msgPlusTrace) + Reporter.getJVMProperties();
        messageBody = String.valueOf(messageBody) + "<br><br>" + msgPlusTrace;
        return messageBody;
    }

    public static String formReport(IMailSettingsProvider provider, String userComment, String email, String name, String sequenceNumber, boolean isProblem) {
        String report = Reporter.formReportHeader(provider, userComment, email, name, sequenceNumber);
        return isProblem ? String.valueOf(report) + "<br><br>" + Reporter.getJVMProperties() : report;
    }

    protected static String formReportHeader(IMailSettingsProvider provider, String userComment, String email, String name, String sequenceNumber) {
        String author = String.valueOf(name != null ? name : "") + (email != null && email.trim().length() > 0 ? " &lt;" + email + "&gt;" : "");
        author = author.trim().length() > 0 ? author : "<i>[not specified]</i>";
        userComment = userComment != null && userComment.trim().length() > 0 ? userComment : "<i>[empty]</i>";
        return "<b>" + sequenceNumber + "</b><br><br><b>Product:</b> " + provider.getPluginName() + "<br><br><b>Version:</b> " + provider.getProductVersion() + "<br><br><b>From:</b> " + author + "<br><br><b>User comment:</b><br>" + userComment + Reporter.getSVNClient();
    }

    protected static String getSVNClient() {
        ISVNClientWrapperFactory factory = CoreExtensionsManager.instance().getSVNClientWrapperFactory();
        return "<br><br><b>SVN Client:</b> " + factory.getId() + " " + factory.getVersion() + " " + factory.getClientVersion();
    }

    protected static String getJVMProperties() {
        return "<b>JVM Properties:</b><br>" + System.getProperties().toString().replace('\n', ' ') + "<br><br>";
    }

    public static interface IStatusVisitor {
        public boolean visit(IStatus var1);
    }
}

