/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui.decorator;

import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.ui.TeamImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.themes.ITheme;
import org.polarion.team.svn.core.IStateFilter;
import org.polarion.team.svn.core.SVNTeamPlugin;
import org.polarion.team.svn.core.resource.ILocalResource;
import org.polarion.team.svn.core.resource.IRepositoryLocation;
import org.polarion.team.svn.core.resource.IRepositoryResource;
import org.polarion.team.svn.core.resource.IRepositoryRoot;
import org.polarion.team.svn.core.resource.events.IResourceStatesListener;
import org.polarion.team.svn.core.resource.events.ResourceStatesChangedEvent;
import org.polarion.team.svn.core.svnstorage.SVNRemoteStorage;
import org.polarion.team.svn.core.utility.SVNUtility;
import org.polarion.team.svn.ui.SVNTeamUIPlugin;
import org.polarion.team.svn.ui.decorator.DecoratorVariables;
import org.polarion.team.svn.ui.decorator.IDecorationFilter;
import org.polarion.team.svn.ui.decorator.IVariable;
import org.polarion.team.svn.ui.decorator.IVariableContentProvider;
import org.polarion.team.svn.ui.decorator.TextVariableSetProvider;
import org.polarion.team.svn.ui.extension.ExtensionsManager;
import org.polarion.team.svn.ui.preferences.SVNTeamPreferences;
import org.polarion.team.svn.ui.utility.UIMonitorUtility;

public abstract class AbstractResourceDecorator
extends LabelProvider
implements ILightweightLabelDecorator {
    private static DateFormat dateTimeFormat = DateFormat.getDateTimeInstance(2, 2, Locale.getDefault());
    protected static final ImageDescriptor OVR_VERSIONED = TeamImages.getImageDescriptor((String)"ovr/version_controlled.gif");
    protected static final ImageDescriptor OVR_ADDED = TeamImages.getImageDescriptor((String)"ovr/waiting_ovr.gif");
    protected static ImageDescriptor OVR_NEW = TeamImages.getImageDescriptor((String)"ovr/dirty_ov.gif");
    protected static ImageDescriptor OVR_MODIFIED = TeamImages.getImageDescriptor((String)"ovr/dirty_ov.gif");
    protected static ImageDescriptor OVR_CONFLICTED;
    protected static ImageDescriptor OVR_OBSTRUCTED;
    protected static ImageDescriptor OVR_DELETED;
    protected static ImageDescriptor OVR_LOCKED;
    protected static ImageDescriptor OVR_NEEDS_LOCK;
    protected static ImageDescriptor OVR_SWITCHED;
    protected static IResourceStatesListener installedListener;
    protected static int instanceCounter;
    protected IPropertyChangeListener configurationListener;
    protected boolean indicateConflicted;
    protected boolean indicateModified;
    protected boolean indicateDeleted;
    protected boolean indicateRemote;
    protected boolean indicateAdded;
    protected boolean indicateNew;
    protected boolean indicateLocked;
    protected boolean indicateNeedsLock;
    protected boolean indicateSwitched;
    protected String outgoingChars;
    protected String addedChars;
    protected String trunkPrefix;
    protected String branchPrefix;
    protected String tagPrefix;
    protected boolean useFonts;
    protected IDecorationFilter filter;
    protected Font ignoredFont;
    protected Font changedFont;
    protected Color ignoredForegroundColor;
    protected Color ignoredBackgroundColor;
    protected Color changedForegroundColor;
    protected Color changedBackgroundColor;
    protected IVariable[] format;
    protected DecoratorVariables decorator;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    static {
        installedListener = null;
        instanceCounter = 0;
    }

    public AbstractResourceDecorator(IResourceStatesListener targetListener) {
        this.initStatic(this, targetListener);
        this.configurationListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().startsWith("preference.decoration.")) {
                    AbstractResourceDecorator.this.loadConfiguration();
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("org.polarion.team.svn.ui.decorator.wrapper.ResourceDecoratorWrapper");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    String decoratorId = clazz.getName();
                    SVNTeamUIPlugin.instance().getWorkbench().getDecoratorManager().update(decoratorId);
                }
            }
        };
        this.filter = ExtensionsManager.getInstance().getCurrentDecorationFilter();
        SVNTeamUIPlugin.instance().getPreferenceStore().addPropertyChangeListener(this.configurationListener);
        PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().addPropertyChangeListener(this.configurationListener);
        this.decorator = new DecoratorVariables(TextVariableSetProvider.instance);
    }

    public void dispose() {
        SVNTeamUIPlugin.instance().getPreferenceStore().removePropertyChangeListener(this.configurationListener);
        this.finiStatic();
        super.dispose();
    }

    public final void decorate(Object element, IDecoration decoration) {
        try {
            int mask;
            IResource resource = this.getResource(element);
            if (resource == null || RepositoryProvider.getProvider((IProject)resource.getProject(), (String)"org.polarion.team.svn.core.svnnature") == null || !this.filter.isAcceptable(resource)) {
                return;
            }
            SVNRemoteStorage storage = SVNRemoteStorage.instance();
            ILocalResource local = storage.asLocalResource(resource);
            IRepositoryResource remote = storage.asRepositoryResource(resource);
            if (local == null || remote == null) {
                return;
            }
            String localStatus = this.getStatus(local);
            if (!IStateFilter.SF_NOTEXISTS.accept(resource, localStatus, mask = local.getChangeMask())) {
                if (this.format == null) {
                    this.loadConfiguration();
                    localStatus = this.getStatus(local);
                }
                this.decorateImpl(remote, local, resource, localStatus, mask, decoration);
            }
        }
        catch (Throwable throwable) {}
    }

    protected void decorateImpl(final IRepositoryResource remote, final ILocalResource local, final IResource resource, final String state, final int mask, IDecoration decoration) {
        if (local.isLocked() && this.indicateLocked) {
            decoration.addOverlay(OVR_LOCKED);
        } else if (IStateFilter.SF_IGNORED.accept(resource, state, mask)) {
            if (this.useFonts) {
                decoration.setBackgroundColor(this.ignoredBackgroundColor);
                decoration.setForegroundColor(this.ignoredForegroundColor);
                decoration.setFont(this.ignoredFont);
            }
        } else if (IStateFilter.SF_NEW.accept(resource, state, mask)) {
            if (this.indicateNew) {
                decoration.addOverlay(OVR_NEW);
            }
        } else if (this.indicateNeedsLock && IStateFilter.SF_NEEDS_LOCK.accept(resource, state, mask)) {
            decoration.addOverlay(OVR_NEEDS_LOCK);
        } else if (IStateFilter.SF_DELETED.accept(resource, state, mask)) {
            decoration.addOverlay(OVR_DELETED);
        } else if (IStateFilter.SF_ADDED.accept(resource, state, mask)) {
            if (this.indicateAdded) {
                decoration.addOverlay(OVR_ADDED);
            }
        } else if (IStateFilter.SF_CONFLICTING.accept(resource, state, mask)) {
            if (this.indicateConflicted) {
                decoration.addOverlay(OVR_CONFLICTED);
            } else if (this.indicateModified) {
                decoration.addOverlay(OVR_MODIFIED);
            } else if (this.indicateSwitched && (local.getChangeMask() & 8) != 0) {
                decoration.addOverlay(OVR_SWITCHED);
            } else if (this.indicateRemote) {
                decoration.addOverlay(OVR_VERSIONED);
            }
        } else if (IStateFilter.SF_MODIFIED.accept(resource, state, mask)) {
            if (this.indicateModified) {
                decoration.addOverlay(OVR_MODIFIED);
            } else if (this.indicateSwitched && (local.getChangeMask() & 8) != 0) {
                decoration.addOverlay(OVR_SWITCHED);
            } else if (this.indicateRemote) {
                decoration.addOverlay(OVR_VERSIONED);
            }
        } else if (IStateFilter.SF_OBSTRUCTED.accept(resource, state, mask)) {
            decoration.addOverlay(OVR_OBSTRUCTED);
        } else if (IStateFilter.SF_VERSIONED.accept(resource, state, mask)) {
            if (this.indicateSwitched && (local.getChangeMask() & 8) != 0) {
                decoration.addOverlay(OVR_SWITCHED);
            } else if (this.indicateRemote) {
                decoration.addOverlay(OVR_VERSIONED);
            }
        }
        if (this.useFonts && IStateFilter.SF_MODIFIED.accept(resource, state, mask)) {
            decoration.setBackgroundColor(this.changedBackgroundColor);
            decoration.setForegroundColor(this.changedForegroundColor);
            decoration.setFont(this.changedFont);
        }
        this.decorator.decorateText(decoration, this.format, new IVariableContentProvider(){

            public String getValue(IVariable var) {
                if (var.equals(TextVariableSetProvider.VAR_ADDED_FLAG)) {
                    return IStateFilter.SF_ADDED.accept(resource, state, mask) ? AbstractResourceDecorator.this.addedChars : "";
                }
                if (var.equals(TextVariableSetProvider.VAR_OUTGOING_FLAG)) {
                    return IStateFilter.SF_COMMITABLE.accept(resource, state, mask) || IStateFilter.SF_CONFLICTING.accept(resource, state, mask) ? AbstractResourceDecorator.this.outgoingChars : "";
                }
                if (var.equals(TextVariableSetProvider.VAR_REVISION)) {
                    return IStateFilter.SF_ONREPOSITORY.accept(resource, state, mask) && !IStateFilter.SF_PREREPLACEDREPLACED.accept(resource, state, mask) ? String.valueOf(local.getRevision()) : "";
                }
                if (var.equals(TextVariableSetProvider.VAR_AUTHOR)) {
                    String author = local.getAuthor() == null ? "[no author]" : local.getAuthor();
                    return IStateFilter.SF_ONREPOSITORY.accept(resource, state, mask) ? author : "";
                }
                if (var.equals(TextVariableSetProvider.VAR_DATE)) {
                    if (!IStateFilter.SF_ONREPOSITORY.accept(resource, state, mask)) {
                        return "";
                    }
                    long date = local.getLastCommitDate();
                    if (date == 0L) {
                        return SVNTeamPlugin.instance().getResource("SVNInfo.NoDate");
                    }
                    return dateTimeFormat.format(new Date(date));
                }
                if (var.equals(TextVariableSetProvider.VAR_RESOURCE_URL)) {
                    return IStateFilter.SF_ONREPOSITORY.accept(resource, state, mask) ? SVNUtility.decodeURL((String)remote.getUrl()) : "";
                }
                if (var.equals(TextVariableSetProvider.VAR_SHORT_RESOURCE_URL)) {
                    if (IStateFilter.SF_ONREPOSITORY.accept(resource, state, mask)) {
                        String shortURL = SVNUtility.decodeURL((String)remote.getUrl()).substring(remote.getRepositoryLocation().getRepositoryRootUrl().length());
                        return shortURL.startsWith("/") ? shortURL.substring(1) : shortURL;
                    }
                    return "";
                }
                if (var.equals(TextVariableSetProvider.VAR_LOCATION_URL)) {
                    return IStateFilter.SF_ONREPOSITORY.accept(resource, state, mask) ? remote.getRepositoryLocation().getUrlAsIs() : "";
                }
                if (var.equals(TextVariableSetProvider.VAR_LOCATION_LABEL)) {
                    if (IStateFilter.SF_ONREPOSITORY.accept(resource, state, mask)) {
                        IRepositoryLocation location = remote.getRepositoryLocation();
                        String label = location.getLabel();
                        return label == null || label.length() == 0 ? location.getUrlAsIs() : label;
                    }
                    return "";
                }
                if (var.equals(TextVariableSetProvider.VAR_ROOT_PREFIX)) {
                    if (IStateFilter.SF_ONREPOSITORY.accept(resource, state, mask)) {
                        int kind = ((IRepositoryRoot)remote.getRoot()).getKind();
                        return kind == 3 ? AbstractResourceDecorator.this.tagPrefix : (kind == 2 ? AbstractResourceDecorator.this.branchPrefix : (kind == 1 ? AbstractResourceDecorator.this.trunkPrefix : ""));
                    }
                    return "";
                }
                if (var.equals(TextVariableSetProvider.VAR_ASCENDANT)) {
                    if (IStateFilter.SF_ONREPOSITORY.accept(resource, state, mask)) {
                        return SVNUtility.getAscendant((IRepositoryResource)remote);
                    }
                    return "";
                }
                if (var.equals(TextVariableSetProvider.VAR_DESCENDANT)) {
                    if (IStateFilter.SF_ONREPOSITORY.accept(resource, state, mask)) {
                        return SVNUtility.getDescendant((IRepositoryResource)remote);
                    }
                    return "";
                }
                if (var.equals(TextVariableSetProvider.VAR_FULLNAME)) {
                    if (IStateFilter.SF_ONREPOSITORY.accept(resource, state, mask)) {
                        return SVNUtility.getPathUpToRoot((IRepositoryResource)remote);
                    }
                    return "";
                }
                if (var.equals(TextVariableSetProvider.VAR_REMOTE_NAME)) {
                    return IStateFilter.SF_ONREPOSITORY.accept(resource, state, mask) ? remote.getName() : "";
                }
                if (var.equals(TextVariableSetProvider.VAR_NAME)) {
                    return local.getName();
                }
                return var.toString();
            }
        });
    }

    protected abstract String getStatus(ILocalResource var1);

    protected IResource getResource(Object object) {
        if (object instanceof IResource) {
            return (IResource)object;
        }
        if (object instanceof IAdaptable) {
            IAdaptable iAdaptable = (IAdaptable)object;
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return (IResource)iAdaptable.getAdapter((Class)clazz);
        }
        return null;
    }

    protected void loadConfiguration() {
        IPreferenceStore store = SVNTeamUIPlugin.instance().getPreferenceStore();
        this.indicateConflicted = SVNTeamPreferences.getDecorationBoolean(store, "icon.conflicted");
        this.indicateModified = SVNTeamPreferences.getDecorationBoolean(store, "icon.modified");
        this.indicateRemote = SVNTeamPreferences.getDecorationBoolean(store, "icon.remote");
        this.indicateAdded = SVNTeamPreferences.getDecorationBoolean(store, "icon.added");
        this.indicateNew = SVNTeamPreferences.getDecorationBoolean(store, "icon.new");
        this.indicateLocked = SVNTeamPreferences.getDecorationBoolean(store, "icon.locked");
        this.indicateNeedsLock = SVNTeamPreferences.getDecorationBoolean(store, "icon.needslock");
        this.indicateSwitched = SVNTeamPreferences.getDecorationBoolean(store, "icon.switched");
        this.outgoingChars = SVNTeamPreferences.getDecorationString(store, "flag.outgoing");
        this.addedChars = SVNTeamPreferences.getDecorationString(store, "flag.added");
        this.trunkPrefix = SVNTeamPreferences.getDecorationString(store, "trunk.branch");
        this.branchPrefix = SVNTeamPreferences.getDecorationString(store, "prefix.branch");
        this.tagPrefix = SVNTeamPreferences.getDecorationString(store, "prefix.tag");
        this.useFonts = SVNTeamPreferences.getDecorationBoolean(store, "use.fontdecor");
        UIMonitorUtility.getDisplay().syncExec(new Runnable(){

            public void run() {
                ITheme current = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme();
                AbstractResourceDecorator.this.ignoredFont = current.getFontRegistry().get(SVNTeamPreferences.fullDecorationName("ignored_resource_font"));
                AbstractResourceDecorator.this.changedFont = current.getFontRegistry().get(SVNTeamPreferences.fullDecorationName("outgoing_change_font"));
                AbstractResourceDecorator.this.ignoredForegroundColor = current.getColorRegistry().get(SVNTeamPreferences.fullDecorationName("ignored_resource_foreground_color"));
                AbstractResourceDecorator.this.ignoredBackgroundColor = current.getColorRegistry().get(SVNTeamPreferences.fullDecorationName("ignored_resource_background_color"));
                AbstractResourceDecorator.this.changedForegroundColor = current.getColorRegistry().get(SVNTeamPreferences.fullDecorationName("outgoing_change_foreground_color"));
                AbstractResourceDecorator.this.changedBackgroundColor = current.getColorRegistry().get(SVNTeamPreferences.fullDecorationName("outgoing_change_background_color"));
            }
        });
    }

    protected synchronized void initStatic(final AbstractResourceDecorator self, final IResourceStatesListener targetListener) {
        if (instanceCounter++ == 0) {
            OVR_NEW = SVNTeamUIPlugin.instance().getImageDescriptor("icons/overlays/new_resource.gif");
            OVR_CONFLICTED = SVNTeamUIPlugin.instance().getImageDescriptor("icons/overlays/conflicted_unresolved.gif");
            OVR_OBSTRUCTED = SVNTeamUIPlugin.instance().getImageDescriptor("icons/overlays/obstructed.gif");
            OVR_DELETED = SVNTeamUIPlugin.instance().getImageDescriptor("icons/overlays/deleted.gif");
            OVR_LOCKED = SVNTeamUIPlugin.instance().getImageDescriptor("icons/overlays/lock.gif");
            OVR_NEEDS_LOCK = SVNTeamUIPlugin.instance().getImageDescriptor("icons/overlays/needs_lock.gif");
            OVR_SWITCHED = SVNTeamUIPlugin.instance().getImageDescriptor("icons/overlays/switched.gif");
            installedListener = new IResourceStatesListener(){

                public void resourcesStateChanged(ResourceStatesChangedEvent event) {
                    if (targetListener != null) {
                        targetListener.resourcesStateChanged(event);
                    } else {
                        self.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)self, (Object[])event.getResourcesRecursivelly()));
                    }
                }
            };
            SVNRemoteStorage sVNRemoteStorage = SVNRemoteStorage.instance();
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("org.polarion.team.svn.core.resource.events.ResourceStatesChangedEvent");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            sVNRemoteStorage.addResourceStatesListener((Class)clazz, installedListener);
        }
    }

    protected synchronized void finiStatic() {
        if (--instanceCounter == 0) {
            SVNRemoteStorage sVNRemoteStorage = SVNRemoteStorage.instance();
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("org.polarion.team.svn.core.resource.events.ResourceStatesChangedEvent");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            sVNRemoteStorage.removeResourceStatesListener((Class)clazz, installedListener);
            installedListener = null;
        }
    }
}

