/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui.dialog;

import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.polarion.team.svn.core.resource.IRepositoryResource;
import org.polarion.team.svn.core.svnstorage.SVNRemoteStorage;
import org.polarion.team.svn.core.utility.SVNUtility;
import org.polarion.team.svn.ui.SVNTeamUIPlugin;

public class OperationErrorDialog
extends MessageDialog {
    public static final int ERR_NONE = -1;
    public static final int ERR_DIFFREPOSITORIES = 0;
    public static final int ERR_DIFFPROJECTS = 1;
    protected static final String[] errorMessages = new String[]{"OperationErrorDialog.Message.DifferentRepositories", "OperationErrorDialog.Message.DifferentProjects"};

    public OperationErrorDialog(Shell parentShell, String title, int errorCode) {
        super(parentShell, title, null, SVNTeamUIPlugin.instance().getResource(errorMessages[errorCode]), 4, new String[]{IDialogConstants.OK_LABEL}, 0);
    }

    public static boolean isAcceptableAtOnce(IResource[] resources, String name, Shell shell) {
        IRepositoryResource[] remoteResources = new IRepositoryResource[resources.length];
        int i = 0;
        while (i < resources.length) {
            remoteResources[i] = SVNRemoteStorage.instance().asRepositoryResource(resources[i]);
            ++i;
        }
        return OperationErrorDialog.isAcceptableAtOnce(remoteResources, name, shell);
    }

    public static boolean isAcceptableAtOnce(IRepositoryResource[] resources, String name, Shell shell) {
        String url = SVNUtility.getTrunkLocation((IRepositoryResource)resources[0]).getUrl();
        int i = 1;
        while (i < resources.length) {
            if (!url.equals(SVNUtility.getTrunkLocation((IRepositoryResource)resources[i]).getUrl())) {
                new OperationErrorDialog(shell, name, 1).open();
                return false;
            }
            ++i;
        }
        return true;
    }
}

