/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui.extension.impl.synchronize;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.polarion.team.svn.core.extension.CoreExtensionsManager;
import org.polarion.team.svn.core.svnstorage.SVNRemoteStorage;
import org.polarion.team.svn.ui.SVNTeamUIPlugin;
import org.polarion.team.svn.ui.preferences.SVNTeamPreferences;
import org.polarion.team.svn.ui.synchronize.AbstractSVNParticipant;
import org.polarion.team.svn.ui.synchronize.AbstractSynchronizeActionGroup;

public class OptionsActionGroup
extends AbstractSynchronizeActionGroup {
    public static final String GROUP_SYNCH_OPTIONS = "synchronizeViewOptions";
    protected IAction changeOptionAction;
    protected IAction contiguousOptionAction;
    protected IPropertyChangeListener configurationListener;

    public void dispose() {
        if (this.configurationListener != null) {
            SVNTeamUIPlugin.instance().getPreferenceStore().removePropertyChangeListener(this.configurationListener);
        }
        super.dispose();
    }

    public void configureMenuGroups(ISynchronizePageConfiguration configuration) {
        configuration.addMenuGroup("org.eclipse.team.ui.P_VIEW_MENU", GROUP_SYNCH_OPTIONS);
    }

    protected void configureActions(ISynchronizePageConfiguration configuration) {
        if (CoreExtensionsManager.instance().getSVNClientWrapperFactory().isReportRevisionChangeAllowed()) {
            this.changeOptionAction = new Action(SVNTeamUIPlugin.instance().getResource("OptionsActionGroup.ReportFolderChanges"), 2){

                public void run() {
                    IPreferenceStore store;
                    boolean reportRevisionChange = SVNTeamPreferences.getSynchronizeBoolean(store = SVNTeamUIPlugin.instance().getPreferenceStore(), "reportRevisionChange");
                    SVNTeamPreferences.setSynchronizeBoolean(store, "reportRevisionChange", !reportRevisionChange);
                    SVNTeamUIPlugin.instance().savePluginPreferences();
                }
            };
        }
        this.contiguousOptionAction = new Action(SVNTeamUIPlugin.instance().getResource("OptionsActionGroup.ShowInfoContiguous"), 2){

            public void run() {
                IPreferenceStore store;
                boolean fastReportMode = SVNTeamPreferences.getSynchronizeBoolean(store = SVNTeamUIPlugin.instance().getPreferenceStore(), "fastReport");
                SVNTeamPreferences.setSynchronizeBoolean(store, "fastReport", !fastReportMode);
                SVNTeamUIPlugin.instance().savePluginPreferences();
            }
        };
        this.refreshOptionButtons();
        if (CoreExtensionsManager.instance().getSVNClientWrapperFactory().isReportRevisionChangeAllowed()) {
            this.appendToGroup("org.eclipse.team.ui.P_VIEW_MENU", GROUP_SYNCH_OPTIONS, this.changeOptionAction);
        }
        this.appendToGroup("org.eclipse.team.ui.P_VIEW_MENU", GROUP_SYNCH_OPTIONS, this.contiguousOptionAction);
        this.configurationListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().startsWith("preference.synchronize.")) {
                    OptionsActionGroup.this.refreshOptionButtons();
                    AbstractSVNParticipant paticipant = (AbstractSVNParticipant)OptionsActionGroup.this.getConfiguration().getParticipant();
                    if (event.getProperty().endsWith("reportRevisionChange") && paticipant.getMatchingSubscriber().isSynchronizedWithRepository()) {
                        SVNRemoteStorage.instance().reconfigureLocations();
                        paticipant.run(null);
                    }
                }
            }
        };
        SVNTeamUIPlugin.instance().getPreferenceStore().addPropertyChangeListener(this.configurationListener);
    }

    protected void refreshOptionButtons() {
        IPreferenceStore store = SVNTeamUIPlugin.instance().getPreferenceStore();
        if (CoreExtensionsManager.instance().getSVNClientWrapperFactory().isReportRevisionChangeAllowed()) {
            this.changeOptionAction.setChecked(SVNTeamPreferences.getSynchronizeBoolean(store, "reportRevisionChange"));
        }
        this.contiguousOptionAction.setChecked(SVNTeamPreferences.getSynchronizeBoolean(store, "fastReport"));
    }
}

