/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui.history;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.polarion.team.svn.core.IStateFilter;
import org.polarion.team.svn.core.client.LogMessage;
import org.polarion.team.svn.core.client.Revision;
import org.polarion.team.svn.core.extension.CoreExtensionsManager;
import org.polarion.team.svn.core.operation.AbstractActionOperation;
import org.polarion.team.svn.core.operation.AbstractNonLockingOperation;
import org.polarion.team.svn.core.operation.CompositeOperation;
import org.polarion.team.svn.core.operation.IActionOperation;
import org.polarion.team.svn.core.operation.IResourcePropertyProvider;
import org.polarion.team.svn.core.operation.local.GetRemoteContentsOperation;
import org.polarion.team.svn.core.operation.local.RefreshResourcesOperation;
import org.polarion.team.svn.core.operation.local.RestoreProjectMetaOperation;
import org.polarion.team.svn.core.operation.local.RevertOperation;
import org.polarion.team.svn.core.operation.local.SaveProjectMetaOperation;
import org.polarion.team.svn.core.operation.local.UpdateOperation;
import org.polarion.team.svn.core.operation.remote.GetLogMessagesOperation;
import org.polarion.team.svn.core.operation.remote.GetRemotePropertiesOperation;
import org.polarion.team.svn.core.operation.remote.LocateResourceURLInHistoryOperation;
import org.polarion.team.svn.core.operation.remote.PreparedBranchTagOperation;
import org.polarion.team.svn.core.operation.remote.management.AddRevisionLinkOperation;
import org.polarion.team.svn.core.operation.remote.management.SaveRepositoryLocationsOperation;
import org.polarion.team.svn.core.resource.ILocalResource;
import org.polarion.team.svn.core.resource.IRepositoryContainer;
import org.polarion.team.svn.core.resource.IRepositoryFile;
import org.polarion.team.svn.core.resource.IRepositoryLocation;
import org.polarion.team.svn.core.resource.IRepositoryResource;
import org.polarion.team.svn.core.resource.IRepositoryResourceProvider;
import org.polarion.team.svn.core.resource.IRepositoryRoot;
import org.polarion.team.svn.core.svnstorage.SVNRemoteStorage;
import org.polarion.team.svn.core.utility.FileUtility;
import org.polarion.team.svn.core.utility.ProgressMonitorUtility;
import org.polarion.team.svn.core.utility.SVNUtility;
import org.polarion.team.svn.core.utility.StringMatcher;
import org.polarion.team.svn.ui.SVNTeamUIPlugin;
import org.polarion.team.svn.ui.action.AbstractRepositoryTeamAction;
import org.polarion.team.svn.ui.action.remote.BranchTagAction;
import org.polarion.team.svn.ui.action.remote.CreatePatchAction;
import org.polarion.team.svn.ui.action.remote.OpenFileAction;
import org.polarion.team.svn.ui.action.remote.OpenFileWithAction;
import org.polarion.team.svn.ui.action.remote.OpenFileWithExternalAction;
import org.polarion.team.svn.ui.action.remote.OpenFileWithInplaceAction;
import org.polarion.team.svn.ui.composite.LogMessagesComposite;
import org.polarion.team.svn.ui.dialog.DefaultDialog;
import org.polarion.team.svn.ui.dialog.ReplaceWarningDialog;
import org.polarion.team.svn.ui.history.IViewInfoProvider;
import org.polarion.team.svn.ui.operation.CompareRepositoryResourcesOperation;
import org.polarion.team.svn.ui.operation.CompareResourcesOperation;
import org.polarion.team.svn.ui.operation.CorrectRevisionOperation;
import org.polarion.team.svn.ui.operation.LocalShowAnnotationOperation;
import org.polarion.team.svn.ui.operation.OpenRemoteFileOperation;
import org.polarion.team.svn.ui.operation.RefreshRepositoryLocationsOperation;
import org.polarion.team.svn.ui.operation.RemoteShowAnnotationOperation;
import org.polarion.team.svn.ui.operation.ShowPropertiesOperation;
import org.polarion.team.svn.ui.panel.view.HistoryFilterPanel;
import org.polarion.team.svn.ui.preferences.SVNTeamPreferences;
import org.polarion.team.svn.ui.repository.model.RepositoryFile;
import org.polarion.team.svn.ui.utility.LockProposeUtility;
import org.polarion.team.svn.ui.utility.UIMonitorUtility;
import org.polarion.team.svn.ui.wizard.CreatePatchWizard;

public class HistoryViewImpl {
    public static final int PAGING_ENABLED = 1;
    public static final int COMPARE_MODE = 2;
    public static final int HIDE_UNRELATED = 4;
    public static final int STOP_ON_COPY = 8;
    protected IResource wcResource;
    protected IRepositoryResource repositoryResource;
    protected IViewInfoProvider viewInfoProvider;
    protected LogMessagesComposite history;
    protected String filterByAuthor;
    protected String filterByComment;
    protected Action showCommentViewerAction;
    protected Action showAffectedPathsViewerAction;
    protected Action hideUnrelatedAction;
    protected Action hideUnrelatedDropDownAction;
    protected Action stopOnCopyAction;
    protected Action stopOnCopyDropDownAction;
    protected Action getNextPageAction;
    protected Action getAllPagesAction;
    protected Action clearFilterAction;
    protected Action clearFilterDropDownAction;
    protected Action filterAction;
    protected Action filterDropDownAction;
    protected Action hierarchicalAction;
    protected Action flatAction;
    protected Action compareModeAction;
    protected Action compareModeDropDownAction;
    protected long limit = 25L;
    protected boolean pagingEnabled = false;
    protected boolean isCommentFilterEnabled = false;
    protected int options = 0;
    protected long currentRevision = 0L;
    protected IPropertyChangeListener configurationListener;
    protected LogMessage[] logMessages;

    public HistoryViewImpl(IResource wcResource, IRepositoryResource repositoryResource, IViewInfoProvider viewInfoProvider) {
        this.wcResource = wcResource;
        this.repositoryResource = repositoryResource;
        this.viewInfoProvider = viewInfoProvider;
        this.filterByAuthor = "";
        this.filterByComment = "";
        this.configurationListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().startsWith("preference.history.")) {
                    HistoryViewImpl.this.refreshOptionButtons();
                }
            }
        };
        SVNTeamUIPlugin.instance().getPreferenceStore().addPropertyChangeListener(this.configurationListener);
    }

    public IWorkbenchPartSite getSite() {
        return this.viewInfoProvider.getPartSite();
    }

    public IActionBars getActionBars() {
        return this.viewInfoProvider.getActionBars();
    }

    public int getOptions() {
        return this.options;
    }

    public void setOptions(int mask, int values) {
        this.options = this.options & ~mask | mask & values;
        IPreferenceStore store = SVNTeamUIPlugin.instance().getPreferenceStore();
        SVNTeamPreferences.setHistoryBoolean(store, "compareMode", (this.options & 2) != 0);
        SVNTeamPreferences.setHistoryBoolean(store, "pagingEnable", (this.options & 1) != 0);
        this.refreshOptionButtons();
    }

    public IResource getResource() {
        return this.wcResource;
    }

    public IRepositoryResource getRepositoryResource() {
        return this.repositoryResource;
    }

    public void dispose() {
        SVNTeamUIPlugin.instance().getPreferenceStore().removePropertyChangeListener(this.configurationListener);
        this.history.dispose();
    }

    public Control getControl() {
        return this.history;
    }

    public void createPartControl(Composite parent) {
        this.history = new LogMessagesComposite(parent, 70, 2);
        Table table = this.history.getTableViewer().getTable();
        MenuManager menuMgr = new MenuManager();
        Menu menu = menuMgr.createContextMenu((Control)table);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.add((IContributionItem)new Separator("additions"));
                IStructuredSelection tSelection = (IStructuredSelection)HistoryViewImpl.this.history.getTableViewer().getSelection();
                Action tAction = null;
                if (HistoryViewImpl.this.repositoryResource instanceof IRepositoryFile) {
                    tAction = new Action(this, SVNTeamUIPlugin.instance().getResource("HistoryView.Open"), tSelection){
                        final /* synthetic */ 2 this$1;
                        private final /* synthetic */ IStructuredSelection val$tSelection;
                        {
                            this.this$1 = var1_1;
                            this.val$tSelection = iStructuredSelection;
                            super($anonymous0);
                        }

                        public void run() {
                            2.access$0(this.this$1).handleDoubleClick(this.val$tSelection.getFirstElement(), false);
                        }
                    };
                    manager.add((IAction)tAction);
                    tAction.setEnabled(tSelection.size() == 1);
                    MenuManager sub = new MenuManager(SVNTeamUIPlugin.instance().getResource("HistoryView.OpenWith"), "historyOpenWithMenu");
                    sub.add((IContributionItem)new Separator("additions"));
                    sub.add((IContributionItem)new Separator("nonDefaultTextEditors"));
                    String name = HistoryViewImpl.this.repositoryResource.getName();
                    IEditorDescriptor[] editors = SVNTeamUIPlugin.instance().getWorkbench().getEditorRegistry().getEditors(name);
                    int i = 0;
                    while (i < editors.length) {
                        if (!editors[i].getId().equals("org.eclipse.ui.DefaultTextEditor")) {
                            HistoryViewImpl.this.addMenuItem(sub, editors[i].getLabel(), new OpenFileWithAction(editors[i].getId(), false));
                        }
                        ++i;
                    }
                    sub.add((IContributionItem)new Separator("variousEditors"));
                    HistoryViewImpl.this.addMenuItem(sub, SVNTeamUIPlugin.instance().getResource("HistoryView.TextEditor"), new OpenFileWithAction());
                    HistoryViewImpl.this.addMenuItem(sub, SVNTeamUIPlugin.instance().getResource("HistoryView.SystemEditor"), new OpenFileWithExternalAction());
                    HistoryViewImpl.this.addMenuItem(sub, SVNTeamUIPlugin.instance().getResource("HistoryView.InplaceEditor"), new OpenFileWithInplaceAction());
                    HistoryViewImpl.this.addMenuItem(sub, SVNTeamUIPlugin.instance().getResource("HistoryView.DefaultEditor"), new OpenFileAction());
                    manager.add((IContributionItem)sub);
                }
                tAction = new Action(this, SVNTeamUIPlugin.instance().getResource("HistoryView.CompareEachOther"), tSelection){
                    final /* synthetic */ 2 this$1;
                    private final /* synthetic */ IStructuredSelection val$tSelection;
                    {
                        this.this$1 = var1_1;
                        this.val$tSelection = iStructuredSelection;
                        super($anonymous0);
                    }

                    public void run() {
                        Object[] selection = this.val$tSelection.toArray();
                        IRepositoryResource left = 2.access$0(this.this$1).getResourceForSelectedRevision(selection[0]);
                        IRepositoryResource right = 2.access$0(this.this$1).getResourceForSelectedRevision(selection[1]);
                        UIMonitorUtility.doTaskScheduledActive((IActionOperation)new CompareRepositoryResourcesOperation(left, right));
                    }
                };
                manager.add((IAction)tAction);
                tAction.setEnabled(tSelection.size() == 2 && (HistoryViewImpl.this.repositoryResource instanceof IRepositoryFile || CoreExtensionsManager.instance().getSVNClientWrapperFactory().isCompareFoldersAllowed()));
                if (tSelection.size() == 1) {
                    Object[] selection = tSelection.toArray();
                    String revision = HistoryViewImpl.this.wcResource != null ? String.valueOf(((LogMessage)selection[0]).revision) : SVNTeamUIPlugin.instance().getResource("HistoryView.HEAD");
                    String msg = MessageFormat.format(SVNTeamUIPlugin.instance().getResource("HistoryView.CompareCurrentWith"), revision);
                    tAction = new Action(this, msg, selection){
                        final /* synthetic */ 2 this$1;
                        private final /* synthetic */ Object[] val$selection;
                        {
                            this.this$1 = var1_1;
                            this.val$selection = objectArray;
                            super($anonymous0);
                        }

                        public void run() {
                            2.access$0(this.this$1).compareWithCurrent(this.val$selection[0]);
                        }
                    };
                    manager.add((IAction)tAction);
                    tAction.setEnabled(tSelection.size() == 1 && (HistoryViewImpl.this.repositoryResource instanceof IRepositoryFile || CoreExtensionsManager.instance().getSVNClientWrapperFactory().isCompareFoldersAllowed()));
                }
                tAction = new Action(this, SVNTeamUIPlugin.instance().getResource("HistoryView.CreateUnifiedDiff"), tSelection){
                    final /* synthetic */ 2 this$1;
                    private final /* synthetic */ IStructuredSelection val$tSelection;
                    {
                        this.this$1 = var1_1;
                        this.val$tSelection = iStructuredSelection;
                        super($anonymous0);
                    }

                    public void run() {
                        2.access$0(this.this$1).createUnifiedDiff(this.val$tSelection);
                    }
                };
                manager.add((IAction)tAction);
                tAction.setEnabled(tSelection.size() == 1 || tSelection.size() == 2);
                if (HistoryViewImpl.this.repositoryResource instanceof IRepositoryFile) {
                    manager.add((IContributionItem)new Separator());
                }
                tAction = new Action(this, SVNTeamUIPlugin.instance().getResource("HistoryView.ShowProperties"), tSelection){
                    final /* synthetic */ 2 this$1;
                    private final /* synthetic */ IStructuredSelection val$tSelection;
                    {
                        this.this$1 = var1_1;
                        this.val$tSelection = iStructuredSelection;
                        super($anonymous0);
                    }

                    public void run() {
                        Object[] selection = this.val$tSelection.toArray();
                        IRepositoryResource resource = 2.access$0(this.this$1).getResourceForSelectedRevision(selection[0]);
                        GetRemotePropertiesOperation provider = new GetRemotePropertiesOperation(resource);
                        ShowPropertiesOperation op = new ShowPropertiesOperation(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IAdaptable)resource, (IResourcePropertyProvider)provider);
                        CompositeOperation composite = new CompositeOperation(op.getId());
                        composite.add((IActionOperation)provider);
                        composite.add((IActionOperation)op, new IActionOperation[]{provider});
                        if (!op.isEditorOpened()) {
                            UIMonitorUtility.doTaskScheduledActive((IActionOperation)composite);
                        }
                    }
                };
                manager.add((IAction)tAction);
                tAction.setEnabled(tSelection.size() == 1);
                tAction.setHoverImageDescriptor(SVNTeamUIPlugin.instance().getImageDescriptor("icons/views/propertiesedit.gif"));
                if (HistoryViewImpl.this.repositoryResource instanceof IRepositoryFile) {
                    tAction = new Action(this, SVNTeamUIPlugin.instance().getResource("HistoryView.ShowAnnotation"), tSelection){
                        final /* synthetic */ 2 this$1;
                        private final /* synthetic */ IStructuredSelection val$tSelection;
                        {
                            this.this$1 = var1_1;
                            this.val$tSelection = iStructuredSelection;
                            super($anonymous0);
                        }

                        public void run() {
                            2.access$0(this.this$1).showRepositoryResourceAnnotation(this.val$tSelection.getFirstElement());
                        }
                    };
                    manager.add((IAction)tAction);
                    tAction.setEnabled(tSelection.size() == 1);
                }
                if (HistoryViewImpl.this.wcResource != null || HistoryViewImpl.this.repositoryResource instanceof IRepositoryFile) {
                    manager.add((IContributionItem)new Separator());
                }
                if (HistoryViewImpl.this.wcResource != null) {
                    tAction = new Action(this, SVNTeamUIPlugin.instance().getResource("HistoryView.GetContents"), tSelection){
                        final /* synthetic */ 2 this$1;
                        private final /* synthetic */ IStructuredSelection val$tSelection;
                        {
                            this.this$1 = var1_1;
                            this.val$tSelection = iStructuredSelection;
                            super($anonymous0);
                        }

                        public void run() {
                            if (2.access$0(this.this$1).isIgnoreReplaceWarning()) {
                                2.access$0(this.this$1).getRevisionContents(this.val$tSelection.getFirstElement());
                            }
                        }
                    };
                    manager.add((IAction)tAction);
                    tAction.setEnabled(tSelection.size() == 1);
                }
                if (HistoryViewImpl.this.wcResource != null) {
                    tAction = new Action(this, SVNTeamUIPlugin.instance().getResource("HistoryView.UpdateTo"), tSelection){
                        final /* synthetic */ 2 this$1;
                        private final /* synthetic */ IStructuredSelection val$tSelection;
                        {
                            this.this$1 = var1_1;
                            this.val$tSelection = iStructuredSelection;
                            super($anonymous0);
                        }

                        public void run() {
                            if (2.access$0(this.this$1).isIgnoreReplaceWarning()) {
                                2.access$0(this.this$1).updateTo(this.val$tSelection.getFirstElement());
                            }
                        }
                    };
                    manager.add((IAction)tAction);
                    tAction.setEnabled(tSelection.size() == 1);
                }
                manager.add((IContributionItem)new Separator());
                String branchFrom = SVNTeamUIPlugin.instance().getResource("HistoryView.BranchFromRevision");
                String tagFrom = SVNTeamUIPlugin.instance().getResource("HistoryView.TagFromRevision");
                if (tSelection.size() == 1) {
                    String revision = String.valueOf(((LogMessage)tSelection.getFirstElement()).revision);
                    branchFrom = SVNTeamUIPlugin.instance().getResource("HistoryView.BranchFrom");
                    tagFrom = SVNTeamUIPlugin.instance().getResource("HistoryView.TagFrom");
                    branchFrom = MessageFormat.format(branchFrom, revision);
                    tagFrom = MessageFormat.format(tagFrom, revision);
                }
                tAction = new Action(this, branchFrom, tSelection){
                    final /* synthetic */ 2 this$1;
                    private final /* synthetic */ IStructuredSelection val$tSelection;
                    {
                        this.this$1 = var1_1;
                        this.val$tSelection = iStructuredSelection;
                        super($anonymous0);
                    }

                    public void run() {
                        PreparedBranchTagOperation op = BranchTagAction.getBranchTagOperation(new IRepositoryResource[]{2.access$0(this.this$1).getResourceForSelectedRevision(this.val$tSelection.getFirstElement())}, UIMonitorUtility.getShell(), 0, false);
                        if (op != null) {
                            UIMonitorUtility.doTaskScheduledActive((IActionOperation)op);
                        }
                    }
                };
                manager.add((IAction)tAction);
                tAction.setEnabled(tSelection.size() == 1);
                tAction.setHoverImageDescriptor(SVNTeamUIPlugin.instance().getImageDescriptor("icons/common/actions/branch.gif"));
                tAction = new Action(this, tagFrom, tSelection){
                    final /* synthetic */ 2 this$1;
                    private final /* synthetic */ IStructuredSelection val$tSelection;
                    {
                        this.this$1 = var1_1;
                        this.val$tSelection = iStructuredSelection;
                        super($anonymous0);
                    }

                    public void run() {
                        PreparedBranchTagOperation op = BranchTagAction.getBranchTagOperation(new IRepositoryResource[]{2.access$0(this.this$1).getResourceForSelectedRevision(this.val$tSelection.getFirstElement())}, UIMonitorUtility.getShell(), 1, false);
                        if (op != null) {
                            UIMonitorUtility.doTaskScheduledActive((IActionOperation)op);
                        }
                    }
                };
                manager.add((IAction)tAction);
                tAction.setEnabled(tSelection.size() == 1);
                tAction.setHoverImageDescriptor(SVNTeamUIPlugin.instance().getImageDescriptor("icons/common/actions/tag.gif"));
                tAction = new Action(this, SVNTeamUIPlugin.instance().getResource("HistoryView.AddRevisionLink"), tSelection){
                    final /* synthetic */ 2 this$1;
                    private final /* synthetic */ IStructuredSelection val$tSelection;
                    {
                        this.this$1 = var1_1;
                        this.val$tSelection = iStructuredSelection;
                        super($anonymous0);
                    }

                    public void run() {
                        2.access$0(this.this$1).addRevisionLinks(this.val$tSelection);
                    }
                };
                manager.add((IAction)tAction);
                tAction.setEnabled(tSelection.size() > 0);
                manager.add((IContributionItem)new Separator());
                if (HistoryViewImpl.this.wcResource != null) {
                    tAction = new Action(this, SVNTeamUIPlugin.instance().getResource("HistoryView.QuickFilter")){
                        final /* synthetic */ 2 this$1;
                        {
                            this.this$1 = var1_1;
                            super($anonymous0);
                        }

                        public void run() {
                            if (2.access$0(this.this$1).quickFilter()) {
                                2.access$0(this.this$1).showHistoryImpl(null, false);
                            }
                        }
                    };
                    manager.add((IAction)tAction);
                    tAction.setEnabled(HistoryViewImpl.this.logMessages != null);
                    tAction.setHoverImageDescriptor(SVNTeamUIPlugin.instance().getImageDescriptor("icons/views/history/filter.gif"));
                    tAction = new Action(this, SVNTeamUIPlugin.instance().getResource("HistoryView.ClearFilter")){
                        final /* synthetic */ 2 this$1;
                        {
                            this.this$1 = var1_1;
                            super($anonymous0);
                        }

                        public void run() {
                            2.access$0(this.this$1).clearFilter();
                            2.access$0(this.this$1).showHistoryImpl(null, false);
                        }
                    };
                    manager.add((IAction)tAction);
                    tAction.setDisabledImageDescriptor(SVNTeamUIPlugin.instance().getImageDescriptor("icons/views/history/clear.gif"));
                    tAction.setHoverImageDescriptor(SVNTeamUIPlugin.instance().getImageDescriptor("icons/views/history/clear_filter.gif"));
                    tAction.setEnabled(HistoryViewImpl.this.isFilterEnabled());
                }
                manager.add((IContributionItem)new Separator());
                tAction = new Action(this, SVNTeamUIPlugin.instance().getResource("HistoryView.CopyHistory")){
                    final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = var1_1;
                        super($anonymous0);
                    }

                    public void run() {
                        2.access$0(this.this$1).handleCopy();
                    }
                };
                manager.add((IAction)tAction);
                tAction.setEnabled(tSelection.size() > 0);
                tAction.setImageDescriptor(SVNTeamUIPlugin.instance().getImageDescriptor("icons/common/copy.gif"));
                manager.add((IContributionItem)new Separator());
                manager.add((IAction)HistoryViewImpl.this.getRefreshAction());
            }

            static /* synthetic */ HistoryViewImpl access$0(2 var0) {
                return var0.HistoryViewImpl.this;
            }
        });
        menuMgr.setRemoveAllWhenShown(true);
        table.setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.history.getTableViewer());
        this.history.getAffectedPathsComposite().registerMenuManager(this.getSite());
        IActionBars actionBars = this.getActionBars();
        IMenuManager actionBarsMenu = actionBars.getMenuManager();
        this.showCommentViewerAction = new Action(SVNTeamUIPlugin.instance().getResource("HistoryView.ShowCommentViewer")){

            public void run() {
                IPreferenceStore store;
                boolean showMultiline = SVNTeamPreferences.getHistoryBoolean(store = SVNTeamUIPlugin.instance().getPreferenceStore(), "multilineComment");
                SVNTeamPreferences.setHistoryBoolean(store, "multilineComment", !showMultiline);
                SVNTeamUIPlugin.instance().savePluginPreferences();
            }
        };
        this.showAffectedPathsViewerAction = new Action(SVNTeamUIPlugin.instance().getResource("HistoryView.ShowAffectedPathsViewer")){

            public void run() {
                IPreferenceStore store;
                boolean showAffected = SVNTeamPreferences.getHistoryBoolean(store = SVNTeamUIPlugin.instance().getPreferenceStore(), "affectedPaths");
                SVNTeamPreferences.setHistoryBoolean(store, "affectedPaths", !showAffected);
                SVNTeamUIPlugin.instance().savePluginPreferences();
            }
        };
        this.hideUnrelatedDropDownAction = new Action(SVNTeamUIPlugin.instance().getResource("HistoryView.HideUnrelatedPaths")){

            public void run() {
                HistoryViewImpl.this.options ^= 4;
                HistoryViewImpl.this.history.setShowRelatedPathsOnly((HistoryViewImpl.this.options & 4) != 0);
                HistoryViewImpl.this.hideUnrelatedAction.setChecked((HistoryViewImpl.this.options & 4) != 0);
            }
        };
        this.stopOnCopyDropDownAction = new Action(SVNTeamUIPlugin.instance().getResource("HistoryView.StopOnCopy")){

            public void run() {
                HistoryViewImpl.this.options ^= 8;
                HistoryViewImpl.this.stopOnCopyAction.setChecked((HistoryViewImpl.this.options & 8) != 0);
                HistoryViewImpl.this.refresh();
            }
        };
        this.filterDropDownAction = new Action(SVNTeamUIPlugin.instance().getResource("HistoryView.QuickFilter")){

            public void run() {
                if (HistoryViewImpl.this.quickFilter()) {
                    HistoryViewImpl.this.showHistoryImpl(null, false);
                }
            }
        };
        this.clearFilterDropDownAction = new Action(SVNTeamUIPlugin.instance().getResource("HistoryView.ClearFilter")){

            public void run() {
                HistoryViewImpl.this.clearFilter();
                HistoryViewImpl.this.showHistoryImpl(null, false);
            }
        };
        this.compareModeDropDownAction = new Action(SVNTeamUIPlugin.instance().getResource("HistoryView.CompareMode")){

            public void run() {
                HistoryViewImpl.this.options ^= 2;
                IPreferenceStore store = SVNTeamUIPlugin.instance().getPreferenceStore();
                SVNTeamPreferences.setHistoryBoolean(store, "compareMode", (HistoryViewImpl.this.options & 2) != 0);
                HistoryViewImpl.this.compareModeAction.setChecked((HistoryViewImpl.this.options & 2) != 0);
            }
        };
        actionBarsMenu.add((IAction)this.showCommentViewerAction);
        actionBarsMenu.add((IAction)this.showAffectedPathsViewerAction);
        MenuManager sub = new MenuManager(SVNTeamUIPlugin.instance().getResource("HistoryView.AffectedPathLayout"), "group.managing");
        this.flatAction = new Action(SVNTeamUIPlugin.instance().getResource("HistoryView.Flat"), 8){

            public void run() {
                IPreferenceStore store = SVNTeamUIPlugin.instance().getPreferenceStore();
                SVNTeamPreferences.setHistoryBoolean(store, "hierarchicalLayout", false);
            }
        };
        sub.add((IAction)this.flatAction);
        this.flatAction.setImageDescriptor(SVNTeamUIPlugin.instance().getImageDescriptor("icons/views/history/flat_layout.gif"));
        this.hierarchicalAction = new Action(SVNTeamUIPlugin.instance().getResource("HistoryView.Hierarchical"), 8){

            public void run() {
                IPreferenceStore store = SVNTeamUIPlugin.instance().getPreferenceStore();
                SVNTeamPreferences.setHistoryBoolean(store, "hierarchicalLayout", true);
            }
        };
        sub.add((IAction)this.hierarchicalAction);
        this.hierarchicalAction.setImageDescriptor(SVNTeamUIPlugin.instance().getImageDescriptor("icons/views/history/tree_layout.gif"));
        actionBarsMenu.add((IContributionItem)sub);
        actionBarsMenu.add((IContributionItem)new Separator());
        actionBarsMenu.add((IAction)this.hideUnrelatedDropDownAction);
        actionBarsMenu.add((IAction)this.stopOnCopyDropDownAction);
        actionBarsMenu.add((IContributionItem)new Separator());
        actionBarsMenu.add((IAction)this.filterDropDownAction);
        actionBarsMenu.add((IAction)this.clearFilterDropDownAction);
        actionBarsMenu.add((IContributionItem)new Separator());
        actionBarsMenu.add((IAction)this.compareModeDropDownAction);
        this.showToolBar();
        this.history.getTableViewer().getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.keyCode == 0x100000E) {
                    HistoryViewImpl.this.refresh();
                }
                if (event.stateMask == 262144 && (event.keyCode == 99 || event.keyCode == 67)) {
                    HistoryViewImpl.this.handleCopy();
                }
            }
        });
        this.history.getTableViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent e) {
                IStructuredSelection structured;
                ISelection selection = e.getSelection();
                if (selection instanceof IStructuredSelection && (structured = (IStructuredSelection)selection).size() == 1) {
                    HistoryViewImpl.this.handleDoubleClick(structured.getFirstElement(), true);
                }
            }
        });
        this.viewInfoProvider.setDescription(this.getResourceLabel());
        this.refreshOptionButtons();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.polarion.team.svn.help.historyViewContext");
    }

    public void refresh() {
        long revision = this.history.getSelectedRevision();
        if (this.wcResource == null) {
            this.showHistory(this.repositoryResource, true);
        } else {
            this.showHistory(this.wcResource, true);
        }
        this.history.setSelectedRevision(revision);
    }

    public void selectRevision(long revision) {
        this.history.setSelectedRevision(revision);
    }

    public void showHistory(IResource resource, boolean background) {
        this.wcResource = resource;
        this.history.getCommentView().usedFor(resource);
        long currentRevision = -1L;
        IRepositoryResource remote = null;
        if (resource != null) {
            SVNRemoteStorage storage = SVNRemoteStorage.instance();
            ILocalResource local = storage.asLocalResource(resource);
            if (local != null) {
                currentRevision = local.getRevision();
            }
            remote = storage.asRepositoryResource(resource);
        }
        this.showHistoryImpl(currentRevision, remote, background);
    }

    public void showHistory(IRepositoryResource remoteResource) {
        this.showHistory(remoteResource, false);
    }

    public void showHistory(IRepositoryResource remoteResource, boolean background) {
        this.wcResource = null;
        this.history.getCommentView().usedFor(remoteResource);
        long currentRevision = -1L;
        try {
            if (remoteResource != null) {
                currentRevision = remoteResource.getRevision();
            }
        }
        catch (Exception exception) {}
        this.showHistoryImpl(currentRevision, remoteResource, background);
    }

    public void updateViewInput(IRepositoryResource resource) {
        if (this.repositoryResource != null && this.repositoryResource.equals(resource)) {
            return;
        }
        if (resource != null) {
            if (this.repositoryResource != null && resource.getUrl().equals(this.repositoryResource.getUrl()) && resource.getSelectedRevision().getKind() == 1) {
                Revision currentRevision = resource.getSelectedRevision();
                this.repositoryResource.setSelectedRevision(Revision.HEAD);
                this.showHistoryImpl(((Revision.Number)currentRevision).getNumber(), this.repositoryResource, true);
                return;
            }
            resource.setSelectedRevision(Revision.HEAD);
            this.showHistory(resource, true);
        }
    }

    public void updateViewInput(IResource resource) {
        SVNRemoteStorage storage;
        ILocalResource local;
        if (resource != null && (local = (storage = SVNRemoteStorage.instance()).asLocalResource(resource)) != null && IStateFilter.SF_ONREPOSITORY.accept(local.getResource(), local.getStatus(), local.getChangeMask())) {
            if (local.getResource().equals((Object)this.wcResource)) {
                IRepositoryResource remote = storage.asRepositoryResource(local.getResource());
                if (this.repositoryResource != null && !this.repositoryResource.equals(remote)) {
                    this.updateViewInput(remote);
                }
                return;
            }
            this.showHistory((IResource)null, true);
            this.refresh();
            this.showHistory(resource, true);
        }
    }

    protected void showHistoryImpl(long currentRevision, IRepositoryResource remote, boolean background) {
        if (this.repositoryResource != null) {
            if (this.repositoryResource.equals(remote)) {
                this.logMessages = null;
            } else {
                this.clearFilter();
            }
        }
        this.repositoryResource = remote;
        this.currentRevision = currentRevision;
        this.viewInfoProvider.setDescription(this.getResourceLabel());
        if (this.repositoryResource == null) {
            this.history.setLogMessages(null, null, null);
            this.setPagingDisabled();
        } else {
            this.logMessages = null;
            GetLogMessagesOperation msgOp = new GetLogMessagesOperation(this.repositoryResource, this.stopOnCopyAction.isChecked());
            msgOp.setLimit(this.limit);
            this.showHistoryImpl(msgOp, background);
        }
    }

    protected void showHistoryImpl(final GetLogMessagesOperation msgsOp, boolean background) {
        Table table = this.history.getTableViewer().getTable();
        final TableItem[] selected = table.getSelection();
        final String selectedText = selected.length == 1 ? selected[0].getText(1) : "";
        AbstractNonLockingOperation showOp = new AbstractNonLockingOperation("Operation.HShowHistory"){

            protected void runImpl(IProgressMonitor monitor) throws Exception {
                UIMonitorUtility.getDisplay().syncExec(new Runnable(this, msgsOp){
                    final /* synthetic */ 28 this$1;
                    private final /* synthetic */ GetLogMessagesOperation val$msgsOp;
                    {
                        this.this$1 = var1_1;
                        this.val$msgsOp = getLogMessagesOperation;
                    }

                    public void run() {
                        if (28.access$0(this.this$1).historyForTheOtherResource(this.val$msgsOp)) {
                            return;
                        }
                        if (this.val$msgsOp != null && this.val$msgsOp.getExecutionState() == 0) {
                            28.access$0(this.this$1).pagingEnabled = 28.access$0(this.this$1).limit > 0L && 28.access$0(this.this$1).logMessages == null ? (long)this.val$msgsOp.getMessages().length == 28.access$0(this.this$1).limit : (long)this.val$msgsOp.getMessages().length == 28.access$0(this.this$1).limit + 1L;
                            28.access$0(this.this$1).addPage(this.val$msgsOp.getMessages());
                        }
                        LogMessage[] toShow = 28.access$0(this.this$1).isFilterEnabled() && 28.access$0(this.this$1).logMessages != null ? 28.access$0(this.this$1).filterMessages(28.access$0(this.this$1).logMessages) : 28.access$0(this.this$1).logMessages;
                        Revision current = 28.access$0(this.this$1).currentRevision != -1L ? Revision.getInstance((long)28.access$0(this.this$1).currentRevision) : null;
                        28.access$0(this.this$1).history.setLogMessages(current, toShow, 28.access$0(this.this$1).repositoryResource);
                        28.access$0(this.this$1).setPagingEnabled();
                    }
                });
            }

            static /* synthetic */ HistoryViewImpl access$0(28 var0) {
                return var0.HistoryViewImpl.this;
            }
        };
        AbstractNonLockingOperation selectOp = new AbstractNonLockingOperation("Operation.HSaveTableSelection"){

            protected void runImpl(IProgressMonitor monitor) throws Exception {
                HistoryViewImpl.this.getSite().getShell().getDisplay().syncExec(new Runnable(this, msgsOp, selected, selectedText){
                    final /* synthetic */ 30 this$1;
                    private final /* synthetic */ GetLogMessagesOperation val$msgsOp;
                    private final /* synthetic */ TableItem[] val$selected;
                    private final /* synthetic */ String val$selectedText;
                    {
                        this.this$1 = var1_1;
                        this.val$msgsOp = getLogMessagesOperation;
                        this.val$selected = tableItemArray;
                        this.val$selectedText = string;
                    }

                    public void run() {
                        if (30.access$0(this.this$1).historyForTheOtherResource(this.val$msgsOp)) {
                            return;
                        }
                        Table table = 30.access$0(this.this$1).history.getTableViewer().getTable();
                        if (!table.isDisposed() && table.getItems().length > 0) {
                            if (this.val$selected.length == 1) {
                                30.access$0(this.this$1).history.setSelectedRevision(new Long(this.val$selectedText.startsWith("*") ? this.val$selectedText.substring(1) : this.val$selectedText));
                            }
                            if (table.getSelection().length == 0) {
                                table.setSelection(0);
                            } else {
                                table.setSelection(this.val$selected);
                            }
                            30.access$0(this.this$1).history.getHistoryTableListener().selectionChanged(null);
                        }
                    }
                });
            }

            static /* synthetic */ HistoryViewImpl access$0(30 var0) {
                return var0.HistoryViewImpl.this;
            }
        };
        CompositeOperation op = new CompositeOperation(showOp.getId());
        if (msgsOp != null) {
            op.add((IActionOperation)new CorrectRevisionOperation(msgsOp, this.repositoryResource, this.currentRevision, this.wcResource));
            op.add((IActionOperation)msgsOp);
        }
        op.add((IActionOperation)showOp);
        op.add((IActionOperation)selectOp, new IActionOperation[]{showOp});
        if (background) {
            ProgressMonitorUtility.doTaskScheduled((IActionOperation)op, (boolean)false);
        } else {
            UIMonitorUtility.doTaskScheduledDefault(this.getSite().getPart(), (IActionOperation)op);
        }
    }

    protected boolean historyForTheOtherResource(GetLogMessagesOperation msgsOp) {
        return this.repositoryResource == null || this.repositoryResource != null && msgsOp != null && !this.repositoryResource.equals(msgsOp.getResource());
    }

    protected void getRevisionContents(Object item) {
        ILocalResource local;
        IRepositoryResource remote = this.getResourceForSelectedRevision(item);
        boolean canWrite = true;
        if (this.wcResource != null && this.wcResource instanceof IFile && (local = SVNRemoteStorage.instance().asLocalResource(this.wcResource)) != null && !local.isLocked() && IStateFilter.SF_NEEDS_LOCK.accept(this.wcResource, local.getStatus(), local.getChangeMask())) {
            canWrite = LockProposeUtility.proposeLock(new IResource[]{this.wcResource}, this.getSite().getShell());
        }
        if (canWrite) {
            GetRemoteContentsOperation mainOp = new GetRemoteContentsOperation(this.wcResource, remote);
            CompositeOperation op = new CompositeOperation(mainOp.getId());
            op.add((IActionOperation)mainOp);
            op.add((IActionOperation)new RefreshResourcesOperation(new IResource[]{this.wcResource}));
            UIMonitorUtility.doTaskNowWorkspaceModify(this.getSite().getShell(), (IActionOperation)op, false);
        }
    }

    protected void showRepositoryResourceAnnotation(Object item) {
        IWorkbenchPage page = this.getSite().getPage();
        IRepositoryResource remote = this.getResourceForSelectedRevision(item);
        UIMonitorUtility.doTaskBusyDefault((IActionOperation)(this.wcResource != null ? new LocalShowAnnotationOperation(this.wcResource, page, remote.getSelectedRevision()) : new RemoteShowAnnotationOperation(remote, page)));
    }

    protected void addRevisionLinks(IStructuredSelection tSelection) {
        IRepositoryLocation location = this.repositoryResource.getRepositoryLocation();
        CompositeOperation op = new CompositeOperation("Operation.HAddSelectedRevision");
        Iterator iter = tSelection.iterator();
        while (iter.hasNext()) {
            LogMessage item = (LogMessage)iter.next();
            IRepositoryResource resource = SVNUtility.copyOf((IRepositoryResource)this.repositoryResource);
            resource.setSelectedRevision(Revision.getInstance((long)item.revision));
            LocateResourceURLInHistoryOperation locateOp = new LocateResourceURLInHistoryOperation(new IRepositoryResource[]{resource}, true);
            op.add((IActionOperation)locateOp);
            op.add((IActionOperation)new AddRevisionLinkOperation((IRepositoryResourceProvider)locateOp, item.revision), new IActionOperation[]{locateOp});
        }
        op.add((IActionOperation)new SaveRepositoryLocationsOperation());
        op.add((IActionOperation)new RefreshRepositoryLocationsOperation(new IRepositoryLocation[]{location}, true));
        UIMonitorUtility.doTaskScheduledDefault((IActionOperation)op);
    }

    protected void updateTo(Object item) {
        IResource[] resources = new IResource[]{this.wcResource};
        CompositeOperation op = new CompositeOperation("Operation.HUpdateTo");
        RevertOperation revertOp = new RevertOperation(resources, true);
        SaveProjectMetaOperation saveOp = new SaveProjectMetaOperation(resources);
        op.add((IActionOperation)saveOp);
        op.add((IActionOperation)revertOp);
        op.add((IActionOperation)new UpdateOperation(resources, Revision.getInstance((long)this.history.getSelectedRevision()), true), new IActionOperation[]{revertOp});
        op.add((IActionOperation)new RestoreProjectMetaOperation(saveOp));
        op.add((IActionOperation)new RefreshResourcesOperation(resources));
        op.add((IActionOperation)new AbstractActionOperation("Operation.HRefreshView"){

            protected void runImpl(IProgressMonitor monitor) throws Exception {
                UIMonitorUtility.getDisplay().syncExec(new Runnable(this){
                    final /* synthetic */ 32 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        32.access$0(this.this$1).refresh();
                    }
                });
            }

            public ISchedulingRule getSchedulingRule() {
                return null;
            }

            static /* synthetic */ HistoryViewImpl access$0(32 var0) {
                return var0.HistoryViewImpl.this;
            }
        });
        UIMonitorUtility.doTaskNowWorkspaceModify(this.getSite().getShell(), (IActionOperation)op, false);
    }

    protected void handleDoubleClick(Object item, boolean doubleClick) {
        if (this.repositoryResource == null) {
            return;
        }
        if ((this.options & 2) != 0 && doubleClick && (this.repositoryResource instanceof IRepositoryFile || CoreExtensionsManager.instance().getSVNClientWrapperFactory().isCompareFoldersAllowed())) {
            this.compareWithCurrent(item);
        } else if (!(this.repositoryResource instanceof IRepositoryContainer)) {
            UIMonitorUtility.doTaskScheduledActive((IActionOperation)new OpenRemoteFileOperation(new IRepositoryFile[]{(IRepositoryFile)this.getResourceForSelectedRevision(item)}, 0));
        }
    }

    protected void compareWithCurrent(Object item) {
        IRepositoryResource resource = this.getResourceForSelectedRevision(item);
        if (this.wcResource != null) {
            UIMonitorUtility.doTaskScheduledActive((IActionOperation)new CompareResourcesOperation(this.wcResource, resource.getSelectedRevision(), resource.getPegRevision()));
        } else {
            UIMonitorUtility.doTaskScheduledActive((IActionOperation)new CompareRepositoryResourcesOperation(resource, this.getResourceForHeadRevision()));
        }
    }

    protected void createUnifiedDiff(IStructuredSelection selection) {
        CreatePatchWizard wizard = new CreatePatchWizard(this.repositoryResource.getName(), false);
        WizardDialog dialog = new WizardDialog(this.getSite().getShell(), (IWizard)wizard);
        if (dialog.open() == 0) {
            Object[] selected = selection.toArray();
            IRepositoryResource left = this.getResourceForSelectedRevision(selected[0]);
            IRepositoryResource right = null;
            if (selection.size() == 1) {
                long revNum = ((Revision.Number)left.getSelectedRevision()).getNumber() - 1L;
                right = left instanceof IRepositoryFile ? ((IRepositoryRoot)left.getRoot()).asRepositoryFile(left.getUrl(), false) : ((IRepositoryRoot)left.getRoot()).asRepositoryContainer(left.getUrl(), false);
                right.setSelectedRevision(Revision.getInstance((long)revNum));
                right.setPegRevision(left.getPegRevision());
            } else {
                right = this.getResourceForSelectedRevision(selected[1]);
            }
            UIMonitorUtility.doTaskScheduledDefault(this.getSite().getPart(), CreatePatchAction.getCreatePatchOperation(left, right, wizard));
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void handleCopy() {
        String historyText = this.history.getSelectedMessagesAsString();
        Clipboard clipboard = new Clipboard(this.getSite().getShell().getDisplay());
        try {
            clipboard.setContents(new Object[]{historyText}, new Transfer[]{TextTransfer.getInstance()});
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            clipboard.dispose();
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        clipboard.dispose();
    }

    protected IRepositoryResource getResourceForSelectedRevision(Object item) {
        long revNum = ((LogMessage)item).revision;
        IRepositoryFile res = this.repositoryResource instanceof IRepositoryFile ? ((IRepositoryRoot)this.repositoryResource.getRoot()).asRepositoryFile(this.repositoryResource.getUrl(), false) : ((IRepositoryRoot)this.repositoryResource.getRoot()).asRepositoryContainer(this.repositoryResource.getUrl(), false);
        res.setSelectedRevision(Revision.getInstance((long)revNum));
        res.setPegRevision(this.repositoryResource.getPegRevision());
        return res;
    }

    protected IRepositoryResource getResourceForHeadRevision() {
        IRepositoryFile res = this.repositoryResource instanceof IRepositoryFile ? ((IRepositoryRoot)this.repositoryResource.getRoot()).asRepositoryFile(this.repositoryResource.getUrl(), false) : ((IRepositoryRoot)this.repositoryResource.getRoot()).asRepositoryContainer(this.repositoryResource.getUrl(), false);
        res.setSelectedRevision(Revision.HEAD);
        res.setPegRevision(Revision.HEAD);
        return res;
    }

    protected String[] getSelectedAuthors() {
        ArrayList<String> authors = new ArrayList<String>();
        if (this.logMessages != null) {
            int i = 0;
            while (i < this.logMessages.length) {
                String current = this.logMessages[i].author;
                if (current != null && !authors.contains(current)) {
                    authors.add(current);
                }
                ++i;
            }
        }
        return authors.toArray(new String[authors.size()]);
    }

    protected boolean quickFilter() {
        boolean okPressed = false;
        HistoryFilterPanel panel = new HistoryFilterPanel(this.filterByAuthor, this.filterByComment, this.getSelectedAuthors(), this.isCommentFilterEnabled);
        DefaultDialog dialog = new DefaultDialog(this.getSite().getShell(), panel);
        if (dialog.open() == 0) {
            okPressed = true;
            this.filterByAuthor = panel.getAuthor();
            this.filterByComment = panel.getComment();
            this.isCommentFilterEnabled = panel.isCommentFilterEnabled();
        }
        return okPressed;
    }

    protected void clearFilter() {
        this.filterByAuthor = "";
        this.filterByComment = "";
        this.isCommentFilterEnabled = false;
    }

    protected boolean isFilterEnabled() {
        return this.filterByAuthor.length() > 0 || this.isCommentFilterEnabled;
    }

    protected LogMessage[] filterMessages(LogMessage[] msgs) {
        ArrayList<LogMessage> filteredMessages = new ArrayList<LogMessage>();
        int i = 0;
        while (i < msgs.length) {
            String author = msgs[i].author;
            String message = msgs[i].message;
            StringMatcher authorMatcher = new StringMatcher(this.filterByAuthor);
            StringMatcher commentMatcher = new StringMatcher(this.filterByComment);
            if (!(this.filterByAuthor.length() > 0 && !authorMatcher.match(author) || this.isCommentFilterEnabled && !commentMatcher.match(message))) {
                filteredMessages.add(msgs[i]);
            }
            ++i;
        }
        LogMessage[] result = filteredMessages.toArray(new LogMessage[filteredMessages.size()]);
        return result.length > 0 ? result : null;
    }

    protected Action getFilterAction() {
        this.filterAction = new Action(SVNTeamUIPlugin.instance().getResource("HistoryView.QuickFilter")){

            public void run() {
                if (HistoryViewImpl.this.quickFilter()) {
                    HistoryViewImpl.this.showHistoryImpl(null, false);
                }
            }
        };
        this.filterAction.setToolTipText(SVNTeamUIPlugin.instance().getResource("HistoryView.QuickFilter"));
        this.filterAction.setHoverImageDescriptor(SVNTeamUIPlugin.instance().getImageDescriptor("icons/views/history/filter.gif"));
        return this.filterAction;
    }

    protected Action getClearFilterAction() {
        this.clearFilterAction = new Action(SVNTeamUIPlugin.instance().getResource("HistoryView.ClearFilter")){

            public void run() {
                HistoryViewImpl.this.clearFilter();
                HistoryViewImpl.this.showHistoryImpl(null, false);
            }
        };
        this.clearFilterAction.setToolTipText(SVNTeamUIPlugin.instance().getResource("HistoryView.ClearFilter"));
        this.clearFilterAction.setDisabledImageDescriptor(SVNTeamUIPlugin.instance().getImageDescriptor("icons/views/history/clear.gif"));
        this.clearFilterAction.setHoverImageDescriptor(SVNTeamUIPlugin.instance().getImageDescriptor("icons/views/history/clear_filter.gif"));
        return this.clearFilterAction;
    }

    protected Action getCompareModeAction() {
        this.compareModeAction = new Action(SVNTeamUIPlugin.instance().getResource("HistoryView.CompareMode"), 2){

            public void run() {
                HistoryViewImpl.this.options ^= 2;
                IPreferenceStore store = SVNTeamUIPlugin.instance().getPreferenceStore();
                SVNTeamPreferences.setHistoryBoolean(store, "compareMode", (HistoryViewImpl.this.options & 2) != 0);
                HistoryViewImpl.this.compareModeDropDownAction.setChecked((HistoryViewImpl.this.options & 2) != 0);
            }
        };
        this.compareModeAction.setToolTipText(SVNTeamUIPlugin.instance().getResource("HistoryView.CompareMode"));
        this.compareModeAction.setDisabledImageDescriptor(SVNTeamUIPlugin.instance().getImageDescriptor("icons/views/history/compare_mode_disabled.gif"));
        this.compareModeAction.setHoverImageDescriptor(SVNTeamUIPlugin.instance().getImageDescriptor("icons/views/history/compare_mode.gif"));
        IPreferenceStore store = SVNTeamUIPlugin.instance().getPreferenceStore();
        this.options = SVNTeamPreferences.getHistoryBoolean(store, "compareMode") ? this.options | 2 : this.options & 0xFFFFFFFD;
        this.compareModeAction.setChecked((this.options & 2) != 0);
        return this.compareModeAction;
    }

    protected void addPage(LogMessage[] newMessages) {
        if (this.logMessages == null) {
            this.logMessages = newMessages;
        } else {
            ArrayList<LogMessage> oldList = new ArrayList<LogMessage>(Arrays.asList(this.logMessages));
            List<LogMessage> newList = Arrays.asList(newMessages);
            if (newList.size() > 1) {
                newList = newList.subList(1, newList.size());
                oldList.addAll(newList);
            }
            this.logMessages = oldList.toArray(new LogMessage[oldList.size()]);
        }
    }

    protected Action getStopOnCopyAction() {
        this.stopOnCopyAction = new Action(SVNTeamUIPlugin.instance().getResource("HistoryView.StopOnCopy"), 2){

            public void run() {
                HistoryViewImpl.this.refresh();
                HistoryViewImpl.this.options = this.isChecked() ? HistoryViewImpl.this.options | 8 : HistoryViewImpl.this.options & 0xFFFFFFF7;
                HistoryViewImpl.this.stopOnCopyDropDownAction.setChecked((HistoryViewImpl.this.options & 8) != 0);
            }
        };
        this.stopOnCopyAction.setToolTipText(SVNTeamUIPlugin.instance().getResource("HistoryView.StopOnCopy"));
        this.stopOnCopyAction.setImageDescriptor(SVNTeamUIPlugin.instance().getImageDescriptor("icons/views/history/stop_on_copy.gif"));
        return this.stopOnCopyAction;
    }

    protected Action getHideUnrelatedAction() {
        this.hideUnrelatedAction = new Action(SVNTeamUIPlugin.instance().getResource("HistoryView.HideUnrelatedPaths"), 2){

            public void run() {
                HistoryViewImpl.this.history.setShowRelatedPathsOnly(this.isChecked());
                HistoryViewImpl.this.hideUnrelatedDropDownAction.setChecked(this.isChecked());
                HistoryViewImpl.this.options = this.isChecked() ? HistoryViewImpl.this.options | 4 : HistoryViewImpl.this.options & 0xFFFFFFFB;
            }
        };
        this.hideUnrelatedAction.setToolTipText(SVNTeamUIPlugin.instance().getResource("HistoryView.HideUnrelatedPaths"));
        this.hideUnrelatedAction.setImageDescriptor(SVNTeamUIPlugin.instance().getImageDescriptor("icons/views/history/hide_unrelated.gif"));
        return this.hideUnrelatedAction;
    }

    protected Action getPagingAction() {
        this.getNextPageAction = new Action(SVNTeamUIPlugin.instance().getResource("HistoryView.GetNextPage")){

            public void run() {
                GetLogMessagesOperation msgOp = new GetLogMessagesOperation(HistoryViewImpl.this.repositoryResource, HistoryViewImpl.this.stopOnCopyAction.isChecked());
                msgOp.setLimit(HistoryViewImpl.this.limit + 1L);
                if (HistoryViewImpl.this.logMessages != null) {
                    LogMessage lm = HistoryViewImpl.this.logMessages[HistoryViewImpl.this.logMessages.length - 1];
                    msgOp.setSelectedRevision(Revision.getInstance((long)lm.revision));
                }
                HistoryViewImpl.this.showHistoryImpl(msgOp, false);
            }
        };
        String msg = this.limit > 0L ? MessageFormat.format(SVNTeamUIPlugin.instance().getResource("HistoryView.ShowNextX"), String.valueOf(this.limit)) : SVNTeamUIPlugin.instance().getResource("HistoryView.ShowNextPage");
        this.getNextPageAction.setToolTipText(msg);
        this.getNextPageAction.setImageDescriptor(SVNTeamUIPlugin.instance().getImageDescriptor("icons/views/history/paging.gif"));
        return this.getNextPageAction;
    }

    protected Action getPagingAllAction() {
        this.getAllPagesAction = new Action(SVNTeamUIPlugin.instance().getResource("HistoryView.ShowAll")){

            public void run() {
                GetLogMessagesOperation msgOp = new GetLogMessagesOperation(HistoryViewImpl.this.repositoryResource, HistoryViewImpl.this.stopOnCopyAction.isChecked());
                msgOp.setLimit(0L);
                if (HistoryViewImpl.this.logMessages != null) {
                    LogMessage lm = HistoryViewImpl.this.logMessages[HistoryViewImpl.this.logMessages.length - 1];
                    msgOp.setSelectedRevision(Revision.getInstance((long)lm.revision));
                }
                HistoryViewImpl.this.showHistoryImpl(msgOp, false);
            }
        };
        this.getAllPagesAction.setToolTipText(SVNTeamUIPlugin.instance().getResource("HistoryView.ShowAll"));
        this.getAllPagesAction.setImageDescriptor(SVNTeamUIPlugin.instance().getImageDescriptor("icons/views/history/paging_all.gif"));
        return this.getAllPagesAction;
    }

    public Action getRefreshAction() {
        Action refreshAction = new Action(SVNTeamUIPlugin.instance().getResource("HistoryView.Refresh")){

            public void run() {
                HistoryViewImpl.this.refresh();
            }
        };
        refreshAction.setImageDescriptor(SVNTeamUIPlugin.instance().getImageDescriptor("icons/common/refresh.gif"));
        refreshAction.setToolTipText(SVNTeamUIPlugin.instance().getResource("HistoryView.Refresh"));
        return refreshAction;
    }

    protected void showToolBar() {
        IActionBars actionBars = this.getActionBars();
        IToolBarManager tbm = actionBars.getToolBarManager();
        tbm.add((IContributionItem)new Separator());
        tbm.add((IAction)this.getHideUnrelatedAction());
        tbm.add((IAction)this.getStopOnCopyAction());
        tbm.add((IContributionItem)new Separator());
        tbm.add((IAction)this.getFilterAction());
        tbm.add((IAction)this.getClearFilterAction());
        tbm.add((IContributionItem)new Separator());
        tbm.add((IAction)this.getPagingAction());
        tbm.add((IAction)this.getPagingAllAction());
        tbm.add((IAction)this.getCompareModeAction());
        tbm.update(true);
    }

    protected void refreshOptionButtons() {
        IPreferenceStore store = SVNTeamUIPlugin.instance().getPreferenceStore();
        boolean showMultiline = SVNTeamPreferences.getHistoryBoolean(store, "multilineComment");
        boolean showAffected = SVNTeamPreferences.getHistoryBoolean(store, "affectedPaths");
        boolean hierarchicalAffectedView = SVNTeamPreferences.getHistoryBoolean(store, "hierarchicalLayout");
        this.showCommentViewerAction.setChecked(showMultiline);
        this.history.setCommentViewerVisible(showMultiline);
        this.showAffectedPathsViewerAction.setChecked(showAffected);
        this.history.setAffectedPathsViewerVisible(showAffected);
        this.hideUnrelatedDropDownAction.setChecked((this.options & 4) != 0);
        this.hideUnrelatedAction.setChecked((this.options & 4) != 0);
        this.stopOnCopyDropDownAction.setChecked((this.options & 8) != 0);
        this.stopOnCopyAction.setChecked((this.options & 8) != 0);
        this.compareModeDropDownAction.setChecked((this.options & 2) != 0);
        this.compareModeAction.setChecked((this.options & 2) != 0);
        this.flatAction.setChecked(!hierarchicalAffectedView);
        this.hierarchicalAction.setChecked(hierarchicalAffectedView);
        this.flatAction.setEnabled(showAffected);
        this.hierarchicalAction.setEnabled(showAffected);
        this.history.setResourceTreeVisible(hierarchicalAffectedView);
        if (SVNTeamPreferences.getHistoryBoolean(store, "pagingEnable")) {
            this.limit = SVNTeamPreferences.getHistoryInt(store, "pageSize");
            this.getNextPageAction.setToolTipText("Show Next " + this.limit);
            this.options |= 1;
        } else {
            this.limit = 0L;
            this.getNextPageAction.setToolTipText("Show Next Page");
            this.options &= 0xFFFFFFFE;
        }
        this.setPagingEnabled();
    }

    protected void setPagingEnabled() {
        this.filterAction.setEnabled(this.repositoryResource != null && this.logMessages != null);
        this.clearFilterAction.setEnabled(this.isFilterEnabled());
        this.getNextPageAction.setEnabled(this.pagingEnabled & (this.options & 1) != 0);
        this.getAllPagesAction.setEnabled(this.pagingEnabled & (this.options & 1) != 0);
    }

    protected void setPagingDisabled() {
        this.filterAction.setEnabled(false);
        this.clearFilterAction.setEnabled(false);
        this.getNextPageAction.setEnabled(false);
        this.getAllPagesAction.setEnabled(false);
    }

    protected void disconnectView() {
        this.getSite().getShell().getDisplay().syncExec(new Runnable(){

            public void run() {
                HistoryViewImpl.this.showHistory((IResource)null, false);
            }
        });
    }

    protected void addMenuItem(MenuManager menuManager, String label, final AbstractRepositoryTeamAction action) {
        IStructuredSelection tSelection = (IStructuredSelection)this.history.getTableViewer().getSelection();
        Action wrapper = new Action(label){

            public void run() {
                action.run((IAction)this);
            }
        };
        StructuredSelection resourceSelection = tSelection.size() == 1 ? new StructuredSelection((Object)new RepositoryFile(null, this.getResourceForSelectedRevision(tSelection.getFirstElement()))) : new StructuredSelection((Object)StructuredSelection.EMPTY);
        action.selectionChanged((IAction)wrapper, (ISelection)resourceSelection);
        menuManager.add((IAction)wrapper);
    }

    protected boolean isIgnoreReplaceWarning() {
        ReplaceWarningDialog dialog;
        return !FileUtility.checkForResourcesPresenceRecursive((IResource[])new IResource[]{this.wcResource}, (IStateFilter)IStateFilter.SF_COMMITABLE) || (dialog = new ReplaceWarningDialog(this.getSite().getShell())).open() == 0;
    }

    public String getResourceLabel() {
        String resourceName;
        String viewDescription = SVNTeamUIPlugin.instance().getResource("HistoryView.Name");
        if (this.wcResource != null) {
            String path = this.wcResource.getFullPath().toString();
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            String message = SVNTeamUIPlugin.instance().getResource("SVNView.ResourceSelected");
            resourceName = MessageFormat.format(message, viewDescription, path);
        } else if (this.repositoryResource != null) {
            String message = SVNTeamUIPlugin.instance().getResource("SVNView.ResourceSelected");
            resourceName = MessageFormat.format(message, viewDescription, this.repositoryResource.getUrl());
        } else {
            resourceName = SVNTeamUIPlugin.instance().getResource("SVNView.ResourceNotSelected");
        }
        return resourceName;
    }
}

