/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui.info;

import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyPage;
import org.polarion.team.svn.core.IStateFilter;
import org.polarion.team.svn.core.SVNTeamPlugin;
import org.polarion.team.svn.core.client.Info2;
import org.polarion.team.svn.core.client.Lock;
import org.polarion.team.svn.core.operation.IActionOperation;
import org.polarion.team.svn.core.operation.IResourcePropertyProvider;
import org.polarion.team.svn.core.operation.local.InfoOperation;
import org.polarion.team.svn.core.operation.local.property.GetPropertiesOperation;
import org.polarion.team.svn.core.resource.ILocalResource;
import org.polarion.team.svn.core.utility.SVNUtility;
import org.polarion.team.svn.ui.SVNTeamUIPlugin;
import org.polarion.team.svn.ui.composite.PropertiesComposite;
import org.polarion.team.svn.ui.utility.UIMonitorUtility;

public class LocalInfoPage
extends PropertyPage {
    protected PropertiesComposite properties;

    public String getTitle() {
        return String.valueOf(super.getTitle()) + "  (" + SVNTeamUIPlugin.instance().getVersionString() + ")";
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(768);
        composite.setLayoutData((Object)data);
        this.noDefaultAndApplyButton();
        DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 2, Locale.getDefault());
        IResource resource = (IResource)this.getElement();
        InfoOperation op = new InfoOperation(resource);
        UIMonitorUtility.doTaskBusyDefault((IActionOperation)op);
        ILocalResource local = op.getLocal();
        Label description = new Label(composite, 64);
        description.setLayoutData((Object)new GridData());
        description.setText(SVNTeamUIPlugin.instance().getResource("LocalInfoPage.LocalPath"));
        Text content = new Text(composite, 64);
        data = new GridData();
        data.widthHint = 300;
        content.setLayoutData((Object)data);
        content.setEditable(false);
        content.setText(resource.getFullPath().toString());
        description = new Label(composite, 64);
        description.setLayoutData((Object)new GridData());
        description.setText(SVNTeamUIPlugin.instance().getResource("LocalInfoPage.State"));
        content = new Text(composite, 4);
        content.setLayoutData((Object)new GridData());
        content.setEditable(false);
        content.setText(SVNUtility.getStatusText((String)local.getStatus()));
        Info2 info = op.getInfo();
        if (IStateFilter.SF_ONREPOSITORY.accept(resource, local.getStatus(), local.getChangeMask()) && info != null) {
            new Label(composite, 64);
            new Label(composite, 64);
            description = new Label(composite, 64);
            description.setLayoutData((Object)new GridData(2));
            description.setText(SVNTeamUIPlugin.instance().getResource("LocalInfoPage.ResourceURL"));
            content = new Text(composite, 64);
            data = new GridData();
            data.widthHint = 300;
            content.setLayoutData((Object)data);
            content.setEditable(false);
            content.setText(SVNUtility.decodeURL((String)info.url));
            description = new Label(composite, 64);
            description.setLayoutData((Object)new GridData());
            description.setText(SVNTeamUIPlugin.instance().getResource("LocalInfoPage.Revision"));
            content = new Text(composite, 4);
            content.setLayoutData((Object)new GridData());
            content.setEditable(false);
            content.setText(String.valueOf(info.revision));
            description = new Label(composite, 64);
            description.setLayoutData((Object)new GridData());
            description.setText(SVNTeamUIPlugin.instance().getResource("LocalInfoPage.LastChangedAuthor"));
            content = new Text(composite, 4);
            content.setLayoutData((Object)new GridData());
            content.setEditable(false);
            content.setText(info.lastChangedAuthor == null ? SVNTeamPlugin.instance().getResource("SVNInfo.NoAuthor") : info.lastChangedAuthor);
            description = new Label(composite, 64);
            description.setLayoutData((Object)new GridData());
            description.setText(SVNTeamUIPlugin.instance().getResource("LocalInfoPage.LastChangedDate"));
            content = new Text(composite, 4);
            content.setLayoutData((Object)new GridData());
            content.setEditable(false);
            content.setText(info.lastChangedDate == 0L ? SVNTeamPlugin.instance().getResource("SVNInfo.NoDate") : dateFormat.format(new Date(info.lastChangedDate)));
            description = new Label(composite, 64);
            description.setLayoutData((Object)new GridData());
            description.setText(SVNTeamUIPlugin.instance().getResource("LocalInfoPage.LastChangedRevision"));
            content = new Text(composite, 4);
            content.setLayoutData((Object)new GridData());
            content.setEditable(false);
            content.setText(String.valueOf(info.lastChangedRevision));
            Lock lock = info.lock;
            if (lock != null) {
                new Label(composite, 64);
                new Label(composite, 64);
                description = new Label(composite, 64);
                description.setLayoutData((Object)new GridData());
                description.setText(SVNTeamUIPlugin.instance().getResource("LocalInfoPage.LockOwner"));
                content = new Text(composite, 4);
                content.setLayoutData((Object)new GridData());
                content.setEditable(false);
                content.setText(lock.owner == null ? SVNTeamPlugin.instance().getResource("SVNInfo.NoAuthor") : lock.owner);
                description = new Label(composite, 64);
                description.setLayoutData((Object)new GridData());
                description.setText(SVNTeamUIPlugin.instance().getResource("LocalInfoPage.LockComment"));
                content = new Text(composite, 4);
                content.setLayoutData((Object)new GridData());
                content.setEditable(false);
                content.setText(lock.comment == null ? SVNTeamPlugin.instance().getResource("SVNInfo.NoComment") : lock.comment);
                description = new Label(composite, 64);
                description.setLayoutData((Object)new GridData());
                description.setText(SVNTeamUIPlugin.instance().getResource("LocalInfoPage.LockCreationDate"));
                content = new Text(composite, 4);
                content.setLayoutData((Object)new GridData());
                content.setEditable(false);
                content.setText(lock.creationDate == 0L ? SVNTeamPlugin.instance().getResource("SVNInfo.NoAuthor") : dateFormat.format(new Date(lock.creationDate)));
                if (lock.expirationDate != 0L) {
                    description = new Label(composite, 64);
                    description.setLayoutData((Object)new GridData());
                    description.setText(SVNTeamUIPlugin.instance().getResource("LocalInfoPage.LockExpirationDate"));
                    content = new Text(composite, 4);
                    content.setLayoutData((Object)new GridData());
                    content.setEditable(false);
                    content.setText(lock.expirationDate == 0L ? SVNTeamPlugin.instance().getResource("SVNInfo.NoDate") : dateFormat.format(new Date(lock.expirationDate)));
                }
            }
        }
        if (IStateFilter.SF_VERSIONED.accept(resource, local.getStatus(), local.getChangeMask())) {
            new Label(composite, 64);
            new Label(composite, 64);
            Composite group = new Composite(composite, 2048);
            data = new GridData(1808);
            data.horizontalSpan = 2;
            group.setLayoutData((Object)data);
            layout = new GridLayout();
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            group.setLayout((Layout)layout);
            this.properties = new PropertiesComposite(group);
            GetPropertiesOperation propertyProvider = new GetPropertiesOperation(resource);
            UIMonitorUtility.doTaskBusyDefault((IActionOperation)propertyProvider);
            this.properties.setResource((IAdaptable)resource, (IResourcePropertyProvider)propertyProvider);
            UIMonitorUtility.doTaskBusyDefault(this.properties.getRefreshViewOperation());
            this.properties.setLayoutData(new GridData(1808));
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.polarion.team.svn.help.SVNInfoContext");
        return composite;
    }
}

