/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui.operation;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.internal.Utilities;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.polarion.team.svn.core.client.ISVNClientWrapper;
import org.polarion.team.svn.core.client.ISVNProgressMonitor;
import org.polarion.team.svn.core.client.Revision;
import org.polarion.team.svn.core.client.Status;
import org.polarion.team.svn.core.operation.AbstractNonLockingOperation;
import org.polarion.team.svn.core.operation.IActionOperation;
import org.polarion.team.svn.core.operation.IUnprotectedOperation;
import org.polarion.team.svn.core.operation.SVNProgressMonitor;
import org.polarion.team.svn.core.resource.ILocalResource;
import org.polarion.team.svn.core.resource.IRepositoryLocation;
import org.polarion.team.svn.core.resource.IRepositoryResource;
import org.polarion.team.svn.core.svnstorage.SVNRemoteStorage;
import org.polarion.team.svn.core.utility.FileUtility;
import org.polarion.team.svn.core.utility.SVNUtility;
import org.polarion.team.svn.ui.SVNTeamUIPlugin;
import org.polarion.team.svn.ui.compare.ComparePanel;
import org.polarion.team.svn.ui.compare.ThreeWayResourceCompareInput;
import org.polarion.team.svn.ui.dialog.DefaultDialog;
import org.polarion.team.svn.ui.utility.UIMonitorUtility;

public class CompareResourcesOperation
extends AbstractNonLockingOperation {
    protected IResource resource;
    protected Revision revision;
    protected Revision pegRevision;
    protected boolean useDialog = false;

    public CompareResourcesOperation(IResource resource, Revision revision, Revision pegRevision) {
        super("Operation.CompareLocal");
        this.resource = resource;
        this.revision = revision;
        this.pegRevision = pegRevision;
    }

    public CompareResourcesOperation(IResource resource, Revision revision, Revision pegRevision, boolean useDialog) {
        this(resource, revision, pegRevision);
        this.useDialog = useDialog;
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        SVNRemoteStorage storage = SVNRemoteStorage.instance();
        final IRepositoryResource remoteBase = storage.asRepositoryResource(this.resource);
        ILocalResource local = storage.asLocalResource(this.resource);
        if (local == null) {
            return;
        }
        final Status[][] localChanges = new Status[1][];
        final Status[][] remoteChanges = new Status[1][];
        IRepositoryLocation location = remoteBase.getRepositoryLocation();
        final ISVNClientWrapper proxy = location.acquireSVNProxy();
        this.protectStep(new IUnprotectedOperation(){

            public void run(IProgressMonitor monitor) throws Exception {
                localChanges[0] = proxy.status(FileUtility.getWorkingCopyPath((IResource)CompareResourcesOperation.this.resource), true, false, false, false, false, true, (ISVNProgressMonitor)new SVNProgressMonitor((IActionOperation)CompareResourcesOperation.this, monitor, null, false));
            }
        }, monitor, 3);
        if (localChanges[0] != null && !monitor.isCanceled()) {
            ArrayList<Status> changesList = new ArrayList<Status>();
            int i = 0;
            while (i < localChanges[0].length) {
                if (localChanges[0][i].textStatus != 13) {
                    changesList.add(localChanges[0][i]);
                }
                ++i;
            }
            localChanges[0] = changesList.toArray(new Status[changesList.size()]);
            if (this.revision.getKind() == 7 || this.revision.getKind() == 1) {
                final IRepositoryResource remoteRight = local.isCopied() ? this.getRepositoryResourceFor(this.resource, localChanges[0][0].urlCopiedFrom, location) : storage.asRepositoryResource(this.resource);
                remoteRight.setPegRevision(this.pegRevision);
                remoteBase.setPegRevision(this.pegRevision);
                SVNUtility.reorder((Status[])localChanges[0], (boolean)true);
                if (local.isCopied()) {
                    remoteRight.setPegRevision(Revision.getInstance((long)localChanges[0][0].revisionCopiedFrom));
                    remoteBase.setSelectedRevision(remoteRight.getPegRevision());
                } else if (local.getRevision() != -1L) {
                    remoteBase.setSelectedRevision(Revision.getInstance((long)local.getRevision()));
                }
                remoteRight.setSelectedRevision(this.revision);
                final String baseUrl = local.isCopied() ? remoteRight.getUrl() : remoteBase.getUrl();
                this.protectStep(new IUnprotectedOperation(){

                    public void run(IProgressMonitor monitor) throws Exception {
                        remoteChanges[0] = proxy.diffStatus(SVNUtility.encodeURL((String)baseUrl), remoteBase.getPegRevision(), remoteBase.getSelectedRevision(), SVNUtility.encodeURL((String)remoteRight.getUrl()), remoteRight.getPegRevision(), remoteRight.getSelectedRevision(), true, false, (ISVNProgressMonitor)new SVNProgressMonitor((IActionOperation)CompareResourcesOperation.this, monitor, null, false));
                    }
                }, monitor, 3);
            } else {
                remoteChanges[0] = new Status[0];
            }
        }
        location.releaseSVNProxy(proxy);
        if (remoteChanges[0] != null && !monitor.isCanceled()) {
            this.protectStep(new IUnprotectedOperation(){

                public void run(IProgressMonitor monitor) throws Exception {
                    CompareConfiguration cc = new CompareConfiguration();
                    cc.setProperty("org.eclipse.compare.internal.CONFIRM_SAVE_PROPERTY", (Object)Boolean.TRUE);
                    ThreeWayResourceCompareInput compare = new ThreeWayResourceCompareInput(cc, CompareResourcesOperation.this.resource, CompareResourcesOperation.this.revision, CompareResourcesOperation.this.pegRevision, localChanges[0], remoteChanges[0]);
                    compare.initialize(monitor);
                    UIMonitorUtility.getDisplay().syncExec(new Runnable(this, compare){
                        final /* synthetic */ 3 this$1;
                        private final /* synthetic */ ThreeWayResourceCompareInput val$compare;
                        {
                            this.this$1 = var1_1;
                            this.val$compare = threeWayResourceCompareInput;
                        }

                        public void run() {
                            if (3.access$0(this.this$1).useDialog) {
                                if (3.access$0(this.this$1).compareResultOK(this.val$compare)) {
                                    ComparePanel panel = new ComparePanel(this.val$compare, 3.access$0(this.this$1).resource);
                                    DefaultDialog dialog = new DefaultDialog(UIMonitorUtility.getShell(), panel);
                                    dialog.open();
                                }
                            } else {
                                CompareUI.openCompareEditor((CompareEditorInput)this.val$compare);
                            }
                        }
                    });
                }

                static /* synthetic */ CompareResourcesOperation access$0(3 var0) {
                    return var0.CompareResourcesOperation.this;
                }
            }, monitor, 3);
        }
    }

    protected IRepositoryResource getRepositoryResourceFor(IResource resource, String url, IRepositoryLocation location) {
        return resource instanceof IFile ? location.asRepositoryFile(url, false) : location.asRepositoryContainer(url, false);
    }

    protected boolean compareResultOK(CompareEditorInput input) {
        Shell shell;
        block5: {
            shell = UIMonitorUtility.getShell();
            SVNTeamUIPlugin.instance().getWorkbench().getProgressService().run(true, true, (IRunnableWithProgress)input);
            String message = input.getMessage();
            if (message == null) break block5;
            MessageDialog.openError((Shell)shell, (String)Utilities.getString((String)"CompareUIPlugin.compareFailed"), (String)message);
            return false;
        }
        try {
            if (input.getCompareResult() == null) {
                MessageDialog.openInformation((Shell)shell, (String)Utilities.getString((String)"CompareUIPlugin.dialogTitle"), (String)Utilities.getString((String)"CompareUIPlugin.noDifferences"));
                return false;
            }
            return true;
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException x) {
            MessageDialog.openError((Shell)shell, (String)Utilities.getString((String)"CompareUIPlugin.compareFailed"), (String)x.getTargetException().getMessage());
        }
        return false;
    }
}

