/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui.operation;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.polarion.team.svn.core.client.ISVNClientWrapper;
import org.polarion.team.svn.core.client.ISVNProgressMonitor;
import org.polarion.team.svn.core.client.PropertyData;
import org.polarion.team.svn.core.client.Revision;
import org.polarion.team.svn.core.operation.AbstractNonLockingOperation;
import org.polarion.team.svn.core.operation.IActionOperation;
import org.polarion.team.svn.core.operation.SVNProgressMonitor;
import org.polarion.team.svn.core.operation.UnreportableException;
import org.polarion.team.svn.core.resource.IRepositoryContainer;
import org.polarion.team.svn.core.resource.IRepositoryLocation;
import org.polarion.team.svn.core.resource.IRepositoryResource;
import org.polarion.team.svn.core.resource.IRepositoryRoot;
import org.polarion.team.svn.core.svnstorage.SVNRemoteStorage;
import org.polarion.team.svn.core.utility.FileUtility;
import org.polarion.team.svn.core.utility.SVNUtility;
import org.polarion.team.svn.ui.SVNTeamUIPlugin;
import org.polarion.team.svn.ui.preferences.SVNTeamPreferences;

public class GetRemoteFolderChildrenOperation
extends AbstractNonLockingOperation {
    protected IRepositoryContainer parent;
    protected IRepositoryResource[] children;
    protected boolean sortChildren;
    protected Map externalsNames;

    public GetRemoteFolderChildrenOperation(IRepositoryContainer parent) {
        this(parent, true);
    }

    public GetRemoteFolderChildrenOperation(IRepositoryContainer parent, boolean sortChildren) {
        super("Operation.GetRemoteChildren");
        this.parent = parent;
        this.sortChildren = sortChildren;
        this.externalsNames = new HashMap();
    }

    public IRepositoryResource[] getChildren() {
        return this.children;
    }

    public String getExternalsName(IRepositoryResource resource) {
        return (String)this.externalsNames.get(resource);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void runImpl(IProgressMonitor monitor) throws Exception {
        Object[] tmp = this.parent.getChildren();
        IRepositoryResource.Info info = this.parent.getInfo();
        if (info != null && info.hasProperties && SVNTeamPreferences.getRepositoryBoolean(SVNTeamUIPlugin.instance().getPreferenceStore(), "showExternals")) {
            IRepositoryLocation location = this.parent.getRepositoryLocation();
            ISVNClientWrapper proxy = location.acquireSVNProxy();
            try {
                String[] externals;
                String remotePath = this.parent.getUrl();
                PropertyData data = proxy.propertyGet(remotePath, "svn:externals", (ISVNProgressMonitor)new SVNProgressMonitor((IActionOperation)this, monitor, null));
                if (data != null && (externals = data.value.trim().split("[\\n]+")).length > 0) {
                    IRepositoryResource[] newTmp = new IRepositoryResource[tmp.length + externals.length];
                    System.arraycopy(tmp, 0, newTmp, 0, tmp.length);
                    int i = 0;
                    while (i < externals.length) {
                        int revision;
                        String name;
                        block15: {
                            String[] parts = externals[i].split("[\\t ]+");
                            if (parts.length < 2 || parts.length > 4) {
                                throw new UnreportableException("Malformed external, " + parts.length + ", " + externals[i]);
                            }
                            name = parts[0];
                            String url = (parts.length == 2 ? parts[1] : (parts.length == 4 ? parts[3] : parts[2])).trim();
                            try {
                                url = SVNUtility.decodeURL((String)url);
                            }
                            catch (IllegalArgumentException illegalArgumentException) {}
                            url = SVNUtility.normalizeURL((String)url);
                            newTmp[tmp.length + i] = SVNRemoteStorage.instance().asRepositoryResource(location, url, false);
                            revision = -1;
                            try {
                                if (parts.length == 4) {
                                    revision = Integer.parseInt(parts[2]);
                                    break block15;
                                }
                                if (parts.length == 3) {
                                    revision = Integer.parseInt(parts[1].substring(2));
                                }
                            }
                            catch (Exception exception) {
                                throw new UnreportableException("Malformed external, " + parts.length + ", " + externals[i]);
                            }
                        }
                        if (revision != -1) {
                            newTmp[tmp.length + i].setSelectedRevision(Revision.getInstance((long)revision));
                        }
                        this.externalsNames.put(newTmp[tmp.length + i], name);
                        ++i;
                    }
                    tmp = newTmp;
                }
                Object var15_17 = null;
            }
            catch (Throwable throwable) {
                Object var15_16 = null;
                location.releaseSVNProxy(proxy);
                throw throwable;
            }
            location.releaseSVNProxy(proxy);
        }
        if (this.sortChildren) {
            FileUtility.sort((Object[])tmp, (Comparator)new Comparator(){

                public int compare(Object o1, Object o2) {
                    IRepositoryResource first = (IRepositoryResource)o1;
                    IRepositoryResource second = (IRepositoryResource)o2;
                    boolean firstContainer = first instanceof IRepositoryContainer;
                    boolean secondContainer = second instanceof IRepositoryContainer;
                    if (firstContainer && secondContainer) {
                        boolean firstRoot = first instanceof IRepositoryRoot;
                        boolean secondRoot = second instanceof IRepositoryRoot;
                        return firstRoot == secondRoot ? (firstRoot ? this.compareRoots(((IRepositoryRoot)first).getKind(), ((IRepositoryRoot)second).getKind()) : first.getUrl().compareTo(second.getUrl())) : (firstRoot ? -1 : 1);
                    }
                    return firstContainer == secondContainer ? first.getUrl().compareTo(second.getUrl()) : (firstContainer ? -1 : 1);
                }

                public int compareRoots(int firstKind, int secondKind) {
                    return firstKind < secondKind ? -1 : 1;
                }
            });
        }
        this.children = tmp;
    }
}

