/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui.operation;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.polarion.team.svn.core.operation.AbstractNonLockingOperation;
import org.polarion.team.svn.core.operation.IUnprotectedOperation;
import org.polarion.team.svn.core.resource.IRepositoryFile;
import org.polarion.team.svn.core.resource.IRepositoryResourceProvider;
import org.polarion.team.svn.ui.SVNTeamUIPlugin;
import org.polarion.team.svn.ui.history.IRepositoryEditorInput;
import org.polarion.team.svn.ui.history.RepositoryFileEditorInput;
import org.polarion.team.svn.ui.utility.UIMonitorUtility;

public class OpenRemoteFileOperation
extends AbstractNonLockingOperation {
    public static final int OPEN_DEFAULT = 0;
    public static final int OPEN_EXTERNAL = 1;
    public static final int OPEN_INPLACE = 2;
    public static final int OPEN_SPECIFIED = 3;
    protected IRepositoryEditorInput[] inputs;
    protected IEditorPart[] editors;
    protected IRepositoryResourceProvider provider;
    protected int openType;
    protected String openWith;

    public OpenRemoteFileOperation(IRepositoryResourceProvider provider, int openType) {
        this(provider, openType, openType == 3 ? "org.eclipse.ui.DefaultTextEditor" : null);
    }

    public OpenRemoteFileOperation(IRepositoryResourceProvider provider, int openType, String openWith) {
        this(new IRepositoryEditorInput[1], openType, openWith);
        this.provider = provider;
    }

    public OpenRemoteFileOperation(IRepositoryFile[] resources, int openType) {
        this(resources, openType, openType == 3 ? "org.eclipse.ui.DefaultTextEditor" : null);
    }

    public OpenRemoteFileOperation(IRepositoryFile[] resources, int openType, String openWith) {
        this(OpenRemoteFileOperation.asEditorInput(resources), openType, openWith);
    }

    public OpenRemoteFileOperation(IRepositoryEditorInput[] inputs, int openType) {
        this(inputs, openType, openType == 3 ? "org.eclipse.ui.DefaultTextEditor" : null);
    }

    public OpenRemoteFileOperation(IRepositoryEditorInput[] inputs, int openType, String openWith) {
        super("Operation.OpenFile");
        this.inputs = inputs;
        this.openType = openType;
        this.openWith = openWith;
    }

    public IEditorPart[] getEditors() {
        return this.editors;
    }

    protected void runImpl(final IProgressMonitor monitor) throws Exception {
        if (this.provider != null) {
            if (!(this.provider.getRepositoryResources()[0] instanceof IRepositoryFile)) {
                return;
            }
            this.inputs = OpenRemoteFileOperation.asEditorInput(new IRepositoryFile[]{(IRepositoryFile)this.provider.getRepositoryResources()[0]});
        }
        this.editors = new IEditorPart[this.inputs.length];
        int i = 0;
        while (i < this.inputs.length) {
            final int current = i++;
            this.protectStep(new IUnprotectedOperation(){

                public void run(IProgressMonitor monitor) throws Exception {
                    OpenRemoteFileOperation.this.inputs[current].fetchContents(monitor);
                }
            }, monitor, this.inputs.length * 2);
            UIMonitorUtility.getDisplay().syncExec(new Runnable(){

                public void run() {
                    OpenRemoteFileOperation.this.protectStep(new IUnprotectedOperation(this, current){
                        final /* synthetic */ 2 this$1;
                        private final /* synthetic */ int val$current;
                        {
                            this.this$1 = var1_1;
                            this.val$current = n;
                        }

                        public void run(IProgressMonitor monitor) throws Exception {
                            2.access$0(this.this$1).openFile(this.val$current);
                        }
                    }, monitor, OpenRemoteFileOperation.this.inputs.length * 2);
                }

                static /* synthetic */ OpenRemoteFileOperation access$0(2 var0) {
                    return var0.OpenRemoteFileOperation.this;
                }
            });
        }
    }

    protected void openFile(int current) throws Exception {
        IRepositoryEditorInput input = this.inputs[current];
        IWorkbench workbench = SVNTeamUIPlugin.instance().getWorkbench();
        IEditorRegistry registry = workbench.getEditorRegistry();
        IWorkbenchPage page = workbench.getActiveWorkbenchWindow().getActivePage();
        if (this.openType == 1) {
            IEditorDescriptor descriptor = registry.findEditor("org.eclipse.ui.systemExternalEditor");
            if (descriptor != null) {
                this.editors[current] = this.openEditor(page, descriptor.getId(), input);
            }
        } else if (this.openType == 2) {
            IEditorDescriptor descriptor = registry.findEditor("org.eclipse.ui.systemInPlaceEditor");
            if (descriptor != null) {
                this.editors[current] = this.openEditor(page, descriptor.getId(), input);
            }
        } else if (this.openType == 3) {
            IEditorReference[] refs = page.findEditors((IEditorInput)input, this.openWith, 3);
            IEditorPart iEditorPart = this.editors[current] = refs == null || refs.length == 0 ? null : refs[0].getEditor(true);
            if (this.editors[current] == null) {
                this.editors[current] = this.openEditor(page, this.openWith, input);
            } else {
                page.activate((IWorkbenchPart)this.editors[current]);
            }
        } else {
            IEditorDescriptor descriptor = registry.getDefaultEditor(input.getRepositoryResource().getName());
            String editorId = descriptor == null ? "org.eclipse.ui.DefaultTextEditor" : descriptor.getId();
            IEditorReference[] refs = page.findEditors((IEditorInput)input, editorId, 3);
            IEditorPart iEditorPart = this.editors[current] = refs == null || refs.length == 0 ? null : refs[0].getEditor(true);
            if (this.editors[current] == null) {
                try {
                    this.editors[current] = this.openEditor(page, editorId, input);
                    if (this.editors[current] != null && this.editors[current].getClass().getName().toLowerCase().indexOf("error") != -1) {
                        this.editors[current] = this.openEditor(page, "org.eclipse.ui.DefaultTextEditor", input);
                    }
                }
                catch (Throwable throwable) {
                    this.editors[current] = this.openEditor(page, "org.eclipse.ui.DefaultTextEditor", input);
                }
            } else {
                page.activate((IWorkbenchPart)this.editors[current]);
            }
        }
    }

    private final IEditorPart openEditor(IWorkbenchPage page, String editorId, IRepositoryEditorInput input) throws Exception {
        return page.openEditor((IEditorInput)input, editorId);
    }

    protected static IRepositoryEditorInput[] asEditorInput(IRepositoryFile[] resources) {
        IRepositoryEditorInput[] inputs = new IRepositoryEditorInput[resources.length];
        int i = 0;
        while (i < resources.length) {
            inputs[i] = new RepositoryFileEditorInput(resources[i]);
            ++i;
        }
        return inputs;
    }
}

