/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui.operation;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Composite;
import org.polarion.team.svn.core.operation.CompositeOperation;
import org.polarion.team.svn.core.operation.IActionOperation;
import org.polarion.team.svn.core.operation.local.AbstractWorkingCopyOperation;
import org.polarion.team.svn.core.operation.local.DetectDeletedProjectsOperation;
import org.polarion.team.svn.core.operation.local.RefreshResourcesOperation;
import org.polarion.team.svn.core.operation.local.management.DisconnectOperation;
import org.polarion.team.svn.core.resource.IResourceProvider;
import org.polarion.team.svn.ui.composite.ProjectListComposite;
import org.polarion.team.svn.ui.dialog.DefaultDialog;
import org.polarion.team.svn.ui.panel.AbstractDialogPanel;
import org.polarion.team.svn.ui.utility.UIMonitorUtility;

public class ProcessDeletedProjectsOperation
extends AbstractWorkingCopyOperation {
    public ProcessDeletedProjectsOperation(final DetectDeletedProjectsOperation detectOp) {
        super("Operation.ProcessDeletedProjects", new IResourceProvider(){

            public IResource[] getResources() {
                return detectOp.getDeleted();
            }
        });
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        final IProject[] toDisconnect = (IProject[])this.operableData();
        if (toDisconnect == null || toDisconnect.length == 0) {
            return;
        }
        UIMonitorUtility.getDisplay().syncExec(new Runnable(){

            public void run() {
                ProjectListPanel panel = new ProjectListPanel(toDisconnect);
                DefaultDialog dlg = new DefaultDialog(UIMonitorUtility.getShell(), panel);
                dlg.open();
            }
        });
        DisconnectOperation mainOp = new DisconnectOperation(toDisconnect, false);
        CompositeOperation op = new CompositeOperation(mainOp.getId());
        op.add((IActionOperation)mainOp);
        op.add((IActionOperation)new RefreshResourcesOperation((IResource[])toDisconnect, 2, RefreshResourcesOperation.REFRESH_CACHE));
        this.reportStatus(op.run(monitor).getStatus());
    }

    protected class ProjectListPanel
    extends AbstractDialogPanel {
        protected IProject[] resources;
        protected TableViewer tableViewer;

        public ProjectListPanel(IProject[] input) {
            super(new String[]{IDialogConstants.OK_LABEL});
            this.dialogTitle = ProcessDeletedProjectsOperation.this.getOperationResource("ProjectList.Title");
            this.dialogDescription = ProcessDeletedProjectsOperation.this.getOperationResource("ProjectList.Description");
            this.defaultMessage = ProcessDeletedProjectsOperation.this.getOperationResource("ProjectList.Message");
            this.resources = input;
        }

        public void createControls(Composite parent) {
            ProjectListComposite composite = new ProjectListComposite(parent, 4, this.resources, false);
            composite.initialize();
        }

        protected void saveChanges() {
        }

        protected void cancelChanges() {
        }
    }
}

