/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui.panel.common;

import java.text.MessageFormat;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.polarion.team.svn.core.IStateFilter;
import org.polarion.team.svn.core.resource.IRepositoryBase;
import org.polarion.team.svn.core.resource.IRepositoryResource;
import org.polarion.team.svn.core.resource.IRepositoryRoot;
import org.polarion.team.svn.core.utility.FileUtility;
import org.polarion.team.svn.core.utility.SVNUtility;
import org.polarion.team.svn.ui.SVNTeamUIPlugin;
import org.polarion.team.svn.ui.composite.CommentComposite;
import org.polarion.team.svn.ui.composite.ResourceSelectionComposite;
import org.polarion.team.svn.ui.dialog.DefaultDialog;
import org.polarion.team.svn.ui.event.IResourceSelectionChangeListener;
import org.polarion.team.svn.ui.event.ResourceSelectionChangedEvent;
import org.polarion.team.svn.ui.panel.AbstractDialogPanel;
import org.polarion.team.svn.ui.panel.common.RepositoryBrowsingPanel;
import org.polarion.team.svn.ui.preferences.SVNTeamPreferences;
import org.polarion.team.svn.ui.utility.UserInputHistory;
import org.polarion.team.svn.ui.verifier.AbsolutePathVerifier;
import org.polarion.team.svn.ui.verifier.AbstractVerifier;
import org.polarion.team.svn.ui.verifier.CompositeVerifier;
import org.polarion.team.svn.ui.verifier.NonEmptyFieldVerifier;
import org.polarion.team.svn.ui.verifier.URLVerifier;

public abstract class AbstractBranchTagPanel
extends AbstractDialogPanel {
    protected Button startWithCheck;
    protected Button freezeExternalsCheck;
    protected Combo destinationCombo;
    protected UserInputHistory resourceNameHistory;
    protected CommentComposite comment;
    protected String destinationUrl;
    protected IRepositoryRoot root;
    protected String nationalizationId;
    protected boolean startsWith;
    protected boolean freezeExternals;
    protected Set existingNodesNamesSet;
    protected boolean considerStructure;
    protected String historyName;
    protected ResourceSelectionComposite resourceSelection;
    protected IResource[] newResources;
    protected boolean disableSwitch;

    public AbstractBranchTagPanel(IRepositoryRoot root, boolean showStartsWith, Set existingNames, String nationalizationId, String historyName) {
        this(root, showStartsWith, existingNames, nationalizationId, historyName, new IResource[0]);
    }

    public AbstractBranchTagPanel(IRepositoryRoot root, boolean showStartsWith, Set existingNames, String nationalizationId, String historyName, IResource[] resources) {
        this.nationalizationId = nationalizationId;
        this.historyName = historyName;
        this.newResources = FileUtility.getResourcesRecursive((IResource[])resources, (IStateFilter)IStateFilter.SF_NEW, (int)2);
        this.disableSwitch = FileUtility.checkForResourcesPresence((IResource[])resources, (IStateFilter)new IStateFilter(){

            public boolean accept(IResource resource, String state, int mask) {
                return state == "Added";
            }

            public boolean allowsRecursion(IResource resource, String state, int mask) {
                return true;
            }
        }, (int)2);
        this.dialogTitle = SVNTeamUIPlugin.instance().getResource(String.valueOf(this.nationalizationId) + ".Title");
        this.dialogDescription = SVNTeamUIPlugin.instance().getResource(String.valueOf(this.nationalizationId) + ".Description");
        this.defaultMessage = SVNTeamPreferences.getRepositoryBoolean(SVNTeamUIPlugin.instance().getPreferenceStore(), "tagConsideringProjectStructure") ? SVNTeamUIPlugin.instance().getResource(String.valueOf(this.nationalizationId) + ".MessageAuto") : SVNTeamUIPlugin.instance().getResource(String.valueOf(this.nationalizationId) + ".Message");
        this.existingNodesNamesSet = existingNames;
        this.root = root;
        this.startsWith = showStartsWith;
        this.considerStructure = root.getRepositoryLocation().isStructureEnabled() && SVNTeamPreferences.getRepositoryBoolean(SVNTeamUIPlugin.instance().getPreferenceStore(), "tagConsideringProjectStructure");
    }

    public IResource[] getSelectedResources() {
        return this.resourceSelection == null ? null : this.resourceSelection.getSelectedResources();
    }

    public IResource[] getNotSelectedResources() {
        return this.resourceSelection == null ? null : this.resourceSelection.getNotSelectedResources();
    }

    public boolean isFreezeExternals() {
        return this.freezeExternals;
    }

    public String getMessage() {
        return this.comment.getMessage();
    }

    public IRepositoryResource getDestination() {
        this.destinationUrl = this.destinationUrl.trim();
        while (this.destinationUrl.endsWith("/") || this.destinationUrl.endsWith("\\")) {
            this.destinationUrl = this.destinationUrl.substring(0, this.destinationUrl.length() - 1);
        }
        return this.root.getRepositoryLocation().asRepositoryContainer(this.destinationUrl, false);
    }

    public boolean isStartWithSelected() {
        return this.startsWith;
    }

    public Point getPrefferedSize() {
        return new Point(this.newResources != null && this.newResources.length > 0 ? 625 : 525, -1);
    }

    public void postInit() {
        super.postInit();
        this.comment.postInit(this.manager);
    }

    public void createControls(Composite parent) {
        GridData data = null;
        GridLayout layout = new GridLayout();
        Group select = null;
        String substitutionUppercase = SVNTeamUIPlugin.instance().getResource(String.valueOf(this.nationalizationId) + ".NodeName");
        if (this.startsWith) {
            select = new Group(parent, 0);
            layout.numColumns = 2;
            select.setText(this.considerStructure ? substitutionUppercase : SVNTeamUIPlugin.instance().getResource(String.valueOf(this.nationalizationId) + ".Location.Group"));
        } else {
            select = new Composite(parent, 0);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.numColumns = 3;
        }
        select.setLayout((Layout)layout);
        select.setLayoutData((Object)new GridData(768));
        if (!this.startsWith) {
            Label description = new Label((Composite)select, 0);
            data = new GridData();
            description.setLayoutData((Object)data);
            description.setText(this.considerStructure ? substitutionUppercase : SVNTeamUIPlugin.instance().getResource(String.valueOf(this.nationalizationId) + ".Location.Field"));
        }
        this.createTopPart((Composite)select, substitutionUppercase);
        if (this.startsWith) {
            Composite inner = new Composite((Composite)select, 0);
            data = new GridData(768);
            inner.setLayoutData((Object)data);
            layout = new GridLayout();
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            inner.setLayout((Layout)layout);
            this.startWithCheck = new Button(inner, 32);
            data = new GridData(768);
            this.startWithCheck.setLayoutData((Object)data);
            this.startWithCheck.setText(SVNTeamUIPlugin.instance().getResource(String.valueOf(this.nationalizationId) + ".StartsWith"));
            this.startWithCheck.setSelection(false);
            this.startWithCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AbstractBranchTagPanel.this.validateContent();
                }
            });
            this.freezeExternalsCheck = new Button(inner, 32);
            data = new GridData(768);
            this.freezeExternalsCheck.setLayoutData((Object)data);
            this.freezeExternalsCheck.setText(SVNTeamUIPlugin.instance().getResource(String.valueOf(this.nationalizationId) + ".FreezeExternals"));
            this.freezeExternalsCheck.setSelection(false);
        }
        SashForm splitter = new SashForm(parent, 512);
        data = new GridData(1808);
        splitter.setLayoutData((Object)data);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 3;
        splitter.setLayout((Layout)layout);
        Group group = new Group((Composite)splitter, 0);
        group.setLayout((Layout)new GridLayout());
        data = new GridData(1808);
        group.setLayoutData((Object)data);
        group.setText(SVNTeamUIPlugin.instance().getResource(String.valueOf(this.nationalizationId) + ".Comment"));
        this.comment = new CommentComposite((Composite)group, this);
        data = new GridData(1808);
        this.comment.setLayoutData(data);
        if (this.startsWith && this.newResources != null && this.newResources.length > 0) {
            this.resourceSelection = new ResourceSelectionComposite((Composite)splitter, 0, this.newResources, true);
            data = new GridData(1808);
            this.resourceSelection.setLayoutData(data);
            this.resourceSelection.addResourcesSelectionChangedListener(new IResourceSelectionChangeListener(){

                public void resourcesSelectionChanged(ResourceSelectionChangedEvent event) {
                    AbstractBranchTagPanel.this.validateContent();
                }
            });
            this.attachTo((Control)this.resourceSelection, new AbstractVerifier(){

                protected String getWarningMessage(Control input) {
                    IResource[] resources = AbstractBranchTagPanel.this.resourceSelection.getSelectedResources();
                    if ((resources != null && resources.length != 0 || AbstractBranchTagPanel.this.disableSwitch) && AbstractBranchTagPanel.this.startWithCheck.getSelection()) {
                        return String.valueOf(AbstractBranchTagPanel.this.defaultMessage) + " " + SVNTeamUIPlugin.instance().getResource(String.valueOf(AbstractBranchTagPanel.this.nationalizationId) + ".Warning");
                    }
                    return null;
                }

                protected String getErrorMessage(Control input) {
                    return null;
                }
            });
            splitter.setWeights(new int[]{1, 1});
        } else {
            splitter.setWeights(new int[]{1});
        }
    }

    protected Composite createTopPart(Composite select, String substitutionUppercase) {
        this.destinationUrl = this.root.getUrl();
        this.destinationCombo = new Combo(select, 2048);
        GridData data = new GridData(768);
        this.destinationCombo.setLayoutData((Object)data);
        Button browse = new Button(select, 8);
        browse.setText(SVNTeamUIPlugin.instance().getResource("Button.Browse"));
        data = new GridData();
        data.widthHint = DefaultDialog.computeButtonWidth(browse);
        browse.setLayoutData((Object)data);
        CompositeVerifier verifier = new CompositeVerifier();
        if (!this.considerStructure) {
            this.resourceNameHistory = new UserInputHistory(this.historyName);
            this.destinationCombo.setText(this.destinationUrl);
            String name = SVNTeamUIPlugin.instance().getResource(String.valueOf(this.nationalizationId) + ".Location.Verifier");
            verifier.add(new URLVerifier(name));
            verifier.add(new AbsolutePathVerifier(name));
            verifier.add(new AbstractVerifier(){

                protected String getErrorMessage(Control input) {
                    String url = AbstractBranchTagPanel.this.root.getRepositoryLocation().getUrl();
                    if (!AbstractBranchTagPanel.this.destinationCombo.getText().startsWith(url)) {
                        String msg = SVNTeamUIPlugin.instance().getResource(String.valueOf(AbstractBranchTagPanel.this.nationalizationId) + ".Location.Verifier.DoesNotCorresponds");
                        return MessageFormat.format(msg, AbstractBranchTagPanel.this.destinationCombo.getText(), url);
                    }
                    if (AbstractBranchTagPanel.this.startsWith) {
                        if (!AbstractBranchTagPanel.this.destinationCombo.getText().startsWith(AbstractBranchTagPanel.this.root.getUrl())) {
                            AbstractBranchTagPanel.this.startWithCheck.setSelection(false);
                            AbstractBranchTagPanel.this.startWithCheck.setEnabled(false);
                        } else {
                            AbstractBranchTagPanel.this.startWithCheck.setEnabled(true);
                        }
                    }
                    if (AbstractBranchTagPanel.this.root.getUrl().equals(SVNUtility.normalizeURL((String)AbstractBranchTagPanel.this.destinationCombo.getText()))) {
                        return SVNTeamUIPlugin.instance().getResource(String.valueOf(AbstractBranchTagPanel.this.nationalizationId) + ".Location.Verifier.NoTagName");
                    }
                    return null;
                }

                protected String getWarningMessage(Control input) {
                    return null;
                }
            });
            browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    RepositoryBrowsingPanel panel = new RepositoryBrowsingPanel(SVNTeamUIPlugin.instance().getResource(String.valueOf(AbstractBranchTagPanel.this.nationalizationId) + ".SelectionProposal"), (IRepositoryBase)AbstractBranchTagPanel.this.root.getRepositoryLocation());
                    DefaultDialog browser = new DefaultDialog(AbstractBranchTagPanel.this.manager.getShell(), panel);
                    if (browser.open() == 0) {
                        IRepositoryResource selected = panel.getSelectedResource();
                        if (selected != null) {
                            AbstractBranchTagPanel.this.destinationCombo.setText(selected.getUrl());
                        }
                        AbstractBranchTagPanel.this.validateContent();
                    }
                }
            });
        } else {
            this.resourceNameHistory = new UserInputHistory(String.valueOf(this.historyName) + "Name");
            String name = SVNTeamUIPlugin.instance().getResource(String.valueOf(this.nationalizationId) + ".NodeName.Verifier");
            verifier.add(new NonEmptyFieldVerifier(name){

                protected String getErrorMessageImpl(Control input) {
                    String msg = super.getErrorMessageImpl(input);
                    if (msg == null && new Path(this.getText(input)).segmentCount() == 0) {
                        return NonEmptyFieldVerifier.ERROR_MESSAGE;
                    }
                    return msg;
                }
            });
            verifier.add(new AbsolutePathVerifier(name));
            verifier.add(new AbstractVerifier(){

                protected String getErrorMessage(Control input) {
                    String name = AbstractBranchTagPanel.this.destinationCombo.getText();
                    if (AbstractBranchTagPanel.this.existingNodesNamesSet != null && AbstractBranchTagPanel.this.existingNodesNamesSet.contains(name)) {
                        String msg = SVNTeamUIPlugin.instance().getResource(String.valueOf(AbstractBranchTagPanel.this.nationalizationId) + ".NodeName.Verifier.Error.Exists");
                        return MessageFormat.format(msg, name);
                    }
                    return null;
                }

                protected String getWarningMessage(Control input) {
                    return null;
                }
            });
            browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    RepositoryBrowsingPanel panel = new RepositoryBrowsingPanel(SVNTeamUIPlugin.instance().getResource(String.valueOf(AbstractBranchTagPanel.this.nationalizationId) + ".SelectionProposal"), (IRepositoryBase)AbstractBranchTagPanel.this.root);
                    DefaultDialog browser = new DefaultDialog(AbstractBranchTagPanel.this.manager.getShell(), panel);
                    if (browser.open() == 0) {
                        IRepositoryResource selected = panel.getSelectedResource();
                        if (selected != null) {
                            AbstractBranchTagPanel.this.destinationCombo.setText(selected.getUrl().substring(AbstractBranchTagPanel.this.root.getUrl().length() + 1));
                        }
                        AbstractBranchTagPanel.this.validateContent();
                    }
                }
            });
        }
        this.destinationCombo.setVisibleItemCount(this.resourceNameHistory.getDepth());
        this.destinationCombo.setItems(this.resourceNameHistory.getHistory());
        this.attachTo((Control)this.destinationCombo, verifier);
        return select;
    }

    protected void saveChanges() {
        if (!this.considerStructure) {
            this.destinationUrl = this.destinationCombo.getText();
            this.resourceNameHistory.addLine(this.destinationUrl);
        } else {
            this.destinationUrl = String.valueOf(this.destinationUrl) + "/" + this.destinationCombo.getText();
            this.resourceNameHistory.addLine(this.destinationCombo.getText());
        }
        this.comment.saveChanges();
        if (this.startWithCheck != null) {
            this.startsWith = this.startWithCheck.getSelection();
            this.freezeExternals = this.freezeExternalsCheck.getSelection();
        } else {
            this.startsWith = false;
            this.freezeExternals = false;
        }
    }

    protected void cancelChanges() {
        this.comment.cancelChanges();
    }
}

