/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui.panel.common;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.polarion.team.svn.core.utility.PatternProvider;
import org.polarion.team.svn.ui.SVNTeamUIPlugin;
import org.polarion.team.svn.ui.dialog.DefaultDialog;
import org.polarion.team.svn.ui.panel.AbstractDialogPanel;
import org.polarion.team.svn.ui.preferences.SVNTeamAutoPropsPreferencePage;
import org.polarion.team.svn.ui.verifier.AbstractVerifierProxy;
import org.polarion.team.svn.ui.verifier.CompositeVerifier;
import org.polarion.team.svn.ui.verifier.FileNameTemplateVerifier;
import org.polarion.team.svn.ui.verifier.MultiLinePropertyVerifier;
import org.polarion.team.svn.ui.verifier.NonEmptyFieldVerifier;

public class EditAutoPropertiesPanel
extends AbstractDialogPanel {
    protected SVNTeamAutoPropsPreferencePage.AutoProperty property;
    protected Text txtFileName;
    protected Text txtProperties;
    protected String fileName;
    protected String properties;

    public EditAutoPropertiesPanel(SVNTeamAutoPropsPreferencePage.AutoProperty property) {
        this.property = property;
        this.dialogTitle = SVNTeamUIPlugin.instance().getResource(property == null ? "EditAutoPropertiesPanel.Title.Add" : "EditAutoPropertiesPanel.Title.Edit");
        this.dialogDescription = SVNTeamUIPlugin.instance().getResource("EditAutoPropertiesPanel.Description");
        this.defaultMessage = SVNTeamUIPlugin.instance().getResource("EditAutoPropertiesPanel.Message");
    }

    public void createControls(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.marginBottom = 5;
        composite.setLayout((Layout)layout);
        GridData layoutData = new GridData(768);
        composite.setLayoutData((Object)layoutData);
        Label label = new Label(composite, 0);
        label.setText(SVNTeamUIPlugin.instance().getResource("EditAutoPropertiesPanel.FileName"));
        this.txtFileName = new Text(composite, 2048);
        this.txtFileName.setText(this.property == null ? "" : this.property.fileName);
        layoutData = new GridData(768);
        this.txtFileName.setLayoutData((Object)layoutData);
        String fieldName = SVNTeamUIPlugin.instance().getResource("EditAutoPropertiesPanel.FileName.Verifier");
        CompositeVerifier verifier = new CompositeVerifier();
        verifier.add(new NonEmptyFieldVerifier(fieldName));
        verifier.add(new AbstractVerifierProxy(new FileNameTemplateVerifier(fieldName)){

            protected boolean isVerificationEnabled(Control input) {
                return EditAutoPropertiesPanel.this.txtFileName.getText().trim().length() > 0;
            }
        });
        this.attachTo((Control)this.txtFileName, verifier);
        Group group = new Group(parent, 0);
        group.setText(SVNTeamUIPlugin.instance().getResource("EditAutoPropertiesPanel.Properties"));
        layoutData = new GridData(1808);
        group.setLayoutData((Object)layoutData);
        layout = new GridLayout();
        group.setLayout((Layout)layout);
        label = new Label((Composite)group, 0);
        label.setText(SVNTeamUIPlugin.instance().getResource("EditAutoPropertiesPanel.Properties.Hint"));
        this.txtProperties = new Text((Composite)group, 2818);
        this.txtProperties.setText(this.property == null ? "" : PatternProvider.replaceAll((String)this.property.properties, (String)";", (String)System.getProperty("line.separator")).trim());
        layoutData = new GridData(1808);
        layoutData.heightHint = DefaultDialog.convertHeightInCharsToPixels((Control)this.txtProperties, 7);
        this.txtProperties.setLayoutData((Object)layoutData);
        this.attachTo((Control)this.txtProperties, new AbstractVerifierProxy(new MultiLinePropertyVerifier(SVNTeamUIPlugin.instance().getResource("EditAutoPropertiesPanel.Properties.Verifier"))){

            protected boolean isVerificationEnabled(Control input) {
                return EditAutoPropertiesPanel.this.txtProperties.getText().trim().length() > 0;
            }
        });
    }

    protected void cancelChanges() {
    }

    protected void saveChanges() {
        this.fileName = this.txtFileName.getText().trim();
        this.properties = PatternProvider.replaceAll((String)this.txtProperties.getText().trim(), (String)";", (String)System.getProperty("line.separator"));
        this.properties = PatternProvider.replaceAll((String)this.properties.trim(), (String)System.getProperty("line.separator"), (String)";");
        this.properties = PatternProvider.replaceAll((String)this.properties, (String)";{2,}", (String)";");
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getProperties() {
        return this.properties;
    }
}

