/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui.panel.common;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.polarion.team.svn.core.client.Revision;
import org.polarion.team.svn.core.resource.IRepositoryBase;
import org.polarion.team.svn.core.resource.IRepositoryLocation;
import org.polarion.team.svn.core.resource.IRepositoryResource;
import org.polarion.team.svn.ui.SVNTeamUIPlugin;
import org.polarion.team.svn.ui.dialog.AdvancedDialog;
import org.polarion.team.svn.ui.operation.UILoggedOperation;
import org.polarion.team.svn.ui.panel.AbstractDialogPanel;
import org.polarion.team.svn.ui.panel.reporting.ErrorCancelPanel;
import org.polarion.team.svn.ui.repository.RepositoryTreeViewer;
import org.polarion.team.svn.ui.repository.model.IRepositoryContentFilter;
import org.polarion.team.svn.ui.repository.model.RepositoryContentProvider;
import org.polarion.team.svn.ui.repository.model.RepositoryError;
import org.polarion.team.svn.ui.repository.model.RepositoryFictiveNode;
import org.polarion.team.svn.ui.repository.model.RepositoryFile;
import org.polarion.team.svn.ui.repository.model.RepositoryFolder;
import org.polarion.team.svn.ui.repository.model.RepositoryLocation;
import org.polarion.team.svn.ui.repository.model.RepositoryPending;
import org.polarion.team.svn.ui.repository.model.RepositoryResource;
import org.polarion.team.svn.ui.utility.UIMonitorUtility;

public class RepositoryBrowsingPanel
extends AbstractDialogPanel {
    protected RepositoryTreeViewer repositoryTree;
    protected IRepositoryBase root;
    protected IRepositoryResource selectedResource;
    protected boolean onlyFolders;
    protected Revision revision;
    protected boolean autoExpandFirstLevel;

    public RepositoryBrowsingPanel(String title, IRepositoryBase root) {
        this(title, root, Revision.HEAD, true);
    }

    public RepositoryBrowsingPanel(String title, IRepositoryBase root, Revision revision) {
        this(title, root, revision, true);
    }

    public RepositoryBrowsingPanel(String title, IRepositoryBase root, Revision revision, boolean onlyFolders) {
        this.dialogTitle = title;
        this.root = root;
        this.revision = revision;
        this.onlyFolders = onlyFolders;
        this.dialogDescription = SVNTeamUIPlugin.instance().getResource("RepositoryBrowsingPanel.Description");
        this.defaultMessage = SVNTeamUIPlugin.instance().getResource("RepositoryBrowsingPanel.Message");
    }

    public void setAutoexpandFirstLevel(boolean autoExpandFirstLevel) {
        this.autoExpandFirstLevel = autoExpandFirstLevel;
    }

    public IRepositoryResource getSelectedResource() {
        return this.selectedResource;
    }

    public void createControls(Composite parent) {
        this.repositoryTree = new RepositoryTreeViewer(parent, 2820);
        if (this.autoExpandFirstLevel) {
            this.repositoryTree.setAutoExpandLevel(2);
        }
        RepositoryContentProvider provider = new RepositoryContentProvider(this.repositoryTree){

            public Object[] getChildren(Object parentElement) {
                Object[] retVal = super.getChildren(parentElement);
                if (parentElement instanceof RepositoryResource && ((RepositoryResource)parentElement).getRepositoryResource() == RepositoryBrowsingPanel.this.root && (retVal == null || retVal.length == 0)) {
                    return new Object[]{new RepositoryFictiveNode(this){
                        final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public Object[] getChildren(Object o) {
                            return null;
                        }

                        public ImageDescriptor getImageDescriptor(Object object) {
                            return null;
                        }

                        public String getLabel(Object o) {
                            return SVNTeamUIPlugin.instance().getResource("RepositoryBrowsingPanel.EmptyLabel");
                        }
                    }};
                }
                return retVal;
            }
        };
        provider.setFilter(new IRepositoryContentFilter(){

            public boolean accept(Object obj) {
                if (RepositoryBrowsingPanel.this.onlyFolders) {
                    if (obj instanceof RepositoryResource) {
                        RepositoryResource child = (RepositoryResource)obj;
                        if (child instanceof RepositoryFile) {
                            return false;
                        }
                        IRepositoryResource remote = child.getRepositoryResource();
                        remote.setSelectedRevision(RepositoryBrowsingPanel.this.revision);
                        remote.setPegRevision(RepositoryBrowsingPanel.this.revision);
                    } else if (!(obj instanceof RepositoryPending) && !(obj instanceof RepositoryError)) {
                        return false;
                    }
                }
                return true;
            }
        });
        this.repositoryTree.setContentProvider((IContentProvider)provider);
        this.repositoryTree.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.repositoryTree.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (RepositoryBrowsingPanel.this.manager != null) {
                    IStructuredSelection selection = (IStructuredSelection)RepositoryBrowsingPanel.this.repositoryTree.getSelection();
                    RepositoryBrowsingPanel.this.manager.setButtonEnabled(0, !selection.isEmpty() && selection.getFirstElement() instanceof RepositoryResource);
                }
            }
        });
        if (this.root instanceof IRepositoryLocation) {
            this.repositoryTree.setInput(new RepositoryLocation((IRepositoryLocation)this.root));
        } else {
            RepositoryResource resource = RepositoryFolder.wrapChild(null, (IRepositoryResource)this.root);
            resource.setViewer(this.repositoryTree);
            this.repositoryTree.setInput(resource);
        }
        GridData data = new GridData(1808);
        data.heightHint = 185;
        this.repositoryTree.getTree().setLayoutData((Object)data);
        MenuManager menuMgr = new MenuManager();
        Menu menu = menuMgr.createContextMenu((Control)this.repositoryTree.getTree());
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                IStructuredSelection tSelection = (IStructuredSelection)RepositoryBrowsingPanel.this.repositoryTree.getSelection();
                if (tSelection.getFirstElement() instanceof RepositoryError) {
                    manager.add((IAction)new Action(this, SVNTeamUIPlugin.instance().getResource("RepositoryBrowsingPanel.Details"), tSelection){
                        final /* synthetic */ 5 this$1;
                        private final /* synthetic */ IStructuredSelection val$tSelection;
                        {
                            this.this$1 = var1_1;
                            this.val$tSelection = iStructuredSelection;
                            super($anonymous0);
                        }

                        public void run() {
                            RepositoryError error = (RepositoryError)this.val$tSelection.getFirstElement();
                            UILoggedOperation.OperationErrorInfo errorInfo = UILoggedOperation.formatMessage(error.getErrorStatus(), true);
                            ErrorCancelPanel panel = new ErrorCancelPanel(SVNTeamUIPlugin.instance().getResource("RepositoryBrowsingPanel.Details.Title"), errorInfo.numberOfErrors, errorInfo.simpleMessage, errorInfo.advancedMessage, false, null);
                            AdvancedDialog dialog = new AdvancedDialog(UIMonitorUtility.getDisplay().getActiveShell(), panel);
                            dialog.open();
                        }
                    });
                }
            }
        });
        menuMgr.setRemoveAllWhenShown(true);
        this.repositoryTree.getTree().setMenu(menu);
    }

    protected void saveChanges() {
        IStructuredSelection selection = (IStructuredSelection)this.repositoryTree.getSelection();
        if (selection != null && !selection.isEmpty()) {
            this.selectedResource = ((RepositoryResource)selection.getFirstElement()).getRepositoryResource();
        }
    }

    protected void cancelChanges() {
    }
}

