/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui.panel.common;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.polarion.team.svn.core.client.LogMessage;
import org.polarion.team.svn.core.client.Revision;
import org.polarion.team.svn.core.operation.AbstractNonLockingOperation;
import org.polarion.team.svn.core.operation.CompositeOperation;
import org.polarion.team.svn.core.operation.IActionOperation;
import org.polarion.team.svn.core.operation.remote.GetLogMessagesOperation;
import org.polarion.team.svn.core.resource.IRepositoryResource;
import org.polarion.team.svn.core.utility.StringMatcher;
import org.polarion.team.svn.ui.SVNTeamUIPlugin;
import org.polarion.team.svn.ui.composite.LogMessagesComposite;
import org.polarion.team.svn.ui.dialog.DefaultDialog;
import org.polarion.team.svn.ui.panel.AbstractDialogPanel;
import org.polarion.team.svn.ui.panel.view.HistoryFilterPanel;
import org.polarion.team.svn.ui.preferences.SVNTeamPreferences;
import org.polarion.team.svn.ui.utility.UIMonitorUtility;

public class SelectRevisionPanel
extends AbstractDialogPanel {
    protected LogMessagesComposite history;
    protected LogMessage[] logMessages;
    protected IRepositoryResource resource;
    protected long currentRevision;
    protected long[] selectedRevisions;
    protected String selectedMessage;
    protected int selectionStyle;
    protected long limit;
    protected boolean pagingEnabled;
    protected LogMessage[] selectedLogMessages;
    protected Text resourceLabel;
    protected ToolItem hideUnrelatedItem;
    protected ToolItem stopOnCopyItem;
    protected ToolItem pagingItem;
    protected ToolItem pagingAllItem;
    protected ToolItem filterItem;
    protected ToolItem clearFilterItem;
    protected ToolItem refreshItem;
    protected ToolItem separator;
    protected boolean isCommentFilterEnabled = false;
    protected String filterByComment;
    protected String filterByAuthor;
    protected ISelectionChangedListener tableViewerListener;
    protected IPropertyChangeListener configurationListener;
    protected boolean initialStopOnCopy;

    public SelectRevisionPanel(GetLogMessagesOperation msgOp, int selectionStyle) {
        this(msgOp, selectionStyle, -1L);
    }

    public SelectRevisionPanel(GetLogMessagesOperation msgOp, int selectionStyle, long currentRevision) {
        this.selectionStyle = selectionStyle;
        this.dialogTitle = SVNTeamUIPlugin.instance().getResource("SelectRevisionPanel.Title");
        this.dialogDescription = SVNTeamUIPlugin.instance().getResource("SelectRevisionPanel.Description");
        this.defaultMessage = SVNTeamUIPlugin.instance().getResource("SelectRevisionPanel.Message");
        this.resource = msgOp.getResource();
        this.selectedRevisions = null;
        this.currentRevision = currentRevision;
        this.filterByAuthor = "";
        this.filterByComment = "";
        this.logMessages = msgOp.getMessages();
        this.initialStopOnCopy = msgOp.getStopOnCopy();
    }

    public String getHelpId() {
        return "org.polarion.team.svn.help.revisionLinkDialogContext";
    }

    public long[] getSelectedRevisions() {
        return this.selectedRevisions;
    }

    public long getSelectedRevision() {
        return this.selectedRevisions[0];
    }

    public String getSelectedMessage() {
        return this.selectedMessage;
    }

    public String getImagePath() {
        return "icons/dialogs/select_revision.gif";
    }

    public void postInit() {
        this.manager.setButtonEnabled(0, false);
    }

    public Point getPrefferedSize() {
        return new Point(700, -1);
    }

    public void createControls(Composite parent) {
        IPreferenceStore store = SVNTeamUIPlugin.instance().getPreferenceStore();
        Composite labelAndToolbar = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        labelAndToolbar.setLayout((Layout)layout);
        GridData data = new GridData(768);
        labelAndToolbar.setLayoutData((Object)data);
        Composite resourceLabelComposite = new Composite(labelAndToolbar, 0);
        data = new GridData(768);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.horizontalSpacing = 1;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        resourceLabelComposite.setLayout((Layout)layout);
        resourceLabelComposite.setLayoutData((Object)data);
        this.resourceLabel = new Text(resourceLabelComposite, 16384);
        this.resourceLabel.setEditable(false);
        data = new GridData(770);
        this.resourceLabel.setLayoutData((Object)data);
        ToolBarManager toolBarMgr = new ToolBarManager(0x800000);
        ToolBar toolBar = toolBarMgr.createControl(labelAndToolbar);
        data = new GridData();
        data.horizontalAlignment = 3;
        toolBar.setLayoutData((Object)data);
        this.hideUnrelatedItem = new ToolItem(toolBar, 0x800020);
        this.stopOnCopyItem = new ToolItem(toolBar, 0x800020);
        this.filterItem = new ToolItem(toolBar, 0x800000);
        this.clearFilterItem = new ToolItem(toolBar, 0x800000);
        this.separator = new ToolItem(toolBar, 2);
        this.pagingItem = new ToolItem(toolBar, 0x800000);
        this.pagingAllItem = new ToolItem(toolBar, 0x800000);
        this.separator = new ToolItem(toolBar, 2);
        this.refreshItem = new ToolItem(toolBar, 0x800000);
        this.hideUnrelatedItem.setImage(SVNTeamUIPlugin.instance().getImageDescriptor("icons/views/history/hide_unrelated.gif").createImage());
        this.stopOnCopyItem.setImage(SVNTeamUIPlugin.instance().getImageDescriptor("icons/views/history/stop_on_copy.gif").createImage());
        this.stopOnCopyItem.setSelection(this.initialStopOnCopy);
        this.filterItem.setImage(SVNTeamUIPlugin.instance().getImageDescriptor("icons/views/history/filter.gif").createImage());
        this.clearFilterItem.setDisabledImage(SVNTeamUIPlugin.instance().getImageDescriptor("icons/views/history/clear.gif").createImage());
        this.clearFilterItem.setImage(SVNTeamUIPlugin.instance().getImageDescriptor("icons/views/history/clear_filter.gif").createImage());
        this.pagingItem.setImage(SVNTeamUIPlugin.instance().getImageDescriptor("icons/views/history/paging.gif").createImage());
        this.pagingAllItem.setImage(SVNTeamUIPlugin.instance().getImageDescriptor("icons/views/history/paging_all.gif").createImage());
        this.refreshItem.setImage(SVNTeamUIPlugin.instance().getImageDescriptor("icons/common/refresh.gif").createImage());
        this.hideUnrelatedItem.setToolTipText(SVNTeamUIPlugin.instance().getResource("SelectRevisionPanel.Unrelated"));
        this.stopOnCopyItem.setToolTipText(SVNTeamUIPlugin.instance().getResource("SelectRevisionPanel.StopOnCopy"));
        this.filterItem.setToolTipText(SVNTeamUIPlugin.instance().getResource("SelectRevisionPanel.QuickFilter"));
        this.clearFilterItem.setToolTipText(SVNTeamUIPlugin.instance().getResource("SelectRevisionPanel.ClearFilter"));
        this.pagingAllItem.setToolTipText(SVNTeamUIPlugin.instance().getResource("SelectRevisionPanel.ShowAll"));
        this.refreshItem.setToolTipText(SVNTeamUIPlugin.instance().getResource("SelectRevisionPanel.Refresh"));
        Composite group = new Composite(parent, 2048);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 1;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(1808));
        this.history = new LogMessagesComposite(group, 75, this.selectionStyle);
        data = new GridData(1808);
        data.heightHint = 350;
        this.history.setLayoutData(data);
        this.history.setFocus();
        this.tableViewerListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (SelectRevisionPanel.this.manager != null) {
                    if (event != null) {
                        SelectRevisionPanel.this.manager.setButtonEnabled(0, !event.getSelection().isEmpty());
                    } else {
                        SelectRevisionPanel.this.manager.setButtonEnabled(0, !SelectRevisionPanel.this.history.getTableViewer().getSelection().isEmpty());
                    }
                }
            }
        };
        this.history.getTableViewer().addSelectionChangedListener(this.tableViewerListener);
        if (SVNTeamPreferences.getHistoryBoolean(store, "pagingEnable")) {
            this.limit = SVNTeamPreferences.getHistoryInt(store, "pageSize");
            String msg = SVNTeamUIPlugin.instance().getResource("SelectRevisionPanel.ShowNextX");
            this.pagingItem.setToolTipText(MessageFormat.format(msg, String.valueOf(this.limit)));
            this.pagingEnabled = true;
        } else {
            this.limit = 0L;
            this.pagingItem.setToolTipText(SVNTeamUIPlugin.instance().getResource("SelectRevisionPanel.ShowNextPage"));
            this.pagingEnabled = false;
        }
        this.pagingEnabled = this.limit > 0L && (long)this.logMessages.length == this.limit;
        this.showMessages(null);
        this.setPagingEnabled();
        this.clearFilterItem.setEnabled(false);
        this.hideUnrelatedItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SelectRevisionPanel.this.history.setShowRelatedPathsOnly(SelectRevisionPanel.this.hideUnrelatedItem.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.stopOnCopyItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SelectRevisionPanel.this.refresh();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.filterItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (SelectRevisionPanel.this.quickFilter()) {
                    SelectRevisionPanel.this.showMessages(null);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.clearFilterItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SelectRevisionPanel.this.clearFilter();
                SelectRevisionPanel.this.showMessages(null);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.pagingItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SelectRevisionPanel.this.showNextPage(false);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.pagingAllItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SelectRevisionPanel.this.showNextPage(true);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.refreshItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SelectRevisionPanel.this.refresh();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.showResourceLabel();
    }

    public LogMessage[] getSelectedLogMessages() {
        return this.selectedLogMessages;
    }

    protected void showResourceLabel() {
        String resourceName = SVNTeamUIPlugin.instance().getResource("SelectRevisionPanel.NotSelected");
        if (this.resource != null) {
            resourceName = this.resource.getUrl();
        }
        this.resourceLabel.setText(resourceName);
    }

    protected void saveChanges() {
        this.selectedRevisions = this.history.getSelectedRevisions();
        this.selectedMessage = this.history.getSelectedMessage();
        this.selectedLogMessages = this.history.getSelectedLogMessages();
    }

    protected void cancelChanges() {
    }

    protected void addPage(LogMessage[] newMessages) {
        if (this.logMessages == null) {
            this.logMessages = newMessages;
        } else {
            ArrayList<LogMessage> oldList = new ArrayList<LogMessage>(Arrays.asList(this.logMessages));
            List<LogMessage> newList = Arrays.asList(newMessages);
            if (newList.size() > 1) {
                newList = newList.subList(1, newList.size());
                oldList.addAll(newList);
            }
            this.logMessages = oldList.toArray(new LogMessage[oldList.size()]);
        }
    }

    protected void setPagingEnabled() {
        this.pagingEnabled &= this.resource != null && this.limit > 0L;
        this.pagingItem.setEnabled(this.pagingEnabled);
        this.pagingAllItem.setEnabled(this.pagingEnabled);
        this.filterItem.setEnabled(this.resource != null && this.logMessages != null);
        this.clearFilterItem.setEnabled(this.isFilterEnabled() && this.logMessages != null);
    }

    protected void showMessages(final GetLogMessagesOperation msgsOp) {
        Table table = this.history.getTableViewer().getTable();
        final TableItem[] selected = table.getSelection();
        AbstractNonLockingOperation showOp = new AbstractNonLockingOperation("Operation.ShowMessages"){

            protected void runImpl(IProgressMonitor monitor) throws Exception {
                SVNTeamUIPlugin.instance().getWorkbench().getDisplay().syncExec(new Runnable(this, msgsOp){
                    final /* synthetic */ 9 this$1;
                    private final /* synthetic */ GetLogMessagesOperation val$msgsOp;
                    {
                        this.this$1 = var1_1;
                        this.val$msgsOp = getLogMessagesOperation;
                    }

                    public void run() {
                        if (this.val$msgsOp != null && this.val$msgsOp.getExecutionState() == 0) {
                            9.access$0(this.this$1).pagingEnabled = 9.access$0(this.this$1).limit > 0L && 9.access$0(this.this$1).logMessages == null ? (long)this.val$msgsOp.getMessages().length == 9.access$0(this.this$1).limit : (long)this.val$msgsOp.getMessages().length == 9.access$0(this.this$1).limit + 1L;
                            9.access$0(this.this$1).addPage(this.val$msgsOp.getMessages());
                        }
                        LogMessage[] toShow = 9.access$0(this.this$1).isFilterEnabled() && 9.access$0(this.this$1).logMessages != null ? 9.access$0(this.this$1).filterMessages(9.access$0(this.this$1).logMessages) : 9.access$0(this.this$1).logMessages;
                        Revision current = 9.access$0(this.this$1).currentRevision != -1L ? Revision.getInstance((long)9.access$0(this.this$1).currentRevision) : null;
                        9.access$0(this.this$1).history.setLogMessages(current, toShow, 9.access$0(this.this$1).resource);
                        9.access$0(this.this$1).setPagingEnabled();
                    }
                });
            }

            static /* synthetic */ SelectRevisionPanel access$0(9 var0) {
                return var0.SelectRevisionPanel.this;
            }
        };
        AbstractNonLockingOperation selectOp = new AbstractNonLockingOperation("Operation.SaveTableSelection"){

            protected void runImpl(IProgressMonitor monitor) throws Exception {
                SVNTeamUIPlugin.instance().getWorkbench().getDisplay().syncExec(new Runnable(this, selected){
                    final /* synthetic */ 11 this$1;
                    private final /* synthetic */ TableItem[] val$selected;
                    {
                        this.this$1 = var1_1;
                        this.val$selected = tableItemArray;
                    }

                    public void run() {
                        Table table = 11.access$0(this.this$1).history.getTableViewer().getTable();
                        if (table.getItems().length > 0) {
                            if (this.val$selected.length != 0) {
                                table.setSelection(this.val$selected);
                            }
                            11.access$0(this.this$1).history.getHistoryTableListener().selectionChanged(null);
                            ISelectionChangedListener listener = 11.access$0(this.this$1).tableViewerListener;
                            if (listener != null) {
                                11.access$0(this.this$1).tableViewerListener.selectionChanged(null);
                            }
                        }
                    }
                });
            }

            static /* synthetic */ SelectRevisionPanel access$0(11 var0) {
                return var0.SelectRevisionPanel.this;
            }
        };
        CompositeOperation op = new CompositeOperation(showOp.getId());
        if (msgsOp != null) {
            op.add((IActionOperation)msgsOp);
        }
        op.add((IActionOperation)showOp);
        op.add((IActionOperation)selectOp, new IActionOperation[]{showOp});
        UIMonitorUtility.doTaskNowDefault((IActionOperation)op, true);
    }

    protected void showNextPage(boolean showAll) {
        if (this.resource != null) {
            GetLogMessagesOperation msgsOp = new GetLogMessagesOperation(this.resource, this.stopOnCopyItem.getSelection());
            msgsOp.setLimit(showAll ? 0L : (this.logMessages == null ? this.limit : this.limit + 1L));
            Revision revision = this.resource.getSelectedRevision();
            if (this.logMessages != null && this.logMessages.length > 1) {
                LogMessage lm = this.logMessages[this.logMessages.length - 1];
                revision = Revision.getInstance((long)lm.revision);
            }
            msgsOp.setSelectedRevision(revision);
            this.showMessages(msgsOp);
        }
    }

    protected boolean quickFilter() {
        boolean okPressed = false;
        HistoryFilterPanel panel = new HistoryFilterPanel(this.filterByAuthor, this.filterByComment, this.getSelectedAuthors(), this.isCommentFilterEnabled);
        DefaultDialog dialog = new DefaultDialog(UIMonitorUtility.getDisplay().getActiveShell(), panel);
        if (dialog.open() == 0) {
            okPressed = true;
            this.filterByAuthor = panel.getAuthor();
            this.filterByComment = panel.getComment();
            this.isCommentFilterEnabled = panel.isCommentFilterEnabled();
        }
        return okPressed;
    }

    protected void clearFilter() {
        this.filterByAuthor = "";
        this.filterByComment = "";
        this.isCommentFilterEnabled = false;
    }

    protected boolean isFilterEnabled() {
        return this.filterByAuthor.length() > 0 || this.isCommentFilterEnabled;
    }

    protected LogMessage[] filterMessages(LogMessage[] msgs) {
        ArrayList<LogMessage> filteredMessages = new ArrayList<LogMessage>();
        int i = 0;
        while (i < msgs.length) {
            String author = msgs[i].author;
            String message = msgs[i].message;
            StringMatcher authorMatcher = new StringMatcher(this.filterByAuthor);
            StringMatcher commentMatcher = new StringMatcher(this.filterByComment);
            if (!(this.filterByAuthor.length() > 0 && !authorMatcher.match(author) || this.isCommentFilterEnabled && !commentMatcher.match(message))) {
                filteredMessages.add(msgs[i]);
            }
            ++i;
        }
        LogMessage[] result = filteredMessages.toArray(new LogMessage[filteredMessages.size()]);
        return result.length > 0 ? result : null;
    }

    protected String[] getSelectedAuthors() {
        ArrayList<String> authors = new ArrayList<String>();
        if (this.logMessages != null) {
            int i = 0;
            while (i < this.logMessages.length) {
                String current = this.logMessages[i].author;
                if (current != null && !authors.contains(current)) {
                    authors.add(current);
                }
                ++i;
            }
        }
        return authors.toArray(new String[authors.size()]);
    }

    protected void refresh() {
        long revision = this.history.getSelectedRevision();
        this.pagingEnabled = true;
        this.logMessages = null;
        this.showNextPage(false);
        this.history.setSelectedRevision(revision);
    }
}

