/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui.panel.local;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.polarion.team.svn.core.IStateFilter;
import org.polarion.team.svn.core.client.PropertyData;
import org.polarion.team.svn.core.operation.AbstractNonLockingOperation;
import org.polarion.team.svn.core.operation.CompositeOperation;
import org.polarion.team.svn.core.operation.IActionOperation;
import org.polarion.team.svn.core.operation.local.RefreshResourcesOperation;
import org.polarion.team.svn.core.operation.local.RestoreProjectMetaOperation;
import org.polarion.team.svn.core.operation.local.SaveProjectMetaOperation;
import org.polarion.team.svn.core.operation.local.property.GetPropertiesOperation;
import org.polarion.team.svn.core.operation.local.refactor.DeleteResourceOperation;
import org.polarion.team.svn.core.resource.ILocalResource;
import org.polarion.team.svn.core.resource.IResourceProvider;
import org.polarion.team.svn.core.resource.events.IResourceStatesListener;
import org.polarion.team.svn.core.resource.events.ResourceStatesChangedEvent;
import org.polarion.team.svn.core.svnstorage.ResourcesParentsProvider;
import org.polarion.team.svn.core.svnstorage.SVNRemoteStorage;
import org.polarion.team.svn.core.utility.FileUtility;
import org.polarion.team.svn.core.utility.ProgressMonitorUtility;
import org.polarion.team.svn.ui.SVNTeamUIPlugin;
import org.polarion.team.svn.ui.action.local.RevertAction;
import org.polarion.team.svn.ui.composite.CommentComposite;
import org.polarion.team.svn.ui.composite.ResourceSelectionComposite;
import org.polarion.team.svn.ui.dialog.DiscardConfirmationDialog;
import org.polarion.team.svn.ui.event.IResourceSelectionChangeListener;
import org.polarion.team.svn.ui.event.ResourceSelectionChangedEvent;
import org.polarion.team.svn.ui.extension.factory.ICommentDialogPanel;
import org.polarion.team.svn.ui.panel.common.CommentPanel;
import org.polarion.team.svn.ui.preferences.SVNTeamPreferences;
import org.polarion.team.svn.ui.properties.bugtraq.BugtraqModel;
import org.polarion.team.svn.ui.utility.UIMonitorUtility;
import org.polarion.team.svn.ui.verifier.AbstractVerifier;

public class CommitPanel
extends CommentPanel
implements ICommentDialogPanel {
    public static final int MSG_COMMIT = 0;
    public static final int MSG_OVER_AND_COMMIT = 1;
    public static final int MAXIMUM_LOG_TEMPLATE_SIZE = 20;
    public static final int MAXIMUM_CHECKS_SIZE = 100;
    protected Composite parent;
    protected ResourceSelectionComposite selectionComposite;
    protected Button keepLocksButton;
    protected Button pasteNamesButton;
    protected SashForm sForm;
    protected IResource[] resources;
    protected boolean keepLocks;
    protected List changeListenerList;
    protected IResource[] userSelectedResources;
    protected final String proposedComment;
    protected IResourceStatesListener resourceStatesListener;
    protected boolean resourcesChanged;
    static /* synthetic */ Class class$0;

    public CommitPanel(IResource[] resources, int msgType) {
        this(resources, msgType, null);
    }

    public CommitPanel(IResource[] resources, int msgType, String proposedComment) {
        this(resources, null, msgType, proposedComment);
    }

    public CommitPanel(IResource[] resources, IResource[] userSelectedResources, int msgType, String proposedComment) {
        super(SVNTeamUIPlugin.instance().getResource("CommitPanel.Title"));
        this.proposedComment = proposedComment;
        this.resources = resources;
        if (msgType == 1) {
            this.defaultMessage = SVNTeamUIPlugin.instance().getResource("CommitPanel.Message");
            this.dialogDescription = SVNTeamUIPlugin.instance().getResource("CommitPanel.Description");
        }
        this.changeListenerList = new ArrayList();
        this.userSelectedResources = userSelectedResources;
    }

    public void createControls(Composite parent) {
        this.parent = parent;
        GridData data = null;
        GridLayout layout = null;
        layout = (GridLayout)parent.getLayout();
        layout.marginHeight = 3;
        this.sForm = new SashForm(parent, 512);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 3;
        this.sForm.setLayout((Layout)layout);
        data = new GridData(1808);
        data.heightHint = 400;
        this.sForm.setLayoutData((Object)data);
        Composite composite = new Composite((Composite)this.sForm, 0);
        composite.setLayoutData((Object)new GridData(1808));
        layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        Group group = new Group(composite, 0);
        layout = new GridLayout();
        group.setLayout((Layout)layout);
        data = new GridData(1808);
        group.setLayoutData((Object)data);
        group.setText(SVNTeamUIPlugin.instance().getResource("CommitPanel.Comment"));
        GetLogTemplatesOperation logTemplatesOp = new GetLogTemplatesOperation(this.resources);
        GetBugTraqPropertiesModelOperation bugtraqOp = new GetBugTraqPropertiesModelOperation(this.resources);
        CommitPanel.runPropertiesOperations(logTemplatesOp, bugtraqOp);
        this.bugtraqModel = bugtraqOp.getBugtraqModel();
        this.comment = new CommentComposite((Composite)group, this.proposedComment, this, logTemplatesOp.getLogTemplates(), this.bugtraqModel);
        data = new GridData(1808);
        this.comment.setLayoutData(data);
        Composite middleComposite = new Composite(composite, 0);
        data = new GridData(768);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 2;
        layout.numColumns = 2;
        middleComposite.setLayoutData((Object)data);
        middleComposite.setLayout((Layout)layout);
        this.keepLocksButton = new Button(middleComposite, 32);
        data = new GridData(769);
        this.keepLocksButton.setLayoutData((Object)data);
        this.keepLocksButton.setText(SVNTeamUIPlugin.instance().getResource("CommitPanel.KeepLocks"));
        this.keepLocksButton.setSelection(false);
        this.keepLocksButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CommitPanel.this.keepLocks = CommitPanel.this.keepLocksButton.getSelection();
            }
        });
        this.pasteNamesButton = new Button(middleComposite, 0x1000008);
        data = new GridData();
        this.pasteNamesButton.setLayoutData((Object)data);
        this.pasteNamesButton.setText(SVNTeamUIPlugin.instance().getResource("CommitPanel.PasteNames.Button"));
        this.pasteNamesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CommitPanel.this.pasteNames();
            }
        });
        Label separator = new Label(composite, 258);
        separator.setLayoutData((Object)new GridData(768));
        this.selectionComposite = new ResourceSelectionComposite((Composite)this.sForm, 0, this.resources, true, this.userSelectedResources);
        data = new GridData(1808);
        data.heightHint = 175;
        this.selectionComposite.setLayoutData(data);
        IPreferenceStore store = SVNTeamUIPlugin.instance().getPreferenceStore();
        int first = SVNTeamPreferences.getCommitDialogInt(store, "weight");
        this.sForm.setWeights(new int[]{first, 100 - first});
        this.selectionComposite.addResourcesSelectionChangedListener(new IResourceSelectionChangeListener(){

            public void resourcesSelectionChanged(ResourceSelectionChangedEvent event) {
                CommitPanel.this.fireResourcesSelectionChanged(event);
            }
        });
        this.attachTo((Control)this.selectionComposite, new AbstractVerifier(){

            protected String getErrorMessage(Control input) {
                IResource[] selection = CommitPanel.this.getSelectedResources();
                if (selection == null || selection.length == 0) {
                    return SVNTeamUIPlugin.instance().getResource("ResourceSelectionComposite.Verifier.Error");
                }
                return null;
            }

            protected String getWarningMessage(Control input) {
                return null;
            }
        });
        this.addContextMenu();
    }

    public String getHelpId() {
        return "org.polarion.team.svn.help.commitDialogContext";
    }

    public void postInit() {
        super.postInit();
        this.resourceStatesListener = new IResourceStatesListener(){

            public void resourcesStateChanged(ResourceStatesChangedEvent event) {
                CommitPanel.this.updateResources();
            }
        };
        SVNRemoteStorage sVNRemoteStorage = SVNRemoteStorage.instance();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.polarion.team.svn.core.resource.events.ResourceStatesChangedEvent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        sVNRemoteStorage.addResourceStatesListener((Class)clazz, this.resourceStatesListener);
    }

    protected void saveChanges() {
        super.saveChanges();
        this.retainSizeAndWeights();
    }

    protected void cancelChanges() {
        super.cancelChanges();
        this.retainSizeAndWeights();
    }

    public boolean canClose() {
        final boolean[] commit = new boolean[]{true};
        if (this.bugtraqModel != null && this.bugtraqModel.getMessage() != null && this.bugtraqModel.isWarnIfNoIssue() && this.comment.getBugID() != null && this.comment.getBugID().trim().length() == 0) {
            UIMonitorUtility.getDisplay().syncExec(new Runnable(){

                public void run() {
                    MessageDialog dlg = new MessageDialog(UIMonitorUtility.getShell(), SVNTeamUIPlugin.instance().getResource("CommitPanel.NoBugId.Title"), null, SVNTeamUIPlugin.instance().getResource("CommitPanel.NoBugId.Message"), 4, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
                    commit[0] = dlg.open() == 0;
                }
            });
        }
        return commit[0];
    }

    protected void pasteNames() {
        List selectedResources = this.selectionComposite.getCurrentSelection();
        String namesString = "";
        Iterator iter = selectedResources.iterator();
        while (iter.hasNext()) {
            IResource resource = (IResource)iter.next();
            namesString = String.valueOf(namesString) + resource.getName() + "\n";
        }
        this.comment.insertText(namesString);
    }

    protected void addContextMenu() {
        final TableViewer tableViewer = this.selectionComposite.getTableViewer();
        MenuManager menuMgr = new MenuManager();
        Menu menu = menuMgr.createContextMenu((Control)tableViewer.getTable());
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.add((IContributionItem)new Separator("additions"));
                IStructuredSelection tSelection = (IStructuredSelection)tableViewer.getSelection();
                IResource[] selectedResources = tSelection.toList().toArray(new IResource[tSelection.size()]);
                Action tAction = null;
                tAction = new Action(this, SVNTeamUIPlugin.instance().getResource("CommitPanel.PasteNames.Action")){
                    final /* synthetic */ 7 this$1;
                    {
                        this.this$1 = var1_1;
                        super($anonymous0);
                    }

                    public void run() {
                        7.access$0(this.this$1).pasteNames();
                    }
                };
                manager.add((IAction)tAction);
                tAction.setEnabled(tSelection.size() > 0);
                manager.add((IContributionItem)new Separator());
                tAction = new Action(this, SVNTeamUIPlugin.instance().getResource("CommitPanel.Revert.Action"), selectedResources){
                    final /* synthetic */ 7 this$1;
                    private final /* synthetic */ IResource[] val$selectedResources;
                    {
                        this.this$1 = var1_1;
                        this.val$selectedResources = iResourceArray;
                        super($anonymous0);
                    }

                    public void run() {
                        IResource[] changedResources = FileUtility.getResourcesRecursive((IResource[])this.val$selectedResources, (IStateFilter)RevertAction.SF_REVERTABLE_OR_NEW);
                        Shell shell = UIMonitorUtility.getShell();
                        CompositeOperation revertOp = RevertAction.getRevertOperation(shell, changedResources, this.val$selectedResources);
                        if (revertOp != null) {
                            UIMonitorUtility.doTaskNowDefault((IActionOperation)revertOp, true);
                        }
                    }
                };
                manager.add((IAction)tAction);
                tAction.setImageDescriptor(SVNTeamUIPlugin.instance().getImageDescriptor("icons/common/actions/revert.gif"));
                tAction.setEnabled(tSelection.size() > 0);
                tAction = new Action(this, SVNTeamUIPlugin.instance().getResource("CommitPanel.Delete.Action"), selectedResources){
                    final /* synthetic */ 7 this$1;
                    private final /* synthetic */ IResource[] val$selectedResources;
                    {
                        this.this$1 = var1_1;
                        this.val$selectedResources = iResourceArray;
                        super($anonymous0);
                    }

                    public void run() {
                        DiscardConfirmationDialog dialog = new DiscardConfirmationDialog(UIMonitorUtility.getShell(), this.val$selectedResources.length == 1, 2);
                        if (dialog.open() == 0) {
                            DeleteResourceOperation deleteOperation = new DeleteResourceOperation(this.val$selectedResources);
                            CompositeOperation op = new CompositeOperation(deleteOperation.getId());
                            SaveProjectMetaOperation saveOp = new SaveProjectMetaOperation(this.val$selectedResources);
                            RestoreProjectMetaOperation restoreOp = new RestoreProjectMetaOperation(saveOp);
                            op.add((IActionOperation)saveOp);
                            op.add((IActionOperation)deleteOperation);
                            op.add((IActionOperation)restoreOp);
                            op.add((IActionOperation)new RefreshResourcesOperation((IResourceProvider)new ResourcesParentsProvider(this.val$selectedResources), 2, RefreshResourcesOperation.REFRESH_ALL));
                            UIMonitorUtility.doTaskNowDefault((IActionOperation)op, true);
                        }
                    }
                };
                manager.add((IAction)tAction);
                tAction.setImageDescriptor(SVNTeamUIPlugin.instance().getImageDescriptor("icons/common/delete.gif"));
                tAction.setEnabled(tSelection.size() > 0);
            }

            static /* synthetic */ CommitPanel access$0(7 var0) {
                return var0.CommitPanel.this;
            }
        });
        menuMgr.setRemoveAllWhenShown(true);
        tableViewer.getTable().setMenu(menu);
    }

    protected void updateResources() {
        final TableViewer tableViewer = this.selectionComposite.getTableViewer();
        HashSet<IResource> toDeleteSet = new HashSet<IResource>();
        toDeleteSet.addAll(Arrays.asList(this.resources));
        HashSet<IResource> newResourcesSet = new HashSet<IResource>();
        newResourcesSet.addAll(Arrays.asList(FileUtility.getResourcesRecursive((IResource[])this.resources, (IStateFilter)IStateFilter.SF_COMMITABLE, (int)0)));
        newResourcesSet.addAll(Arrays.asList(FileUtility.getResourcesRecursive((IResource[])this.resources, (IStateFilter)IStateFilter.SF_ADDED, (int)0)));
        final IResource[] newResources = newResourcesSet.toArray(new IResource[newResourcesSet.size()]);
        toDeleteSet.removeAll(newResourcesSet);
        final IResource[] toDeleteResources = toDeleteSet.toArray(new IResource[toDeleteSet.size()]);
        UIMonitorUtility.getDisplay().syncExec(new Runnable(){

            public void run() {
                CommitPanel.this.selectionComposite.setResources(newResources);
                if (!tableViewer.getTable().isDisposed()) {
                    tableViewer.remove((Object[])toDeleteResources);
                    tableViewer.refresh();
                    CommitPanel.this.selectionComposite.fireSelectionChanged();
                }
            }
        });
        this.resources = newResources;
        this.resourcesChanged = true;
    }

    public boolean getResourcesChanged() {
        return this.resourcesChanged;
    }

    public IResource[] getSelectedResources() {
        return this.selectionComposite.getSelectedResources();
    }

    public IResource[] getNotSelectedResources() {
        return this.selectionComposite.getNotSelectedResources();
    }

    public void addResourcesSelectionChangedListener(IResourceSelectionChangeListener listener) {
        this.changeListenerList.add(listener);
    }

    public void removeResourcesSelectionChangedListener(IResourceSelectionChangeListener listener) {
        this.changeListenerList.remove(listener);
    }

    public void fireResourcesSelectionChanged(ResourceSelectionChangedEvent event) {
        this.validateContent();
        IResourceSelectionChangeListener[] listeners = this.changeListenerList.toArray(new IResourceSelectionChangeListener[this.changeListenerList.size()]);
        int i = 0;
        while (i < listeners.length) {
            listeners[i].resourcesSelectionChanged(event);
            ++i;
        }
    }

    public boolean getKeepLocks() {
        return this.keepLocks;
    }

    public Point getPrefferedSize() {
        IPreferenceStore store = SVNTeamUIPlugin.instance().getPreferenceStore();
        return new Point(SVNTeamPreferences.getCommitDialogInt(store, "width"), SVNTeamPreferences.getCommitDialogInt(store, "height"));
    }

    protected void retainSizeAndWeights() {
        int[] weights = this.sForm.getWeights();
        IPreferenceStore store = SVNTeamUIPlugin.instance().getPreferenceStore();
        Point size = this.parent.getSize();
        SVNTeamPreferences.setCommitDialogInt(store, "width", size.x);
        SVNTeamPreferences.setCommitDialogInt(store, "height", size.y);
        SVNTeamPreferences.setCommitDialogInt(store, "weight", weights[0] / 10);
    }

    public static void runPropertiesOperations(GetLogTemplatesOperation logOperation, GetBugTraqPropertiesModelOperation bugtraqOp) {
        CompositeOperation composite = new CompositeOperation("Operation.ScanForProperties");
        if (SVNTeamPreferences.getCommentTemplatesBoolean(SVNTeamUIPlugin.instance().getPreferenceStore(), "comment.logTemplates.enabled")) {
            composite.add((IActionOperation)logOperation);
        }
        composite.add((IActionOperation)bugtraqOp);
        UIMonitorUtility.doTaskNowDefault((IActionOperation)composite, true);
    }

    protected static String getLogTemplateProperty(IResource resource, Map parentTemplates) {
        PropertyData[] logTemplateProperties;
        if (parentTemplates.containsKey(resource)) {
            return (String)parentTemplates.get(resource);
        }
        String value = null;
        GetPropertiesOperation op = new GetPropertiesOperation(resource);
        ProgressMonitorUtility.doTaskExternalDefault((IActionOperation)op, (IProgressMonitor)new NullProgressMonitor());
        if (op.getExecutionState() == 0 && (logTemplateProperties = op.getProperties()) != null && logTemplateProperties.length > 0) {
            int i = 0;
            while (i < logTemplateProperties.length) {
                if (logTemplateProperties[i].name.equals("tsvn:logtemplate")) {
                    value = logTemplateProperties[i].value;
                    break;
                }
                ++i;
            }
        }
        parentTemplates.put(resource, value);
        if (value != null) {
            return value;
        }
        IContainer parent = resource.getParent();
        if (parent != null && !(parent instanceof IWorkspaceRoot)) {
            return CommitPanel.getLogTemplateProperty((IResource)parent, parentTemplates);
        }
        return null;
    }

    public void dispose() {
        super.dispose();
        SVNRemoteStorage sVNRemoteStorage = SVNRemoteStorage.instance();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.polarion.team.svn.core.resource.events.ResourceStatesChangedEvent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        sVNRemoteStorage.removeResourceStatesListener((Class)clazz, this.resourceStatesListener);
    }

    public static class GetLogTemplatesOperation
    extends AbstractNonLockingOperation {
        protected HashSet logTemplates = new HashSet();
        protected IResource[] resources;

        public GetLogTemplatesOperation(IResource[] resources) {
            super("Operation.CollectLogTemplates");
            this.resources = resources;
        }

        protected void runImpl(IProgressMonitor monitor) throws Exception {
            HashMap parentTemplates = new HashMap();
            int length = this.resources.length < 100 ? this.resources.length : 100;
            int i = 0;
            while (i < length && !monitor.isCanceled()) {
                String logTemplate;
                ProgressMonitorUtility.setTaskInfo((IProgressMonitor)monitor, (IActionOperation)this, (String)this.resources[i].getFullPath().toString());
                ILocalResource local = SVNRemoteStorage.instance().asLocalResource(this.resources[i]);
                if (local != null && !IStateFilter.SF_NONVERSIONED.accept(this.resources[i], local.getStatus(), local.getChangeMask()) && (logTemplate = CommitPanel.getLogTemplateProperty(this.resources[i], parentTemplates)) != null) {
                    this.logTemplates.add(logTemplate);
                    if (this.logTemplates.size() == 20) break;
                }
                ProgressMonitorUtility.progress((IProgressMonitor)monitor, (int)i, (int)length);
                ++i;
            }
        }

        public HashSet getLogTemplates() {
            return this.logTemplates;
        }
    }

    public static class GetBugTraqPropertiesModelOperation
    extends AbstractNonLockingOperation {
        protected IResource[] resources;
        protected BugtraqModel model;

        public GetBugTraqPropertiesModelOperation(IResource[] resources) {
            super("Operation.CollectBugTraq");
            this.resources = resources;
            this.model = new BugtraqModel();
        }

        public BugtraqModel getBugtraqModel() {
            return this.model;
        }

        protected void runImpl(IProgressMonitor monitor) throws Exception {
            HashSet<String> bugtraqProperties = new HashSet<String>(Arrays.asList("bugtraq:url", "bugtraq:logregex", "bugtraq:label", "bugtraq:message", "bugtraq:number", "bugtraq:warnifnoissue", "bugtraq:append"));
            IResource versionedResource = null;
            int i = 0;
            while (i < this.resources.length && !monitor.isCanceled()) {
                ILocalResource local = SVNRemoteStorage.instance().asLocalResource(this.resources[i]);
                if (local != null && !IStateFilter.SF_NONVERSIONED.accept(this.resources[i], local.getStatus(), local.getChangeMask())) {
                    versionedResource = this.resources[i];
                }
                ++i;
            }
            if (versionedResource != null) {
                this.getBugtraqProperties(bugtraqProperties, versionedResource);
            }
        }

        protected Set getBugtraqProperties(Set bugtraqProperties, IResource resource) {
            IContainer parent;
            PropertyData[] resourceProperties;
            GetPropertiesOperation op = new GetPropertiesOperation(resource);
            ProgressMonitorUtility.doTaskExternalDefault((IActionOperation)op, (IProgressMonitor)new NullProgressMonitor());
            if (op.getExecutionState() == 0 && (resourceProperties = op.getProperties()) != null && resourceProperties.length > 0) {
                int i = 0;
                while (i < resourceProperties.length) {
                    if (bugtraqProperties.contains(resourceProperties[i].name)) {
                        this.processBugtraqProperty(resourceProperties[i].name, resourceProperties[i].value);
                        bugtraqProperties.remove(resourceProperties[i].name);
                    }
                    ++i;
                }
            }
            if ((parent = resource.getParent()) != null && !(parent instanceof IWorkspaceRoot) && !bugtraqProperties.isEmpty()) {
                return this.getBugtraqProperties(bugtraqProperties, (IResource)parent);
            }
            return bugtraqProperties;
        }

        protected void processBugtraqProperty(String name, String value) {
            if (name.equals("bugtraq:url")) {
                this.model.setUrl(value);
            } else if (name.equals("bugtraq:logregex")) {
                this.model.setLogregex(value);
            } else if (name.equals("bugtraq:label")) {
                this.model.setLabel(value);
            } else if (name.equals("bugtraq:message")) {
                this.model.setMessage(value);
            } else if (name.equals("bugtraq:number")) {
                boolean number = value == null || !value.trim().equals("false") && !value.trim().equals("no");
                this.model.setNumber(number);
            } else if (name.equals("bugtraq:warnifnoissue")) {
                boolean warn = value != null && (value.trim().equals("yes") || value.trim().equals("true"));
                this.model.setWarnIfNoIssue(warn);
            } else if (name.equals("bugtraq:append")) {
                boolean append = value == null || !value.trim().equals("false") && !value.trim().equals("no");
                this.model.setAppend(append);
            }
        }
    }
}

