/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui.panel.local;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.team.internal.core.subscribers.ActiveChangeSet;
import org.polarion.team.svn.ui.SVNTeamUIPlugin;
import org.polarion.team.svn.ui.composite.CommentComposite;
import org.polarion.team.svn.ui.composite.ResourceSelectionComposite;
import org.polarion.team.svn.ui.event.IResourceSelectionChangeListener;
import org.polarion.team.svn.ui.event.ResourceSelectionChangedEvent;
import org.polarion.team.svn.ui.extension.factory.ICommentDialogPanel;
import org.polarion.team.svn.ui.panel.common.CommentPanel;
import org.polarion.team.svn.ui.panel.local.CommitPanel;
import org.polarion.team.svn.ui.verifier.NonEmptyFieldVerifier;

public class CommitSetPanel
extends CommentPanel
implements ICommentDialogPanel {
    public static final int MSG_CREATE = 0;
    public static final int MSG_EDIT = 1;
    private final ActiveChangeSet set;
    protected ResourceSelectionComposite selectionComposite;
    private Text nameText;
    protected IResource[] resources;
    protected List changeListenerList;

    public CommitSetPanel(ActiveChangeSet set, IResource[] resources, int type) {
        super(SVNTeamUIPlugin.instance().getResource("CommitSetPanel.Title"));
        this.set = set;
        this.resources = resources;
        switch (type) {
            case 1: {
                this.dialogDescription = SVNTeamUIPlugin.instance().getResource("CommitSetPanel.Description.Edit");
                this.defaultMessage = SVNTeamUIPlugin.instance().getResource("CommitSetPanel.Message.Edit");
                break;
            }
            default: {
                this.dialogDescription = SVNTeamUIPlugin.instance().getResource("CommitSetPanel.Description.New");
                this.defaultMessage = SVNTeamUIPlugin.instance().getResource("CommitSetPanel.Message.New");
            }
        }
        if (resources == null) {
            resources = set.getResources();
        }
        this.changeListenerList = new ArrayList();
    }

    public void createControls(Composite parent) {
        GridData data = null;
        GridLayout layout = null;
        Composite composite = new Composite(parent, 0);
        GridLayout nameLayout = new GridLayout();
        nameLayout.marginHeight = 0;
        nameLayout.marginWidth = 0;
        nameLayout.numColumns = 2;
        composite.setLayout((Layout)nameLayout);
        composite.setLayoutData((Object)new GridData(768));
        composite.setFont(parent.getFont());
        Label label = new Label(composite, 0);
        label.setText(SVNTeamUIPlugin.instance().getResource("CommitSetPanel.Name"));
        label.setLayoutData((Object)new GridData(1));
        this.nameText = new Text(composite, 2048);
        this.nameText.setLayoutData((Object)new GridData(768));
        String initialText = this.set.getTitle();
        if (initialText == null) {
            initialText = "";
        }
        this.nameText.setText(initialText);
        this.attachTo((Control)this.nameText, new NonEmptyFieldVerifier(SVNTeamUIPlugin.instance().getResource("CommitSetPanel.Name.Verifier")));
        Group group = new Group(parent, 0);
        layout = new GridLayout();
        group.setLayout((Layout)layout);
        data = new GridData(1808);
        group.setLayoutData((Object)data);
        group.setText(SVNTeamUIPlugin.instance().getResource("CommitSetPanel.Comment"));
        CommitPanel.GetLogTemplatesOperation logTemplatesOp = new CommitPanel.GetLogTemplatesOperation(this.resources);
        CommitPanel.GetBugTraqPropertiesModelOperation bugtraqOp = new CommitPanel.GetBugTraqPropertiesModelOperation(new IResource[0]);
        CommitPanel.runPropertiesOperations(logTemplatesOp, bugtraqOp);
        this.bugtraqModel = bugtraqOp.getBugtraqModel();
        this.comment = new CommentComposite((Composite)group, this.set.getComment(), this, logTemplatesOp.getLogTemplates(), null);
        data = new GridData(1808);
        this.comment.setLayoutData(data);
    }

    public String getHelpId() {
        return "org.polarion.team.svn.help.commitSetDialogContext";
    }

    public IResource[] getSelectedResources() {
        return this.selectionComposite.getSelectedResources();
    }

    public void addResourcesSelectionChangedListener(IResourceSelectionChangeListener listener) {
        this.changeListenerList.add(listener);
    }

    public void removeResourcesSelectionChangedListener(IResourceSelectionChangeListener listener) {
        this.changeListenerList.remove(listener);
    }

    public void fireResourcesSelectionChanged(ResourceSelectionChangedEvent event) {
        this.validateContent();
        IResourceSelectionChangeListener[] listeners = this.changeListenerList.toArray(new IResourceSelectionChangeListener[this.changeListenerList.size()]);
        int i = 0;
        while (i < listeners.length) {
            listeners[i].resourcesSelectionChanged(event);
            ++i;
        }
    }

    public Point getPrefferedSize() {
        return new Point(525, -1);
    }

    protected void saveChanges() {
        super.saveChanges();
        this.set.setTitle(this.nameText.getText());
        this.set.setComment(this.comment.getMessage());
    }
}

