/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui.panel.local;

import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.polarion.team.svn.core.client.ISVNProgressMonitor;
import org.polarion.team.svn.core.client.NotifyAction;
import org.polarion.team.svn.core.client.Revision;
import org.polarion.team.svn.core.operation.IActionOperation;
import org.polarion.team.svn.core.operation.local.JavaHLMergeOperation;
import org.polarion.team.svn.core.resource.IRepositoryResource;
import org.polarion.team.svn.core.utility.SVNUtility;
import org.polarion.team.svn.ui.SVNTeamUIPlugin;
import org.polarion.team.svn.ui.composite.RepositoryResourceSelectionComposite;
import org.polarion.team.svn.ui.dialog.DefaultDialog;
import org.polarion.team.svn.ui.panel.AbstractAdvancedDialogPanel;
import org.polarion.team.svn.ui.panel.IDialogManagerEx;
import org.polarion.team.svn.ui.panel.reporting.PreviewPanel;
import org.polarion.team.svn.ui.preferences.SVNTeamPreferences;
import org.polarion.team.svn.ui.utility.UIMonitorUtility;
import org.polarion.team.svn.ui.verifier.AbstractVerifier;
import org.polarion.team.svn.ui.verifier.AbstractVerifierProxy;
import org.polarion.team.svn.ui.verifier.IValidationManager;

public class JavaHLMergePanel
extends AbstractAdvancedDialogPanel {
    protected static final String FIRST_URL_HISTORY = "Merge.FirstUrl";
    protected static final String SECOND_URL_HISTORY = "Merge.SecondUrl";
    protected IResource[] to;
    protected IRepositoryResource baseResource;
    protected long currentRevision;
    protected IRepositoryResource firstSelectedResource;
    protected IRepositoryResource secondSelectedResource;
    protected boolean advancedMode;
    protected boolean ignoreAncestry;
    protected RepositoryResourceSelectionComposite simpleSelectionComposite;
    protected RepositoryResourceSelectionComposite firstSelectionComposite;
    protected RepositoryResourceSelectionComposite secondSelectionComposite;
    protected Composite simpleView;
    protected Composite advancedView;
    protected Button ignoreAncestryButton;

    public JavaHLMergePanel(IResource[] to, IRepositoryResource baseResource, long currentRevision) {
        super(new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, new String[]{SVNTeamUIPlugin.instance().getResource("Button.Advanced"), SVNTeamUIPlugin.instance().getResource("JavaHLMergePanel.Preview")});
        this.dialogTitle = SVNTeamUIPlugin.instance().getResource("JavaHLMergePanel.Title");
        this.dialogDescription = SVNTeamUIPlugin.instance().getResource("JavaHLMergePanel.Description");
        this.defaultMessage = SVNTeamUIPlugin.instance().getResource("JavaHLMergePanel.Message");
        this.to = to;
        this.firstSelectedResource = this.secondSelectedResource = baseResource;
        this.baseResource = this.secondSelectedResource;
        this.currentRevision = currentRevision;
    }

    public Point getPrefferedSize() {
        return new Point(550, 245);
    }

    public Revision getStartRevision() {
        return this.simpleSelectionComposite.getStartRevision();
    }

    public IRepositoryResource getSelectedResource() {
        IRepositoryResource retVal = SVNUtility.copyOf((IRepositoryResource)this.simpleSelectionComposite.getSelectedResource());
        retVal.setSelectedRevision(this.simpleSelectionComposite.getSecondSelectedRevision());
        return retVal;
    }

    public IRepositoryResource[] getSelection() {
        return this.getSelection(this.getSelectedResource());
    }

    public IRepositoryResource getFirstSelectedResource() {
        if (this.isAdvancedMode()) {
            return this.firstSelectionComposite.getSelectedResource();
        }
        IRepositoryResource retVal = SVNUtility.copyOf((IRepositoryResource)this.getSelectedResource());
        retVal.setSelectedRevision(this.getStartRevision());
        return retVal;
    }

    public IRepositoryResource getSecondSelectedResource() {
        return this.isAdvancedMode() ? this.secondSelectionComposite.getSelectedResource() : this.getSelectedResource();
    }

    public IRepositoryResource[] getFirstSelection() {
        return this.getSelection(this.getFirstSelectedResource());
    }

    public IRepositoryResource[] getSecondSelection() {
        return this.getSelection(this.getSecondSelectedResource());
    }

    public boolean getIgnoreAncestry() {
        return this.advancedMode ? this.ignoreAncestry : false;
    }

    public boolean isAdvancedMode() {
        return this.advancedMode;
    }

    public void createControls(Composite parent) {
        ((GridLayout)parent.getLayout()).verticalSpacing = 0;
        this.simpleView = this.createSimpleModeView(parent);
        this.advancedView = this.createAdvancedModeView(parent);
        this.setMode(false);
    }

    public void postInit() {
        super.postInit();
        this.simpleSelectionComposite.setUrl("");
        this.firstSelectionComposite.setUrl("");
        this.secondSelectionComposite.setUrl("");
        this.manager.setMessage(0, this.defaultMessage);
    }

    protected Composite createSimpleModeView(Composite parent) {
        GridData data = null;
        this.simpleSelectionComposite = new RepositoryResourceSelectionComposite(parent, 0, new ValidationManagerProxy(){

            protected AbstractVerifier wrapVerifier(AbstractVerifier verifier) {
                return new AbstractVerifierProxy(this, verifier){
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                        super($anonymous0);
                    }

                    protected boolean isVerificationEnabled(Control input) {
                        return !1.access$0(this.this$1).advancedMode;
                    }
                };
            }

            static /* synthetic */ JavaHLMergePanel access$0(1 var0) {
                return var0.JavaHLMergePanel.this;
            }
        }, FIRST_URL_HISTORY, this.firstSelectedResource, true, SVNTeamUIPlugin.instance().getResource("JavaHLMergePanel.Selection.Title"), SVNTeamUIPlugin.instance().getResource("JavaHLMergePanel.Selection.Description"), 1);
        data = new GridData(768);
        this.simpleSelectionComposite.setLayoutData(data);
        this.simpleSelectionComposite.setCurrentRevision(this.currentRevision);
        return this.simpleSelectionComposite;
    }

    protected Composite createAdvancedModeView(Composite parent) {
        GridData data = null;
        GridLayout layout = null;
        parent = new Composite(parent, 0);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        parent.setLayout((Layout)layout);
        data = new GridData(768);
        parent.setLayoutData((Object)data);
        ValidationManagerProxy proxy = new ValidationManagerProxy(){

            protected AbstractVerifier wrapVerifier(AbstractVerifier verifier) {
                return new AbstractVerifierProxy(this, verifier){
                    final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = var1_1;
                        super($anonymous0);
                    }

                    protected boolean isVerificationEnabled(Control input) {
                        return 3.access$0(this.this$1).advancedMode;
                    }
                };
            }

            static /* synthetic */ JavaHLMergePanel access$0(3 var0) {
                return var0.JavaHLMergePanel.this;
            }
        };
        this.firstSelectionComposite = new RepositoryResourceSelectionComposite(parent, 0, proxy, FIRST_URL_HISTORY, "JavaHLMergePanel.SourceURL1", this.firstSelectedResource, true, SVNTeamUIPlugin.instance().getResource("JavaHLMergePanel.Selection.Title"), SVNTeamUIPlugin.instance().getResource("JavaHLMergePanel.Selection.Description"), 0);
        data = new GridData(768);
        this.firstSelectionComposite.setLayoutData(data);
        this.firstSelectionComposite.setCurrentRevision(this.currentRevision);
        Label strut = new Label(parent, 0);
        data = new GridData();
        data.heightHint = 12;
        strut.setLayoutData((Object)data);
        this.secondSelectionComposite = new RepositoryResourceSelectionComposite(parent, 0, proxy, SECOND_URL_HISTORY, "JavaHLMergePanel.SourceURL2", this.secondSelectedResource, true, SVNTeamUIPlugin.instance().getResource("JavaHLMergePanel.Selection.Title"), SVNTeamUIPlugin.instance().getResource("JavaHLMergePanel.Selection.Description"), 0);
        data = new GridData(768);
        this.secondSelectionComposite.setLayoutData(data);
        this.secondSelectionComposite.setCurrentRevision(this.currentRevision);
        strut = new Label(parent, 0);
        data = new GridData();
        data.heightHint = 7;
        strut.setLayoutData((Object)data);
        data = new GridData();
        this.ignoreAncestryButton = new Button(parent, 32);
        this.ignoreAncestryButton.setLayoutData((Object)data);
        this.ignoreAncestryButton.setText(SVNTeamUIPlugin.instance().getResource("JavaHLMergePanel.Button.IgnoreAncestry"));
        this.ignoreAncestryButton.setSelection(this.ignoreAncestry);
        return parent;
    }

    public void extendedButtonPressed(int idx) {
        super.extendedButtonPressed(idx);
        if (idx == 1) {
            this.saveChanges();
            JavaHLMergeOperation mergeOp = new JavaHLMergeOperation(this.to, this.getFirstSelection(), this.getSecondSelection(), true, this.getIgnoreAncestry());
            final StringBuffer buf = new StringBuffer();
            buf.append(SVNTeamUIPlugin.instance().getResource("JavaHLMergePanel.Preview.Header.Text"));
            buf.append(SVNTeamUIPlugin.instance().getResource("JavaHLMergePanel.Preview.Header.Line"));
            mergeOp.setExternalMonitor(new ISVNProgressMonitor(){

                public boolean isActivityCancelled() {
                    return false;
                }

                public void progress(int current, int total, ISVNProgressMonitor.ItemState state) {
                    buf.append("<b>");
                    switch (state.action) {
                        case 9: {
                            buf.append(SVNTeamUIPlugin.instance().getResource("JavaHLMergePanel.Preview.Added"));
                            break;
                        }
                        case 8: {
                            buf.append(SVNTeamUIPlugin.instance().getResource("JavaHLMergePanel.Preview.Deleted"));
                            break;
                        }
                        case 10: {
                            buf.append(SVNTeamUIPlugin.instance().getResource("JavaHLMergePanel.Preview.Modified"));
                            break;
                        }
                        default: {
                            buf.append(NotifyAction.actionNames[state.action]);
                            buf.append(SVNTeamUIPlugin.instance().getResource("JavaHLMergePanel.Preview.Default"));
                        }
                    }
                    buf.append(state.path);
                    buf.append("\n");
                }
            });
            UIMonitorUtility.doTaskNowDefault((IActionOperation)mergeOp, true);
            if (mergeOp.getExecutionState() == 0) {
                Font font = new Font((Device)UIMonitorUtility.getDisplay(), "Courier New", 8, 0);
                new DefaultDialog(this.manager.getShell(), new PreviewPanel(SVNTeamUIPlugin.instance().getResource("JavaHLMergePanel.Preview.Title"), SVNTeamUIPlugin.instance().getResource("JavaHLMergePanel.Preview.Description"), SVNTeamUIPlugin.instance().getResource("JavaHLMergePanel.Preview.Message"), buf.toString(), font)).open();
            }
        }
    }

    protected void showDetails() {
        this.setMode(!this.advancedMode);
    }

    protected void setMode(boolean advanced) {
        this.saveChanges();
        this.advancedMode = advanced;
        if (this.advancedMode) {
            ((GridData)this.simpleView.getLayoutData()).heightHint = 0;
            ((GridData)this.advancedView.getLayoutData()).heightHint = -1;
            this.simpleView.setVisible(false);
            this.advancedView.setVisible(true);
            this.ignoreAncestryButton.setSelection(this.ignoreAncestry);
            this.firstSelectionComposite.setUrl(this.simpleSelectionComposite.getUrl());
        } else {
            ((GridData)this.advancedView.getLayoutData()).heightHint = 0;
            ((GridData)this.simpleView.getLayoutData()).heightHint = -1;
            this.simpleView.setVisible(true);
            this.advancedView.setVisible(false);
            this.simpleSelectionComposite.setUrl(this.firstSelectionComposite.getUrl());
        }
        this.simpleView.getParent().layout();
        if (this.manager != null) {
            ((IDialogManagerEx)this.manager).setExtendedButtonCaption(0, this.advancedMode ? SVNTeamUIPlugin.instance().getResource("Button.Simple") : SVNTeamUIPlugin.instance().getResource("Button.Advanced"));
            this.validateContent();
        }
    }

    protected void saveChanges() {
        if (!this.advancedMode) {
            this.firstSelectedResource = this.simpleSelectionComposite.getSelectedResource();
            this.secondSelectedResource = SVNUtility.copyOf((IRepositoryResource)this.firstSelectedResource);
            this.secondSelectedResource.setSelectedRevision(this.simpleSelectionComposite.getSecondSelectedRevision());
            this.simpleSelectionComposite.saveHistory();
        } else {
            this.firstSelectedResource = this.firstSelectionComposite.getSelectedResource();
            this.firstSelectionComposite.saveHistory();
            this.secondSelectedResource = this.secondSelectionComposite.getSelectedResource();
            this.secondSelectionComposite.saveHistory();
        }
        this.ignoreAncestry = this.ignoreAncestryButton.getSelection();
    }

    protected void cancelChanges() {
    }

    protected void setButtonsEnabled(boolean enabled) {
        if (!SVNTeamPreferences.getMergeBoolean(SVNTeamUIPlugin.instance().getPreferenceStore(), "useJavaHL")) {
            enabled &= this.advancedMode;
        }
        ((IDialogManagerEx)this.manager).setExtendedButtonEnabled(1, enabled);
    }

    protected IRepositoryResource[] getSelection(IRepositoryResource base) {
        if (this.to.length == 1) {
            return new IRepositoryResource[]{base};
        }
        IRepositoryResource[] retVal = new IRepositoryResource[this.to.length];
        String baseUrl = base.getUrl();
        int i = 0;
        while (i < retVal.length) {
            String url = String.valueOf(baseUrl) + "/" + this.to[i].getName();
            retVal[i] = this.to[i].getType() == 1 ? base.asRepositoryFile(url, false) : base.asRepositoryContainer(url, false);
            ++i;
        }
        return retVal;
    }

    public String getHelpId() {
        return "org.eclipse.team.svn.help.mergeDialogContext";
    }

    protected abstract class ValidationManagerProxy
    implements IValidationManager {
        protected ValidationManagerProxy() {
        }

        public void attachTo(Control cmp, AbstractVerifier verifier) {
            JavaHLMergePanel.this.attachTo(cmp, this.wrapVerifier(verifier));
        }

        public void detachFrom(Control cmp) {
            JavaHLMergePanel.this.detachFrom(cmp);
        }

        public void detachAll() {
            JavaHLMergePanel.this.detachAll();
        }

        public boolean isFilledRight() {
            return JavaHLMergePanel.this.isFilledRight();
        }

        public void validateContent() {
            JavaHLMergePanel.this.validateContent();
        }

        protected abstract AbstractVerifier wrapVerifier(AbstractVerifier var1);
    }
}

