/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui.panel.remote;

import java.text.MessageFormat;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.polarion.team.svn.ui.SVNTeamUIPlugin;
import org.polarion.team.svn.ui.composite.CommentComposite;
import org.polarion.team.svn.ui.dialog.DefaultDialog;
import org.polarion.team.svn.ui.panel.AbstractDialogPanel;
import org.polarion.team.svn.ui.verifier.ExistingResourceVerifier;

public class ImportPanel
extends AbstractDialogPanel {
    protected Text locationField;
    protected String location;
    protected Button recursiveButton;
    protected boolean isRecursive;
    protected CommentComposite comment;

    public ImportPanel(String importToUrl) {
        this.dialogTitle = SVNTeamUIPlugin.instance().getResource("ImportPanel.Title");
        this.dialogDescription = SVNTeamUIPlugin.instance().getResource("ImportPanel.Description");
        this.defaultMessage = SVNTeamUIPlugin.instance().getResource("ImportPanel.Message");
        this.defaultMessage = MessageFormat.format(this.defaultMessage, importToUrl);
        this.isRecursive = true;
    }

    public void createControls(Composite parent) {
        GridLayout layout = null;
        GridData data = null;
        Group group = new Group(parent, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        data = new GridData(768);
        group.setLayoutData((Object)data);
        group.setText(SVNTeamUIPlugin.instance().getResource("ImportPanel.Folder"));
        this.locationField = new Text((Composite)group, 2052);
        data = new GridData(768);
        this.locationField.setLayoutData((Object)data);
        this.attachTo((Control)this.locationField, new ExistingResourceVerifier(SVNTeamUIPlugin.instance().getResource("ImportPanel.Folder.Verifier"), false));
        Button browseButton = new Button((Composite)group, 8);
        browseButton.setText(SVNTeamUIPlugin.instance().getResource("Button.Browse"));
        data = new GridData();
        data.widthHint = DefaultDialog.computeButtonWidth(browseButton);
        browseButton.setLayoutData((Object)data);
        browseButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                DirectoryDialog fileDialog = new DirectoryDialog(ImportPanel.this.manager.getShell());
                fileDialog.setText(SVNTeamUIPlugin.instance().getResource("ImportPanel.ImportFolder"));
                fileDialog.setMessage(SVNTeamUIPlugin.instance().getResource("ImportPanel.ImportFolder.Msg"));
                String path = fileDialog.open();
                if (path != null) {
                    ImportPanel.this.locationField.setText(path);
                }
            }
        });
        this.recursiveButton = new Button((Composite)group, 32);
        this.recursiveButton.setText(SVNTeamUIPlugin.instance().getResource("ImportPanel.Recursively"));
        this.recursiveButton.setSelection(true);
        group = new Group(parent, 0);
        group.setLayout((Layout)new GridLayout());
        data = new GridData(1808);
        group.setLayoutData((Object)data);
        group.setText(SVNTeamUIPlugin.instance().getResource("ImportPanel.Comment"));
        this.comment = new CommentComposite((Composite)group, this);
        data = new GridData(1808);
        this.comment.setLayoutData(data);
    }

    public String getHelpId() {
        return "org.polarion.team.svn.help.remote_importDialogContext";
    }

    public Point getPrefferedSize() {
        return new Point(525, -1);
    }

    public void postInit() {
        super.postInit();
        this.comment.postInit(this.manager);
    }

    protected void saveChanges() {
        this.location = this.locationField.getText();
        this.comment.saveChanges();
        this.isRecursive = this.recursiveButton.getSelection();
    }

    protected void cancelChanges() {
        this.comment.cancelChanges();
    }

    public String getLocation() {
        return this.location;
    }

    public String getMessage() {
        return this.comment.getMessage();
    }

    public boolean isRecursive() {
        return this.isRecursive;
    }
}

