/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui.panel.view;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.polarion.team.svn.ui.SVNTeamUIPlugin;
import org.polarion.team.svn.ui.panel.AbstractDialogPanel;
import org.polarion.team.svn.ui.utility.UserInputHistory;
import org.polarion.team.svn.ui.verifier.AbstractVerifierProxy;
import org.polarion.team.svn.ui.verifier.NonEmptyFieldVerifier;

public class HistoryFilterPanel
extends AbstractDialogPanel {
    protected static final String FILTER_AUTHOR_HISTORY_NAME = "filterAuthor";
    protected static final String FILTER_COMMENT_HISTORY_NAME = "filterComment";
    protected String filter;
    protected Button authorButton;
    protected Button commentButton;
    protected Combo authorsCombo;
    protected Combo commentsCombo;
    protected boolean commentFilterEnabled;
    protected String authorInput = "";
    protected String commentInput = "";
    protected String[] selectedAuthors;
    protected UserInputHistory authorsHistory;
    protected UserInputHistory commentsHistory;

    public HistoryFilterPanel(String authorInput, String commentInput, String[] selectedAuthors, boolean commentFilterEnabled) {
        this.dialogTitle = SVNTeamUIPlugin.instance().getResource("HistoryFilterPanel.Title");
        this.dialogDescription = SVNTeamUIPlugin.instance().getResource("HistoryFilterPanel.Description");
        this.defaultMessage = SVNTeamUIPlugin.instance().getResource("HistoryFilterPanel.Message");
        this.selectedAuthors = selectedAuthors;
        this.authorInput = authorInput;
        this.commentInput = commentInput;
        this.commentFilterEnabled = commentFilterEnabled;
    }

    public String getAuthor() {
        return this.authorInput.trim();
    }

    public String getComment() {
        return this.commentInput.trim();
    }

    public boolean isCommentFilterEnabled() {
        return this.commentFilterEnabled;
    }

    public Point getPrefferedSize() {
        return new Point(470, 100);
    }

    public void createControls(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        composite.setLayoutData((Object)data);
        this.authorButton = new Button(composite, 32);
        this.authorButton.setText(SVNTeamUIPlugin.instance().getResource("HistoryFilterPanel.Author"));
        this.authorButton.setSelection(this.authorInput.length() > 0);
        this.authorButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HistoryFilterPanel.this.validateContent();
                if (HistoryFilterPanel.this.authorButton.getSelection()) {
                    HistoryFilterPanel.this.authorsCombo.setEnabled(true);
                } else {
                    HistoryFilterPanel.this.authorsCombo.setEnabled(false);
                    HistoryFilterPanel.this.authorInput = "";
                }
            }
        });
        this.authorsHistory = new UserInputHistory(FILTER_AUTHOR_HISTORY_NAME);
        this.authorsCombo = new Combo(composite, 0);
        data = new GridData(768);
        data.widthHint = 200;
        this.authorsCombo.setLayoutData((Object)data);
        this.authorsCombo.setEnabled(this.authorButton.getSelection());
        this.authorsCombo.setVisibleItemCount(this.authorsHistory.getDepth());
        this.authorsCombo.setItems(this.mergeAuthorsList());
        this.authorsCombo.setText(this.authorInput);
        this.authorsCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                HistoryFilterPanel.this.authorInput = HistoryFilterPanel.this.authorsCombo.getText();
                HistoryFilterPanel.this.validateContent();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.attachTo((Control)this.authorsCombo, new AbstractVerifierProxy(new NonEmptyFieldVerifier(SVNTeamUIPlugin.instance().getResource("HistoryFilterPanel.Author.Verifier"))){

            protected boolean isVerificationEnabled(Control input) {
                return HistoryFilterPanel.this.authorButton.getSelection();
            }
        });
        this.commentButton = new Button(composite, 32);
        this.commentButton.setText(SVNTeamUIPlugin.instance().getResource("HistoryFilterPanel.Comment"));
        this.commentButton.setSelection(this.commentFilterEnabled);
        this.commentButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HistoryFilterPanel.this.validateContent();
                if (HistoryFilterPanel.this.commentButton.getSelection()) {
                    HistoryFilterPanel.this.commentsCombo.setEnabled(true);
                    HistoryFilterPanel.this.commentFilterEnabled = true;
                } else {
                    HistoryFilterPanel.this.commentsCombo.setEnabled(false);
                    HistoryFilterPanel.this.commentInput = "";
                    HistoryFilterPanel.this.commentFilterEnabled = false;
                }
            }
        });
        this.commentsHistory = new UserInputHistory(FILTER_COMMENT_HISTORY_NAME);
        this.commentsCombo = new Combo(composite, 0);
        data = new GridData(768);
        data.widthHint = 200;
        this.commentsCombo.setLayoutData((Object)data);
        this.commentsCombo.setEnabled(this.commentButton.getSelection());
        this.commentsCombo.setVisibleItemCount(this.commentsHistory.getDepth());
        this.commentsCombo.setItems(this.commentsHistory.getHistory());
        this.commentsCombo.setText(this.commentInput);
        this.commentsCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                HistoryFilterPanel.this.commentInput = HistoryFilterPanel.this.commentsCombo.getText();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    public String getHelpId() {
        return "org.polarion.team.svn.help.historyDialogContext";
    }

    protected void saveChanges() {
        if (this.authorButton.getSelection()) {
            this.authorInput = this.authorsCombo.getText();
            this.authorsHistory.addLine(this.authorInput);
        }
        if (this.commentButton.getSelection()) {
            this.commentInput = this.commentsCombo.getText();
            this.commentsHistory.addLine(this.commentInput);
        }
    }

    protected void cancelChanges() {
    }

    protected String[] mergeAuthorsList() {
        ArrayList<String> merged = new ArrayList<String>();
        merged.addAll(Arrays.asList(this.selectedAuthors));
        Collections.sort(merged);
        String[] userInputs = this.authorsHistory == null ? new String[]{} : this.authorsHistory.getHistory();
        int i = 0;
        while (i < userInputs.length) {
            if (!merged.contains(userInputs[i])) {
                merged.add(userInputs[i]);
            }
            ++i;
        }
        return merged.toArray(new String[merged.size()]);
    }
}

