/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui.preferences;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.PlatformUI;
import org.polarion.team.svn.core.SVNTeamPlugin;
import org.polarion.team.svn.core.client.ClientWrapperException;
import org.polarion.team.svn.core.client.ISVNClientWrapper;
import org.polarion.team.svn.core.extension.CoreExtensionsManager;
import org.polarion.team.svn.core.operation.LoggedOperation;
import org.polarion.team.svn.core.utility.FileUtility;
import org.polarion.team.svn.ui.SVNTeamUIPlugin;
import org.polarion.team.svn.ui.dialog.DefaultDialog;
import org.polarion.team.svn.ui.panel.common.EditAutoPropertiesPanel;
import org.polarion.team.svn.ui.preferences.AbstractSVNTeamPreferencesPage;
import org.polarion.team.svn.ui.preferences.SVNTeamPreferences;

public class SVNTeamAutoPropsPreferencePage
extends AbstractSVNTeamPreferencesPage {
    protected CheckboxTableViewer tableViewer;
    protected Button btnAdd;
    protected Button btnEdit;
    protected Button btnRemove;
    protected Button btnExport;
    protected Button btnImport;
    protected String autoPropsValue;
    public static final int COLUMN_INDEX_FILE_NAME = 1;
    public static final int COLUMN_INDEX_PROPERTIES = 2;
    public static final String AUTO_PROPS_CONFIG_FILE_NAME = "config";
    public static final String AUTO_PROPS_SECTION_HEADER = "[auto-props]";
    public static final String AUTO_PROPS_COMMENT_START = "#";
    public static final String AUTO_PROPS_PATTERN_SEPARATOR = "=";
    public static final String AUTO_PROPS_PROPS_SEPARATOR = ";";

    protected void saveValues(IPreferenceStore store) {
        int propsCount = this.tableViewer.getTable().getItemCount();
        String[] props = new String[3 * propsCount];
        int i = 0;
        while (i < propsCount) {
            AutoProperty property = (AutoProperty)this.tableViewer.getElementAt(i);
            props[3 * i] = property.enabled ? "1" : "0";
            props[3 * i + 1] = property.fileName;
            props[3 * i + 2] = property.properties;
            ++i;
        }
        this.autoPropsValue = FileUtility.encodeArrayToString((String[])props);
        SVNTeamPreferences.setAutoPropertiesList(store, "autoproperties", this.autoPropsValue);
    }

    protected void loadDefaultValues(IPreferenceStore store) {
        this.autoPropsValue = "";
    }

    protected void loadValues(IPreferenceStore store) {
        this.autoPropsValue = SVNTeamPreferences.getAutoPropertiesList(store, "autoproperties");
    }

    protected void initializeControls() {
        this.removeAllProperties();
        this.populateTable(SVNTeamAutoPropsPreferencePage.loadProperties(this.autoPropsValue));
    }

    protected Control createContentsImpl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        composite.setLayoutData((Object)data);
        this.createTable(composite);
        this.createButtons(composite);
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                SVNTeamAutoPropsPreferencePage.this.btnEdit.setEnabled(selection.size() == 1);
                SVNTeamAutoPropsPreferencePage.this.btnRemove.setEnabled(selection.size() > 0);
            }
        });
        this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                SVNTeamAutoPropsPreferencePage.this.editProperty();
            }
        });
        this.tableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ((AutoProperty)event.getElement()).enabled = event.getChecked();
                SVNTeamAutoPropsPreferencePage.this.btnExport.setEnabled(SVNTeamAutoPropsPreferencePage.this.tableViewer.getCheckedElements().length != 0);
            }
        });
        this.btnAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SVNTeamAutoPropsPreferencePage.this.addProperty();
                SVNTeamAutoPropsPreferencePage.this.btnExport.setEnabled(SVNTeamAutoPropsPreferencePage.this.tableViewer.getCheckedElements().length != 0);
            }
        });
        this.btnEdit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SVNTeamAutoPropsPreferencePage.this.editProperty();
            }
        });
        this.btnRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SVNTeamAutoPropsPreferencePage.this.removeProperty();
                SVNTeamAutoPropsPreferencePage.this.btnExport.setEnabled(SVNTeamAutoPropsPreferencePage.this.tableViewer.getCheckedElements().length != 0);
            }
        });
        this.btnExport.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SVNTeamAutoPropsPreferencePage.this.exportProperties();
            }
        });
        this.btnImport.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SVNTeamAutoPropsPreferencePage.this.importProperties();
                SVNTeamAutoPropsPreferencePage.this.btnExport.setEnabled(SVNTeamAutoPropsPreferencePage.this.tableViewer.getCheckedElements().length != 0);
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.polarion.team.svn.help.autoPropsPreferencesContext");
        return composite;
    }

    protected void createTable(Composite parent) {
        this.tableViewer = CheckboxTableViewer.newCheckList((Composite)parent, (int)68354);
        TableLayout layout = new TableLayout();
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(20, false));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(25, true));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(75, true));
        this.tableViewer.getTable().setLayout((Layout)layout);
        this.tableViewer.getTable().setLinesVisible(true);
        this.tableViewer.getTable().setHeaderVisible(true);
        this.tableViewer.getTable().setLayoutData((Object)new GridData(1808));
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                if (columnIndex == 1) {
                    return ((AutoProperty)element).fileName;
                }
                if (columnIndex == 2) {
                    return ((AutoProperty)element).properties;
                }
                return "";
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
        TableColumn column = new TableColumn(this.tableViewer.getTable(), 0);
        column.setResizable(false);
        column = new TableColumn(this.tableViewer.getTable(), 0);
        column.setText(SVNTeamUIPlugin.instance().getResource("AutoPropsPreferencePage.columnHeaderFileName"));
        column = new TableColumn(this.tableViewer.getTable(), 0);
        column.setText(SVNTeamUIPlugin.instance().getResource("AutoPropsPreferencePage.columnHeaderProperties"));
    }

    protected void createButtons(Composite parent) {
        Composite buttons = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        buttons.setLayout((Layout)layout);
        buttons.setLayoutData((Object)new GridData(2));
        this.btnAdd = this.createButton(buttons, SVNTeamUIPlugin.instance().getResource("AutoPropsPreferencePage.buttonTextAdd"), true);
        this.btnEdit = this.createButton(buttons, SVNTeamUIPlugin.instance().getResource("AutoPropsPreferencePage.buttonTextEdit"), false);
        this.btnRemove = this.createButton(buttons, SVNTeamUIPlugin.instance().getResource("AutoPropsPreferencePage.buttonTextRemove"), false);
        this.btnExport = this.createButton(buttons, SVNTeamUIPlugin.instance().getResource("AutoPropsPreferencePage.buttonTextExport"), this.tableViewer.getCheckedElements().length != 0);
        this.btnImport = this.createButton(buttons, SVNTeamUIPlugin.instance().getResource("AutoPropsPreferencePage.buttonTextImport"), true);
    }

    protected Button createButton(Composite parent, String text, boolean enabled) {
        Button button = new Button(parent, 8);
        button.setText(text);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.widthHint = DefaultDialog.computeButtonWidth(button);
        button.setLayoutData((Object)data);
        button.setEnabled(enabled);
        return button;
    }

    public void addProperty() {
        EditAutoPropertiesPanel panel = new EditAutoPropertiesPanel(null);
        DefaultDialog dialog = new DefaultDialog(this.getShell(), panel);
        if (dialog.open() == 0) {
            AutoProperty property = new AutoProperty(panel.getFileName(), panel.getProperties(), true);
            this.tableViewer.add((Object)property);
            this.tableViewer.setChecked((Object)property, property.enabled);
        }
    }

    public void editProperty() {
        IStructuredSelection selection = (IStructuredSelection)this.tableViewer.getSelection();
        AutoProperty property = (AutoProperty)selection.getFirstElement();
        EditAutoPropertiesPanel panel = new EditAutoPropertiesPanel(property);
        DefaultDialog dialog = new DefaultDialog(this.getShell(), panel);
        if (dialog.open() == 0) {
            property.fileName = panel.getFileName();
            property.properties = panel.getProperties();
            this.tableViewer.update((Object)property, null);
        }
    }

    public void removeProperty() {
        IStructuredSelection selection = (IStructuredSelection)this.tableViewer.getSelection();
        this.tableViewer.remove(selection.toArray());
    }

    public void removeAllProperties() {
        this.tableViewer.getTable().clearAll();
        this.tableViewer.refresh();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void exportProperties() {
        String filePath = this.findConfigFile(SVNTeamUIPlugin.instance().getResource("AutoPropsPreferencePage.dialogTitleExport"));
        if (filePath == null) {
            return;
        }
        File srcCfg = new File(filePath);
        File tmpCfg = null;
        BufferedReader srcReader = null;
        PrintWriter tmpWriter = null;
        try {
            try {
                int i;
                Object[] checkedProps;
                String line;
                tmpCfg = File.createTempFile("cfg_", String.valueOf(srcCfg.getName()) + "tmp", SVNTeamPlugin.instance().getStateLocation().toFile());
                tmpCfg.deleteOnExit();
                if (!srcCfg.exists()) {
                    srcCfg.createNewFile();
                }
                srcReader = new BufferedReader(new FileReader(srcCfg));
                tmpWriter = new PrintWriter(new FileOutputStream(tmpCfg));
                while (true) {
                    if ((line = srcReader.readLine()) == null || line.startsWith(AUTO_PROPS_SECTION_HEADER)) break;
                    tmpWriter.println(line);
                }
                tmpWriter.println(AUTO_PROPS_SECTION_HEADER);
                while (true) {
                    if ((line = srcReader.readLine()) == null || line.trim().equals("")) {
                        checkedProps = this.tableViewer.getCheckedElements();
                        i = 0;
                        break;
                    }
                    tmpWriter.println(line);
                }
                while (i < checkedProps.length) {
                    AutoProperty property = (AutoProperty)checkedProps[i];
                    if (!property.properties.equals("")) {
                        tmpWriter.println(String.valueOf(property.fileName) + " " + AUTO_PROPS_PATTERN_SEPARATOR + " " + property.properties);
                    }
                    ++i;
                }
                while (true) {
                    block24: {
                        if ((line = srcReader.readLine()) != null) break block24;
                        srcReader.close();
                        tmpWriter.close();
                        srcCfg.delete();
                        tmpCfg.renameTo(srcCfg);
                        break;
                    }
                    tmpWriter.println(line);
                }
            }
            catch (IOException ioe) {
                LoggedOperation.reportError((String)SVNTeamUIPlugin.instance().getResource("Error.ExportProperties"), (Throwable)ioe);
                Object var10_11 = null;
                try {
                    if (srcReader != null) {
                        srcReader.close();
                    }
                }
                catch (IOException iOException) {}
                if (tmpWriter != null) {
                    tmpWriter.close();
                }
                if (tmpCfg == null) return;
                tmpCfg.delete();
                return;
            }
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            try {}
            catch (IOException iOException) {}
            if (srcReader != null) {
                srcReader.close();
            }
            if (tmpWriter != null) {
                tmpWriter.close();
            }
            if (tmpCfg == null) throw throwable;
            tmpCfg.delete();
            throw throwable;
        }
        {
            Object var10_13 = null;
        }
        try {}
        catch (IOException iOException) {}
        if (srcReader != null) {
            srcReader.close();
        }
        if (tmpWriter != null) {
            tmpWriter.close();
        }
        if (tmpCfg == null) return;
        tmpCfg.delete();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void importProperties() {
        String filePath = this.findConfigFile(SVNTeamUIPlugin.instance().getResource("AutoPropsPreferencePage.dialogTitleImport"));
        if (filePath == null) {
            return;
        }
        BufferedReader cfgReader = null;
        ArrayList<AutoProperty> autoPropsList = new ArrayList<AutoProperty>();
        try {
            try {
                String line;
                cfgReader = new BufferedReader(new FileReader(filePath));
                while ((line = cfgReader.readLine()) != null && !line.startsWith(AUTO_PROPS_SECTION_HEADER)) {
                }
                while (true) {
                    block15: {
                        if ((line = cfgReader.readLine()) != null && !line.trim().equals("")) break block15;
                        this.populateTable(autoPropsList.toArray());
                        break;
                    }
                    if (line.startsWith(AUTO_PROPS_COMMENT_START)) continue;
                    String fileName = "";
                    String properties = "";
                    int index = line.indexOf(AUTO_PROPS_PATTERN_SEPARATOR);
                    if (index != -1) {
                        fileName = line.substring(0, index).trim();
                        if (index < line.length() - 1) {
                            properties = line.substring(index + 1).trim();
                        }
                    } else {
                        fileName = line.trim();
                    }
                    autoPropsList.add(new AutoProperty(fileName, properties, true));
                }
            }
            catch (IOException ioe) {
                LoggedOperation.reportError((String)SVNTeamUIPlugin.instance().getResource("Error.ImportProperties"), (Throwable)ioe);
                Object var8_9 = null;
                try {
                    if (cfgReader == null) return;
                    cfgReader.close();
                    return;
                }
                catch (IOException iOException) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            try {}
            catch (IOException iOException) {}
            if (cfgReader == null) throw throwable;
            cfgReader.close();
            throw throwable;
            throw throwable;
        }
        {
            Object var8_11 = null;
        }
        try {}
        catch (IOException iOException) {
            return;
        }
        if (cfgReader == null) return;
        cfgReader.close();
    }

    public void populateTable(Object[] items) {
        int i = 0;
        while (i < items.length) {
            this.tableViewer.add(items[i]);
            this.tableViewer.setChecked(items[i], ((AutoProperty)items[i]).enabled);
            ++i;
        }
    }

    public static Object[] loadProperties(String encodedProps) {
        ArrayList<AutoProperty> propsList = new ArrayList<AutoProperty>();
        String[] props = FileUtility.decodeStringToArray((String)encodedProps);
        int i = 0;
        while (i < props.length) {
            boolean enabled = !props[i].equals("0");
            String fileName = props[i + 1];
            String properties = i + 2 == props.length ? "" : props[i + 2];
            AutoProperty property = new AutoProperty(fileName, properties, enabled);
            propsList.add(property);
            i += 3;
        }
        return propsList.toArray();
    }

    public String findConfigFile(String dialogTitle) {
        String cfgDir;
        ISVNClientWrapper client = CoreExtensionsManager.instance().getSVNClientWrapperFactory().newInstance();
        try {
            cfgDir = client.getConfigDirectory();
        }
        catch (ClientWrapperException cwe) {
            LoggedOperation.reportError((String)SVNTeamUIPlugin.instance().getResource("Error.FindConfigFile"), (Throwable)cwe);
            return null;
        }
        FileDialog dlg = new FileDialog(this.getShell());
        dlg.setText(dialogTitle);
        dlg.setFilterPath(cfgDir);
        File cfgFile = new File(String.valueOf(cfgDir) + System.getProperty("file.separator") + AUTO_PROPS_CONFIG_FILE_NAME);
        if (cfgFile.exists()) {
            dlg.setFileName(AUTO_PROPS_CONFIG_FILE_NAME);
        }
        return dlg.open();
    }

    public static class AutoProperty {
        public String fileName;
        public String properties;
        public boolean enabled;

        public AutoProperty(String fileName, String properties, boolean enabled) {
            this.fileName = fileName;
            this.properties = properties;
            this.enabled = enabled;
        }
    }
}

