/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui.preferences;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.PlatformUI;
import org.polarion.team.svn.core.operation.IActionOperation;
import org.polarion.team.svn.core.operation.remote.management.SaveRepositoryLocationsOperation;
import org.polarion.team.svn.core.resource.IRepositoryLocation;
import org.polarion.team.svn.core.svnstorage.SVNRemoteStorage;
import org.polarion.team.svn.core.svnstorage.SVNRepositoryLocation;
import org.polarion.team.svn.ui.SVNTeamUIPlugin;
import org.polarion.team.svn.ui.dialog.DefaultDialog;
import org.polarion.team.svn.ui.preferences.AbstractSVNTeamPreferencesPage;
import org.polarion.team.svn.ui.utility.UIMonitorUtility;

public class SVNTeamPasswordManagementPreferencesPage
extends AbstractSVNTeamPreferencesPage {
    protected TableViewer viewer;
    protected Button removeButton;
    protected Button removeAllButton;
    protected List forRemove = new ArrayList();

    protected Control createContentsImpl(Composite parent) {
        GridData data = null;
        Label label = new Label(parent, 64);
        String text = SVNTeamUIPlugin.instance().getResource("PasswordManagementPreferencePage.Hint");
        label.setText(text);
        data = new GridData(768);
        data.widthHint = label.computeSize((int)-1, (int)-1).x / 4;
        data.heightHint = DefaultDialog.convertHeightInCharsToPixels((Control)label, 4);
        label.setLayoutData((Object)data);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        data = new GridData(1808);
        composite.setLayoutData((Object)data);
        this.viewer = new TableViewer(composite, 68354);
        Table table = this.viewer.getTable();
        new TableEditor(table);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        data = new GridData(1808);
        data.heightHint = 290;
        data.widthHint = 370;
        table.setLayoutData((Object)data);
        table.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                SVNTeamPasswordManagementPreferencesPage.this.handleSelection();
            }
        });
        TableColumn column = new TableColumn(table, 0);
        column.setText(SVNTeamUIPlugin.instance().getResource("PasswordManagementPreferencePage.Location"));
        this.viewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        this.viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement == null) {
                    return null;
                }
                IRepositoryLocation[] locations = ((SVNRemoteStorage)inputElement).getRepositoryLocations();
                ArrayList<IRepositoryLocation> repositories = new ArrayList<IRepositoryLocation>();
                int i = 0;
                while (i < locations.length) {
                    if (SVNTeamPasswordManagementPreferencesPage.this.checkIfAnyPasswordSaved(locations[i]) && !SVNTeamPasswordManagementPreferencesPage.this.forRemove.contains(locations[i])) {
                        repositories.add(locations[i]);
                    }
                    ++i;
                }
                return repositories.toArray(new SVNRepositoryLocation[repositories.size()]);
            }
        });
        TableLayout tLayout = new TableLayout();
        tLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(100));
        table.setLayout((Layout)tLayout);
        Composite buttons = new Composite(composite, 0);
        buttons.setLayoutData((Object)new GridData(1042));
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        buttons.setLayout((Layout)layout);
        this.removeButton = new Button(buttons, 8);
        this.removeButton.setText(SVNTeamUIPlugin.instance().getResource("Button.Remove"));
        this.removeButton.setEnabled(false);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SVNTeamPasswordManagementPreferencesPage.this.remove();
            }
        });
        this.removeAllButton = new Button(buttons, 8);
        this.removeAllButton.setText(SVNTeamUIPlugin.instance().getResource("Button.RemoveAll"));
        this.removeAllButton.setEnabled(true);
        this.removeAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SVNTeamPasswordManagementPreferencesPage.this.removeAll();
            }
        });
        data = new GridData();
        data.widthHint = DefaultDialog.computeButtonWidth(this.removeAllButton);
        this.removeButton.setLayoutData((Object)data);
        data = new GridData();
        data.widthHint = DefaultDialog.computeButtonWidth(this.removeAllButton);
        this.removeAllButton.setLayoutData((Object)data);
        this.viewer.setInput((Object)SVNRemoteStorage.instance());
        this.handleSelection();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.polarion.team.svn.help.passwordPreferencesContext");
        return composite;
    }

    protected void remove() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        Iterator it = selection.iterator();
        while (it.hasNext()) {
            this.forRemove.add((IRepositoryLocation)it.next());
        }
        this.viewer.refresh();
        this.handleSelection();
    }

    protected void removeAll() {
        IRepositoryLocation[] locations = SVNRemoteStorage.instance().getRepositoryLocations();
        int i = 0;
        while (i < locations.length) {
            if (this.checkIfAnyPasswordSaved(locations[i])) {
                this.forRemove.add(locations[i]);
            }
            ++i;
        }
        this.viewer.refresh();
        this.handleSelection();
    }

    protected boolean checkIfAnyPasswordSaved(IRepositoryLocation location) {
        return location.isPasswordSaved() || location.getSSHSettings().isPassPhraseSaved() || location.getSSLSettings().isPassPhraseSaved() || location.getProxySettings().isPasswordSaved();
    }

    protected void resetPasswordsSaving(IRepositoryLocation location) {
        location.setPasswordSaved(false);
        location.getSSHSettings().setPassPhraseSaved(false);
        location.getSSLSettings().setPassPhraseSaved(false);
        location.getProxySettings().setPasswordSaved(false);
        location.reconfigure();
    }

    protected void handleSelection() {
        if (this.viewer.getTable().getSelectionCount() > 0) {
            this.removeButton.setEnabled(true);
        } else {
            this.removeButton.setEnabled(false);
        }
        this.removeAllButton.setEnabled(this.viewer.getTable().getItemCount() > 0);
    }

    protected void saveValues(IPreferenceStore store) {
        Iterator iter = this.forRemove.iterator();
        while (iter.hasNext()) {
            this.resetPasswordsSaving((IRepositoryLocation)iter.next());
        }
        this.forRemove = new ArrayList();
        UIMonitorUtility.doTaskBusyDefault((IActionOperation)new SaveRepositoryLocationsOperation());
    }

    protected void loadDefaultValues(IPreferenceStore store) {
    }

    protected void loadValues(IPreferenceStore store) {
    }

    protected void initializeControls() {
    }

    protected class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        protected TableLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            SVNRepositoryLocation location = (SVNRepositoryLocation)element;
            switch (columnIndex) {
                case 0: {
                    return location.getUrl();
                }
                case 1: {
                    return location.getUsername();
                }
            }
            return null;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }
    }
}

