/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui.properties;

import java.text.MessageFormat;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;
import org.polarion.team.svn.core.IStateFilter;
import org.polarion.team.svn.core.operation.IResourcePropertyProvider;
import org.polarion.team.svn.core.resource.ILocalResource;
import org.polarion.team.svn.core.resource.IRepositoryResource;
import org.polarion.team.svn.core.svnstorage.SVNRemoteStorage;
import org.polarion.team.svn.ui.SVNTeamUIPlugin;

public class PropertiesEditorInput
implements IEditorInput {
    protected IRepositoryResource remoteResource;
    protected IResource localResource;
    protected IResourcePropertyProvider propertyProvider;

    public PropertiesEditorInput(IAdaptable resource, IResourcePropertyProvider propertyProvider) {
        if (resource instanceof IRepositoryResource) {
            this.remoteResource = (IRepositoryResource)resource;
        } else if (resource instanceof IResource) {
            this.localResource = (IResource)resource;
        }
        this.propertyProvider = propertyProvider;
    }

    public boolean exists() {
        return this.remoteResource != null || this.localResource != null;
    }

    public ImageDescriptor getImageDescriptor() {
        return SVNTeamUIPlugin.instance().getImageDescriptor("icons/views/propertiesedit.gif");
    }

    public String getName() {
        if (this.localResource != null) {
            ILocalResource local = SVNRemoteStorage.instance().asLocalResource(this.localResource);
            if (local == null) {
                return this.localResource.getName();
            }
            return String.valueOf(local.getName()) + (IStateFilter.SF_ADDED.accept(local.getResource(), local.getStatus(), local.getChangeMask()) ? "" : " " + local.getRevision());
        }
        String name = SVNTeamUIPlugin.instance().getResource("PropertiesEditor.Name");
        return MessageFormat.format(name, this.remoteResource.getName(), String.valueOf(this.remoteResource.getSelectedRevision()));
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        return this.getName();
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public IAdaptable getResource() {
        if (this.localResource == null) {
            return this.remoteResource;
        }
        return this.localResource;
    }

    public boolean equals(Object obj) {
        if (obj instanceof PropertiesEditorInput) {
            return this.getResource().equals(((PropertiesEditorInput)obj).getResource());
        }
        return false;
    }

    public IResourcePropertyProvider getPropertyProvider() {
        return this.propertyProvider;
    }
}

