/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui.properties.bugtraq;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.polarion.team.svn.ui.properties.bugtraq.BugtraqModel;

public class IssueList {
    protected ArrayList issues = new ArrayList();

    public List getIssues() {
        return this.issues;
    }

    public String getTemplatePrefix(String template) {
        int indexOfIssue = template.indexOf("%BUGID%");
        String prefix = "";
        if (indexOfIssue > 0) {
            prefix = template.substring(0, indexOfIssue);
        }
        return prefix;
    }

    public String getTemplateSuffix(String template) {
        int indexOfSuffix;
        int indexOfIssue = template.indexOf("%BUGID%");
        String suffix = "";
        if (indexOfIssue != -1 && (indexOfSuffix = indexOfIssue + "%BUGID%".length()) < template.length()) {
            suffix = template.substring(indexOfSuffix);
        }
        return suffix;
    }

    public void parseMessage(String message, BugtraqModel model) {
        String template = model.getMessage();
        this.issues.clear();
        if (template == null) {
            return;
        }
        String prefix = this.getTemplatePrefix(template);
        String sufix = this.getTemplateSuffix(template);
        int bugIdIndex = template.indexOf("%BUGID%");
        if (bugIdIndex != -1) {
            String regex;
            Matcher matcher;
            String issueRegex;
            String string = issueRegex = model.isNumber() ? "[0-9]+(,?[0-9]+)*" : model.getLogregex();
            if (issueRegex == null) {
                issueRegex = "*";
            }
            if ((matcher = Pattern.compile(regex = String.valueOf(prefix) + issueRegex + sufix, 8).matcher(message)).find()) {
                String issuesPattern = matcher.group(0);
                int startAllIssues = matcher.start(0);
                boolean first = true;
                int i = prefix.length();
                while (i < issuesPattern.length()) {
                    if (issuesPattern.substring(i, i + 1).equals(",") || first) {
                        if (issuesPattern.substring(i, i + 1).equals(",")) {
                            first = true;
                        } else {
                            first = false;
                            int start = i++;
                            int end = i;
                            boolean found = false;
                            while (i + 1 < issuesPattern.length() && !issuesPattern.substring(i + 1, i + 2).equals(",")) {
                                ++end;
                                found = true;
                                ++i;
                            }
                            if (found) {
                                this.issues.add(new Issue(startAllIssues + start, startAllIssues + ++end, message));
                            }
                        }
                    }
                    ++i;
                }
            }
        }
    }

    public boolean isIssueAt(int offset) {
        Iterator iter = this.issues.iterator();
        while (iter.hasNext()) {
            Issue issue = (Issue)iter.next();
            if (!issue.existAtOffset(offset)) continue;
            return true;
        }
        return false;
    }

    public Issue getIssueAt(int offset) {
        Iterator iter = this.issues.iterator();
        while (iter.hasNext()) {
            Issue issue = (Issue)iter.next();
            if (!issue.existAtOffset(offset)) continue;
            return issue;
        }
        return null;
    }

    public class Issue {
        protected int start;
        protected int end;
        protected String issue;

        public Issue(int start, int end, String message) {
            this.issue = message.substring(start, end);
            this.start = start;
            this.end = end;
        }

        protected boolean existAtOffset(int offset) {
            return this.start <= offset && offset < this.end;
        }

        public int getStart() {
            return this.start;
        }

        public void setStart(int start) {
            this.start = start;
        }

        public int getEnd() {
            return this.end;
        }

        public void setEnd(int end) {
            this.end = end;
        }

        public String getURL() {
            return this.issue;
        }
    }
}

