/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui.repository.browser;

import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.eclipse.compare.CompareUI;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Image;
import org.polarion.team.svn.core.SVNTeamPlugin;
import org.polarion.team.svn.core.client.Lock;
import org.polarion.team.svn.core.operation.LoggedOperation;
import org.polarion.team.svn.core.resource.IRepositoryFile;
import org.polarion.team.svn.core.resource.IRepositoryResource;
import org.polarion.team.svn.ui.SVNTeamUIPlugin;
import org.polarion.team.svn.ui.repository.browser.RepositoryBrowserTableViewer;
import org.polarion.team.svn.ui.repository.model.RepositoryFictiveNode;
import org.polarion.team.svn.ui.repository.model.RepositoryFictiveWorkingDirectory;
import org.polarion.team.svn.ui.repository.model.RepositoryResource;

public class RepositoryBrowserLabelProvider
implements ITableLabelProvider {
    protected RepositoryBrowserTableViewer tableViewer;
    protected Map images;
    protected static String hasProps;
    protected static String noAuthor;
    protected static String noDate;

    public RepositoryBrowserLabelProvider(RepositoryBrowserTableViewer tableViewer) {
        this.tableViewer = tableViewer;
        this.images = new HashMap();
        noAuthor = SVNTeamPlugin.instance().getResource("SVNInfo.NoAuthor");
        noDate = SVNTeamPlugin.instance().getResource("SVNInfo.NoDate");
        hasProps = SVNTeamUIPlugin.instance().getResource("RepositoriesView.Browser.HasProps");
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == this.tableViewer.getNameColumnIndex()) {
            ImageDescriptor iDescr = null;
            if (element instanceof RepositoryResource) {
                iDescr = ((RepositoryResource)element).getImageDescriptor(null);
            } else if (element instanceof RepositoryFictiveNode) {
                iDescr = ((RepositoryFictiveNode)element).getImageDescriptor(null);
            }
            if (iDescr != null) {
                Image img = (Image)this.images.get(iDescr);
                if (img == null) {
                    img = iDescr.createImage();
                    this.images.put(iDescr, img);
                    CompareUI.disposeOnShutdown((Image)img);
                }
                return img;
            }
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (element instanceof RepositoryResource) {
            return this.getColumnTextForElement(element, columnIndex);
        }
        if (element instanceof RepositoryFictiveNode) {
            if (columnIndex == this.tableViewer.getNameColumnIndex()) {
                return ((RepositoryFictiveNode)element).getLabel(null);
            }
            if (element instanceof RepositoryFictiveWorkingDirectory) {
                return this.getColumnTextForElement(((RepositoryFictiveWorkingDirectory)element).getAssociatedDirectory(), columnIndex);
            }
        }
        return "";
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    protected String getColumnTextForElement(Object element, int columnIndex) {
        DateFormat dateTimeFormat = DateFormat.getDateTimeInstance(2, 2, Locale.getDefault());
        if (element instanceof RepositoryResource) {
            IRepositoryResource resource = ((RepositoryResource)element).getRepositoryResource();
            IRepositoryResource.Info resourceInfo = resource.getInfo();
            if (columnIndex == this.tableViewer.getNameColumnIndex()) {
                return ((RepositoryResource)element).getLabel();
            }
            if (columnIndex == this.tableViewer.getRevisionColumnIndex()) {
                String revision = "";
                try {
                    revision = resource.isInfoCached() ? String.valueOf(((RepositoryResource)element).getRevision()) : SVNTeamUIPlugin.instance().getResource("RepositoriesView.Model.Pending");
                }
                catch (Exception ex) {
                    LoggedOperation.reportError((String)SVNTeamUIPlugin.instance().getResource("Error.GetColumnText"), (Throwable)ex);
                }
                return revision;
            }
            if (resourceInfo != null) {
                if (columnIndex == this.tableViewer.getDateColumnIndex()) {
                    Date date = resourceInfo.lastChangedDate;
                    return date != null ? dateTimeFormat.format(date) : noDate;
                }
                if (columnIndex == this.tableViewer.getAuthorColumnIndex()) {
                    String author = resourceInfo.lastAuthor;
                    return author != null ? author : noAuthor;
                }
                if (columnIndex == this.tableViewer.getLockOwnerColumnIndex()) {
                    Lock lock = resourceInfo.lock;
                    String lockOwner = lock == null ? "" : lock.owner;
                    return lockOwner;
                }
                if (columnIndex == this.tableViewer.getSizeColumnIndex()) {
                    long size = resourceInfo.fileSize;
                    return resource instanceof IRepositoryFile ? String.valueOf(size) : "";
                }
                if (columnIndex == this.tableViewer.getPropertiesColumnIndex()) {
                    boolean hasProps = resourceInfo.hasProperties;
                    return hasProps ? RepositoryBrowserLabelProvider.hasProps : "";
                }
            }
        }
        return "";
    }
}

