/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui.synchronize;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.subscribers.ISubscriberChangeEvent;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.core.subscribers.SubscriberChangeEvent;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.variants.IResourceVariantComparator;
import org.polarion.team.svn.core.IStateFilter;
import org.polarion.team.svn.core.client.Status;
import org.polarion.team.svn.core.extension.CoreExtensionsManager;
import org.polarion.team.svn.core.operation.AbstractNonLockingOperation;
import org.polarion.team.svn.core.operation.CompositeOperation;
import org.polarion.team.svn.core.operation.IActionOperation;
import org.polarion.team.svn.core.operation.IUnprotectedOperation;
import org.polarion.team.svn.core.operation.LoggedOperation;
import org.polarion.team.svn.core.operation.local.IRemoteStatusOperation;
import org.polarion.team.svn.core.resource.ILocalResource;
import org.polarion.team.svn.core.resource.IRemoteStorage;
import org.polarion.team.svn.core.resource.IResourceChange;
import org.polarion.team.svn.core.resource.events.IResourceStatesListener;
import org.polarion.team.svn.core.resource.events.ResourceStatesChangedEvent;
import org.polarion.team.svn.core.svnstorage.SVNRemoteStorage;
import org.polarion.team.svn.core.utility.FileUtility;
import org.polarion.team.svn.core.utility.ProgressMonitorUtility;
import org.polarion.team.svn.core.utility.SVNUtility;
import org.polarion.team.svn.ui.SVNTeamUIPlugin;
import org.polarion.team.svn.ui.preferences.SVNTeamPreferences;
import org.polarion.team.svn.ui.synchronize.AbstractSVNSubscriber;
import org.polarion.team.svn.ui.synchronize.RemoteStatusCache;
import org.polarion.team.svn.ui.synchronize.ResourceVariantComparator;
import org.polarion.team.svn.ui.utility.DefaultOperationWrapperFactory;
import org.polarion.team.svn.ui.utility.IOperationWrapperFactory;
import org.polarion.team.svn.ui.utility.UIMonitorUtility;

public abstract class AbstractSVNSubscriber
extends Subscriber
implements IResourceStatesListener {
    protected static final IResourceVariantComparator RV_COMPARATOR = new ResourceVariantComparator();
    protected RemoteStatusCache statusCache = new RemoteStatusCache();
    protected Set oldResources;
    static /* synthetic */ Class class$0;

    public AbstractSVNSubscriber() {
        SVNRemoteStorage sVNRemoteStorage = SVNRemoteStorage.instance();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.polarion.team.svn.core.resource.events.ResourceStatesChangedEvent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        sVNRemoteStorage.addResourceStatesListener((Class)clazz, (IResourceStatesListener)this);
        this.oldResources = new HashSet();
    }

    public boolean isSynchronizedWithRepository() {
        return this.statusCache.containsData();
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public boolean isSupervised(IResource resource) {
        return FileUtility.isConnected((IResource)resource) && !FileUtility.isSVNInternals((IResource)resource) && !FileUtility.isLinked((IResource)resource);
    }

    public IResource[] members(IResource resource) {
        ILocalResource local = SVNRemoteStorage.instance().asLocalResource(resource);
        if (local == null || IStateFilter.SF_IGNORED.accept(resource, local.getStatus(), local.getChangeMask()) || IStateFilter.SF_NOTEXISTS.accept(resource, local.getStatus(), local.getChangeMask())) {
            return FileUtility.NO_CHILDREN;
        }
        return this.statusCache.allMembers(resource);
    }

    public IResource[] roots() {
        ArrayList<IProject> roots = new ArrayList<IProject>();
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            if (FileUtility.isConnected((IResource)projects[i])) {
                roots.add(projects[i]);
            }
            ++i;
        }
        return roots.toArray(new IResource[roots.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SyncInfo getSyncInfo(IResource resource) throws TeamException {
        if (!this.isSupervised(resource)) {
            return null;
        }
        SVNRemoteStorage storage = SVNRemoteStorage.instance();
        IResourceChange remoteStatus = storage.resourceChangeFromBytes(this.statusCache.getBytes(resource));
        ILocalResource localStatus = storage.asLocalResourceDirty(resource);
        if (localStatus != null || remoteStatus != null) {
            SyncInfo info = this.getSVNSyncInfo((IRemoteStorage)storage, localStatus, remoteStatus);
            if (info != null) {
                info.init();
                if (info.getKind() != 0) {
                    Set set = this.oldResources;
                    synchronized (set) {
                        this.oldResources.add(resource);
                    }
                }
            }
            return info;
        }
        return null;
    }

    public IResourceVariantComparator getResourceComparator() {
        return RV_COMPARATOR;
    }

    public void refresh(IResource[] resources, int depth, IProgressMonitor monitor) {
        IPreferenceStore store = SVNTeamUIPlugin.instance().getPreferenceStore();
        boolean contiguousReportMode = SVNTeamPreferences.getSynchronizeBoolean(store, "fastReport");
        HashSet refreshScope = this.clearRemoteStatusesImpl(resources);
        if (contiguousReportMode) {
            this.resourcesStateChangedImpl(refreshScope.toArray(new IResource[refreshScope.size()]));
            UpdateStatusOperation op = new UpdateStatusOperation(resources, depth);
            UIMonitorUtility.doTaskExternalDefault((IActionOperation)op, monitor);
        } else {
            refreshScope.addAll(Arrays.asList(this.findChanges(resources, depth, monitor, new DefaultOperationWrapperFactory())));
            this.resourcesStateChangedImpl(refreshScope.toArray(new IResource[refreshScope.size()]));
        }
    }

    public void clearRemoteStatuses(IResource[] resources) {
        HashSet refreshScope = this.clearRemoteStatusesImpl(resources);
        this.resourcesStateChangedImpl(refreshScope.toArray(new IResource[refreshScope.size()]));
    }

    public void resourcesStateChanged(ResourceStatesChangedEvent event) {
        this.resourcesStateChangedImpl(event.getResourcesRecursivelly());
    }

    protected HashSet clearRemoteStatusesImpl(IResource[] resources) {
        return this.clearRemoteStatusesImpl(this.statusCache, resources);
    }

    protected HashSet clearRemoteStatusesImpl(RemoteStatusCache cache, IResource[] resources) {
        final HashSet refreshSet = new HashSet();
        cache.traverse(resources, 2, new RemoteStatusCache.ICacheVisitor(){

            public void visit(IPath current, byte[] data) {
                IResource resource = SVNRemoteStorage.instance().resourceChangeFromBytes(data).getResource();
                if (resource != null) {
                    refreshSet.add(resource);
                }
            }
        });
        int i = 0;
        while (i < resources.length) {
            cache.flushBytes(resources[i], 2);
            ++i;
        }
        return refreshSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resourcesStateChangedImpl(IResource[] resources) {
        HashSet<IResource> allResources = new HashSet<IResource>(Arrays.asList(resources));
        int i = 0;
        while (i < resources.length) {
            allResources.addAll(Arrays.asList(this.statusCache.allMembers(resources[i])));
            ++i;
        }
        Set set = this.oldResources;
        synchronized (set) {
            allResources.addAll(this.oldResources);
            this.oldResources.clear();
            IResource[] refreshSet = allResources.toArray(new IResource[allResources.size()]);
            if (CoreExtensionsManager.instance().getOptionProvider().isSVNCacheEnabled()) {
                IResource[] parents = FileUtility.getParents((IResource[])refreshSet, (boolean)false);
                int i2 = 0;
                while (i2 < parents.length) {
                    try {
                        SVNRemoteStorage.instance().getRegisteredChildren((IContainer)parents[i2]);
                    }
                    catch (Exception ex) {
                        LoggedOperation.reportError((String)SVNTeamUIPlugin.instance().getResource("Error.CheckCache"), (Throwable)ex);
                    }
                    ++i2;
                }
            }
            this.fireTeamResourceChange((ISubscriberChangeEvent[])SubscriberChangeEvent.asSyncChangedDeltas((Subscriber)this, (IResource[])refreshSet));
        }
    }

    protected IResource[] findChanges(IResource[] resources, int depth, IProgressMonitor monitor, IOperationWrapperFactory operationWrapperFactory) {
        final ArrayList changes = new ArrayList();
        final IRemoteStatusOperation rStatusOp = this.getStatusOperation(resources, depth);
        if (rStatusOp != null) {
            CompositeOperation op = new CompositeOperation(rStatusOp.getId());
            op.add((IActionOperation)rStatusOp);
            op.add((IActionOperation)new AbstractNonLockingOperation("Operation.FetchChanges"){

                protected void runImpl(IProgressMonitor monitor) throws Exception {
                    Status[] statuses = rStatusOp.getStatuses();
                    if (statuses != null) {
                        int i = 0;
                        while (i < statuses.length && !monitor.isCanceled()) {
                            IResourceChange resourceChange = AbstractSVNSubscriber.this.handleResourceChange((IRemoteStorage)SVNRemoteStorage.instance(), rStatusOp, statuses[i]);
                            if (resourceChange != null) {
                                ProgressMonitorUtility.setTaskInfo((IProgressMonitor)monitor, (IActionOperation)this, (String)resourceChange.getResource().getFullPath().toString());
                                ProgressMonitorUtility.progress((IProgressMonitor)monitor, (int)i, (int)statuses.length);
                                AbstractSVNSubscriber.this.statusCache.setBytes(resourceChange.getResource(), SVNRemoteStorage.instance().resourceChangeAsBytes(resourceChange));
                                changes.add(resourceChange.getResource());
                            }
                            ++i;
                        }
                    }
                }
            }, new IActionOperation[]{rStatusOp});
            UIMonitorUtility.doTaskExternal((IActionOperation)op, monitor, operationWrapperFactory);
        }
        return changes.toArray(new IResource[changes.size()]);
    }

    protected abstract IResourceChange handleResourceChange(IRemoteStorage var1, IRemoteStatusOperation var2, Status var3);

    protected abstract SyncInfo getSVNSyncInfo(IRemoteStorage var1, ILocalResource var2, IResourceChange var3);

    protected abstract IRemoteStatusOperation getStatusOperation(IResource[] var1, int var2);

    public class UpdateStatusOperation
    extends AbstractNonLockingOperation {
        protected IResource[] resources;
        protected int depth;

        public UpdateStatusOperation(IResource[] resources, int depth) {
            super("Operation.UpdateStatus");
            this.resources = resources;
            this.depth = depth;
        }

        protected void runImpl(IProgressMonitor monitor) throws Exception {
            Map project2Resources = SVNUtility.splitWorkingCopies((IResource[])this.resources);
            Iterator it = project2Resources.values().iterator();
            while (it.hasNext() && !monitor.isCanceled()) {
                List entry = (List)it.next();
                IResource[] wcResources = entry.toArray(new IResource[entry.size()]);
                this.protectStep(new IUnprotectedOperation(this, wcResources){
                    final /* synthetic */ UpdateStatusOperation this$1;
                    private final /* synthetic */ IResource[] val$wcResources;
                    {
                        this.this$1 = updateStatusOperation;
                        this.val$wcResources = iResourceArray;
                    }

                    public void run(IProgressMonitor monitor) throws Exception {
                        UpdateStatusOperation.access$1(this.this$1).resourcesStateChangedImpl(UpdateStatusOperation.access$1(this.this$1).findChanges(this.val$wcResources, this.this$1.depth, monitor, new DefaultOperationWrapperFactory(this){
                            final /* synthetic */ 1 this$2;
                            {
                                this.this$2 = var1_1;
                            }

                            protected IActionOperation wrappedOperation(IActionOperation operation) {
                                return new LoggedOperation(this, operation){
                                    final /* synthetic */ 2 this$3;
                                    {
                                        this.this$3 = var1_1;
                                        super($anonymous0);
                                    }

                                    protected void handleError(IStatus errorStatus) {
                                        UpdateStatusOperation.access$0(1.access$0(2.access$0(this.this$3)), errorStatus);
                                    }
                                };
                            }

                            static /* synthetic */ 1 access$0(2 var0) {
                                return var0.this$2;
                            }
                        }));
                    }

                    static /* synthetic */ UpdateStatusOperation access$0(1 var0) {
                        return var0.this$1;
                    }
                }, monitor, project2Resources.size());
            }
        }

        static /* synthetic */ void access$0(UpdateStatusOperation updateStatusOperation, IStatus iStatus) {
            updateStatusOperation.reportStatus(iStatus);
        }

        static /* synthetic */ AbstractSVNSubscriber access$1(UpdateStatusOperation updateStatusOperation) {
            return updateStatusOperation.AbstractSVNSubscriber.this;
        }
    }
}

