/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui.synchronize;

import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.variants.IResourceVariant;
import org.eclipse.team.core.variants.IResourceVariantComparator;
import org.polarion.team.svn.core.IStateFilter;
import org.polarion.team.svn.core.resource.ILocalFolder;
import org.polarion.team.svn.core.resource.ILocalResource;
import org.polarion.team.svn.ui.synchronize.variant.BaseFileVariant;
import org.polarion.team.svn.ui.synchronize.variant.BaseFolderVariant;
import org.polarion.team.svn.ui.synchronize.variant.RemoteFileVariant;
import org.polarion.team.svn.ui.synchronize.variant.RemoteFolderVariant;
import org.polarion.team.svn.ui.synchronize.variant.VirtualRemoteFileVariant;
import org.polarion.team.svn.ui.synchronize.variant.VirtualRemoteFolderVariant;

public abstract class AbstractSVNSyncInfo
extends SyncInfo {
    protected ILocalResource local;

    public AbstractSVNSyncInfo(ILocalResource local, ILocalResource remote, IResourceVariantComparator comparator) {
        this(local, AbstractSVNSyncInfo.makeBaseVariant(local), AbstractSVNSyncInfo.makeRemoteVariant(local, remote), comparator);
    }

    protected AbstractSVNSyncInfo(ILocalResource local, IResourceVariant base, IResourceVariant remote, IResourceVariantComparator comparator) {
        super(local.getResource(), base, remote, comparator);
        this.local = local;
    }

    public ILocalResource getLocalResource() {
        return this.local;
    }

    protected boolean isLinked(String kind, int mask) {
        return IStateFilter.SF_LINKED.accept(this.getLocal(), kind, mask);
    }

    protected boolean isReplaced(String kind, int mask) {
        return IStateFilter.SF_PREREPLACEDREPLACED.accept(this.getLocal(), kind, mask);
    }

    protected boolean isDeleted(String kind, int mask) {
        return IStateFilter.SF_DELETED.accept(this.getLocal(), kind, mask);
    }

    protected boolean isModified(String kind, int mask) {
        return IStateFilter.SF_MODIFIED.accept(this.getLocal(), kind, mask);
    }

    protected boolean isConflicted(String kind, int mask) {
        return IStateFilter.SF_CONFLICTING.accept(this.getLocal(), kind, mask);
    }

    protected boolean isNotModified(String kind, int mask) {
        return IStateFilter.SF_NOTMODIFIED.accept(this.getLocal(), kind, mask);
    }

    protected boolean isNonVersioned(String kind, int mask) {
        return IStateFilter.SF_NONVERSIONED.accept(this.getLocal(), kind, mask);
    }

    protected boolean isNotExists(String kind, int mask) {
        return IStateFilter.SF_NOTEXISTS.accept(this.getLocal(), kind, mask);
    }

    protected boolean isIgnored(String kind, int mask) {
        return IStateFilter.SF_IGNORED.accept(this.getLocal(), kind, mask);
    }

    protected boolean isAdded(String kind, int mask) {
        return IStateFilter.SF_ADDED.accept(this.getLocal(), kind, mask);
    }

    protected static IResourceVariant makeBaseVariant(ILocalResource local) {
        if (local == null) {
            return null;
        }
        return local instanceof ILocalFolder ? new BaseFolderVariant(local) : new BaseFileVariant(local);
    }

    protected static IResourceVariant makeRemoteVariant(ILocalResource local, ILocalResource remote) {
        if (remote == null) {
            return local instanceof ILocalFolder ? new VirtualRemoteFolderVariant(local) : new VirtualRemoteFileVariant(local);
        }
        return remote instanceof ILocalFolder ? new RemoteFolderVariant(remote) : new RemoteFileVariant(remote);
    }
}

