/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui.synchronize.action;

import org.eclipse.core.resources.IResource;
import org.polarion.team.svn.core.IStateFilter;

public interface ISyncStateFilter
extends IStateFilter {
    public static final ISyncStateFilter SF_ONREPOSITORY = new ISyncStateFilter(){

        public boolean accept(IResource resource, String state, int mask) {
            return IStateFilter.SF_ONREPOSITORY.accept(resource, state, mask);
        }

        public boolean acceptRemote(IResource resource, String state, int mask) {
            return !IStateFilter.SF_NOTEXISTS.accept(resource, state, mask);
        }

        public boolean allowsRecursion(IResource resource, String state, int mask) {
            return true;
        }
    };
    public static final ISyncStateFilter SF_OVERRIDE = new ISyncStateFilter(){

        public boolean accept(IResource resource, String state, int mask) {
            return IStateFilter.SF_REVERTABLE.accept(resource, state, mask) || IStateFilter.SF_NONVERSIONED.accept(resource, state, mask);
        }

        public boolean acceptRemote(IResource resource, String state, int mask) {
            return !IStateFilter.SF_NOTEXISTS.accept(resource, state, mask);
        }

        public boolean allowsRecursion(IResource resource, String state, int mask) {
            return true;
        }
    };

    public boolean acceptRemote(IResource var1, String var2, int var3);

    public static class StateFilterWrapper
    implements ISyncStateFilter {
        protected IStateFilter filter;

        public StateFilterWrapper(IStateFilter filter) {
            this.filter = filter;
        }

        public boolean accept(IResource resource, String state, int mask) {
            return this.filter.accept(resource, state, mask);
        }

        public boolean acceptRemote(IResource resource, String state, int mask) {
            return false;
        }

        public boolean allowsRecursion(IResource resource, String state, int mask) {
            return true;
        }
    }
}

