/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui.synchronize.merge;

import org.eclipse.core.resources.IResource;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.polarion.team.svn.core.client.Revision;
import org.polarion.team.svn.core.client.Status;
import org.polarion.team.svn.core.operation.local.IRemoteStatusOperation;
import org.polarion.team.svn.core.operation.local.MergeStatusOperation;
import org.polarion.team.svn.core.resource.IChangeStateProvider;
import org.polarion.team.svn.core.resource.ICommentProvider;
import org.polarion.team.svn.core.resource.ILocalResource;
import org.polarion.team.svn.core.resource.IRemoteStorage;
import org.polarion.team.svn.core.resource.IRepositoryResource;
import org.polarion.team.svn.core.resource.IResourceChange;
import org.polarion.team.svn.core.svnstorage.SVNRemoteStorage;
import org.polarion.team.svn.core.utility.FileUtility;
import org.polarion.team.svn.core.utility.SVNUtility;
import org.polarion.team.svn.ui.synchronize.AbstractSVNSubscriber;
import org.polarion.team.svn.ui.synchronize.merge.MergeScope;
import org.polarion.team.svn.ui.synchronize.merge.MergeSyncInfo;

public class MergeSubscriber
extends AbstractSVNSubscriber {
    private static MergeSubscriber instance = null;
    protected MergeScope scope;
    protected MergeStatusOperation mergeStatusOp;

    public static synchronized MergeSubscriber instance() {
        if (instance == null) {
            instance = new MergeSubscriber();
        }
        return instance;
    }

    public IRepositoryResource[] getRemoteOriginators(IResource[] resources) {
        SVNRemoteStorage storage = SVNRemoteStorage.instance();
        IRepositoryResource[] retVal = new IRepositoryResource[resources.length];
        int i = 0;
        while (i < resources.length) {
            IResourceChange remoteStatus = storage.resourceChangeFromBytes(this.statusCache.getBytes(resources[i]));
            retVal[i] = remoteStatus.getOriginator();
            ++i;
        }
        return retVal;
    }

    public MergeScope getMergeScope() {
        return this.scope;
    }

    public void setMergeScope(MergeScope scope) {
        this.scope = scope;
    }

    protected SyncInfo getSVNSyncInfo(IRemoteStorage storage, ILocalResource localStatus, IResourceChange remoteStatus) {
        return new MergeSyncInfo(localStatus, (ILocalResource)remoteStatus, this.getResourceComparator());
    }

    protected IRemoteStatusOperation getStatusOperation(IResource[] resources, int depth) {
        this.mergeStatusOp = this.scope == null ? null : new MergeStatusOperation(this.scope.getMergeSet());
        return this.mergeStatusOp;
    }

    protected IResourceChange handleResourceChange(IRemoteStorage storage, IRemoteStatusOperation rStatusOp, final Status current) {
        IChangeStateProvider provider = new IChangeStateProvider(){

            public long getChangeDate() {
                return current.lastChangedDate;
            }

            public String getChangeAuthor() {
                return current.lastCommitAuthor;
            }

            public Revision.Number getChangeRevision() {
                return current.lastChangedRevision == -1L ? null : (Revision.Number)Revision.getInstance((long)current.lastChangedRevision);
            }

            public int getTextChangeType() {
                return current.textStatus;
            }

            public int getPropertiesChangeType() {
                return current.propStatus;
            }

            public int getNodeKind() {
                int kind = SVNUtility.getNodeKind((String)current.path, (int)current.reposKind, (boolean)true);
                return kind == 0 ? SVNUtility.getNodeKind((String)current.path, (int)current.nodeKind, (boolean)false) : kind;
            }

            public String getLocalPath() {
                return current.path;
            }

            public String getComment() {
                return null;
            }

            public boolean isCopied() {
                return false;
            }

            public boolean isSwitched() {
                return false;
            }

            public IResource getExact(IResource[] set) {
                return FileUtility.selectOneOf((IResource[])MergeSubscriber.this.scope.getRoots(), (IResource[])set);
            }
        };
        if (provider.getNodeKind() == 0) {
            return null;
        }
        IResourceChange resourceChange = storage.asResourceChange(provider);
        if (resourceChange == null || resourceChange.getRevision() == -1L) {
            return null;
        }
        IRepositoryResource originator = this.scope.getMergeSet().from[0];
        originator = provider.getNodeKind() == 2 ? originator.asRepositoryContainer(current.url, false) : originator.asRepositoryFile(current.url, false);
        originator.setSelectedRevision(Revision.getInstance((long)(current.textStatus == 4 ? current.lastChangedRevision - 1L : current.lastChangedRevision)));
        resourceChange.setOriginator(originator);
        resourceChange.setCommentProvider(new ICommentProvider(){

            public String getComment(IResource resource, Revision rev, Revision peg) {
                return current.lockComment;
            }
        });
        return resourceChange;
    }

    private MergeSubscriber() {
    }
}

