/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui.synchronize.merge.action;

import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.team.core.synchronize.FastSyncInfoFilter;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.polarion.team.svn.core.IStateFilter;
import org.polarion.team.svn.core.operation.CompositeOperation;
import org.polarion.team.svn.core.operation.IActionOperation;
import org.polarion.team.svn.core.operation.local.ClearLocalStatusesOperation;
import org.polarion.team.svn.core.operation.local.GetRemoteContentsOperation;
import org.polarion.team.svn.core.operation.local.RefreshResourcesOperation;
import org.polarion.team.svn.core.operation.local.RemoveNonVersionedResourcesOperation;
import org.polarion.team.svn.core.operation.local.RestoreProjectMetaOperation;
import org.polarion.team.svn.core.operation.local.RevertOperation;
import org.polarion.team.svn.core.operation.local.SaveProjectMetaOperation;
import org.polarion.team.svn.core.operation.local.UpdateOperation;
import org.polarion.team.svn.core.resource.IRepositoryContainer;
import org.polarion.team.svn.core.resource.IRepositoryResource;
import org.polarion.team.svn.core.resource.IRepositoryRoot;
import org.polarion.team.svn.core.utility.FileUtility;
import org.polarion.team.svn.ui.dialog.DefaultDialog;
import org.polarion.team.svn.ui.operation.ClearMergeStatusesOperation;
import org.polarion.team.svn.ui.panel.local.OverrideResourcesPanel;
import org.polarion.team.svn.ui.synchronize.action.AbstractSynchronizeModelAction;
import org.polarion.team.svn.ui.synchronize.action.ISyncStateFilter;
import org.polarion.team.svn.ui.synchronize.merge.MergeSubscriber;

public class OverrideAndUpdateAction
extends AbstractSynchronizeModelAction {
    public OverrideAndUpdateAction(String text, ISynchronizePageConfiguration configuration) {
        super(text, configuration);
    }

    protected FastSyncInfoFilter getSyncInfoFilter() {
        return new FastSyncInfoFilter.SyncInfoDirectionFilter(new int[]{12, 8});
    }

    protected IActionOperation execute(final AbstractSynchronizeModelAction.FilteredSynchronizeModelOperation operation) {
        final IResource[][] resources = new IResource[1][];
        operation.getShell().getDisplay().syncExec(new Runnable(){

            public void run() {
                IResource[] obstructedResources = operation.getSelectedResources(IStateFilter.SF_OBSTRUCTED);
                obstructedResources = FileUtility.addOperableParents((IResource[])obstructedResources, (IStateFilter)IStateFilter.SF_OBSTRUCTED);
                HashSet<IResource> allResources = new HashSet<IResource>(Arrays.asList(obstructedResources));
                IResource[] changedResources = operation.getSelectedResources(ISyncStateFilter.SF_OVERRIDE);
                changedResources = FileUtility.addOperableParents((IResource[])changedResources, (IStateFilter)IStateFilter.SF_NOTONREPOSITORY);
                allResources.addAll(Arrays.asList(changedResources));
                IResource[] fullSet = allResources.toArray(new IResource[allResources.size()]);
                OverrideResourcesPanel panel = new OverrideResourcesPanel(fullSet, fullSet, 1);
                DefaultDialog dialog = new DefaultDialog(operation.getShell(), panel);
                if (dialog.open() == 0) {
                    resources[0] = panel.getSelectedResources();
                }
            }
        });
        if (resources[0] == null) {
            return null;
        }
        CompositeOperation op = new CompositeOperation("Operation.MOverrideAndUpdate");
        SaveProjectMetaOperation saveOp = new SaveProjectMetaOperation(resources[0]);
        op.add((IActionOperation)saveOp);
        RevertOperation revertOp = new RevertOperation(FileUtility.getResourcesRecursive((IResource[])resources[0], (IStateFilter)IStateFilter.SF_REVERTABLE, (int)0), true);
        RemoveNonVersionedResourcesOperation removeNonVersionedResourcesOp = new RemoveNonVersionedResourcesOperation(resources[0], true);
        op.add((IActionOperation)revertOp);
        op.add((IActionOperation)new ClearLocalStatusesOperation(resources[0]));
        op.add((IActionOperation)removeNonVersionedResourcesOp);
        RevertOperation revertOp1 = new RevertOperation(FileUtility.getResourcesRecursive((IResource[])resources[0], (IStateFilter)IStateFilter.SF_OBSTRUCTED, (int)0), true);
        op.add((IActionOperation)revertOp1);
        op.add((IActionOperation)new ClearLocalStatusesOperation(resources[0]));
        op.add((IActionOperation)new UpdateOperation(FileUtility.getResourcesRecursive((IResource[])resources[0], (IStateFilter)IStateFilter.SF_OBSTRUCTED, (int)0), true));
        CompositeOperation getRemoteContentOp = new CompositeOperation("Operation.MGetRemoteContent");
        IRepositoryResource fromProject = MergeSubscriber.instance().getMergeScope().getMergeSet().from[0];
        IRepositoryRoot fromRoot = (IRepositoryRoot)fromProject.getRoot();
        int i = 0;
        while (i < resources[0].length) {
            IResource res = resources[0][i];
            String path = String.valueOf(fromProject.getUrl()) + "/" + res.getProjectRelativePath().toString();
            IRepositoryContainer from = res instanceof IContainer ? fromRoot.asRepositoryContainer(path, false) : fromRoot.asRepositoryFile(path, false);
            getRemoteContentOp.add((IActionOperation)new GetRemoteContentsOperation(res, (IRepositoryResource)from));
            ++i;
        }
        op.add((IActionOperation)getRemoteContentOp, new IActionOperation[]{revertOp, revertOp1, removeNonVersionedResourcesOp});
        op.add((IActionOperation)new RestoreProjectMetaOperation(saveOp));
        op.add((IActionOperation)new ClearMergeStatusesOperation(resources[0]));
        op.add((IActionOperation)new RefreshResourcesOperation(resources[0]));
        return op;
    }
}

