/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui.synchronize.update.action;

import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.synchronize.FastSyncInfoFilter;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.polarion.team.svn.core.IStateFilter;
import org.polarion.team.svn.core.operation.AbstractNonLockingOperation;
import org.polarion.team.svn.core.operation.CompositeOperation;
import org.polarion.team.svn.core.operation.IActionOperation;
import org.polarion.team.svn.core.operation.IRevisionProvider;
import org.polarion.team.svn.core.operation.local.AddToSVNWithPropertiesOperation;
import org.polarion.team.svn.core.operation.local.ClearLocalStatusesOperation;
import org.polarion.team.svn.core.operation.local.CommitOperation;
import org.polarion.team.svn.core.operation.local.MarkAsMergedOperation;
import org.polarion.team.svn.core.operation.local.RefreshResourcesOperation;
import org.polarion.team.svn.core.resource.IResourceProvider;
import org.polarion.team.svn.core.utility.FileUtility;
import org.polarion.team.svn.ui.dialog.NotifyNodeKindChangedDialog;
import org.polarion.team.svn.ui.extension.ExtensionsManager;
import org.polarion.team.svn.ui.extension.factory.ICommitDialog;
import org.polarion.team.svn.ui.operation.ClearUpdateStatusesOperation;
import org.polarion.team.svn.ui.panel.local.CommitPanel;
import org.polarion.team.svn.ui.synchronize.SVNChangeSetCapability;
import org.polarion.team.svn.ui.synchronize.action.AbstractSynchronizeModelAction;
import org.polarion.team.svn.ui.synchronize.action.ISyncStateFilter;
import org.polarion.team.svn.ui.synchronize.update.UpdateSyncInfo;
import org.polarion.team.svn.ui.utility.UnacceptableOperationNotificator;

public class OverrideAndCommitAction
extends AbstractSynchronizeModelAction {
    public static final IStateFilter SF_NEW = new IStateFilter(){

        public boolean accept(IResource resource, String state, int mask) {
            return state == "New";
        }

        public boolean allowsRecursion(IResource resource, String state, int mask) {
            return true;
        }
    };

    public OverrideAndCommitAction(String text, ISynchronizePageConfiguration configuration) {
        super(text, configuration);
    }

    protected FastSyncInfoFilter getSyncInfoFilter() {
        return new FastSyncInfoFilter.SyncInfoDirectionFilter(new int[]{12}){

            public boolean select(SyncInfo info) {
                if (super.select(info)) {
                    UpdateSyncInfo sync = (UpdateSyncInfo)info;
                    return !IStateFilter.SF_OBSTRUCTED.accept(sync.getLocal(), sync.getLocalResource().getStatus(), sync.getLocalResource().getChangeMask());
                }
                return false;
            }
        };
    }

    protected IActionOperation execute(final AbstractSynchronizeModelAction.FilteredSynchronizeModelOperation operation) {
        final String[] msg = new String[1];
        final boolean[] keepLocks = new boolean[1];
        final IResource[][] resources = new IResource[1][];
        operation.getShell().getDisplay().syncExec(new Runnable(){

            public void run() {
                IResource[] changedResources = operation.getSelectedResources(ISyncStateFilter.SF_OVERRIDE);
                IResource[] overrideResources = UnacceptableOperationNotificator.shrinkResourcesWithNotOnRespositoryParents(operation.getShell(), changedResources);
                if (overrideResources != null && overrideResources.length > 0) {
                    overrideResources = FileUtility.addOperableParents((IResource[])overrideResources, (IStateFilter)IStateFilter.SF_NOTONREPOSITORY);
                    HashSet<IResource> allResourcesSet = new HashSet<IResource>(Arrays.asList(overrideResources));
                    String proposedComment = SVNChangeSetCapability.getProposedComment(overrideResources);
                    CommitPanel commitPanel = new CommitPanel(overrideResources, overrideResources, 1, proposedComment);
                    ICommitDialog commitDialog = ExtensionsManager.getInstance().getCurrentCommitFactory().getCommitDialog(operation.getShell(), allResourcesSet, commitPanel);
                    if (commitDialog.open() == 0) {
                        resources[0] = commitPanel.getSelectedResources().length == 0 ? null : commitPanel.getSelectedResources();
                        msg[0] = commitDialog.getMessage();
                        keepLocks[0] = commitPanel.getKeepLocks();
                    }
                }
            }
        });
        if (resources[0] == null) {
            return null;
        }
        CompositeOperation op = new CompositeOperation("Operation.UOverrideAndCommit");
        final MarkAsMergedOperation mergeOp = new MarkAsMergedOperation(resources[0], true, msg[0], keepLocks[0]);
        op.add((IActionOperation)mergeOp);
        final IResource[] addition = FileUtility.getResourcesRecursive((IResource[])resources[0], (IStateFilter)SF_NEW);
        if (addition.length != 0) {
            IResourceProvider additionProvider = new IResourceProvider(){
                protected IResource[] result;

                public IResource[] getResources() {
                    if (this.result == null) {
                        HashSet<IResource> tAdd = new HashSet<IResource>(Arrays.asList(addition));
                        IResource[] restricted = mergeOp.getHavingDifferentNodeKind();
                        int i = 0;
                        while (i < restricted.length) {
                            if (restricted[i] instanceof IContainer) {
                                IResource[] restrictedChildren = FileUtility.getResourcesRecursive((IResource[])resources[0], (IStateFilter)IStateFilter.SF_ALL);
                                tAdd.removeAll(Arrays.asList(restrictedChildren));
                            } else {
                                tAdd.remove(restricted[i]);
                            }
                            ++i;
                        }
                        this.result = tAdd.toArray(new IResource[tAdd.size()]);
                    }
                    return this.result;
                }
            };
            op.add((IActionOperation)new AddToSVNWithPropertiesOperation(additionProvider, false), new IActionOperation[]{mergeOp});
            op.add((IActionOperation)new ClearLocalStatusesOperation(additionProvider));
        }
        CommitOperation mainOp = new CommitOperation((IResourceProvider)mergeOp, msg[0], true, keepLocks[0]);
        IActionOperation[] dependsOn = new IActionOperation[]{mergeOp};
        op.add((IActionOperation)mainOp, dependsOn);
        op.add((IActionOperation)new AbstractNonLockingOperation("Operation.UNodeKindChanged"){

            protected void runImpl(IProgressMonitor monitor) throws Exception {
                IResource[] diffNodeKind = mergeOp.getHavingDifferentNodeKind();
                if (diffNodeKind.length > 0) {
                    operation.getShell().getDisplay().syncExec(new Runnable(this, operation, diffNodeKind){
                        final /* synthetic */ 5 this$1;
                        private final /* synthetic */ AbstractSynchronizeModelAction.FilteredSynchronizeModelOperation val$operation;
                        private final /* synthetic */ IResource[] val$diffNodeKind;
                        {
                            this.this$1 = var1_1;
                            this.val$operation = filteredSynchronizeModelOperation;
                            this.val$diffNodeKind = iResourceArray;
                        }

                        public void run() {
                            new NotifyNodeKindChangedDialog(this.val$operation.getShell(), this.val$diffNodeKind).open();
                        }
                    });
                }
            }
        });
        op.add((IActionOperation)new ClearUpdateStatusesOperation(resources[0]));
        op.add((IActionOperation)new RefreshResourcesOperation(resources[0]));
        ExtensionsManager.getInstance().getCurrentCommitFactory().performAfterCommitTasks(op, (IRevisionProvider)mainOp, dependsOn, operation.getPart());
        return op;
    }
}

