/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui.utility;

import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;

public class OverlayedImageDescriptor
extends CompositeImageDescriptor {
    public static int LEFT = 0;
    public static int RIGHT = 1;
    public static int CENTER_H = 3;
    public static int TOP = 0;
    public static int BOTTOM = 16;
    public static int CENTER_V = 48;
    public static int CENTER = CENTER_H | CENTER_V;
    protected Point size;
    protected Image base;
    protected ImageDescriptor overlay;
    protected int where;

    public OverlayedImageDescriptor(Image base, ImageDescriptor overlay, Point size, int where) {
        this.base = base;
        this.size = size;
        this.overlay = overlay;
        this.where = where;
    }

    protected void drawCompositeImage(int width, int height) {
        this.drawImage(this.base.getImageData(), 0, 0);
        ImageData overlayData = this.overlay.getImageData();
        int x = 0;
        int y = 0;
        if ((this.where & CENTER_H) == CENTER_H) {
            x = (this.size.x - overlayData.width) / 2;
        } else if ((this.where & RIGHT) == RIGHT) {
            x = this.size.x - overlayData.width;
        }
        if ((this.where & CENTER_V) == CENTER_V) {
            y = (this.size.y - overlayData.height) / 2;
        } else if ((this.where & BOTTOM) == BOTTOM) {
            y = this.size.y - overlayData.height;
        }
        this.drawImage(overlayData, x, y);
    }

    protected Point getSize() {
        return this.size;
    }

    public int hashCode() {
        return this.base.hashCode() ^ this.overlay.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof OverlayedImageDescriptor) {
            OverlayedImageDescriptor other = (OverlayedImageDescriptor)((Object)obj);
            return this.base.equals((Object)other.base) && this.overlay.equals(other.overlay) && this.where == other.where && this.size.equals((Object)other.size);
        }
        return super.equals(obj);
    }
}

