/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui.verifier;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.polarion.team.svn.ui.SVNTeamUIPlugin;
import org.polarion.team.svn.ui.verifier.IVerifierListener;

public abstract class AbstractVerifier {
    protected List listeners = new ArrayList();
    protected boolean filledRight = false;
    protected boolean hasWarning = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addVerifierListener(IVerifierListener listener) {
        List list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeVerifierListener(IVerifierListener listener) {
        List list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    public boolean isFilledRight() {
        return this.filledRight;
    }

    public boolean hasWarning() {
        return this.hasWarning;
    }

    public boolean verify(Control input) {
        String msg = this.getErrorMessage(input);
        if (msg != null) {
            this.fireError(msg);
            return false;
        }
        msg = this.getWarningMessage(input);
        if (msg != null) {
            this.fireWarning(msg);
        } else {
            this.fireOk();
        }
        return true;
    }

    protected abstract String getErrorMessage(Control var1);

    protected abstract String getWarningMessage(Control var1);

    protected String getText(Control input) {
        if (input instanceof Text) {
            return ((Text)input).getText();
        }
        if (input instanceof Combo) {
            return ((Combo)input).getText();
        }
        String message = SVNTeamUIPlugin.instance().getResource("Verifier.Abstract");
        throw new RuntimeException(MessageFormat.format(message, this.getClass().getName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireError(String errorReason) {
        this.filledRight = false;
        this.hasWarning = false;
        Object[] listeners = null;
        List list = this.listeners;
        synchronized (list) {
            listeners = this.listeners.toArray();
        }
        int i = listeners.length - 1;
        while (i >= 0) {
            ((IVerifierListener)listeners[i]).hasError(errorReason);
            --i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireWarning(String warningReason) {
        this.filledRight = true;
        this.hasWarning = true;
        Object[] listeners = null;
        List list = this.listeners;
        synchronized (list) {
            listeners = this.listeners.toArray();
        }
        int i = listeners.length - 1;
        while (i >= 0) {
            ((IVerifierListener)listeners[i]).hasWarning(warningReason);
            --i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireOk() {
        this.filledRight = true;
        this.hasWarning = false;
        Object[] listeners = null;
        List list = this.listeners;
        synchronized (list) {
            listeners = this.listeners.toArray();
        }
        int i = listeners.length - 1;
        while (i >= 0) {
            ((IVerifierListener)listeners[i]).hasNoError();
            --i;
        }
    }
}

