/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui.verifier;

import java.io.File;
import java.text.MessageFormat;
import org.eclipse.swt.widgets.Control;
import org.polarion.team.svn.ui.SVNTeamUIPlugin;
import org.polarion.team.svn.ui.verifier.AbstractFormattedVerifier;

public class ExistingResourceVerifier
extends AbstractFormattedVerifier {
    protected static String ERROR_MESSAGE_DOES_NOT_EXIST;
    protected static String ERROR_MESSAGE_IS_NOT_A_FILE;
    protected static String ERROR_MESSAGE_IS_NOT_A_DIRECTORY;
    protected boolean checkNodeType;
    protected boolean files;

    public ExistingResourceVerifier(String fieldName) {
        super(fieldName);
        this.init();
        this.checkNodeType = false;
    }

    public ExistingResourceVerifier(String fieldName, boolean files) {
        super(fieldName);
        this.init();
        this.files = files;
        this.checkNodeType = true;
    }

    protected String getErrorMessageImpl(Control input) {
        File currentFile = new File(this.getText(input));
        if (!currentFile.exists()) {
            return ERROR_MESSAGE_DOES_NOT_EXIST;
        }
        if (this.checkNodeType && this.files && !currentFile.isFile()) {
            return ERROR_MESSAGE_IS_NOT_A_FILE;
        }
        if (this.checkNodeType && !this.files && !currentFile.isDirectory()) {
            return ERROR_MESSAGE_IS_NOT_A_DIRECTORY;
        }
        return null;
    }

    protected String getWarningMessageImpl(Control input) {
        return null;
    }

    private void init() {
        ERROR_MESSAGE_DOES_NOT_EXIST = SVNTeamUIPlugin.instance().getResource("Verifier.ExistingResource.NotExists");
        ERROR_MESSAGE_DOES_NOT_EXIST = MessageFormat.format(ERROR_MESSAGE_DOES_NOT_EXIST, "$FIELD_NAME$");
        ERROR_MESSAGE_IS_NOT_A_FILE = SVNTeamUIPlugin.instance().getResource("Verifier.ExistingResource.IsNotAFile");
        ERROR_MESSAGE_IS_NOT_A_FILE = MessageFormat.format(ERROR_MESSAGE_IS_NOT_A_FILE, "$FIELD_NAME$");
        ERROR_MESSAGE_IS_NOT_A_DIRECTORY = SVNTeamUIPlugin.instance().getResource("Verifier.ExistingResource.IsNotADir");
        ERROR_MESSAGE_IS_NOT_A_DIRECTORY = MessageFormat.format(ERROR_MESSAGE_IS_NOT_A_DIRECTORY, "$FIELD_NAME$");
    }
}

