/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui.verifier;

import java.text.MessageFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.swt.widgets.Control;
import org.polarion.team.svn.ui.SVNTeamUIPlugin;
import org.polarion.team.svn.ui.verifier.AbstractFormattedVerifier;

public class PropertyNameVerifier
extends AbstractFormattedVerifier {
    protected static String ERROR_MESSAGE_LETTER;
    protected static String ERROR_MESSAGE_SYMBOLS;

    public PropertyNameVerifier(String fieldName) {
        super(fieldName);
        ERROR_MESSAGE_LETTER = SVNTeamUIPlugin.instance().getResource("Verifier.PropertyName.Letter");
        ERROR_MESSAGE_LETTER = MessageFormat.format(ERROR_MESSAGE_LETTER, "$FIELD_NAME$");
        ERROR_MESSAGE_SYMBOLS = SVNTeamUIPlugin.instance().getResource("Verifier.PropertyName.Symbols");
        ERROR_MESSAGE_SYMBOLS = MessageFormat.format(ERROR_MESSAGE_SYMBOLS, "$FIELD_NAME$");
    }

    protected String getErrorMessageImpl(Control input) {
        String property = this.getText(input);
        if (property.trim().length() == 0) {
            return null;
        }
        Pattern pattern = Pattern.compile("[a-zA-Z].*");
        Matcher matcher = pattern.matcher(property);
        if (!matcher.matches()) {
            return ERROR_MESSAGE_LETTER;
        }
        pattern = Pattern.compile("[a-zA-Z0-9:\\-_.]*");
        if (!pattern.matcher(property).matches()) {
            return ERROR_MESSAGE_SYMBOLS;
        }
        return null;
    }

    protected String getWarningMessageImpl(Control input) {
        return null;
    }
}

