/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui.verifier;

import java.text.MessageFormat;
import org.eclipse.swt.widgets.Control;
import org.polarion.team.svn.ui.SVNTeamUIPlugin;
import org.polarion.team.svn.ui.verifier.AbstractFormattedVerifier;

public class ResourceNameVerifier
extends AbstractFormattedVerifier {
    protected static String ERROR_MESSAGE;
    protected boolean allowMultipart;

    public ResourceNameVerifier(String fieldName, boolean allowMultipart) {
        super(fieldName);
        ERROR_MESSAGE = SVNTeamUIPlugin.instance().getResource("Verifier.ResourceName");
        ERROR_MESSAGE = MessageFormat.format(ERROR_MESSAGE, "$FIELD_NAME$");
        this.allowMultipart = allowMultipart;
    }

    protected String getErrorMessageImpl(Control input) {
        String fileName = this.getText(input);
        if (fileName.length() != 0 && !this.isValidSegment(fileName)) {
            return ERROR_MESSAGE;
        }
        return null;
    }

    public boolean isValidSegment(String segment) {
        int size = segment.length();
        boolean nameCharactersFound = false;
        int i = 0;
        while (i < size) {
            char c = segment.charAt(i);
            if (c == '?' || c == '*' || c == ':' || !this.allowMultipart && (c == '\\' || c == '/')) {
                return false;
            }
            if (c != '\\' && c != '/' && c != '.') {
                nameCharactersFound = true;
            }
            ++i;
        }
        return nameCharactersFound;
    }

    protected String getWarningMessageImpl(Control input) {
        return null;
    }
}

