/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui.wizard;

import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.NewProjectAction;
import org.polarion.team.svn.core.IStateFilter;
import org.polarion.team.svn.core.client.ISVNClientWrapper;
import org.polarion.team.svn.core.client.ISVNProgressMonitor;
import org.polarion.team.svn.core.client.PropertyData;
import org.polarion.team.svn.core.operation.AbstractActionOperation;
import org.polarion.team.svn.core.operation.AbstractNonLockingOperation;
import org.polarion.team.svn.core.operation.CompositeOperation;
import org.polarion.team.svn.core.operation.IActionOperation;
import org.polarion.team.svn.core.operation.IResourcePropertyProvider;
import org.polarion.team.svn.core.operation.LoggedOperation;
import org.polarion.team.svn.core.operation.SVNProgressMonitor;
import org.polarion.team.svn.core.operation.file.CheckoutAsOperation;
import org.polarion.team.svn.core.operation.local.AddToSVNOperation;
import org.polarion.team.svn.core.operation.local.RefreshResourcesOperation;
import org.polarion.team.svn.core.operation.local.RestoreProjectMetaOperation;
import org.polarion.team.svn.core.operation.local.SaveProjectMetaOperation;
import org.polarion.team.svn.core.operation.local.property.SetPropertiesOperation;
import org.polarion.team.svn.core.operation.remote.LocateProjectsOperation;
import org.polarion.team.svn.core.resource.ILocalResource;
import org.polarion.team.svn.core.resource.IRepositoryContainer;
import org.polarion.team.svn.core.resource.IRepositoryLocation;
import org.polarion.team.svn.core.resource.IRepositoryResource;
import org.polarion.team.svn.core.resource.IRepositoryResourceProvider;
import org.polarion.team.svn.core.resource.IResourceProvider;
import org.polarion.team.svn.core.svnstorage.SVNRemoteStorage;
import org.polarion.team.svn.core.utility.FileUtility;
import org.polarion.team.svn.core.utility.SVNUtility;
import org.polarion.team.svn.ui.SVNTeamUIPlugin;
import org.polarion.team.svn.ui.action.remote.CheckoutAction;
import org.polarion.team.svn.ui.extension.ExtensionsManager;
import org.polarion.team.svn.ui.operation.GetRemoteFolderChildrenOperation;
import org.polarion.team.svn.ui.operation.MoveProjectsToWorkingSetOperation;
import org.polarion.team.svn.ui.operation.ObtainProjectNameOperation;
import org.polarion.team.svn.ui.utility.DefaultOperationWrapperFactory;
import org.polarion.team.svn.ui.utility.UIMonitorUtility;
import org.polarion.team.svn.ui.wizard.AbstractSVNWizard;
import org.polarion.team.svn.ui.wizard.CheckoutAsWizard;
import org.polarion.team.svn.ui.wizard.CheckoutProjectsWizard;
import org.polarion.team.svn.ui.wizard.checkoutas.CheckoutAsFolderPage;
import org.polarion.team.svn.ui.wizard.checkoutas.CheckoutMethodSelectionPage;
import org.polarion.team.svn.ui.wizard.checkoutas.MultipleCheckoutMethodSelectionPage;
import org.polarion.team.svn.ui.wizard.checkoutas.ProjectLocationSelectionPage;

public class CheckoutAsWizard
extends AbstractSVNWizard {
    public static final int SIZING_WIZARD_WIDTH = 570;
    public static final int SIZING_WIZARD_HEIGHT = 500;
    protected HashMap names2resources;
    protected IRepositoryResource[] resources;
    protected MultipleCheckoutMethodSelectionPage multipleMethodPage;
    protected CheckoutMethodSelectionPage methodSelectionPage;
    protected ProjectLocationSelectionPage locationSelectionPage;
    protected CheckoutAsFolderPage selectFolderPage;
    protected String projectName;
    protected boolean singleMode;
    protected IActionOperation priorOp;

    public CheckoutAsWizard(IRepositoryResource[] resources) {
        this(resources, null);
    }

    public CheckoutAsWizard(IRepositoryResource[] resources, IActionOperation priorOp) {
        this.setWindowTitle(SVNTeamUIPlugin.instance().getResource("CheckoutAsWizard.Title"));
        this.setForcePreviousAndNextButtons(true);
        this.resources = resources;
        this.singleMode = this.resources.length == 1;
        this.priorOp = priorOp;
    }

    public boolean isUseNewProjectWizard() {
        return this.methodSelectionPage == null ? false : this.methodSelectionPage.isUseNewProjectWizard();
    }

    public boolean isFindProjectsSelected() {
        return this.singleMode ? (this.methodSelectionPage == null ? false : this.methodSelectionPage.isFindProjectsSelected()) : (this.multipleMethodPage == null ? false : this.multipleMethodPage.isFindProjectsSelected());
    }

    public boolean isCheckoutAsFolderSelected() {
        return this.singleMode ? (this.methodSelectionPage == null ? false : this.methodSelectionPage.isCheckoutAsFolderSelected()) : (this.multipleMethodPage == null ? false : this.multipleMethodPage.isCheckoutAsFolderSelected());
    }

    public IContainer getTargetFolder() {
        return this.selectFolderPage.getTargetFolder();
    }

    public boolean isCheckoutRecursivelySelected() {
        return this.singleMode ? (this.methodSelectionPage == null ? true : this.methodSelectionPage.isCheckoutRecursivelySelected()) : (this.multipleMethodPage == null ? true : this.multipleMethodPage.isCheckoutRecursivelySelected());
    }

    public String getProjectName() {
        return this.methodSelectionPage == null ? this.resources[0].getName() : this.methodSelectionPage.getProjectName();
    }

    public String getLocation() {
        return this.isCheckoutAsFolderSelected() ? FileUtility.getWorkingCopyPath((IResource)this.getTargetFolder()) : this.locationSelectionPage.getLocation();
    }

    public String getWorkingSetName() {
        return this.locationSelectionPage.getWorkingSetName();
    }

    public void addPages() {
        if (this.resources.length == 1) {
            this.projectName = this.fetchProjectName();
            GetRemoteFolderChildrenOperation op = new GetRemoteFolderChildrenOperation((IRepositoryContainer)this.resources[0], false);
            UIMonitorUtility.doTaskBusy((IActionOperation)op, new DefaultOperationWrapperFactory(){

                public IActionOperation getLogged(IActionOperation operation) {
                    return new LoggedOperation(operation);
                }
            });
            boolean isEclipseProject = false;
            if (op.getExecutionState() == 0) {
                IRepositoryResource[] children = op.getChildren();
                int i = 0;
                while (i < children.length) {
                    if (children[i].getName().equals(".project")) {
                        isEclipseProject = true;
                        break;
                    }
                    ++i;
                }
            }
            this.methodSelectionPage = new CheckoutMethodSelectionPage(this.projectName, !isEclipseProject);
            this.addPage((IWizardPage)this.methodSelectionPage);
        } else {
            this.multipleMethodPage = new MultipleCheckoutMethodSelectionPage(this.resources);
            this.addPage((IWizardPage)this.multipleMethodPage);
        }
        this.selectFolderPage = new CheckoutAsFolderPage(this.resources);
        this.addPage((IWizardPage)this.selectFolderPage);
        this.locationSelectionPage = new ProjectLocationSelectionPage(this.resources.length > 1, null);
        this.addPage((IWizardPage)this.locationSelectionPage);
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.selectFolderPage) {
            return null;
        }
        if (page instanceof CheckoutMethodSelectionPage ? this.methodSelectionPage.isUseNewProjectWizard() || this.methodSelectionPage.isFindProjectsSelected() : page instanceof MultipleCheckoutMethodSelectionPage && this.multipleMethodPage.isFindProjectsSelected()) {
            return null;
        }
        if (!(page != this.methodSelectionPage && page != this.multipleMethodPage || this.isCheckoutAsFolderSelected())) {
            return super.getNextPage(super.getNextPage(page));
        }
        return super.getNextPage(page);
    }

    public boolean performFinish() {
        if (this.isFindProjectsSelected()) {
            CompositeOperation op = this.getLocateProjectsOperation(this.resources, this.isCheckoutRecursivelySelected());
            UIMonitorUtility.doTaskScheduledActive((IActionOperation)op);
        } else if (this.obtainNames()) {
            this.doCheckout(this.getLocation(), this.getProjectName(), this.isUseNewProjectWizard(), this.isCheckoutRecursivelySelected(), this.getWorkingSetName());
        }
        return true;
    }

    protected String fetchProjectName() {
        ObtainProjectNameOperation obtainOperation = new ObtainProjectNameOperation(this.resources);
        UIMonitorUtility.doTaskNowDefault((IActionOperation)obtainOperation, true);
        if (obtainOperation.getExecutionState() != 0) {
            return this.resources[0].getName();
        }
        this.names2resources = ExtensionsManager.getInstance().getCurrentCheckoutFactory().prepareName2resources(obtainOperation.getNames2Resources());
        return (String)this.names2resources.keySet().iterator().next();
    }

    protected boolean obtainNames() {
        if (this.names2resources == null) {
            ObtainProjectNameOperation obtainOperation = new ObtainProjectNameOperation(this.resources);
            UIMonitorUtility.doTaskNowDefault((IActionOperation)obtainOperation, true);
            if (obtainOperation.getExecutionState() != 0) {
                return false;
            }
            this.names2resources = ExtensionsManager.getInstance().getCurrentCheckoutFactory().prepareName2resources(obtainOperation.getNames2Resources());
        }
        return true;
    }

    protected void doCheckout(String location, String projectName, boolean useNewProjectWizard, boolean checkoutRecursive, String workingSetName) {
        if (!useNewProjectWizard && this.names2resources.keySet().size() == 1) {
            Object resource = this.names2resources.get(this.names2resources.keySet().iterator().next());
            this.names2resources.clear();
            this.names2resources.put(projectName, resource);
        }
        ArrayList operateResources = new ArrayList();
        if (useNewProjectWizard) {
            operateResources.add(this.names2resources.get(this.names2resources.keySet().iterator().next()));
        } else {
            operateResources = CheckoutAction.getOperateResources(this.names2resources, CheckoutAction.getResources2Names(this.names2resources), this.getShell(), location, !this.isCheckoutAsFolderSelected());
        }
        if (operateResources.size() > 0) {
            CompositeOperation op = null;
            if (useNewProjectWizard) {
                ProjectAdditionListener listener = new ProjectAdditionListener();
                ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)listener, 1);
                new NewProjectAction(PlatformUI.getWorkbench().getActiveWorkbenchWindow()).run();
                ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)listener);
                IProject selectedProject = listener.getProject();
                if (selectedProject != null) {
                    op = this.prepareForOne((IRepositoryResource)operateResources.get(0), selectedProject.getName(), FileUtility.getResourcePath((IResource)selectedProject).removeLastSegments(1).toString(), true, checkoutRecursive, workingSetName);
                }
            } else if (this.isCheckoutAsFolderSelected()) {
                HashMap resources2Names = new HashMap();
                if (this.names2resources != null) {
                    Iterator it = this.names2resources.entrySet().iterator();
                    while (it.hasNext()) {
                        Map.Entry entry = it.next();
                        resources2Names.put(entry.getValue(), entry.getKey());
                    }
                }
                Map mappings = this.getExternalsFolderNames(this.resources, resources2Names);
                IResource destinationRoot = ResourcesPlugin.getWorkspace().getRoot().findMember(this.selectFolderPage.getTargetFolder().getFullPath());
                SVNRemoteStorage storage = SVNRemoteStorage.instance();
                ILocalResource localDest = storage.asLocalResource(destinationRoot);
                op = localDest == null ? this.getCheckoutAsFolderOperationUnshared(this.getTargetFolder(), this.resources, mappings) : this.getCheckoutAsFolderOperation(this.getTargetFolder(), this.resources, mappings);
            } else if (this.singleMode) {
                op = this.prepareForOne((IRepositoryResource)operateResources.get(0), projectName, location, false, checkoutRecursive, workingSetName);
            } else {
                HashMap operateMap = new HashMap();
                Iterator iter = operateResources.iterator();
                while (iter.hasNext()) {
                    IRepositoryResource resource = (IRepositoryResource)iter.next();
                    HashMap resources2names = CheckoutAction.getResources2Names(this.names2resources);
                    operateMap.put(resources2names.get(resource), resource);
                }
                op = this.prepareForMultiple(operateMap, location, checkoutRecursive, workingSetName);
            }
            if (op != null) {
                if (this.priorOp != null) {
                    CompositeOperation tmp = new CompositeOperation(op.getId());
                    tmp.add(this.priorOp);
                    tmp.add((IActionOperation)op, new IActionOperation[]{this.priorOp});
                    op = tmp;
                }
                UIMonitorUtility.doTaskScheduledActive((IActionOperation)op);
            }
        }
    }

    protected IActionOperation getCheckoutAsFolderOperationUnshared(IContainer targetFolder, IRepositoryResource[] resources, Map mappings) {
        CompositeOperation op = new CompositeOperation(SVNTeamUIPlugin.instance().getResource("Operation.CheckoutAsFolder"));
        int i = 0;
        while (i < resources.length) {
            IPath location = FileUtility.getResourcePath((IResource)targetFolder);
            File target = location.append((String)mappings.get(resources[i])).toFile();
            op.add((IActionOperation)new CheckoutAsOperation(target, resources[i], this.isCheckoutRecursivelySelected(), false, false));
            ++i;
        }
        IResource[] localResources = new IResource[]{targetFolder};
        op.add((IActionOperation)new RefreshResourcesOperation(localResources), null);
        return op;
    }

    protected IActionOperation getCheckoutAsFolderOperation(IContainer targetFolder, IRepositoryResource[] resources, Map mappings) {
        String externalsData = "";
        int i = 0;
        while (i < resources.length) {
            String line = String.valueOf((String)mappings.get(resources[i])) + "\t" + SVNUtility.encodeURL((String)resources[i].getUrl()) + "\n";
            externalsData = String.valueOf(externalsData) + line;
            ++i;
        }
        CompositeOperation op = new CompositeOperation(SVNTeamUIPlugin.instance().getResource("Operation.CheckoutAsFolder"));
        IActionOperation[] dependency = null;
        IResource[] localResources = new IResource[]{targetFolder};
        ILocalResource localResource = SVNRemoteStorage.instance().asLocalResource((IResource)targetFolder);
        IResource[] newResources = null;
        if (IStateFilter.SF_NONVERSIONED.accept((IResource)targetFolder, localResource.getStatus(), localResource.getChangeMask())) {
            newResources = FileUtility.addOperableParents((IResource[])localResources, (IStateFilter)IStateFilter.SF_NONVERSIONED);
        }
        if (newResources != null && newResources.length > 0) {
            AddToSVNOperation addToSVN = new AddToSVNOperation(newResources);
            op.add((IActionOperation)addToSVN);
            dependency = new IActionOperation[]{addToSVN};
        }
        ConcatenateProperyDataOperation concatenateProps = new ConcatenateProperyDataOperation((IResource)targetFolder, "svn:externals", externalsData.getBytes());
        op.add((IActionOperation)concatenateProps, dependency);
        dependency = new IActionOperation[]{concatenateProps};
        SetPropertiesOperation setProps = new SetPropertiesOperation(localResources, (IResourcePropertyProvider)concatenateProps, false);
        op.add((IActionOperation)setProps, dependency);
        dependency = new IActionOperation[]{setProps};
        int i2 = 0;
        while (i2 < resources.length) {
            IPath location = targetFolder.getLocation();
            if (location != null) {
                File target = location.append((String)mappings.get(resources[i2])).toFile();
                op.add((IActionOperation)new CheckoutAsOperation(target, resources[i2], this.isCheckoutRecursivelySelected(), false, false), dependency);
            }
            ++i2;
        }
        op.add((IActionOperation)new RefreshResourcesOperation(localResources), dependency);
        return op;
    }

    protected Map getExternalsFolderNames(IRepositoryResource[] resources, Map resource2Name) {
        HashMap<IRepositoryResource, String> retVal = new HashMap<IRepositoryResource, String>();
        HashSet<String> allNames = new HashSet<String>();
        int i = 0;
        while (i < resources.length) {
            String name = (String)resource2Name.get(resources[i]);
            if (name == null) {
                name = resources[i].getName();
            }
            name = this.getName(this.getTargetFolder(), name, allNames);
            retVal.put(resources[i], name);
            allNames.add(name);
            ++i;
        }
        return retVal;
    }

    protected String getName(IContainer targetFolder, String baseName, Set allNames) {
        String name;
        baseName = baseName.replace(' ', '_');
        if (targetFolder == null || !targetFolder.exists((IPath)new Path(baseName))) {
            return baseName;
        }
        int i = 1;
        while (targetFolder.exists((IPath)new Path(name = String.valueOf(baseName) + "_(" + i + ")")) || allNames.contains(name)) {
            ++i;
        }
        return name;
    }

    protected CompositeOperation prepareForOne(IRepositoryResource resource, String projectName, String location, boolean isUseNewProjectWizard, boolean checkoutRecursive, String workingSetName) {
        org.polarion.team.svn.core.operation.remote.CheckoutAsOperation mainOp = new org.polarion.team.svn.core.operation.remote.CheckoutAsOperation(projectName, resource, location, checkoutRecursive);
        CompositeOperation op = new CompositeOperation(mainOp.getId());
        if (isUseNewProjectWizard) {
            SaveProjectMetaOperation saveOp = new SaveProjectMetaOperation(new IResource[]{mainOp.getProject()}, "");
            op.add((IActionOperation)saveOp);
            op.add((IActionOperation)mainOp);
            mainOp.setRestoreOperation(new RestoreProjectMetaOperation(saveOp, true));
        } else {
            op.add((IActionOperation)mainOp);
        }
        if (workingSetName != null) {
            op.add((IActionOperation)new MoveProjectsToWorkingSetOperation((IResource[])new IProject[]{mainOp.getProject()}, workingSetName));
        }
        return op;
    }

    protected CompositeOperation prepareForMultiple(HashMap name2resources, String location, boolean checkoutRecursive, String workingSetName) {
        CompositeOperation op = new CompositeOperation("");
        IResource[] locals = new IResource[name2resources.keySet().size()];
        int i = 0;
        Iterator iter = name2resources.keySet().iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            org.polarion.team.svn.core.operation.remote.CheckoutAsOperation mainOp = new org.polarion.team.svn.core.operation.remote.CheckoutAsOperation(name, (IRepositoryResource)name2resources.get(name), false, location, checkoutRecursive);
            locals[i] = mainOp.getProject();
            op.add((IActionOperation)mainOp);
            op.setOperationName(mainOp.getId());
            ++i;
        }
        if (workingSetName != null) {
            op.add((IActionOperation)new MoveProjectsToWorkingSetOperation(locals, workingSetName));
        }
        return op;
    }

    protected CompositeOperation getLocateProjectsOperation(IRepositoryResource[] resources, boolean checkoutRecursively) {
        LocateProjectsOperation mainOp = new LocateProjectsOperation(resources, ExtensionsManager.getInstance().getCurrentCheckoutFactory().getLocateFilter(), 5);
        CompositeOperation op = new CompositeOperation(mainOp.getId());
        op.add((IActionOperation)mainOp);
        IRepositoryResourceProvider provider = ExtensionsManager.getInstance().getCurrentCheckoutFactory().additionalProcessing(op, (IRepositoryResourceProvider)mainOp);
        ObtainProjectNameOperation obtainOperation = new ObtainProjectNameOperation(provider);
        op.add((IActionOperation)obtainOperation, new IActionOperation[]{mainOp});
        op.add((IActionOperation)this.getCheckoutProjectOperation(resources, obtainOperation, checkoutRecursively), new IActionOperation[]{obtainOperation});
        return op;
    }

    protected AbstractActionOperation getCheckoutProjectOperation(final IRepositoryResource[] resources, final ObtainProjectNameOperation obtainOperation, final boolean checkoutRecursively) {
        return new AbstractNonLockingOperation("Operation.CheckoutProjects"){

            protected void runImpl(IProgressMonitor monitor) throws Exception {
                UIMonitorUtility.getDisplay().syncExec(new Runnable(this, obtainOperation, resources, checkoutRecursively){
                    final /* synthetic */ 2 this$1;
                    private final /* synthetic */ ObtainProjectNameOperation val$obtainOperation;
                    private final /* synthetic */ IRepositoryResource[] val$resources;
                    private final /* synthetic */ boolean val$checkoutRecursively;
                    {
                        this.this$1 = var1_1;
                        this.val$obtainOperation = obtainProjectNameOperation;
                        this.val$resources = iRepositoryResourceArray;
                        this.val$checkoutRecursively = bl;
                    }

                    public void run() {
                        HashMap name2resources = this.val$obtainOperation.getNames2Resources();
                        if (name2resources.isEmpty()) {
                            new MessageDialog(UIMonitorUtility.getShell(), 2.access$0(this.this$1, "Title"), null, 2.access$0(this.this$1, "Message"), 2, new String[]{IDialogConstants.OK_LABEL}, 0).open();
                            return;
                        }
                        CheckoutProjectsWizard wizard = new CheckoutProjectsWizard(this.val$resources, name2resources);
                        WizardDialog dialog = new WizardDialog(UIMonitorUtility.getShell(), (IWizard)wizard);
                        dialog.create();
                        wizard.postInit();
                        dialog.getShell().setSize(Math.max(570, dialog.getShell().getSize().x), 500);
                        if (dialog.open() == 0) {
                            IActionOperation op;
                            Set<K> projectNames;
                            List selection = wizard.getResultSelections();
                            if (wizard.isCheckoutAsFoldersSelected()) {
                                projectNames = null;
                                op = 2.access$1(this.this$1).getCheckoutAsFolderOperation(wizard.getTargetFolder(), selection.toArray(new IRepositoryResource[selection.size()]), name2resources);
                            } else {
                                HashMap<String, V> selectedMap = new HashMap<String, V>();
                                ArrayList<V> projects = new ArrayList<V>();
                                projectNames = name2resources.keySet();
                                Iterator<K> iter = projectNames.iterator();
                                while (iter.hasNext()) {
                                    String projName = (String)iter.next();
                                    if (!wizard.getResultSelections().contains(name2resources.get(projName))) continue;
                                    selectedMap.put(projName, name2resources.get(projName));
                                    projects.add(name2resources.get(projName));
                                }
                                op = ExtensionsManager.getInstance().getCurrentCheckoutFactory().getCheckoutOperation(2.access$1(this.this$1).getShell(), projects.toArray(new IRepositoryResource[projects.size()]), selectedMap, wizard.isRespectHierarchy(), wizard.getLocation(), this.val$checkoutRecursively);
                            }
                            if (op != null) {
                                String wsName = wizard.getWorkingSetName();
                                if (2.access$1(this.this$1).priorOp != null || wsName != null) {
                                    CompositeOperation tmp = new CompositeOperation(op.getId());
                                    if (2.access$1(this.this$1).priorOp != null) {
                                        tmp.add(2.access$1(this.this$1).priorOp);
                                        tmp.add(op, new IActionOperation[]{2.access$1(this.this$1).priorOp});
                                    } else {
                                        tmp.add(op);
                                    }
                                    if (wsName != null) {
                                        tmp.add((IActionOperation)new MoveProjectsToWorkingSetOperation(new IResourceProvider(this, projectNames){
                                            final /* synthetic */ 3 this$2;
                                            private final /* synthetic */ Set val$projectNames;
                                            {
                                                this.this$2 = var1_1;
                                                this.val$projectNames = set;
                                            }

                                            public IResource[] getResources() {
                                                ArrayList<IProject> projects = new ArrayList<IProject>();
                                                Iterator<E> it = this.val$projectNames.iterator();
                                                while (it.hasNext()) {
                                                    String name = (String)it.next();
                                                    IProject prj = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
                                                    if (prj == null) continue;
                                                    projects.add(prj);
                                                }
                                                return projects.toArray(new IProject[projects.size()]);
                                            }
                                        }, wsName));
                                    }
                                    op = tmp;
                                }
                                UIMonitorUtility.doTaskScheduledActive(op);
                            }
                        }
                    }
                });
            }

            static /* synthetic */ String access$0(2 var0, String string) {
                return var0.getOperationResource(string);
            }

            static /* synthetic */ CheckoutAsWizard access$1(2 var0) {
                return var0.CheckoutAsWizard.this;
            }
        };
    }

    public boolean canFinish() {
        IWizardPage currentPage = this.getContainer().getCurrentPage();
        if ((currentPage instanceof CheckoutMethodSelectionPage || currentPage instanceof MultipleCheckoutMethodSelectionPage) && this.isCheckoutAsFolderSelected()) {
            return false;
        }
        return super.canFinish();
    }

    protected class ProjectAdditionListener
    implements IResourceChangeListener {
        protected IProject project = null;

        protected ProjectAdditionListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta[] deltas = event.getDelta().getAffectedChildren();
            int i = 0;
            while (i < deltas.length) {
                IResource resource = deltas[i].getResource();
                if (resource instanceof IProject) {
                    if (deltas[i].getKind() == 1) {
                        this.project = (IProject)resource;
                    } else if (deltas[i].getKind() == 2 && this.project == resource) {
                        this.project = null;
                    }
                }
                ++i;
            }
        }

        public IProject getProject() {
            return this.project;
        }
    }

    protected class ConcatenateProperyDataOperation
    extends AbstractNonLockingOperation
    implements IResourcePropertyProvider {
        protected IResource resource;
        protected String propertyName;
        protected byte[] concatenatedData;
        protected PropertyData property;

        public ConcatenateProperyDataOperation(IResource resource, String propertyName, byte[] concatenatedData) {
            super("Operation.ConcatenatePropertyData");
            this.resource = resource;
            this.propertyName = propertyName;
            this.concatenatedData = concatenatedData;
            this.property = new PropertyData(propertyName, null, concatenatedData);
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected void runImpl(IProgressMonitor monitor) throws Exception {
            PropertyData existingProperty;
            String wcPath = FileUtility.getWorkingCopyPath((IResource)this.resource);
            IRepositoryLocation location = SVNRemoteStorage.instance().getRepositoryLocation(this.resource);
            ISVNClientWrapper proxy = location.acquireSVNProxy();
            try {
                existingProperty = proxy.propertyGet(wcPath, "svn:externals", (ISVNProgressMonitor)new SVNProgressMonitor((IActionOperation)this, monitor, null));
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                location.releaseSVNProxy(proxy);
                throw throwable;
            }
            {
                Object var6_9 = null;
            }
            location.releaseSVNProxy(proxy);
            if (existingProperty != null && (existingProperty.value != null || existingProperty.data != null)) {
                byte[] existingData = existingProperty.value != null ? existingProperty.value.getBytes() : existingProperty.data;
                byte[] newData = new byte[existingData.length + this.concatenatedData.length];
                System.arraycopy(existingData, 0, newData, 0, existingData.length);
                System.arraycopy(this.concatenatedData, 0, newData, existingData.length, this.concatenatedData.length);
                this.property = new PropertyData(this.propertyName, null, newData);
            }
        }

        public IResource getLocal() {
            return this.resource;
        }

        public PropertyData[] getProperties() {
            return new PropertyData[]{this.property};
        }

        public IRepositoryResource getRemote() {
            return SVNRemoteStorage.instance().asRepositoryResource(this.resource);
        }

        public boolean isEditAllowed() {
            return false;
        }

        public void refresh() {
        }

        protected String getShortErrorMessage(Throwable t) {
            return MessageFormat.format(super.getShortErrorMessage(t), this.propertyName, this.resource.getName());
        }
    }
}

