/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui.wizard;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.wizard.IWizardPage;
import org.polarion.team.svn.ui.SVNTeamUIPlugin;
import org.polarion.team.svn.ui.wizard.AbstractSVNWizard;
import org.polarion.team.svn.ui.wizard.createpatch.PatchOptionsPage;
import org.polarion.team.svn.ui.wizard.createpatch.SelectPatchFilePage;

public class CreatePatchWizard
extends AbstractSVNWizard {
    public static final int WRITE_TO_CLIPBOARD = 0;
    public static final int WRITE_TO_EXTERNAL_FILE = 1;
    public static final int WRITE_TO_WORKSPACE_FILE = 2;
    protected String targetName;
    protected boolean localMode;
    protected boolean showIgnoreAncestry;
    protected SelectPatchFilePage selectFile;
    protected PatchOptionsPage options;

    public CreatePatchWizard(String targetName) {
        this(targetName, true);
    }

    public CreatePatchWizard(String targetName, boolean localMode) {
        this(targetName, localMode, false);
    }

    public CreatePatchWizard(String targetName, boolean localMode, boolean showIgnoreAncestry) {
        this.setWindowTitle(SVNTeamUIPlugin.instance().getResource("CreatePatchWizard.Title"));
        this.targetName = targetName;
        this.localMode = localMode;
        this.showIgnoreAncestry = showIgnoreAncestry;
    }

    public IResource getTargetFolder() {
        return ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(this.getFileName())).getParent();
    }

    public String getFileName() {
        return this.selectFile.getFileName();
    }

    public int getWriteMode() {
        return this.selectFile.getWriteMode();
    }

    public boolean isIgnoreDeleted() {
        return this.options.isIgnoreDeleted();
    }

    public boolean isProcessBinary() {
        return this.options.isProcessBinary();
    }

    public boolean isProcessUnversioned() {
        return this.options.isProcessUnversioned();
    }

    public boolean isRecursive() {
        return this.options.isRecursive();
    }

    public boolean isIgnoreAncestry() {
        return this.options.isIgnoreAncestry();
    }

    public void addPages() {
        this.selectFile = new SelectPatchFilePage(this.targetName);
        this.addPage((IWizardPage)this.selectFile);
        this.options = new PatchOptionsPage(this.localMode, this.showIgnoreAncestry);
        this.addPage((IWizardPage)this.options);
    }

    public boolean performFinish() {
        return true;
    }
}

