/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui.wizard;

import java.text.MessageFormat;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.team.ui.IConfigurationWizard;
import org.eclipse.ui.IWorkbench;
import org.polarion.team.svn.core.IStateFilter;
import org.polarion.team.svn.core.operation.AbstractActionOperation;
import org.polarion.team.svn.core.operation.AbstractNonLockingOperation;
import org.polarion.team.svn.core.operation.CompositeOperation;
import org.polarion.team.svn.core.operation.IActionOperation;
import org.polarion.team.svn.core.operation.IUnprotectedOperation;
import org.polarion.team.svn.core.operation.local.NotifyProjectStatesChangedOperation;
import org.polarion.team.svn.core.operation.local.RefreshResourcesOperation;
import org.polarion.team.svn.core.operation.local.management.IShareProjectPrompt;
import org.polarion.team.svn.core.operation.local.management.ReconnectProjectOperation;
import org.polarion.team.svn.core.operation.local.management.ShareProjectOperation;
import org.polarion.team.svn.core.resource.IRepositoryLocation;
import org.polarion.team.svn.core.resource.IResourceProvider;
import org.polarion.team.svn.core.svnstorage.SVNRemoteStorage;
import org.polarion.team.svn.core.utility.FileUtility;
import org.polarion.team.svn.ui.SVNTeamUIPlugin;
import org.polarion.team.svn.ui.action.IResourceSelector;
import org.polarion.team.svn.ui.extension.ExtensionsManager;
import org.polarion.team.svn.ui.extension.factory.ICommitDialog;
import org.polarion.team.svn.ui.extension.factory.IShareProjectFactory;
import org.polarion.team.svn.ui.panel.local.CommitPanel;
import org.polarion.team.svn.ui.synchronize.SVNChangeSetCapability;
import org.polarion.team.svn.ui.utility.CommitActionUtility;
import org.polarion.team.svn.ui.utility.UIMonitorUtility;
import org.polarion.team.svn.ui.wizard.AbstractSVNWizard;
import org.polarion.team.svn.ui.wizard.shareproject.AddRepositoryLocationPage;
import org.polarion.team.svn.ui.wizard.shareproject.AlreadyConnectedPage;
import org.polarion.team.svn.ui.wizard.shareproject.EditCommentPage;
import org.polarion.team.svn.ui.wizard.shareproject.IShareProjectWrapper;
import org.polarion.team.svn.ui.wizard.shareproject.SelectProjectNamePage;
import org.polarion.team.svn.ui.wizard.shareproject.SelectProjectsGroupPage;
import org.polarion.team.svn.ui.wizard.shareproject.SelectRepositoryLocationPage;

public class ShareProjectWizard
extends AbstractSVNWizard
implements IConfigurationWizard {
    protected IProject[] allProjects;
    protected IResourceProvider projects;
    protected SelectRepositoryLocationPage selectLocation;
    protected SelectProjectNamePage selectName;
    protected AddRepositoryLocationPage addLocation;
    protected AlreadyConnectedPage connectedPage;
    protected EditCommentPage commentPage;

    public ShareProjectWizard() {
        this.setWindowTitle(SVNTeamUIPlugin.instance().getResource("ShareProjectWizard.Title.Single"));
    }

    public void addPages() {
        this.projects = new SelectProjectsGroupPage(this.allProjects);
        this.addPage((IWizardPage)((SelectProjectsGroupPage)this.projects));
        this.connectedPage = new AlreadyConnectedPage();
        this.addPage((IWizardPage)this.connectedPage);
        IRepositoryLocation[] locations = SVNRemoteStorage.instance().getRepositoryLocations();
        if (locations.length > 0) {
            this.selectLocation = new SelectRepositoryLocationPage(locations);
            this.addPage((IWizardPage)this.selectLocation);
        }
        this.addLocation = new AddRepositoryLocationPage();
        this.addPage((IWizardPage)this.addLocation);
        this.selectName = ExtensionsManager.getInstance().getCurrentShareProjectFactory().getProjectLayoutPage();
        this.addPage((IWizardPage)this.selectName);
        this.commentPage = new EditCommentPage(this.projects);
        this.addPage((IWizardPage)this.commentPage);
    }

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
    }

    public IWizardPage getStartingPage() {
        if (!this.isGroupSelectionRequired()) {
            return this.getNextPage(super.getStartingPage());
        }
        return super.getStartingPage();
    }

    public IWizardPage getNextPage(IWizardPage page) {
        IWizardPage retVal = null;
        this.addLocation.setInitialUrl(null);
        if (page == this.projects && !this.alreadyConnected()) {
            retVal = super.getNextPage(super.getNextPage(page));
        } else if (page instanceof SelectRepositoryLocationPage && this.selectLocation.useExistingLocation()) {
            retVal = super.getNextPage(super.getNextPage(page));
        } else if (page instanceof AlreadyConnectedPage) {
            if (this.connectedPage.createUsingProjectSettings()) {
                this.addLocation.setInitialUrl(this.connectedPage.getResourceUrl());
                this.addLocation.setForceDisableRoots(true);
                retVal = this.selectLocation == null ? super.getNextPage(page) : super.getNextPage(super.getNextPage(page));
            } else {
                this.addLocation.setInitialUrl("");
                this.addLocation.setForceDisableRoots(false);
                retVal = super.getNextPage(page);
            }
        } else {
            retVal = super.getNextPage(page);
        }
        if (retVal == this.selectName) {
            this.selectName.setProjectsAndLocation(this.getProjects(), this.selectLocation != null && this.selectLocation.useExistingLocation() ? this.selectLocation.getRepositoryLocation() : this.addLocation.getRepositoryLocation());
        } else if (retVal == this.commentPage) {
            this.commentPage.setSelectedRepositoryLocation(this.selectLocation != null && this.selectLocation.useExistingLocation() ? this.selectLocation.getRepositoryLocation() : this.addLocation.getRepositoryLocation());
            this.commentPage.setDefaultCommitMessage();
        } else if (retVal == this.connectedPage && this.alreadyConnected()) {
            this.connectedPage.setProjects(this.getProjects());
        }
        return retVal;
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        IWizardPage retVal = null;
        retVal = super.getPreviousPage(page) == this.connectedPage && !this.alreadyConnected() ? super.getPreviousPage(super.getPreviousPage(page)) : (page instanceof SelectProjectNamePage && this.selectLocation != null && this.selectLocation.useExistingLocation() ? super.getPreviousPage(super.getPreviousPage(page)) : (page instanceof AddRepositoryLocationPage && this.connectedPage != null && this.connectedPage.createUsingProjectSettings() ? super.getPreviousPage(super.getPreviousPage(page)) : super.getPreviousPage(page)));
        if (retVal == this.projects && !this.isGroupSelectionRequired()) {
            return null;
        }
        return retVal;
    }

    public boolean canFinish() {
        IWizardPage currentPage = this.getContainer().getCurrentPage();
        IShareProjectFactory factory = ExtensionsManager.getInstance().getCurrentShareProjectFactory();
        if (currentPage instanceof SelectProjectsGroupPage) {
            return false;
        }
        if (currentPage instanceof AlreadyConnectedPage) {
            return ((AlreadyConnectedPage)currentPage).useProjectSettings() && currentPage.isPageComplete() && !factory.disallowFinishOnAlreadyConnected(this.getProjects());
        }
        if (currentPage instanceof AddRepositoryLocationPage && this.connectedPage != null && this.connectedPage.createUsingProjectSettings()) {
            return currentPage.isPageComplete() && !factory.disallowFinishOnAddRepositoryLocation(this.getProjects());
        }
        if (currentPage instanceof SelectRepositoryLocationPage) {
            return this.selectLocation.useExistingLocation() && !factory.disallowFinishOnSelectRepositoryLocation(this.getProjects());
        }
        return super.canFinish();
    }

    public boolean performFinish() {
        IWizardPage currentPage = this.getContainer().getCurrentPage();
        if (currentPage instanceof AddRepositoryLocationPage && !this.addLocation.performFinish()) {
            return false;
        }
        boolean reconnect = this.connectedPage == null || !this.connectedPage.useProjectSettings() && !this.connectedPage.createUsingProjectSettings();
        IShareProjectWrapper mainOp = reconnect ? this.getFreshConnectOperation() : this.getAlreadyConnectedOperation(this.connectedPage.createUsingProjectSettings());
        CompositeOperation op = new CompositeOperation(mainOp.getId());
        op.add((IActionOperation)new NotifyProjectStatesChangedOperation(mainOp.getProjects(), 2));
        if (this.addLocation.getOperationToPeform() != null) {
            op.add(this.addLocation.getOperationToPeform());
            op.add((IActionOperation)mainOp, new IActionOperation[]{this.addLocation.getOperationToPeform()});
        } else {
            op.add((IActionOperation)mainOp);
        }
        op.add((IActionOperation)new RefreshResourcesOperation((IResourceProvider)mainOp, 2, RefreshResourcesOperation.REFRESH_ALL));
        op.add((IActionOperation)new NotifyProjectStatesChangedOperation(mainOp.getProjects(), 0));
        UIMonitorUtility.doTaskNowDefault(this.getShell(), (IActionOperation)op, false);
        if (!(this.alreadyConnected() && !reconnect || this.commentPage != null && !this.commentPage.isShowCommitDialog())) {
            UIMonitorUtility.doTaskScheduledActive((IActionOperation)new PostShareCommitOperation(mainOp));
        }
        return true;
    }

    protected boolean isGroupSelectionRequired() {
        return ((SelectProjectsGroupPage)this.projects).isGroupSelectionRequired();
    }

    protected IShareProjectWrapper getAlreadyConnectedOperation(boolean create) {
        return create ? new ReconnectProjectOperationImpl(this.getProjects(), this.addLocation.getRepositoryLocation()) : new ReconnectProjectOperationImpl(this.getProjects(), this.connectedPage.getSelectedRoot().getRepositoryLocation());
    }

    protected IShareProjectWrapper getFreshConnectOperation() {
        IActionOperation addLocationOp = this.addLocation.getOperationToPeform();
        IRepositoryLocation location = null;
        location = addLocationOp != null ? this.addLocation.getRepositoryLocation() : this.selectLocation.getRepositoryLocation();
        ShareProjectOperation mainOp = ExtensionsManager.getInstance().getCurrentShareProjectFactory().getShareProjectOperation(this.getProjects(), location, this.selectName, this.commentPage.getCommitComment());
        mainOp.setSharePrompt(new IShareProjectPrompt(){

            public boolean prompt(IProject[] projects) {
                String projectNames = FileUtility.getNamesListAsString((Object[])projects);
                String message = SVNTeamUIPlugin.instance().getResource(projects.length == 1 ? "ShareProject.Confirmation.Description.Single" : "ShareProject.Confirmation.Description.Multiple");
                int[] result = new int[1];
                MessageDialog dialog = new MessageDialog(ShareProjectWizard.this.getShell(), SVNTeamUIPlugin.instance().getResource(projects.length == 1 ? "ShareProject.Confirmation.Title.Single" : "ShareProject.Confirmation.Title.Multiple"), null, MessageFormat.format(message, projectNames), 4, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
                ShareProjectWizard.this.getShell().getDisplay().syncExec(new Runnable(this, result, dialog){
                    final /* synthetic */ 3 this$1;
                    private final /* synthetic */ int[] val$result;
                    private final /* synthetic */ MessageDialog val$dialog;
                    {
                        this.this$1 = var1_1;
                        this.val$result = nArray;
                        this.val$dialog = messageDialog;
                    }

                    public void run() {
                        this.val$result[0] = this.val$dialog.open();
                    }
                });
                return result[0] == 0;
            }
        });
        CompositeOperationImpl op = new CompositeOperationImpl(mainOp.getId());
        AbstractActionOperation predecessor = null;
        if (this.alreadyConnected()) {
            predecessor = new AbstractActionOperation("Operation.DropSVNMeta"){

                public ISchedulingRule getSchedulingRule() {
                    return MultiRule.combine((ISchedulingRule[])ShareProjectWizard.this.getProjects());
                }

                protected void runImpl(IProgressMonitor monitor) throws Exception {
                    IProject[] projects = ShareProjectWizard.this.getProjects();
                    int i = 0;
                    while (i < projects.length && !monitor.isCanceled()) {
                        IProject project = projects[i];
                        this.protectStep(new IUnprotectedOperation(this, project){
                            final /* synthetic */ 5 this$1;
                            private final /* synthetic */ IProject val$project;
                            {
                                this.this$1 = var1_1;
                                this.val$project = iProject;
                            }

                            public void run(IProgressMonitor monitor) throws Exception {
                                FileUtility.removeSVNMetaInformation((IResource)this.val$project, (IProgressMonitor)monitor);
                            }
                        }, monitor, projects.length);
                        ++i;
                    }
                }
            };
            op.add((IActionOperation)predecessor);
        }
        if (predecessor != null) {
            op.add((IActionOperation)mainOp, new IActionOperation[]{predecessor});
        } else {
            op.add((IActionOperation)mainOp);
        }
        return op;
    }

    public void init(IWorkbench workbench, IProject project) {
        this.init(new IProject[]{project});
    }

    public void init(IProject[] projects) {
        this.allProjects = projects;
        if (projects.length > 1) {
            this.setWindowTitle(SVNTeamUIPlugin.instance().getResource("ShareProjectWizard.Title.Multiple"));
        } else {
            this.setWindowTitle(SVNTeamUIPlugin.instance().getResource("ShareProjectWizard.Title.Single"));
        }
    }

    protected boolean alreadyConnected() {
        return FileUtility.alreadyOnSVN((IResource)this.getProjects()[0]);
    }

    protected IProject[] getProjects() {
        return (IProject[])this.projects.getResources();
    }

    protected class ReconnectProjectOperationImpl
    extends ReconnectProjectOperation
    implements IShareProjectWrapper {
        public ReconnectProjectOperationImpl(IProject[] projects, IRepositoryLocation location) {
            super(projects, location);
        }

        public IResource[] getResources() {
            return this.getProjects();
        }

        public IProject[] getProjects() {
            return ShareProjectWizard.this.getProjects();
        }
    }

    protected class CompositeOperationImpl
    extends CompositeOperation
    implements IShareProjectWrapper {
        public CompositeOperationImpl(String name) {
            super(name);
        }

        public IResource[] getResources() {
            return this.getProjects();
        }

        public IProject[] getProjects() {
            return ShareProjectWizard.this.getProjects();
        }
    }

    protected class PostShareCommitOperation
    extends AbstractNonLockingOperation {
        protected IActionOperation mainOp;

        public PostShareCommitOperation(IActionOperation mainOp) {
            super("Operation.PrepareCommit");
            this.mainOp = mainOp;
        }

        protected void runImpl(IProgressMonitor monitor) throws Exception {
            if (this.mainOp.getExecutionState() != 0) {
                return;
            }
            IResourceSelector selector = new IResourceSelector(this, monitor){
                final /* synthetic */ PostShareCommitOperation this$1;
                private final /* synthetic */ IProgressMonitor val$monitor;
                {
                    this.this$1 = postShareCommitOperation;
                    this.val$monitor = iProgressMonitor;
                }

                public IResource[] getSelectedResources() {
                    return PostShareCommitOperation.access$0(this.this$1).getProjects();
                }

                public IResource[] getSelectedResources(IStateFilter filter) {
                    return FileUtility.getResourcesRecursive((IResource[])this.getSelectedResources(), (IStateFilter)filter, (int)0);
                }

                public IResource[] getSelectedResourcesRecursive(IStateFilter filter) {
                    return this.getSelectedResourcesRecursive(filter, 2);
                }

                public IResource[] getSelectedResourcesRecursive(IStateFilter filter, int depth) {
                    return FileUtility.getResourcesRecursive((IResource[])this.getSelectedResources(), (IStateFilter)filter, (int)depth, (IActionOperation)this.this$1, (IProgressMonitor)this.val$monitor);
                }
            };
            CommitActionUtility commitUtility = new CommitActionUtility(selector);
            if (commitUtility.getAllResources().length == 0) {
                return;
            }
            String proposedComment = SVNChangeSetCapability.getProposedComment(commitUtility.getAllResources());
            IResource[] allResources = commitUtility.getAllResources();
            CommitPanel commitPanel = new CommitPanel(allResources, allResources, 0, proposedComment);
            CompositeOperation[] commitOp = new CompositeOperation[1];
            UIMonitorUtility.getDisplay().syncExec(new Runnable(this, commitUtility, commitPanel, commitOp){
                final /* synthetic */ PostShareCommitOperation this$1;
                private final /* synthetic */ CommitActionUtility val$commitUtility;
                private final /* synthetic */ CommitPanel val$commitPanel;
                private final /* synthetic */ CompositeOperation[] val$commitOp;
                {
                    this.this$1 = postShareCommitOperation;
                    this.val$commitUtility = commitActionUtility;
                    this.val$commitPanel = commitPanel;
                    this.val$commitOp = compositeOperationArray;
                }

                public void run() {
                    ICommitDialog commitDialog = ExtensionsManager.getInstance().getCurrentCommitFactory().getCommitDialog(PostShareCommitOperation.access$0(this.this$1).getShell(), this.val$commitUtility.getAllResourcesSet(), this.val$commitPanel);
                    if (commitDialog.open() == 0) {
                        this.val$commitOp[0] = this.val$commitUtility.getCompositeCommitOperation(this.val$commitPanel.getSelectedResources(), this.val$commitPanel.getNotSelectedResources(), commitDialog.getMessage(), this.val$commitPanel.getKeepLocks(), PostShareCommitOperation.access$0(this.this$1).getShell(), UIMonitorUtility.getActivePart(), true);
                    }
                }
            });
            if (commitOp[0] != null) {
                UIMonitorUtility.doTaskScheduledActive((IActionOperation)commitOp[0]);
            }
        }

        static /* synthetic */ ShareProjectWizard access$0(PostShareCommitOperation postShareCommitOperation) {
            return postShareCommitOperation.ShareProjectWizard.this;
        }
    }
}

