/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui.wizard.checkoutas;

import java.text.MessageFormat;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.polarion.team.svn.core.utility.FileUtility;
import org.polarion.team.svn.ui.SVNTeamUIPlugin;
import org.polarion.team.svn.ui.extension.ExtensionsManager;
import org.polarion.team.svn.ui.verifier.AbstractVerifierProxy;
import org.polarion.team.svn.ui.verifier.CompositeVerifier;
import org.polarion.team.svn.ui.verifier.NonEmptyFieldVerifier;
import org.polarion.team.svn.ui.verifier.ResourceNameVerifier;
import org.polarion.team.svn.ui.wizard.AbstractVerifiedWizardPage;

public class CheckoutMethodSelectionPage
extends AbstractVerifiedWizardPage {
    protected static final int USE_NEW_PROJECT_WIZARD = 0;
    protected static final int FIND_PROJECTS = 1;
    protected static final int CHECKOUT_AS_PROJECT = 2;
    protected static final int CHECKOUT_AS_FOLDER = 3;
    protected String defaultName;
    protected Button selectLocationButton;
    protected Text nameField;
    protected String projectName;
    protected int checkoutType;
    protected boolean checkoutRecursivelySelected;
    static /* synthetic */ Class class$0;

    public CheckoutMethodSelectionPage(String defaultName, boolean newProjectSelectionEnabled) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.polarion.team.svn.ui.wizard.checkoutas.CheckoutMethodSelectionPage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        super(clazz.getName(), SVNTeamUIPlugin.instance().getResource("CheckoutMethodSelectionPage.Title"), SVNTeamUIPlugin.instance().getImageDescriptor("icons/wizards/newconnect.gif"));
        this.setDescription(SVNTeamUIPlugin.instance().getResource("CheckoutMethodSelectionPage.Description"));
        this.projectName = this.defaultName = defaultName;
        this.checkoutType = newProjectSelectionEnabled ? 0 : 2;
        this.checkoutRecursivelySelected = true;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public boolean isUseNewProjectWizard() {
        return this.checkoutType == 0;
    }

    public boolean isFindProjectsSelected() {
        return this.checkoutType == 1;
    }

    public boolean isCheckoutAsFolderSelected() {
        return this.checkoutType == 3;
    }

    public boolean isCheckoutRecursivelySelected() {
        return this.checkoutRecursivelySelected;
    }

    protected Composite createControlImpl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.initializeDialogUnits((Control)composite);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        composite.setLayoutData((Object)data);
        this.setControl((Control)composite);
        Label description = new Label(composite, 64);
        data = new GridData(768);
        data.widthHint = 200;
        data.heightHint = this.convertHeightInCharsToPixels(this.checkoutType == 0 ? 1 : 2);
        description.setLayoutData((Object)data);
        String message = SVNTeamUIPlugin.instance().getResource("CheckoutMethodSelectionPage.HintHead");
        message = MessageFormat.format(message, this.defaultName);
        description.setText(String.valueOf(message) + (this.checkoutType != 0 ? " " + SVNTeamUIPlugin.instance().getResource("CheckoutMethodSelectionPage.HintTail") : ""));
        this.projectName = this.defaultName = FileUtility.formatResourceName((String)this.defaultName);
        Button useNewProjectWizardButton = new Button(composite, 16);
        data = new GridData(768);
        useNewProjectWizardButton.setLayoutData((Object)data);
        useNewProjectWizardButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CheckoutMethodSelectionPage.this.selectionChanged(0);
            }
        });
        useNewProjectWizardButton.setText(SVNTeamUIPlugin.instance().getResource("CheckoutMethodSelectionPage.NewWizard"));
        useNewProjectWizardButton.setSelection(this.checkoutType == 0);
        useNewProjectWizardButton.setEnabled(this.checkoutType == 0);
        Button findProjectsButton = new Button(composite, 16);
        data = new GridData(768);
        findProjectsButton.setLayoutData((Object)data);
        findProjectsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CheckoutMethodSelectionPage.this.selectionChanged(1);
            }
        });
        findProjectsButton.setText(SVNTeamUIPlugin.instance().getResource("CheckoutMethodSelectionPage.Find"));
        findProjectsButton.setEnabled(this.checkoutType == 0 || ExtensionsManager.getInstance().getCurrentCheckoutFactory().findProjectsOptionEnabled());
        Button checkoutAsFolder = new Button(composite, 16);
        data = new GridData(768);
        checkoutAsFolder.setLayoutData((Object)data);
        checkoutAsFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CheckoutMethodSelectionPage.this.selectionChanged(3);
            }
        });
        checkoutAsFolder.setText(SVNTeamUIPlugin.instance().getResource("CheckoutMethodSelectionPage.Folder"));
        this.selectLocationButton = new Button(composite, 16);
        data = new GridData(768);
        this.selectLocationButton.setLayoutData((Object)data);
        this.selectLocationButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CheckoutMethodSelectionPage.this.selectionChanged(2);
            }
        });
        this.selectLocationButton.setText(SVNTeamUIPlugin.instance().getResource("CheckoutMethodSelectionPage.Project"));
        this.selectLocationButton.setSelection(this.checkoutType != 0);
        this.nameField = new Text(composite, 2052);
        data = new GridData(768);
        this.nameField.setLayoutData((Object)data);
        this.nameField.setText(this.defaultName);
        this.nameField.setEnabled(this.checkoutType != 0);
        this.nameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String name;
                CheckoutMethodSelectionPage.this.projectName = name = CheckoutMethodSelectionPage.this.nameField.getText().trim();
            }
        });
        String name = SVNTeamUIPlugin.instance().getResource("CheckoutMethodSelectionPage.ProjectName.Verifier");
        CompositeVerifier verifier = new CompositeVerifier();
        verifier.add(new ResourceNameVerifier(name, false));
        verifier.add(new NonEmptyFieldVerifier(name));
        this.attachTo((Control)this.nameField, new AbstractVerifierProxy(verifier){

            protected boolean isVerificationEnabled(Control input) {
                return CheckoutMethodSelectionPage.this.selectLocationButton.getSelection();
            }
        });
        Label separator = new Label(composite, 258);
        separator.setLayoutData((Object)new GridData(768));
        separator.setVisible(false);
        Button checkoutRecursivelyCheckbox = new Button(composite, 32);
        data = new GridData(768);
        checkoutRecursivelyCheckbox.setLayoutData((Object)data);
        checkoutRecursivelyCheckbox.setSelection(true);
        checkoutRecursivelyCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CheckoutMethodSelectionPage.this.checkoutRecursivelySelected = ((Button)e.widget).getSelection();
            }
        });
        checkoutRecursivelyCheckbox.setText(SVNTeamUIPlugin.instance().getResource("CheckoutMethodSelectionPage.Recursively"));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.polarion.team.svn.help.checkoutMethodSelectionContext");
        return composite;
    }

    protected void selectionChanged(int newSelection) {
        this.checkoutType = newSelection;
        switch (this.checkoutType) {
            case 0: 
            case 1: 
            case 3: {
                this.projectName = this.defaultName;
                this.nameField.setEnabled(false);
                break;
            }
            case 2: {
                this.projectName = this.nameField.getText().trim();
                this.nameField.setEnabled(true);
            }
        }
        this.validateContent();
    }
}

