/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui.wizard.shareproject;

import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.ui.PlatformUI;
import org.polarion.team.svn.core.SVNTeamProvider;
import org.polarion.team.svn.core.client.Info2;
import org.polarion.team.svn.core.operation.AbstractNonLockingOperation;
import org.polarion.team.svn.core.operation.CompositeOperation;
import org.polarion.team.svn.core.operation.IActionOperation;
import org.polarion.team.svn.core.operation.remote.management.AddRepositoryLocationOperation;
import org.polarion.team.svn.core.operation.remote.management.SaveRepositoryLocationsOperation;
import org.polarion.team.svn.core.resource.IRepositoryLocation;
import org.polarion.team.svn.core.svnstorage.SVNRemoteStorage;
import org.polarion.team.svn.core.utility.SVNUtility;
import org.polarion.team.svn.ui.SVNTeamUIPlugin;
import org.polarion.team.svn.ui.composite.ProjectListComposite;
import org.polarion.team.svn.ui.composite.RepositoryPropertiesTabFolder;
import org.polarion.team.svn.ui.dialog.DefaultDialog;
import org.polarion.team.svn.ui.dialog.NonValidLocationErrorDialog;
import org.polarion.team.svn.ui.operation.RefreshRepositoryLocationsOperation;
import org.polarion.team.svn.ui.panel.AbstractDialogPanel;
import org.polarion.team.svn.ui.preferences.SVNTeamPreferences;
import org.polarion.team.svn.ui.utility.UIMonitorUtility;
import org.polarion.team.svn.ui.verifier.AbstractFormattedVerifier;
import org.polarion.team.svn.ui.wizard.AbstractVerifiedWizardPage;

public class AddRepositoryLocationPage
extends AbstractVerifiedWizardPage {
    protected RepositoryPropertiesTabFolder propertiesTabFolder;
    protected IActionOperation operationToPerform;
    protected IRepositoryLocation editable;
    protected boolean alreadyConnected;
    protected boolean createNew;
    protected String initialUrl;
    protected String oldUrl;
    protected String oldLabel;
    protected String oldUuid;
    static /* synthetic */ Class class$0;

    public AddRepositoryLocationPage() {
        this((IRepositoryLocation)null);
    }

    public AddRepositoryLocationPage(IRepositoryLocation editable) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.polarion.team.svn.ui.wizard.shareproject.AddRepositoryLocationPage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        super(clazz.getName(), SVNTeamUIPlugin.instance().getResource("AddRepositoryLocationPage.Title"), SVNTeamUIPlugin.instance().getImageDescriptor("icons/wizards/newconnect.gif"));
        this.setDescription(SVNTeamUIPlugin.instance().getResource("AddRepositoryLocationPage.Description"));
        this.editable = editable;
        if (editable != null) {
            this.oldUrl = editable.getUrl();
            this.oldLabel = editable.getLabel();
            this.oldUuid = null;
        }
        this.alreadyConnected = false;
        this.createNew = true;
    }

    protected Composite createControlImpl(Composite parent) {
        this.propertiesTabFolder = new RepositoryPropertiesTabFolder(parent, 0, this, this.editable);
        this.propertiesTabFolder.initialize();
        this.propertiesTabFolder.setLayoutData(new GridData(768));
        this.propertiesTabFolder.resetChanges();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.polarion.team.svn.help.newReposWizContext");
        return this.propertiesTabFolder;
    }

    public void setInitialUrl(String initialUrl) {
        this.initialUrl = initialUrl;
        this.alreadyConnected = initialUrl != null;
        if (this.alreadyConnected) {
            this.createNew = initialUrl.trim().length() == 0;
            this.getRepositoryLocation().setUrl(initialUrl);
            this.propertiesTabFolder.resetChanges();
        }
    }

    public void setForceDisableRoots(boolean force) {
        this.propertiesTabFolder.setForceDisableRoots(force, this.initialUrl == null || this.initialUrl.length() == 0 ? null : new AbstractFormattedVerifier(SVNTeamUIPlugin.instance().getResource("AddRepositoryLocationPage.RootURL")){

            protected String getErrorMessageImpl(Control input) {
                String url = this.getText(input);
                if (!new Path(url).isPrefixOf((IPath)new Path(SVNUtility.decodeURL((String)AddRepositoryLocationPage.this.initialUrl)))) {
                    String message = SVNTeamUIPlugin.instance().getResource("AddRepositoryLocationPage.FixedURL.Verifier.Error");
                    return MessageFormat.format(message, "$FIELD_NAME$", AddRepositoryLocationPage.this.initialUrl);
                }
                return null;
            }

            protected String getWarningMessageImpl(Control input) {
                return null;
            }
        });
    }

    public IRepositoryLocation getRepositoryLocation() {
        return this.propertiesTabFolder.getRepositoryLocation();
    }

    public boolean canFlipToNextPage() {
        return (!this.alreadyConnected || this.createNew) && this.isPageComplete();
    }

    public IWizardPage getNextPage() {
        return this.performFinish() ? super.getNextPage() : this;
    }

    public IWizardPage getPreviousPage() {
        this.performCancel();
        return super.getPreviousPage();
    }

    public void performCancel() {
        this.operationToPerform = null;
    }

    public boolean performFinish() {
        IPreferenceStore store;
        String newUrl = this.propertiesTabFolder.getLocationUrl();
        ProjectListPanel panel = null;
        ArrayList<IProject> connectedProjects = new ArrayList<IProject>();
        IProject[] projectsArray = null;
        if (this.editable != null && !newUrl.equals(this.oldUrl) && this.oldUuid == null) {
            IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int i = 0;
            while (i < projects.length) {
                SVNTeamProvider provider;
                RepositoryProvider tmp = RepositoryProvider.getProvider((IProject)projects[i]);
                if (tmp != null && "org.polarion.team.svn.core.svnnature".equals(tmp.getID()) && this.editable.equals((provider = (SVNTeamProvider)tmp).getRepositoryLocation())) {
                    connectedProjects.add(projects[i]);
                }
                ++i;
            }
            if (connectedProjects.size() > 0) {
                projectsArray = connectedProjects.toArray(new IProject[connectedProjects.size()]);
                Info2 info = this.getLocationInfo(this.editable);
                this.oldUuid = info == null ? null : info.reposUUID;
            }
        }
        this.propertiesTabFolder.saveChanges();
        if (this.propertiesTabFolder.isStructureEnabled() && (newUrl.endsWith(SVNTeamPreferences.getRepositoryString(store = SVNTeamUIPlugin.instance().getPreferenceStore(), "head")) || newUrl.endsWith(SVNTeamPreferences.getRepositoryString(store, "branches")) || newUrl.endsWith(SVNTeamPreferences.getRepositoryString(store, "tags")))) {
            final int[] result = new int[1];
            final MessageDialog dialog = new MessageDialog(this.getShell(), SVNTeamUIPlugin.instance().getResource("AddRepositoryLocationPage.Normalize.Title"), null, SVNTeamUIPlugin.instance().getResource("AddRepositoryLocationPage.Normalize.Message"), 4, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
            UIMonitorUtility.getDisplay().syncExec(new Runnable(){

                public void run() {
                    result[0] = dialog.open();
                }
            });
            if (result[0] == 0) {
                IRepositoryLocation location = this.editable == null ? this.getRepositoryLocation() : this.editable;
                boolean useCustomLabel = false;
                useCustomLabel = !location.getUrl().equals(location.getLabel());
                newUrl = new Path(newUrl).removeLastSegments(1).toString();
                location.setUrl(newUrl);
                if (!useCustomLabel) {
                    location.setLabel(newUrl);
                }
                location.reconfigure();
            }
        }
        if (connectedProjects.size() > 0) {
            if (panel == null) {
                this.editable.reconfigure();
                Info2 newInfo = this.getLocationInfo(this.editable);
                if (newInfo == null) {
                    panel = new ProjectListPanel(projectsArray, false);
                } else if (this.oldUuid != null && !this.oldUuid.equals(newInfo.reposUUID)) {
                    panel = new ProjectListPanel(projectsArray, true);
                }
            }
            if (panel != null) {
                this.editable.setUrl(this.oldUrl);
                this.editable.setLabel(this.oldLabel);
                this.editable.reconfigure();
                new DefaultDialog(this.getShell(), panel).open();
            }
        }
        if (this.propertiesTabFolder.isValidateOnFinishRequested() && panel == null) {
            NonValidLocationErrorDialog dialog;
            final Exception[] problem = new Exception[1];
            UIMonitorUtility.doTaskNowDefault(this.getShell(), (IActionOperation)new AbstractNonLockingOperation("Operation.ValidateLocation"){

                protected void runImpl(IProgressMonitor monitor) throws Exception {
                    problem[0] = SVNUtility.validateRepositoryLocation((IRepositoryLocation)AddRepositoryLocationPage.this.propertiesTabFolder.getRepositoryLocation());
                }
            }, false);
            if (problem[0] != null && (dialog = new NonValidLocationErrorDialog(this.getShell(), problem[0].getMessage())).open() != 0) {
                return false;
            }
        }
        boolean shouldntBeAdded = this.editable == null ? false : SVNRemoteStorage.instance().getRepositoryLocation(this.editable.getId()) != null;
        AbstractNonLockingOperation mainOp = shouldntBeAdded ? new AbstractNonLockingOperation("Operation.CommitLocationChanges"){

            protected void runImpl(IProgressMonitor monitor) throws Exception {
                AddRepositoryLocationPage.this.editable.reconfigure();
            }
        } : new AddRepositoryLocationOperation(this.getRepositoryLocation());
        CompositeOperation op = new CompositeOperation(mainOp.getId());
        op.add((IActionOperation)mainOp);
        op.add((IActionOperation)new SaveRepositoryLocationsOperation());
        op.add((IActionOperation)(shouldntBeAdded ? new RefreshRepositoryLocationsOperation(new IRepositoryLocation[]{this.editable}, true) : new RefreshRepositoryLocationsOperation(false)));
        this.operationToPerform = op;
        return true;
    }

    public IActionOperation getOperationToPeform() {
        return this.operationToPerform;
    }

    protected Info2 getLocationInfo(IRepositoryLocation location) {
        try {
            return SVNUtility.getLocationInfo((IRepositoryLocation)location);
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected static class ProjectListPanel
    extends AbstractDialogPanel {
        protected IProject[] resources;
        protected TableViewer tableViewer;

        public ProjectListPanel(IProject[] input, boolean differentUuid) {
            super(new String[]{IDialogConstants.OK_LABEL});
            this.dialogTitle = SVNTeamUIPlugin.instance().getResource("AddRepositoryLocationPage.ProjectList.Title");
            this.dialogDescription = SVNTeamUIPlugin.instance().getResource("AddRepositoryLocationPage.ProjectList.Description");
            this.defaultMessage = SVNTeamUIPlugin.instance().getResource(differentUuid ? "AddRepositoryLocationPage.ProjectList.Message1" : "AddRepositoryLocationPage.ProjectList.Message2");
            this.resources = input;
        }

        public void createControls(Composite parent) {
            ProjectListComposite composite = new ProjectListComposite(parent, 4, this.resources, false);
            composite.initialize();
        }

        protected void saveChanges() {
        }

        protected void cancelChanges() {
        }
    }
}

